/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.layoutlib.reflection.TrackingThreadLocal;
import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.classloading.UtilKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.android.uipreview.ModuleClassLoaderManagerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002JN\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00012\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00142\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014H\u0007J \u0010\u0017\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0001J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0016\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0001J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0001H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/android/uipreview/ModuleClassLoaderManager;", "", "()V", "cache", "", "Lcom/intellij/openapi/module/Module;", "Lorg/jetbrains/android/uipreview/ModuleClassLoader;", "holders", "", "clearCache", "", "module", "createHoldersSet", "disposeClassLoaderThreadLocals", "moduleClassLoader", "getPrivate", "parent", "Ljava/lang/ClassLoader;", "holder", "additionalProjectTransformation", "Ljava/util/function/Function;", "Lorg/jetbrains/org/objectweb/asm/ClassVisitor;", "additionalNonProjectTransformation", "getShared", "isHeld", "", "isManaged", "release", "unHold", "Companion", "intellij.android.core"})
public final class ModuleClassLoaderManager {
    private final Map<Module, ModuleClassLoader> cache = new WeakHashMap();
    private final Map<ModuleClassLoader, Set<Object>> holders = new HashMap();
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final synchronized ModuleClassLoader getShared(@Nullable ClassLoader parent, @NotNull Module module2, @NotNull Object holder) {
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        ModuleClassLoader moduleClassLoader = this.cache.get(module2);
        ModuleClassLoader oldClassLoader = null;
        if (moduleClassLoader != null) {
            if (parent != null && Intrinsics.areEqual((Object)moduleClassLoader.getParent(), (Object)parent) ^ true) {
                LOG.debug("Parent has changed, discarding ModuleClassLoader");
                oldClassLoader = moduleClassLoader;
                moduleClassLoader = null;
            } else if (!moduleClassLoader.isUpToDate()) {
                LOG.debug("Files have changed, discarding ModuleClassLoader");
                oldClassLoader = moduleClassLoader;
                moduleClassLoader = null;
            } else {
                LOG.debug("ModuleClassLoader is up to date");
            }
        }
        if (moduleClassLoader == null) {
            Logger $this$debug$iv = LOG;
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                Logger logger2 = $this$debug$iv;
                boolean bl2 = false;
                String string = "Loading new class loader for module " + LogAnonymizerUtil.anonymize((Module)module2);
                logger2.debug(string, (Throwable)e$iv);
            }
            moduleClassLoader = new ModuleClassLoader(parent, module2);
            this.cache.put(module2, moduleClassLoader);
            ModuleClassLoader moduleClassLoader2 = oldClassLoader;
            if (moduleClassLoader2 != null) {
                object = moduleClassLoader2;
                boolean bl3 = false;
                bl = false;
                Object it = object;
                boolean bl4 = false;
                this.release((ModuleClassLoader)it, ModuleClassLoaderManagerKt.access$getDUMMY_HOLDER$p());
            }
        }
        object = this.holders.computeIfAbsent(moduleClassLoader, new Function(this){
            final /* synthetic */ ModuleClassLoaderManager this$0;

            @NotNull
            public final Set<Object> apply(@NotNull ModuleClassLoader it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ModuleClassLoaderManager.access$createHoldersSet(this.this$0);
            }
            {
                this.this$0 = moduleClassLoaderManager;
            }
        });
        boolean bl5 = false;
        bl = false;
        Set<Object> $this$apply = object;
        boolean bl6 = false;
        $this$apply.add(holder);
        return moduleClassLoader;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final synchronized ModuleClassLoader getPrivate(@Nullable ClassLoader parent, @NotNull Module module2, @NotNull Object holder, @NotNull Function<ClassVisitor, ClassVisitor> additionalProjectTransformation, @NotNull Function<ClassVisitor, ClassVisitor> additionalNonProjectTransformation) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter(additionalProjectTransformation, (String)"additionalProjectTransformation");
        Intrinsics.checkNotNullParameter(additionalNonProjectTransformation, (String)"additionalNonProjectTransformation");
        Function<ClassVisitor, ClassVisitor> function = ModuleClassLoader.PROJECT_DEFAULT_TRANSFORMS;
        Intrinsics.checkNotNullExpressionValue(function, (String)"PROJECT_DEFAULT_TRANSFORMS");
        Function<ClassVisitor, ClassVisitor> function2 = UtilKt.combine(function, additionalProjectTransformation);
        Function<ClassVisitor, ClassVisitor> function3 = ModuleClassLoader.NON_PROJECT_CLASSES_DEFAULT_TRANSFORMS;
        Intrinsics.checkNotNullExpressionValue(function3, (String)"NON_PROJECT_CLASSES_DEFAULT_TRANSFORMS");
        ModuleClassLoader moduleClassLoader = new ModuleClassLoader(parent, module2, function2, UtilKt.combine(function3, additionalNonProjectTransformation));
        boolean bl = false;
        boolean bl2 = false;
        ModuleClassLoader $this$apply2 = moduleClassLoader;
        boolean bl3 = false;
        Set<Object> set = this.createHoldersSet();
        boolean bl4 = false;
        boolean bl5 = false;
        Set<Object> set2 = set;
        ModuleClassLoader moduleClassLoader2 = $this$apply2;
        Map<ModuleClassLoader, Set<Object>> map2 = this.holders;
        boolean bl6 = false;
        $this$apply.add(holder);
        Unit unit = Unit.INSTANCE;
        map2.put(moduleClassLoader2, set);
        return moduleClassLoader;
    }

    public static /* synthetic */ ModuleClassLoader getPrivate$default(ModuleClassLoaderManager moduleClassLoaderManager, ClassLoader classLoader, Module module2, Object object, Function function, Function function2, int n, Object object2) {
        if ((n & 8) != 0) {
            Function<ClassVisitor, ClassVisitor> function3 = Function.identity();
            Intrinsics.checkNotNullExpressionValue(function3, (String)"identity()");
            function = function3;
        }
        if ((n & 0x10) != 0) {
            Function<ClassVisitor, ClassVisitor> function4 = Function.identity();
            Intrinsics.checkNotNullExpressionValue(function4, (String)"identity()");
            function2 = function4;
        }
        return moduleClassLoaderManager.getPrivate(classLoader, module2, object, function, function2);
    }

    @JvmOverloads
    @NotNull
    public final ModuleClassLoader getPrivate(@Nullable ClassLoader parent, @NotNull Module module2, @NotNull Object holder, @NotNull Function<ClassVisitor, ClassVisitor> additionalProjectTransformation) {
        return ModuleClassLoaderManager.getPrivate$default(this, parent, module2, holder, additionalProjectTransformation, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final ModuleClassLoader getPrivate(@Nullable ClassLoader parent, @NotNull Module module2, @NotNull Object holder) {
        return ModuleClassLoaderManager.getPrivate$default(this, parent, module2, holder, null, null, 24, null);
    }

    private final Set<Object> createHoldersSet() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            boolean bl = false;
            return new LinkedHashSet();
        }
        Set<Object> set = Collections.newSetFromMap(new WeakHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"Collections.newSetFromMap(WeakHashMap())");
        return set;
    }

    public final synchronized void clearCache() {
        List values2 = CollectionsKt.toList((Iterable)this.cache.values());
        this.cache.clear();
        Iterable $this$forEach$iv = values2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleClassLoader it = (ModuleClassLoader)element$iv;
            boolean bl = false;
            this.release(it, ModuleClassLoaderManagerKt.access$getDUMMY_HOLDER$p());
        }
    }

    public final synchronized void clearCache(@NotNull Module module2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            ModuleClassLoader moduleClassLoader = this.cache.remove(module2);
            if (moduleClassLoader == null) break block0;
            ModuleClassLoader moduleClassLoader2 = moduleClassLoader;
            boolean bl = false;
            boolean bl2 = false;
            ModuleClassLoader it = moduleClassLoader2;
            boolean bl3 = false;
            this.release(it, ModuleClassLoaderManagerKt.access$getDUMMY_HOLDER$p());
        }
    }

    private final synchronized boolean isManaged(ModuleClassLoader moduleClassLoader) {
        return this.cache.values().contains(moduleClassLoader);
    }

    private final synchronized void unHold(ModuleClassLoader moduleClassLoader, Object holder) {
        block1: {
            Set<Object> set = this.holders.get(moduleClassLoader);
            if (set == null) break block1;
            Set<Object> set2 = set;
            boolean bl = false;
            boolean bl2 = false;
            Set<Object> it = set2;
            boolean bl3 = false;
            it.remove(holder);
            if (it.isEmpty()) {
                this.holders.remove(moduleClassLoader);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final synchronized boolean isHeld(ModuleClassLoader moduleClassLoader) {
        Set<Object> set = this.holders.get(moduleClassLoader);
        if (set == null) return false;
        Collection collection2 = set;
        boolean bl = false;
        if (collection2.isEmpty()) return false;
        return true;
    }

    public final void release(@NotNull ModuleClassLoader moduleClassLoader, @NotNull Object holder) {
        Intrinsics.checkNotNullParameter((Object)moduleClassLoader, (String)"moduleClassLoader");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.unHold(moduleClassLoader, holder);
        if (this.isHeld(moduleClassLoader) || this.isManaged(moduleClassLoader)) {
            return;
        }
        this.disposeClassLoaderThreadLocals(moduleClassLoader);
    }

    private final void disposeClassLoaderThreadLocals(ModuleClassLoader moduleClassLoader) {
        block1: {
            Set<ThreadLocal<?>> set = TrackingThreadLocal.Companion.clearThreadLocals(moduleClassLoader);
            if (set == null) break block1;
            Set<ThreadLocal<?>> set2 = set;
            boolean bl = false;
            boolean bl2 = false;
            Set<ThreadLocal<?>> threadLocals = set2;
            boolean bl3 = false;
            if (threadLocals.isEmpty()) {
                return;
            }
            RenderService.getRenderAsyncActionExecutor().runAsyncAction(new Runnable(threadLocals){
                final /* synthetic */ Set $threadLocals;

                public final void run() {
                    Iterable $this$forEach$iv = this.$threadLocals;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ThreadLocal threadLocal = (ThreadLocal)element$iv;
                        boolean bl = false;
                        try {
                            threadLocal.remove();
                        }
                        catch (Exception e) {
                            ModuleClassLoaderManager.access$getLOG$cp().warn((Throwable)e);
                        }
                    }
                }
                {
                    this.$threadLocals = set;
                }
            });
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(ModuleClassLoaderManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(Modul\u2026oaderManager::class.java)");
        LOG = logger2;
    }

    public static final /* synthetic */ Set access$createHoldersSet(ModuleClassLoaderManager $this) {
        return $this.createHoldersSet();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @JvmStatic
    @NotNull
    public static final ModuleClassLoaderManager get() {
        return Companion.get();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007R\u001b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/uipreview/ModuleClassLoaderManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG$annotations", "get", "Lorg/jetbrains/android/uipreview/ModuleClassLoaderManager;", "intellij.android.core"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void getLOG$annotations() {
        }

        @JvmStatic
        @NotNull
        public final ModuleClassLoaderManager get() {
            Object object = ApplicationManager.getApplication().getService(ModuleClassLoaderManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026oaderManager::class.java)");
            return (ModuleClassLoaderManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

