/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AndroidManifestPackageNameUtils;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.projectmodel.ExternalLibrary;
import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.Namespacing;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.classloading.ClassConverter;
import com.android.tools.idea.rendering.classloading.ConstantRemapperManager;
import com.android.tools.idea.rendering.classloading.PreviewAnimationClockMethodTransform;
import com.android.tools.idea.rendering.classloading.RenderClassLoader;
import com.android.tools.idea.rendering.classloading.RepackageTransform;
import com.android.tools.idea.rendering.classloading.ThreadLocalRenameTransform;
import com.android.tools.idea.rendering.classloading.UtilKt;
import com.android.tools.idea.rendering.classloading.VersionClassTransform;
import com.android.tools.idea.rendering.classloading.ViewMethodWrapperTransform;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.idea.util.VirtualFileSystemOpener;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.StudioEmbeddedRenderTarget;
import org.jetbrains.android.uipreview.ClassLoadingUtilsKt;
import org.jetbrains.android.uipreview.RecyclerViewHelper;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public final class ModuleClassLoader
extends RenderClassLoader {
    private static final Logger LOG = Logger.getInstance(ModuleClassLoader.class);
    private static final String INTERNAL_PACKAGE = "_layoutlib_._internal_.";
    private static final ImmutableList<String> PACKAGES_TO_RENAME = ImmutableList.of((Object)"kotlin.", (Object)"kotlinx.", (Object)"android.support.constraint.solver.");
    static final Function<ClassVisitor, ClassVisitor> PROJECT_DEFAULT_TRANSFORMS = UtilKt.multiTransformOf(visitor2 -> new ViewMethodWrapperTransform((ClassVisitor)visitor2), visitor2 -> new VersionClassTransform((ClassVisitor)visitor2, ClassConverter.getCurrentClassVersion(), 0), visitor2 -> new ThreadLocalRenameTransform((ClassVisitor)visitor2), visitor2 -> new RepackageTransform((ClassVisitor)visitor2, (Collection<String>)PACKAGES_TO_RENAME, INTERNAL_PACKAGE));
    static final Function<ClassVisitor, ClassVisitor> NON_PROJECT_CLASSES_DEFAULT_TRANSFORMS = UtilKt.multiTransformOf(visitor2 -> new ViewMethodWrapperTransform((ClassVisitor)visitor2), visitor2 -> new VersionClassTransform((ClassVisitor)visitor2, ClassConverter.getCurrentClassVersion(), 0), visitor2 -> new ThreadLocalRenameTransform((ClassVisitor)visitor2), visitor2 -> new PreviewAnimationClockMethodTransform((ClassVisitor)visitor2), visitor2 -> new RepackageTransform((ClassVisitor)visitor2, (Collection<String>)PACKAGES_TO_RENAME, INTERNAL_PACKAGE));
    private final WeakReference<Module> myModuleReference;
    private final long myConstantRemapperModificationCount;
    private Map<String, VirtualFile> myClassFiles;
    private Map<String, ClassModificationTimestamp> myClassFilesLastModified;
    private final List<Path> mAdditionalLibraries;
    private static final Pattern RESOURCE_CLASS_NAME = Pattern.compile(".+\\.R(\\$[^.]+)?$");

    @NotNull
    private static String nonProjectClassNameLookup(@NotNull String name) {
        if (name == null) {
            ModuleClassLoader.$$$reportNull$$$0(0);
        }
        String string = StringUtil.trimStart((String)name, (String)INTERNAL_PACKAGE);
        if (string == null) {
            ModuleClassLoader.$$$reportNull$$$0(1);
        }
        return string;
    }

    ModuleClassLoader(@Nullable ClassLoader parent, @NotNull Module module2, @NotNull Function<ClassVisitor, ClassVisitor> projectTransformations, @NotNull Function<ClassVisitor, ClassVisitor> nonProjectTransformations) {
        if (module2 == null) {
            ModuleClassLoader.$$$reportNull$$$0(2);
        }
        if (projectTransformations == null) {
            ModuleClassLoader.$$$reportNull$$$0(3);
        }
        if (nonProjectTransformations == null) {
            ModuleClassLoader.$$$reportNull$$$0(4);
        }
        super(parent, projectTransformations, nonProjectTransformations, ModuleClassLoader::nonProjectClassNameLookup);
        this.myModuleReference = new WeakReference<Module>(module2);
        this.mAdditionalLibraries = ModuleClassLoader.getAdditionalLibraries();
        this.myConstantRemapperModificationCount = ConstantRemapperManager.INSTANCE.getConstantRemapper().getModificationCount();
        ModuleClassLoader.registerResources(module2);
    }

    ModuleClassLoader(@Nullable ClassLoader parent, @NotNull Module module2) {
        if (module2 == null) {
            ModuleClassLoader.$$$reportNull$$$0(5);
        }
        this(parent, module2, PROJECT_DEFAULT_TRANSFORMS, NON_PROJECT_CLASSES_DEFAULT_TRANSFORMS);
    }

    @NotNull
    private static List<Path> getAdditionalLibraries() {
        String layoutlibDistributionPath = StudioEmbeddedRenderTarget.getEmbeddedLayoutLibPath();
        if (layoutlibDistributionPath == null) {
            List<Path> list = Collections.emptyList();
            if (list == null) {
                ModuleClassLoader.$$$reportNull$$$0(6);
            }
            return list;
        }
        String relativeCoroutineLibPath = FileUtil.toSystemIndependentName((String)"data/layoutlib-extensions.jar");
        List<Path> list = List.of(new File(layoutlibDistributionPath, relativeCoroutineLibPath).toPath());
        if (list == null) {
            ModuleClassLoader.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static boolean isRepackagedClass(@NotNull String classFqn) {
        if (classFqn == null) {
            ModuleClassLoader.$$$reportNull$$$0(8);
        }
        for (String pkgName : PACKAGES_TO_RENAME) {
            if (!classFqn.startsWith(pkgName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if ("kotlinx.coroutines.android.AndroidDispatcherFactory".equals(name)) {
            throw new IllegalArgumentException("AndroidDispatcherFactory not supported by layoutlib");
        }
        if (ModuleClassLoader.isRepackagedClass((String)name)) {
            name = INTERNAL_PACKAGE + (String)name;
        }
        return super.loadClass((String)name);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        block13: {
            block12: {
                if (ModuleClassLoader.LOG.isDebugEnabled()) {
                    ModuleClassLoader.LOG.debug(String.format("findClass(%s)", new Object[]{name}));
                }
                module = (Module)this.myModuleReference.get();
                try {
                    if (this.myInsideJarClassLoader || module == null || !ModuleClassLoader.isResourceClassName(name)) ** GOTO lbl35
                    facet = AndroidFacet.getInstance((Module)module);
                    if (facet == null) ** GOTO lbl34
                    repositoryManager = ResourceRepositoryManager.getInstance(facet);
                    data = ResourceClassRegistry.get(module.getProject()).findClassDefinition(name, repositoryManager);
                    if (data == null) break block12;
                    ModuleClassLoader.LOG.debug("  Defining class from AAR registry");
                    v0 = this.loadClass(name, data);
                }
                catch (ClassNotFoundException e) {
                    clazz = null;
                    if ("com.android.layoutlib.bridge.android.support.Adapter".equals(name)) {
                        clazz = RecyclerViewHelper.getAdapterClass(DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_V7), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_VIEW_HOLDER), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_ADAPTER));
                    }
                    if ("com.android.layoutlib.bridge.android.support.Adapter$ViewHolder".equals(name)) {
                        clazz = RecyclerViewHelper.getViewHolder(DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_V7), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_VIEW_HOLDER), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_ADAPTER));
                    }
                    if (clazz != null) {
                        if (ModuleClassLoader.LOG.isDebugEnabled()) {
                            ModuleClassLoader.LOG.debug("  Defining RecyclerView helper class");
                        }
                        v1 = this.defineClassAndPackage(name, clazz, 0, clazz.length);
                        if (v1 == null) {
                            ModuleClassLoader.$$$reportNull$$$0(11);
                        }
                        return v1;
                    }
                    ModuleClassLoader.LOG.debug((Throwable)e);
                    throw e;
                }
                if (v0 == null) {
                    ModuleClassLoader.$$$reportNull$$$0(9);
                }
                return v0;
            }
            break block13;
lbl34:
            // 1 sources

            ModuleClassLoader.LOG.debug("  LocalResourceRepositoryInstance not found");
        }
        if (ModuleClassLoader.LOG.isDebugEnabled()) {
            ModuleClassLoader.LOG.debug(String.format("  super.findClass(%s)", new Object[]{LogAnonymizerUtil.anonymizeClassName((String)name)}));
        }
        v2 = super.findClass(name);
        if (v2 == null) {
            ModuleClassLoader.$$$reportNull$$$0(10);
        }
        return v2;
    }

    @Override
    @NotNull
    protected Class<?> load(@NotNull String name) throws ClassNotFoundException {
        Module module2;
        if (name == null) {
            ModuleClassLoader.$$$reportNull$$$0(12);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("load(%s)", LogAnonymizerUtil.anonymizeClassName((String)name)));
        }
        if ((module2 = (Module)this.myModuleReference.get()) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("  ClassNotFoundException(%s)", name));
            }
            throw new ClassNotFoundException(name);
        }
        Class<?> aClass = this.loadClassFromModuleOrDependency(module2, name);
        if (aClass != null) {
            Class<?> clazz = aClass;
            if (clazz == null) {
                ModuleClassLoader.$$$reportNull$$$0(13);
            }
            return clazz;
        }
        Class<?> clazz = this.loadClassFromNonProjectDependency(name);
        if (clazz == null) {
            ModuleClassLoader.$$$reportNull$$$0(14);
        }
        return clazz;
    }

    @Nullable
    private Class<?> loadClassFromModuleOrDependency(@NotNull Module module2, @NotNull String name) {
        if (module2 == null) {
            ModuleClassLoader.$$$reportNull$$$0(15);
        }
        if (name == null) {
            ModuleClassLoader.$$$reportNull$$$0(16);
        }
        if (module2.isDisposed()) {
            return null;
        }
        VirtualFile classFile = ProjectSystemUtil.getModuleSystem(module2).findClassFile(name);
        if (classFile == null) {
            return null;
        }
        return this.loadClassFile(name, classFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSourceModified(@NotNull String name, @Nullable Object myCredential) {
        if (name == null) {
            ModuleClassLoader.$$$reportNull$$$0(17);
        }
        if (ModuleClassLoader.isResourceClassName(name)) {
            return false;
        }
        Module module2 = (Module)this.myModuleReference.get();
        if (module2 == null) {
            return false;
        }
        VirtualFile classFile = this.getClassFile(name);
        if (classFile == null) {
            return false;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null || AndroidModel.get(facet2) == null) {
            return false;
        }
        boolean token = RenderSecurityManager.enterSafeRegion(myCredential);
        try {
            boolean bl = AndroidModel.get(facet2).isClassFileOutOfDate(module2, name, classFile);
            return bl;
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }

    private static boolean isResourceClassName(@NotNull String className2) {
        if (className2 == null) {
            ModuleClassLoader.$$$reportNull$$$0(18);
        }
        return RESOURCE_CLASS_NAME.matcher(className2).matches();
    }

    @Override
    @Nullable
    protected Class<?> loadClassFile(@NotNull String name, @NotNull VirtualFile classFile) {
        if (name == null) {
            ModuleClassLoader.$$$reportNull$$$0(19);
        }
        if (classFile == null) {
            ModuleClassLoader.$$$reportNull$$$0(20);
        }
        if (this.myClassFiles == null) {
            this.myClassFiles = new ConcurrentHashMap<String, VirtualFile>();
            this.myClassFilesLastModified = new ConcurrentHashMap<String, ClassModificationTimestamp>();
        }
        this.myClassFiles.put(name, classFile);
        this.myClassFilesLastModified.put(name, new ClassModificationTimestamp(classFile.getTimeStamp(), classFile.getLength()));
        return super.loadClassFile(name, classFile);
    }

    private static void registerResources(@NotNull Module module2) {
        AndroidFacet androidFacet;
        if (module2 == null) {
            ModuleClassLoader.$$$reportNull$$$0(21);
        }
        if ((androidFacet = AndroidFacet.getInstance((Module)module2)) == null) {
            return;
        }
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(androidFacet);
        ResourceIdManager idManager = ResourceIdManager.get(module2);
        ResourceClassRegistry classRegistry = ResourceClassRegistry.get(module2.getProject());
        if (!idManager.finalIdsUsed()) {
            classRegistry.addLibrary((ResourceRepository)repositoryManager.getAppResources(), idManager, (String)ReadAction.compute(() -> AndroidManifestUtils.getPackageName(androidFacet)), repositoryManager.getNamespace());
        }
        for (AndroidFacet dependency : AndroidUtils.getAllAndroidDependencies(module2, false)) {
            classRegistry.addLibrary((ResourceRepository)repositoryManager.getAppResources(), idManager, (String)ReadAction.compute(() -> AndroidManifestUtils.getPackageName(dependency)), repositoryManager.getNamespace());
        }
        AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem(module2);
        for (ExternalLibrary library : moduleSystem.getResolvedLibraryDependencies()) {
            if (!library.getHasResources()) continue;
            ModuleClassLoader.registerLibraryResources(library, repositoryManager, classRegistry, idManager);
        }
    }

    private static void registerLibraryResources(@NotNull ExternalLibrary library, @NotNull ResourceRepositoryManager repositoryManager, @NotNull ResourceClassRegistry classRegistry, @NotNull ResourceIdManager idManager) {
        ResourceNamespace resourcesNamespace;
        Object rClassContents;
        String packageName;
        if (library == null) {
            ModuleClassLoader.$$$reportNull$$$0(22);
        }
        if (repositoryManager == null) {
            ModuleClassLoader.$$$reportNull$$$0(23);
        }
        if (classRegistry == null) {
            ModuleClassLoader.$$$reportNull$$$0(24);
        }
        if (idManager == null) {
            ModuleClassLoader.$$$reportNull$$$0(25);
        }
        LocalResourceRepository appResources = repositoryManager.getAppResources();
        if (repositoryManager.getNamespacing() == Namespacing.DISABLED) {
            packageName = ModuleClassLoader.getPackageName(library);
            if (packageName == null) {
                return;
            }
            rClassContents = appResources;
            resourcesNamespace = ResourceNamespace.RES_AUTO;
        } else {
            AarResourceRepository aarResources = repositoryManager.findLibraryResources(library);
            if (aarResources == null) {
                return;
            }
            rClassContents = aarResources;
            resourcesNamespace = aarResources.getNamespace();
            packageName = aarResources.getPackageName();
        }
        classRegistry.addLibrary((ResourceRepository)rClassContents, idManager, packageName, resourcesNamespace);
    }

    @Nullable
    private static String getPackageName(@NotNull ExternalLibrary library) {
        block7: {
            if (library == null) {
                ModuleClassLoader.$$$reportNull$$$0(26);
            }
            if (library.getPackageName() != null) {
                return library.getPackageName();
            }
            PathString manifestFile = library.getManifestFile();
            if (manifestFile != null) {
                try {
                    return AndroidManifestPackageNameUtils.getPackageNameFromManifestFile((PathString)manifestFile);
                }
                catch (IOException ignore) {
                    if (!VirtualFileSystemOpener.INSTANCE.recognizes(manifestFile)) break block7;
                    FileExtensions.toVirtualFile(manifestFile, true);
                    try {
                        return AndroidManifestPackageNameUtils.getPackageNameFromManifestFile((PathString)manifestFile);
                    }
                    catch (IOException ignore2) {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected List<Path> getExternalJars() {
        ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.concat(this.mAdditionalLibraries, ClassLoadingUtilsKt.getLibraryDependenciesJars((Module)this.myModuleReference.get())));
        if (arrayList == null) {
            ModuleClassLoader.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @Nullable
    private VirtualFile getClassFile(@NotNull String className2) {
        if (className2 == null) {
            ModuleClassLoader.$$$reportNull$$$0(28);
        }
        if (this.myClassFiles == null) {
            return null;
        }
        VirtualFile file2 = this.myClassFiles.get(className2);
        if (file2 == null) {
            return null;
        }
        return file2.isValid() ? file2 : null;
    }

    boolean isUpToDate() {
        if (this.myClassFiles != null) {
            for (Map.Entry<String, VirtualFile> entry : this.myClassFiles.entrySet()) {
                String className2 = entry.getKey();
                VirtualFile classFile = entry.getValue();
                if (!classFile.isValid()) {
                    return false;
                }
                ClassModificationTimestamp lastModifiedStamp = this.myClassFilesLastModified.get(className2);
                if (lastModifiedStamp == null) continue;
                long loadedModifiedTime = lastModifiedStamp.timestamp;
                long loadedModifiedLength = lastModifiedStamp.length;
                long classFileModifiedTime = classFile.getTimeStamp();
                long classFileModifiedLength = classFile.getLength();
                if ((classFileModifiedTime <= 0L || loadedModifiedTime <= 0L || loadedModifiedTime >= classFileModifiedTime) && loadedModifiedLength == classFileModifiedLength) continue;
                return false;
            }
        }
        return this.areDependenciesUpToDate();
    }

    public boolean isClassLoaded(@NotNull String className2) {
        if (className2 == null) {
            ModuleClassLoader.$$$reportNull$$$0(29);
        }
        return this.findLoadedClass(className2) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/uipreview/ModuleClassLoader";
                break;
            }
            case 2: 
            case 5: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTransformations";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonProjectTransformations";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 18: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFile";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classRegistry";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/uipreview/ModuleClassLoader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "nonProjectClassNameLookup";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalLibraries";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findClass";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalJars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nonProjectClassNameLookup";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 27: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isRepackagedClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadClassFromModuleOrDependency";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSourceModified";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isResourceClassName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadClassFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "registerResources";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "registerLibraryResources";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getClassFile";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isClassLoaded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ClassModificationTimestamp {
        public final long timestamp;
        public final long length;

        ClassModificationTimestamp(long timestamp, long length) {
            this.timestamp = timestamp;
            this.length = length;
        }
    }
}

