/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.tools.idea.model.AndroidModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.uipreview.ClassLoadingUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0000\u00a8\u0006\b"}, d2={"getExternalLibraryJars", "Lkotlin/sequences/Sequence;", "Ljava/io/File;", "module", "Lcom/intellij/openapi/module/Module;", "getLibraryDependenciesJars", "", "Ljava/nio/file/Path;", "intellij.android.core"})
public final class ClassLoadingUtilsKt {
    private static final Sequence<File> getExternalLibraryJars(Module module2) {
        AndroidModel model2;
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 != null && AndroidModel.isRequired(facet2) && (model2 = AndroidModel.get(facet2)) != null) {
            List<File> list = model2.getClassJarProvider().getModuleExternalLibraries(module2);
            Intrinsics.checkNotNullExpressionValue(list, (String)"model.classJarProvider.g\u2026ExternalLibraries(module)");
            return CollectionsKt.asSequence((Iterable)list);
        }
        List<VirtualFile> list = AndroidRootUtil.getExternalLibraries(module2);
        Intrinsics.checkNotNullExpressionValue(list, (String)"AndroidRootUtil.getExternalLibraries(module)");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)getExternalLibraryJars.1.INSTANCE);
    }

    @NotNull
    public static final List<Path> getLibraryDependenciesJars(@Nullable Module module2) {
        if (module2 == null || module2.isDisposed()) {
            return CollectionsKt.emptyList();
        }
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(ClassLoadingUtilsKt.getExternalLibraryJars(module2), (Function1)getLibraryDependenciesJars.1.INSTANCE), (Function1)getLibraryDependenciesJars.2.INSTANCE));
    }
}

