/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.SdkConstants;
import com.android.internal.util.Preconditions;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.OptionalLibrary;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.util.StudioPathManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.download.AndroidLayoutlibDownloader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioEmbeddedRenderTarget
implements IAndroidTarget {
    private static final Logger LOG = Logger.getInstance(StudioEmbeddedRenderTarget.class);
    private static final String ONLY_FOR_RENDERING_ERROR = "This target is only for rendering";
    private static final String FRAMEWORK_RES_JAR = "framework_res.jar";
    @Nullable
    private final String myBasePath = StudioEmbeddedRenderTarget.getEmbeddedLayoutLibPath();
    private static StudioEmbeddedRenderTarget ourStudioEmbeddedTarget;
    private static boolean ourDisableEmbeddedTargetForTesting;

    @VisibleForTesting
    public static void setDisableEmbeddedTarget(boolean value2) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ourDisableEmbeddedTargetForTesting = value2;
    }

    public static CompatibilityRenderTarget getCompatibilityTarget(@NotNull IAndroidTarget target) {
        StudioEmbeddedRenderTarget embeddedRenderer;
        if (target == null) {
            StudioEmbeddedRenderTarget.$$$reportNull$$$0(0);
        }
        if (!(embeddedRenderer = StudioEmbeddedRenderTarget.getInstance()).isValid() || ourDisableEmbeddedTargetForTesting) {
            return new CompatibilityRenderTarget(target, target.getVersion().getApiLevel(), target);
        }
        int api = target.getVersion().getApiLevel();
        if (target instanceof CompatibilityRenderTarget) {
            CompatibilityRenderTarget compatRenderTarget = (CompatibilityRenderTarget)target;
            target = compatRenderTarget.getRealTarget();
        }
        return new CompatibilityRenderTarget(embeddedRenderer, api, target);
    }

    @NotNull
    @VisibleForTesting
    public static StudioEmbeddedRenderTarget getInstance() {
        if (ourStudioEmbeddedTarget == null) {
            ourStudioEmbeddedTarget = new StudioEmbeddedRenderTarget();
        }
        StudioEmbeddedRenderTarget studioEmbeddedRenderTarget = ourStudioEmbeddedTarget;
        if (studioEmbeddedRenderTarget == null) {
            StudioEmbeddedRenderTarget.$$$reportNull$$$0(1);
        }
        return studioEmbeddedRenderTarget;
    }

    private StudioEmbeddedRenderTarget() {
    }

    private boolean isValid() {
        return this.myBasePath != null;
    }

    @Nullable
    public static String getEmbeddedLayoutLibPath() {
        String homePath = FileUtil.toSystemIndependentName((String)(PathManager.getHomePath() + "/"));
        String[] paths = new String[]{FileUtil.join((String[])new String[]{homePath, "plugins/android/lib/layoutlib/"}), StudioPathManager.isRunningFromSources() ? FileUtil.join((String[])new String[]{StudioPathManager.getSourcesRoot(), "prebuilts/studio/layoutlib/"}) : null, StudioPathManager.isRunningFromSources() ? FileUtil.join((String[])new String[]{PathManager.getCommunityHomePath(), "build/dependencies/build/android-sdk/layoutlib/plugins/android/lib/layoutlib/"}) : null};
        StringBuilder notFoundPaths = new StringBuilder();
        for (String path2 : paths) {
            if (path2 == null) continue;
            VirtualFile root2 = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path2));
            if (root2 != null) {
                File rootFile = VfsUtilCore.virtualToIoFile((VirtualFile)root2);
                if (!rootFile.exists() || !rootFile.isDirectory()) continue;
                LOG.debug("Embedded layoutlib found at " + path2);
                return rootFile.getAbsolutePath() + File.separator;
            }
            notFoundPaths.append(path2).append('\n');
        }
        AndroidLayoutlibDownloader.getInstance().makeSureComponentIsInPlace();
        File dir = AndroidLayoutlibDownloader.getInstance().getHostDir("plugins/android/lib/layoutlib/");
        if (dir.exists()) {
            return dir.getAbsolutePath() + File.separator;
        }
        notFoundPaths.append(dir).append('\n');
        LOG.error("Unable to find embedded layoutlib in paths:\n" + notFoundPaths);
        return null;
    }

    @NotNull
    public String getLocation() {
        Preconditions.checkState((this.myBasePath != null ? 1 : 0) != 0, (String)"Embedded layoutlib not found");
        String string = this.myBasePath;
        if (string == null) {
            StudioEmbeddedRenderTarget.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String getVendor() {
        return "Android Open Source Project";
    }

    @NotNull
    public AndroidVersion getVersion() {
        throw new UnsupportedOperationException("This target can only be used as a CompatibilityRenderTarget delegate");
    }

    public String getVersionName() {
        throw new UnsupportedOperationException("This target can only be used as a CompatibilityRenderTarget delegate");
    }

    public int getRevision() {
        return 1;
    }

    public boolean isPlatform() {
        return true;
    }

    public IAndroidTarget getParent() {
        return null;
    }

    @NotNull
    public String getPath(int pathId) {
        switch (pathId) {
            case 7: {
                String string = this.getLocation() + SdkConstants.OS_PLATFORM_DATA_FOLDER;
                if (string == null) {
                    StudioEmbeddedRenderTarget.$$$reportNull$$$0(3);
                }
                return string;
            }
            case 11: {
                String string = this.getLocation() + SdkConstants.OS_PLATFORM_DATA_FOLDER + FRAMEWORK_RES_JAR;
                if (string == null) {
                    StudioEmbeddedRenderTarget.$$$reportNull$$$0(4);
                }
                return string;
            }
            case 12: {
                String string = this.getLocation() + SdkConstants.OS_PLATFORM_FONTS_FOLDER;
                if (string == null) {
                    StudioEmbeddedRenderTarget.$$$reportNull$$$0(5);
                }
                return string;
            }
        }
        assert (false) : this.getClass().getSimpleName() + " does not support path of type " + pathId;
        String string = this.getLocation();
        if (string == null) {
            StudioEmbeddedRenderTarget.$$$reportNull$$$0(6);
        }
        return string;
    }

    public BuildToolInfo getBuildToolInfo() {
        return null;
    }

    @NotNull
    public List<String> getBootClasspath() {
        ImmutableList immutableList = ImmutableList.of((Object)this.getPath(1));
        if (immutableList == null) {
            StudioEmbeddedRenderTarget.$$$reportNull$$$0(7);
        }
        return immutableList;
    }

    public boolean hasRenderingLibrary() {
        return true;
    }

    public String getName() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public String getFullName() {
        return this.getName();
    }

    public String getClasspathName() {
        return this.getName();
    }

    public String getShortClasspathName() {
        return this.getName();
    }

    @NotNull
    public List<OptionalLibrary> getOptionalLibraries() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    @NotNull
    public List<OptionalLibrary> getAdditionalLibraries() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    @NotNull
    public File[] getSkins() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    @Nullable
    public File getDefaultSkin() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public String[] getPlatformLibraries() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public String getProperty(String name) {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public Map<String, String> getProperties() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public boolean canRunOn(IAndroidTarget target) {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public String hashString() {
        return "studio-embedded-render-target";
    }

    public int compareTo(IAndroidTarget o) {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public static void resetInstance() {
        ourStudioEmbeddedTarget = null;
    }

    static {
        ourDisableEmbeddedTargetForTesting = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/sdk/StudioEmbeddedRenderTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/sdk/StudioEmbeddedRenderTarget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBootClasspath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibilityTarget";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

