/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.LayoutLibraryLoader;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.res.FrameworkResourceRepositoryManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeDefinitionsImpl;
import org.jetbrains.android.resourceManagers.FilteredAttributeDefinitions;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.StudioEmbeddedRenderTarget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTargetData {
    private static final Logger LOG = Logger.getInstance(AndroidTargetData.class);
    private final AndroidSdkData mySdkData;
    private final IAndroidTarget myTarget;
    private final Object myAttrDefsLock;
    private AttributeDefinitions myAttrDefs;
    private volatile LayoutLibrary myLayoutLibrary;
    private final Object myPublicResourceCacheLock;
    private volatile Map<String, Set<String>> myPublicResourceCache;
    private TIntObjectHashMap<String> myPublicResourceIdMap;
    private volatile MyStaticConstantsData myStaticConstantsData;

    public AndroidTargetData(@NotNull AndroidSdkData sdkData, @NotNull IAndroidTarget target) {
        if (sdkData == null) {
            AndroidTargetData.$$$reportNull$$$0(0);
        }
        if (target == null) {
            AndroidTargetData.$$$reportNull$$$0(1);
        }
        this.myAttrDefsLock = new Object();
        this.myPublicResourceCacheLock = new Object();
        this.mySdkData = sdkData;
        this.myTarget = target;
    }

    @NotNull
    public AttributeDefinitions getPublicAttrDefs(@NotNull Project project) {
        if (project == null) {
            AndroidTargetData.$$$reportNull$$$0(2);
        }
        AttributeDefinitions attrDefs = this.getAllAttrDefs(project);
        return new PublicAttributeDefinitions(attrDefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public AttributeDefinitions getAllAttrDefs(@NotNull Project project) {
        if (project == null) {
            AndroidTargetData.$$$reportNull$$$0(3);
        }
        Object object = this.myAttrDefsLock;
        // MONITORENTER : object
        if (this.myAttrDefs == null) {
            String attrsPath = FileUtil.toSystemIndependentName((String)this.myTarget.getPath(8));
            String attrsManifestPath = FileUtil.toSystemIndependentName((String)this.myTarget.getPath(9));
            this.myAttrDefs = AttributeDefinitionsImpl.parseFrameworkFiles(new File(attrsPath), new File(attrsManifestPath));
        }
        AttributeDefinitions attributeDefinitions = this.myAttrDefs;
        // MONITOREXIT : object
        if (attributeDefinitions != null) return attributeDefinitions;
        AndroidTargetData.$$$reportNull$$$0(4);
        return attributeDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Map<String, Set<String>> getPublicResourceCache() {
        Object object = this.myPublicResourceCacheLock;
        synchronized (object) {
            if (this.myPublicResourceCache == null) {
                this.parsePublicResCache();
            }
            return this.myPublicResourceCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TIntObjectHashMap<String> getPublicIdMap() {
        Object object = this.myPublicResourceCacheLock;
        synchronized (object) {
            if (this.myPublicResourceIdMap == null) {
                this.parsePublicResCache();
            }
            return this.myPublicResourceIdMap;
        }
    }

    public boolean isResourcePublic(@NotNull String type, @NotNull String name) {
        Map<String, Set<String>> publicResourceCache;
        if (type == null) {
            AndroidTargetData.$$$reportNull$$$0(5);
        }
        if (name == null) {
            AndroidTargetData.$$$reportNull$$$0(6);
        }
        if ((publicResourceCache = this.getPublicResourceCache()) == null) {
            return false;
        }
        Set<String> set = publicResourceCache.get(type);
        return set != null && set.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePublicResCache() {
        String resDirPath = this.myTarget.getPath(11);
        String publicXmlPath = resDirPath + "/values/public.xml";
        VirtualFile publicXml = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)publicXmlPath));
        if (publicXml != null) {
            try {
                MyPublicResourceCacheBuilder builder2 = new MyPublicResourceCacheBuilder();
                NanoXmlUtil.parse((InputStream)publicXml.getInputStream(), (IXMLBuilder)builder2);
                Object object = this.myPublicResourceCacheLock;
                synchronized (object) {
                    this.myPublicResourceCache = builder2.getPublicResourceCache();
                    this.myPublicResourceIdMap = builder2.getIdMap();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    public synchronized LayoutLibrary getLayoutLibrary(@NotNull Project project) throws RenderingException {
        if (project == null) {
            AndroidTargetData.$$$reportNull$$$0(7);
        }
        if (this.myLayoutLibrary == null || this.myLayoutLibrary.isDisposed()) {
            IAndroidTarget target;
            AndroidTargetData targetData;
            if (this.myTarget instanceof CompatibilityRenderTarget && (targetData = this.mySdkData.getTargetData(target = ((CompatibilityRenderTarget)this.myTarget).getRenderTarget())) != this) {
                LayoutLibrary layoutLibrary = this.myLayoutLibrary = targetData.getLayoutLibrary(project);
                if (layoutLibrary == null) {
                    AndroidTargetData.$$$reportNull$$$0(8);
                }
                return layoutLibrary;
            }
            if (!(this.myTarget instanceof StudioEmbeddedRenderTarget)) {
                LOG.warn("Rendering will not use the StudioEmbeddedRenderTarget");
            }
            this.myLayoutLibrary = LayoutLibraryLoader.load((IAndroidTarget)this.myTarget, this.getFrameworkEnumValues());
            Disposer.register((Disposable)project, (Disposable)this.myLayoutLibrary);
        }
        LayoutLibrary layoutLibrary = this.myLayoutLibrary;
        if (layoutLibrary == null) {
            AndroidTargetData.$$$reportNull$$$0(9);
        }
        return layoutLibrary;
    }

    @NotNull
    private Map<String, Map<String, Integer>> getFrameworkEnumValues() {
        ResourceRepository resources = this.getFrameworkResources((Set<String>)ImmutableSet.of());
        if (resources == null) {
            Map<String, Map<String, Integer>> map2 = Collections.emptyMap();
            if (map2 == null) {
                AndroidTargetData.$$$reportNull$$$0(10);
            }
            return map2;
        }
        HashMap<String, Map<String, Integer>> result2 = new HashMap<String, Map<String, Integer>>();
        Collection items2 = resources.getResources(ResourceNamespace.ANDROID, ResourceType.ATTR).values();
        for (ResourceItem item : items2) {
            Map valueMap;
            ResourceValue attr = item.getResourceValue();
            if (!(attr instanceof AttrResourceValue) || (valueMap = ((AttrResourceValue)attr).getAttributeValues()).isEmpty()) continue;
            result2.put(attr.getName(), valueMap);
        }
        items2 = resources.getResources(ResourceNamespace.ANDROID, ResourceType.STYLEABLE).values();
        for (ResourceItem item : items2) {
            ResourceValue styleable = item.getResourceValue();
            if (!(styleable instanceof StyleableResourceValue)) continue;
            List attrs = ((StyleableResourceValue)styleable).getAllAttributes();
            for (AttrResourceValue attr : attrs) {
                Map valueMap = attr.getAttributeValues();
                if (valueMap.isEmpty()) continue;
                result2.put(attr.getName(), valueMap);
            }
        }
        HashMap<String, Map<String, Integer>> hashMap = result2;
        if (hashMap == null) {
            AndroidTargetData.$$$reportNull$$$0(11);
        }
        return hashMap;
    }

    public void clearLayoutBitmapCache(Module module2) {
        if (this.myLayoutLibrary != null) {
            this.myLayoutLibrary.clearResourceCaches((Object)module2);
        }
    }

    public void clearFontCache(String path2) {
        if (this.myLayoutLibrary != null) {
            this.myLayoutLibrary.clearFontCache(path2);
        }
    }

    public void clearAllCaches(Module module2) {
        if (this.myLayoutLibrary != null) {
            this.myLayoutLibrary.clearAllCaches((Object)module2);
        }
    }

    @NotNull
    public IAndroidTarget getTarget() {
        IAndroidTarget iAndroidTarget = this.myTarget;
        if (iAndroidTarget == null) {
            AndroidTargetData.$$$reportNull$$$0(12);
        }
        return iAndroidTarget;
    }

    @NotNull
    public synchronized MyStaticConstantsData getStaticConstantsData() {
        if (this.myStaticConstantsData == null) {
            this.myStaticConstantsData = new MyStaticConstantsData();
        }
        MyStaticConstantsData myStaticConstantsData = this.myStaticConstantsData;
        if (myStaticConstantsData == null) {
            AndroidTargetData.$$$reportNull$$$0(13);
        }
        return myStaticConstantsData;
    }

    @Nullable
    public synchronized ResourceRepository getFrameworkResources(@NotNull Set<String> languages2) {
        File resFolderOrJar;
        if (languages2 == null) {
            AndroidTargetData.$$$reportNull$$$0(14);
        }
        if (!(resFolderOrJar = this.myTarget.getFile(11)).exists()) {
            LOG.error(String.format("\"%s\" directory or file cannot be found", resFolderOrJar.getPath()));
            return null;
        }
        return FrameworkResourceRepositoryManager.getInstance().getFrameworkResources(resFolderOrJar, false, languages2);
    }

    @Nullable
    public static AndroidTargetData getTargetData(@NotNull IAndroidTarget target, @NotNull Module module2) {
        AndroidPlatform platform;
        if (target == null) {
            AndroidTargetData.$$$reportNull$$$0(15);
        }
        if (module2 == null) {
            AndroidTargetData.$$$reportNull$$$0(16);
        }
        return (platform = AndroidPlatform.getInstance(module2)) != null ? platform.getSdkData().getTargetData(target) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkData";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/sdk/AndroidTargetData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languages";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/sdk/AndroidTargetData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAttrDefs";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutLibrary";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkEnumValues";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticConstantsData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPublicAttrDefs";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllAttrDefs";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isResourcePublic";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutLibrary";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkResources";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTargetData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MyStaticConstantsData {
        private final Set<String> myActivityActions = this.collectValues(14);
        private final Set<String> myServiceActions = this.collectValues(16);
        private final Set<String> myReceiverActions = this.collectValues(15);
        private final Set<String> myCategories = this.collectValues(17);

        private MyStaticConstantsData() {
        }

        @Nullable
        public Set<String> getActivityActions() {
            return this.myActivityActions;
        }

        @Nullable
        public Set<String> getServiceActions() {
            return this.myServiceActions;
        }

        @Nullable
        public Set<String> getReceiverActions() {
            return this.myReceiverActions;
        }

        @Nullable
        public Set<String> getCategories() {
            return this.myCategories;
        }

        @Nullable
        private Set<String> collectValues(int pathId) {
            HashSet<String> hashSet;
            block9: {
                BufferedReader reader = Files.newBufferedReader(Paths.get(AndroidTargetData.this.myTarget.getPath(pathId), new String[0]));
                try {
                    String line2;
                    HashSet<String> result2 = new HashSet<String>();
                    while ((line2 = reader.readLine()) != null) {
                        if ((line2 = line2.trim()).isEmpty() || line2.startsWith("#")) continue;
                        result2.add(line2);
                    }
                    hashSet = result2;
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                reader.close();
            }
            return hashSet;
        }
    }

    @VisibleForTesting
    static class MyPublicResourceCacheBuilder
    implements NanoXmlBuilder {
        private final Map<String, Set<String>> myResult = new HashMap<String, Set<String>>();
        private final TIntObjectHashMap<String> myIdMap = new TIntObjectHashMap(3000);
        private String myName;
        private String myType;
        private int myId;
        private boolean inGroup;

        MyPublicResourceCacheBuilder() {
        }

        public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) {
            if ("public".equals(name) && this.myName != null && this.myType != null) {
                Set<String> set = this.myResult.get(this.myType);
                if (set == null) {
                    set = new HashSet<String>();
                    this.myResult.put(this.myType, set);
                }
                set.add(this.myName);
                if (this.myId != 0) {
                    this.myIdMap.put(this.myId, (Object)("@android:" + this.myType + "/" + this.myName));
                    if (this.inGroup) {
                        ++this.myId;
                    }
                }
            }
        }

        public void addAttribute(String key, String nsPrefix, String nsURI, String value2, String type) {
            switch (key) {
                case "name": {
                    this.myName = value2;
                    break;
                }
                case "type": {
                    this.myType = value2;
                    break;
                }
                case "first-id": 
                case "id": {
                    try {
                        this.myId = Integer.decode(value2);
                        break;
                    }
                    catch (NumberFormatException e) {
                        this.myId = 0;
                    }
                }
            }
        }

        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) {
            if (!this.inGroup) {
                this.myType = null;
                this.myId = 0;
            }
            if ("public-group".equals(name)) {
                this.inGroup = true;
            }
            this.myName = null;
        }

        public void endElement(String name, String nsPrefix, String nsURI) {
            if ("public-group".equals(name)) {
                this.inGroup = false;
            }
        }

        public Map<String, Set<String>> getPublicResourceCache() {
            return this.myResult;
        }

        public TIntObjectHashMap<String> getIdMap() {
            return this.myIdMap;
        }
    }

    private class PublicAttributeDefinitions
    extends FilteredAttributeDefinitions {
        protected PublicAttributeDefinitions(AttributeDefinitions wrappee) {
            if (wrappee == null) {
                PublicAttributeDefinitions.$$$reportNull$$$0(0);
            }
            super(wrappee);
        }

        @Override
        protected boolean isAttributeAcceptable(@NotNull ResourceReference attr) {
            if (attr == null) {
                PublicAttributeDefinitions.$$$reportNull$$$0(1);
            }
            return attr.getNamespace().equals((Object)ResourceNamespace.ANDROID) && !attr.getName().startsWith("__removed") && AndroidTargetData.this.isResourcePublic(ResourceType.ATTR.getName(), attr.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrappee";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attr";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/sdk/AndroidTargetData$PublicAttributeDefinitions";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAttributeAcceptable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

