/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.SdkConstants;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.SelectSdkDialog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.CommonBundle;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidSdkUtils {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.sdk.AndroidSdkUtils");
    public static final String DEFAULT_PLATFORM_NAME_PROPERTY = "AndroidPlatformName";
    public static final String DEFAULT_JDK_NAME = "JDK";
    public static final String ADB_PATH_PROPERTY = "android.adb.path";

    private AndroidSdkUtils() {
    }

    @Nullable
    public static Sdk createNewAndroidPlatform(@Nullable String sdkPath, boolean promptUser) {
        Sdk sdk;
        IAndroidTarget target;
        Sdk jdk = IdeSdks.getInstance().getJdk();
        if (sdkPath != null && jdk != null && (target = AndroidSdkUtils.findBestTarget(sdkPath = FileUtil.toSystemIndependentName((String)sdkPath))) != null && (sdk = AndroidSdks.getInstance().create(target, new File(sdkPath), AndroidSdks.getInstance().chooseNameForNewLibrary(target), jdk, true)) != null) {
            return sdk;
        }
        String jdkPath = jdk == null ? null : jdk.getHomePath();
        return promptUser ? AndroidSdkUtils.promptUserForSdkCreation(null, sdkPath, jdkPath) : null;
    }

    @Nullable
    private static IAndroidTarget findBestTarget(@NotNull String sdkPath) {
        AndroidSdkData sdkData;
        if (sdkPath == null) {
            AndroidSdkUtils.$$$reportNull$$$0(0);
        }
        if ((sdkData = AndroidSdkData.getSdkData(sdkPath)) != null) {
            IAndroidTarget[] targets = sdkData.getTargets();
            if (targets.length == 1) {
                return targets[0];
            }
            return AndroidSdkUtils.findBestTarget(targets);
        }
        return null;
    }

    @Nullable
    private static IAndroidTarget findBestTarget(@NotNull IAndroidTarget[] targets) {
        if (targets == null) {
            AndroidSdkUtils.$$$reportNull$$$0(1);
        }
        IAndroidTarget bestTarget = null;
        int maxApiLevel = -1;
        for (IAndroidTarget target : targets) {
            AndroidVersion version2 = target.getVersion();
            if (!target.isPlatform() || version2.isPreview() || version2.getApiLevel() <= maxApiLevel) continue;
            bestTarget = target;
            maxApiLevel = version2.getApiLevel();
        }
        return bestTarget;
    }

    public static String getTargetPresentableName(@NotNull IAndroidTarget target) {
        if (target == null) {
            AndroidSdkUtils.$$$reportNull$$$0(2);
        }
        return target.isPlatform() ? target.getName() : target.getName() + " (" + target.getVersionName() + ")";
    }

    public static boolean targetHasId(@NotNull IAndroidTarget target, @NotNull String id) {
        if (target == null) {
            AndroidSdkUtils.$$$reportNull$$$0(3);
        }
        if (id == null) {
            AndroidSdkUtils.$$$reportNull$$$0(4);
        }
        return id.equals(target.getVersion().getApiString()) || id.equals(target.getVersionName());
    }

    private static boolean tryToSetAndroidPlatform(@NotNull Module module2, @NotNull Sdk sdk) {
        AndroidPlatform platform;
        if (module2 == null) {
            AndroidSdkUtils.$$$reportNull$$$0(5);
        }
        if (sdk == null) {
            AndroidSdkUtils.$$$reportNull$$$0(6);
        }
        if ((platform = AndroidPlatform.parse(sdk)) != null) {
            ModuleRootModificationUtil.setModuleSdk((Module)module2, (Sdk)sdk);
            return true;
        }
        return false;
    }

    private static void setupPlatform(@NotNull Module module2) {
        String targetHashString;
        if (module2 == null) {
            AndroidSdkUtils.$$$reportNull$$$0(7);
        }
        if ((targetHashString = AndroidSdkUtils.getTargetHashStringFromPropertyFile(module2)) != null && AndroidSdkUtils.findAndSetSdkWithHashString(module2, targetHashString)) {
            return;
        }
        PropertiesComponent component = PropertiesComponent.getInstance();
        if (component.isValueSet(DEFAULT_PLATFORM_NAME_PROPERTY)) {
            String defaultPlatformName = component.getValue(DEFAULT_PLATFORM_NAME_PROPERTY);
            Sdk defaultLib = ProjectJdkTable.getInstance().findJdk(defaultPlatformName, AndroidSdkType.getInstance().getName());
            if (defaultLib != null && AndroidSdkUtils.tryToSetAndroidPlatform(module2, defaultLib)) {
                return;
            }
        }
        for (Sdk sdk : AndroidSdks.getInstance().getAllAndroidSdks()) {
            AndroidPlatform platform = AndroidPlatform.getInstance(sdk);
            if (platform == null || !AndroidSdkUtils.checkSdkRoots(sdk, platform.getTarget(), false) || !AndroidSdkUtils.tryToSetAndroidPlatform(module2, sdk)) continue;
            component.setValue(DEFAULT_PLATFORM_NAME_PROPERTY, sdk.getName());
            return;
        }
    }

    @Nullable
    private static String getTargetHashStringFromPropertyFile(@NotNull Module module2) {
        Pair<String, VirtualFile> targetProp;
        if (module2 == null) {
            AndroidSdkUtils.$$$reportNull$$$0(8);
        }
        return (targetProp = AndroidRootUtil.getProjectPropertyValue(module2, "target")) != null ? (String)targetProp.getFirst() : null;
    }

    private static boolean findAndSetSdkWithHashString(@NotNull Module module2, @NotNull String targetHashString) {
        Pair<String, VirtualFile> sdkDirProperty;
        if (module2 == null) {
            AndroidSdkUtils.$$$reportNull$$$0(9);
        }
        if (targetHashString == null) {
            AndroidSdkUtils.$$$reportNull$$$0(10);
        }
        String sdkDir = (sdkDirProperty = AndroidRootUtil.getPropertyValue(module2, "local.properties", "sdk.dir")) != null ? (String)sdkDirProperty.getFirst() : null;
        return AndroidSdkUtils.findAndSetSdk(module2, targetHashString, sdkDir);
    }

    public static boolean findAndSetSdk(@NotNull Module module2, @NotNull String targetHashString, @Nullable String sdkPath) {
        Sdk sdk;
        if (module2 == null) {
            AndroidSdkUtils.$$$reportNull$$$0(11);
        }
        if (targetHashString == null) {
            AndroidSdkUtils.$$$reportNull$$$0(12);
        }
        File path2 = null;
        if (sdkPath != null) {
            path2 = new File(FileUtil.toSystemIndependentName((String)sdkPath));
        }
        if ((sdk = AndroidSdks.getInstance().findSuitableAndroidSdk(targetHashString)) != null) {
            ModuleRootModificationUtil.setModuleSdk((Module)module2, (Sdk)sdk);
            return true;
        }
        if (sdkPath != null && AndroidSdkUtils.tryToCreateAndSetAndroidSdk(module2, path2, targetHashString)) {
            return true;
        }
        String androidHomeValue = System.getenv("ANDROID_HOME");
        if (androidHomeValue != null && AndroidSdkUtils.tryToCreateAndSetAndroidSdk(module2, new File(FileUtil.toSystemIndependentName((String)androidHomeValue)), targetHashString)) {
            return true;
        }
        String androidSdkRootValue = System.getenv("ANDROID_SDK_ROOT");
        if (androidSdkRootValue != null && AndroidSdkUtils.tryToCreateAndSetAndroidSdk(module2, new File(FileUtil.toSystemIndependentName((String)androidSdkRootValue)), targetHashString)) {
            return true;
        }
        for (File dir : AndroidSdks.getInstance().getAndroidSdkPathsFromExistingPlatforms()) {
            if (!AndroidSdkUtils.tryToCreateAndSetAndroidSdk(module2, dir, targetHashString)) continue;
            return true;
        }
        return false;
    }

    public static void updateSdkSourceRoot(@NotNull Sdk sdk) {
        AndroidPlatform platform;
        if (sdk == null) {
            AndroidSdkUtils.$$$reportNull$$$0(13);
        }
        if ((platform = AndroidPlatform.getInstance(sdk)) != null) {
            IAndroidTarget target = platform.getTarget();
            SdkModificator sdkModificator = sdk.getSdkModificator();
            sdkModificator.removeRoots(OrderRootType.SOURCES);
            AndroidSdks.getInstance().findAndSetPlatformSources(target, sdkModificator);
            sdkModificator.commitChanges();
        }
    }

    @VisibleForTesting
    static boolean tryToCreateAndSetAndroidSdk(@NotNull Module module2, @NotNull File sdkPath, @NotNull String targetHashString) {
        Sdk sdk;
        if (module2 == null) {
            AndroidSdkUtils.$$$reportNull$$$0(14);
        }
        if (sdkPath == null) {
            AndroidSdkUtils.$$$reportNull$$$0(15);
        }
        if (targetHashString == null) {
            AndroidSdkUtils.$$$reportNull$$$0(16);
        }
        if ((sdk = AndroidSdks.getInstance().tryToCreate(sdkPath, targetHashString)) != null) {
            ModuleRootModificationUtil.setModuleSdk((Module)module2, (Sdk)sdk);
            return true;
        }
        return false;
    }

    @Nullable
    private static Sdk promptUserForSdkCreation(@Nullable IAndroidTarget target, @Nullable String androidSdkPath, @Nullable String jdkPath) {
        Ref sdkRef = new Ref();
        Runnable task2 = () -> {
            SelectSdkDialog dlg = new SelectSdkDialog(jdkPath, androidSdkPath);
            dlg.setModal(true);
            if (dlg.showAndGet()) {
                Sdk sdk = AndroidSdkUtils.createNewAndroidPlatform(target, dlg.getAndroidHome(), dlg.getJdkHome());
                sdkRef.set((Object)sdk);
                if (sdk != null) {
                    IdeSdks.updateWelcomeRunAndroidSdkAction();
                }
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            task2.run();
            return (Sdk)sdkRef.get();
        }
        application.invokeAndWait(task2, ModalityState.any());
        return (Sdk)sdkRef.get();
    }

    @Nullable
    private static Sdk createNewAndroidPlatform(@Nullable IAndroidTarget target, @NotNull String androidSdkPath, @NotNull String jdkPath) {
        if (androidSdkPath == null) {
            AndroidSdkUtils.$$$reportNull$$$0(17);
        }
        if (jdkPath == null) {
            AndroidSdkUtils.$$$reportNull$$$0(18);
        }
        if (StringUtil.isNotEmpty((String)jdkPath)) {
            jdkPath = FileUtil.toSystemIndependentName((String)jdkPath);
            Sdk jdk = Jdks.getInstance().createJdk(jdkPath);
            if (jdk != null) {
                androidSdkPath = FileUtil.toSystemIndependentName((String)androidSdkPath);
                if (target == null) {
                    target = AndroidSdkUtils.findBestTarget(androidSdkPath);
                }
                if (target != null) {
                    return AndroidSdks.getInstance().create(target, new File(androidSdkPath), AndroidSdks.getInstance().chooseNameForNewLibrary(target), jdk, true);
                }
            }
        }
        return null;
    }

    public static void setupAndroidPlatformIfNecessary(@NotNull Module module2, boolean forceImportFromProperties) {
        AndroidPlatform platform;
        Sdk currentSdk;
        if (module2 == null) {
            AndroidSdkUtils.$$$reportNull$$$0(19);
        }
        if ((currentSdk = ModuleRootManager.getInstance((Module)module2).getSdk()) == null || !AndroidSdks.getInstance().isAndroidSdk(currentSdk)) {
            AndroidSdkUtils.setupPlatform(module2);
            return;
        }
        if (forceImportFromProperties && (platform = AndroidPlatform.getInstance(currentSdk)) != null) {
            String targetHashString = AndroidSdkUtils.getTargetHashStringFromPropertyFile(module2);
            String currentTargetHashString = platform.getTarget().hashString();
            if (targetHashString != null && !targetHashString.equals(currentTargetHashString)) {
                AndroidSdkUtils.findAndSetSdkWithHashString(module2, targetHashString);
            }
        }
    }

    public static void openModuleDependenciesConfigurable(@NotNull Module module2) {
        if (module2 == null) {
            AndroidSdkUtils.$$$reportNull$$$0(20);
        }
        ProjectSettingsService.getInstance((Project)module2.getProject()).openModuleDependenciesSettings(module2, null);
    }

    @Nullable
    public static Sdk findAppropriateAndroidPlatform(@NotNull IAndroidTarget target, @NotNull AndroidSdkData sdkData, boolean forMaven) {
        if (target == null) {
            AndroidSdkUtils.$$$reportNull$$$0(21);
        }
        if (sdkData == null) {
            AndroidSdkUtils.$$$reportNull$$$0(22);
        }
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            IAndroidTarget currentTarget;
            AndroidSdkAdditionalData data;
            AndroidSdkData currentSdkData;
            String homePath = sdk.getHomePath();
            AndroidSdks androidSdks = AndroidSdks.getInstance();
            if (homePath == null || !androidSdks.isAndroidSdk(sdk) || !sdkData.equals(currentSdkData = AndroidSdkData.getSdkData(homePath)) || (data = androidSdks.getAndroidSdkAdditionalData(sdk)) == null || (currentTarget = data.getBuildTarget(currentSdkData)) == null || !target.hashString().equals(currentTarget.hashString()) || !AndroidSdkUtils.checkSdkRoots(sdk, target, forMaven)) continue;
            return sdk;
        }
        return null;
    }

    public static boolean checkSdkRoots(@NotNull Sdk sdk, @NotNull IAndroidTarget target, boolean forMaven) {
        Sdk javaSdk;
        String homePath;
        if (sdk == null) {
            AndroidSdkUtils.$$$reportNull$$$0(23);
        }
        if (target == null) {
            AndroidSdkUtils.$$$reportNull$$$0(24);
        }
        if ((homePath = sdk.getHomePath()) == null) {
            return false;
        }
        AndroidSdks androidSdks = AndroidSdks.getInstance();
        AndroidSdkAdditionalData sdkAdditionalData = androidSdks.getAndroidSdkAdditionalData(sdk);
        Sdk sdk2 = javaSdk = sdkAdditionalData != null ? sdkAdditionalData.getJavaSdk() : null;
        if (javaSdk == null) {
            return false;
        }
        HashSet filesInSdk = Sets.newHashSet((Object[])sdk.getRootProvider().getFiles(OrderRootType.CLASSES));
        List<VirtualFile> platformAndAddOnJars = androidSdks.getPlatformAndAddOnJars(target);
        for (VirtualFile file2 : platformAndAddOnJars) {
            if (filesInSdk.contains(file2) != forMaven) continue;
            return false;
        }
        boolean containsJarFromJdk = false;
        for (VirtualFile file3 : javaSdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
            if (!(file3.getFileType() instanceof ArchiveFileType) || !filesInSdk.contains(file3)) continue;
            containsJarFromJdk = true;
        }
        return containsJarFromJdk == forMaven;
    }

    @Nullable
    public static File getAdb(@Nullable Project project) {
        File adb;
        String path2 = System.getProperty(ADB_PATH_PROPERTY);
        if (path2 != null && (adb = new File(path2)).exists()) {
            return adb;
        }
        adb = null;
        if (project != null) {
            AndroidSdkData data = AndroidSdkUtils.getProjectSdkData(project);
            if (data == null) {
                data = AndroidSdkUtils.getFirstAndroidModuleSdkData(project);
            }
            File file2 = adb = data == null ? null : new File(data.getLocation(), AndroidBuildCommonUtils.platformToolPath((String)SdkConstants.FN_ADB));
        }
        if (adb == null && IdeSdks.getInstance().getAndroidSdkPath() != null) {
            adb = new File(IdeSdks.getInstance().getAndroidSdkPath(), AndroidBuildCommonUtils.platformToolPath((String)SdkConstants.FN_ADB));
        }
        return adb != null && adb.exists() ? adb : null;
    }

    @Nullable
    public static AndroidSdkData getFirstAndroidModuleSdkData(Project project) {
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        for (AndroidFacet facet2 : facets) {
            AndroidPlatform androidPlatform = AndroidPlatform.getInstance(facet2.getModule());
            if (androidPlatform == null) continue;
            return androidPlatform.getSdkData();
        }
        return null;
    }

    @Nullable
    public static AndroidSdkData getProjectSdkData(Project project) {
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (projectSdk != null) {
            AndroidPlatform platform = AndroidPlatform.getInstance(projectSdk);
            return platform != null ? platform.getSdkData() : null;
        }
        return null;
    }

    public static boolean isAndroidSdkAvailable() {
        return AndroidSdks.getInstance().tryToChooseAndroidSdk() != null;
    }

    @NotNull
    public static String getTargetLabel(@NotNull IAndroidTarget target) {
        if (target == null) {
            AndroidSdkUtils.$$$reportNull$$$0(25);
        }
        if (!target.isPlatform()) {
            String string = String.format("%1$s (API %2$s)", target.getFullName(), target.getVersion().getApiString());
            if (string == null) {
                AndroidSdkUtils.$$$reportNull$$$0(26);
            }
            return string;
        }
        AndroidVersion version2 = target.getVersion();
        if (version2.isPreview()) {
            String string = String.format(Locale.US, "API %d+: %s", target.getVersion().getApiLevel(), target.getName());
            if (string == null) {
                AndroidSdkUtils.$$$reportNull$$$0(27);
            }
            return string;
        }
        String name = SdkVersionInfo.getAndroidName((int)target.getVersion().getApiLevel());
        if (StringUtil.isNotEmpty((String)name)) {
            String string = name;
            if (string == null) {
                AndroidSdkUtils.$$$reportNull$$$0(28);
            }
            return string;
        }
        String release = target.getProperty("ro.build.version.release");
        if (release != null) {
            String string = String.format(Locale.US, "API %1$d: Android %2$s", version2.getApiLevel(), release);
            if (string == null) {
                AndroidSdkUtils.$$$reportNull$$$0(29);
            }
            return string;
        }
        String string = String.format(Locale.US, "API %1$d", version2.getApiLevel());
        if (string == null) {
            AndroidSdkUtils.$$$reportNull$$$0(30);
        }
        return string;
    }

    @Nullable
    public static AndroidDebugBridge getDebugBridge(@NotNull Project project) {
        boolean retry;
        if (project == null) {
            AndroidSdkUtils.$$$reportNull$$$0(31);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        AndroidSdkData data = AndroidSdkUtils.getProjectSdkData(project);
        if (data == null) {
            data = AndroidSdkUtils.getFirstAndroidModuleSdkData(project);
        }
        if (data == null) {
            LOG.warn("Fail to find project SDK data.");
        }
        AndroidDebugBridge bridge = null;
        do {
            File adb;
            if ((adb = AndroidSdkUtils.getAdb(project)) == null) {
                LOG.error("Unable to locate adb.");
                return null;
            }
            ListenableFuture<AndroidDebugBridge> future2 = AdbService.getInstance().getDebugBridge(adb);
            MyMonitorBridgeConnectionTask task2 = new MyMonitorBridgeConnectionTask(project, (Future<AndroidDebugBridge>)future2);
            ProgressManager.getInstance().run((Task)task2);
            if (task2.wasCanceled()) {
                return null;
            }
            retry = false;
            try {
                bridge = (AndroidDebugBridge)future2.get();
            }
            catch (InterruptedException e) {
                break;
            }
            catch (ExecutionException e) {
                String message2 = "ADB not responding. If you'd like to retry, then please manually kill \"" + SdkConstants.FN_ADB + "\" and click 'Restart'";
                boolean bl = retry = Messages.showYesNoDialog((Project)project, (String)message2, (String)CommonBundle.getErrorTitle(), (String)"&Restart", (String)"&Cancel", (Icon)Messages.getErrorIcon()) == 0;
            }
        } while (retry);
        return bridge;
    }

    public static void refreshLibrariesIn(@NotNull Sdk sdk) {
        if (sdk == null) {
            AndroidSdkUtils.$$$reportNull$$$0(32);
        }
        VirtualFile[] libraries = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.removeRoots(OrderRootType.CLASSES);
        sdkModificator.commitChanges();
        sdkModificator = sdk.getSdkModificator();
        for (VirtualFile library : libraries) {
            sdkModificator.addRoot(library, OrderRootType.CLASSES);
        }
        sdkModificator.commitChanges();
    }

    public static boolean isAndroidSdkManagerEnabled() {
        boolean sdkManagerDisabled = SystemProperties.getBooleanProperty((String)"android.studio.sdk.manager.disabled", (boolean)false);
        return !sdkManagerDisabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 2: 
            case 3: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 13: 
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetHashString";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidSdkPath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkPath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkData";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/sdk/AndroidSdkUtils";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/sdk/AndroidSdkUtils";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findBestTarget";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTargetPresentableName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "targetHasId";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryToSetAndroidPlatform";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupPlatform";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTargetHashStringFromPropertyFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findAndSetSdkWithHashString";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findAndSetSdk";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateSdkSourceRoot";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "tryToCreateAndSetAndroidSdk";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createNewAndroidPlatform";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setupAndroidPlatformIfNecessary";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "openModuleDependenciesConfigurable";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findAppropriateAndroidPlatform";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkSdkRoots";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTargetLabel";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getDebugBridge";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "refreshLibrariesIn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyMonitorBridgeConnectionTask
    extends Task.Modal {
        private final Future<AndroidDebugBridge> myFuture;
        private boolean myCancelled;

        public MyMonitorBridgeConnectionTask(@Nullable Project project, Future<AndroidDebugBridge> future2) {
            super(project, "Waiting for adb", true);
            this.myFuture = future2;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyMonitorBridgeConnectionTask.$$$reportNull$$$0(0);
            }
            indicator.setIndeterminate(true);
            while (!this.myFuture.isDone()) {
                try {
                    this.myFuture.get(200L, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!indicator.isCanceled()) continue;
                return;
            }
        }

        public void onCancel() {
            this.myCancelled = true;
        }

        public boolean wasCanceled() {
            return this.myCancelled;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/android/sdk/AndroidSdkUtils$MyMonitorBridgeConnectionTask", "run"));
        }
    }
}

