/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkNotConfiguredNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.sdk.not.configured.notification");
    private final Project myProject;

    public AndroidSdkNotConfiguredNotificationProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            AndroidSdkNotConfiguredNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        AndroidPlatform platform;
        AndroidFacet facet2;
        if (file2 == null) {
            AndroidSdkNotConfiguredNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            AndroidSdkNotConfiguredNotificationProvider.$$$reportNull$$$0(2);
        }
        if (file2.getFileType() != XmlFileType.INSTANCE) {
            return null;
        }
        Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)this.myProject);
        AndroidFacet androidFacet = facet2 = module2 != null ? AndroidFacet.getInstance((Module)module2) : null;
        if (facet2 == null) {
            return null;
        }
        if (!AndroidModel.isRequired(facet2) && (IdeResourcesUtil.isResourceFile(file2, facet2) || file2.equals(AndroidRootUtil.getPrimaryManifestFile(facet2))) && (platform = AndroidPlatform.getInstance(module2)) == null) {
            return new MySdkNotConfiguredNotificationPanel(fileEditor, module2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/sdk/AndroidSdkNotConfiguredNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/sdk/AndroidSdkNotConfiguredNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MySdkNotConfiguredNotificationPanel
    extends EditorNotificationPanel {
        MySdkNotConfiguredNotificationPanel(@NotNull FileEditor fileEditor, final Module module2) {
            if (fileEditor == null) {
                MySdkNotConfiguredNotificationPanel.$$$reportNull$$$0(0);
            }
            if (module2 == null) {
                MySdkNotConfiguredNotificationPanel.$$$reportNull$$$0(1);
            }
            super(fileEditor);
            this.setText("Android SDK is not configured for module '" + module2.getName() + "' or corrupted");
            this.createActionLabel("Open Project Structure", new Runnable(){

                @Override
                public void run() {
                    ModulesConfigurator.showDialog((Project)module2.getProject(), (String)module2.getName(), (String)ClasspathEditor.getName());
                    EditorNotifications.getInstance((Project)AndroidSdkNotConfiguredNotificationProvider.this.myProject).updateAllNotifications();
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "module";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/sdk/AndroidSdkNotConfiguredNotificationProvider$MySdkNotConfiguredNotificationPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

