/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.repository.Revision;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.utils.ILogger;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.reference.SoftReference;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkData {
    private final Map<String, SoftReference<AndroidTargetData>> myTargetDataByTarget;
    private final DeviceManager myDeviceManager;
    private final int myPlatformToolsRevision;
    private static final ConcurrentMap<String, SoftReference<AndroidSdkData>> ourCache = Maps.newConcurrentMap();
    private AndroidSdkHandler mySdkHandler;

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidSdkData.$$$reportNull$$$0(0);
        }
        return ModuleSdkDataHolder.getInstance(facet2).getSdkData();
    }

    @NotNull
    public static AndroidSdkHandler getSdkHolder(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidSdkData.$$$reportNull$$$0(1);
        }
        AndroidSdkHandler androidSdkHandler = ModuleSdkDataHolder.getInstance(facet2).getSdkHandler();
        if (androidSdkHandler == null) {
            AndroidSdkData.$$$reportNull$$$0(2);
        }
        return androidSdkHandler;
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull File sdkLocation) {
        if (sdkLocation == null) {
            AndroidSdkData.$$$reportNull$$$0(3);
        }
        return AndroidSdkData.getSdkData(sdkLocation, false);
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull File sdkLocation, boolean forceReparse) {
        SoftReference cachedRef;
        if (sdkLocation == null) {
            AndroidSdkData.$$$reportNull$$$0(4);
        }
        String canonicalPath = FileUtil.toCanonicalPath((String)sdkLocation.getPath());
        if (!forceReparse && (cachedRef = (SoftReference)ourCache.get(canonicalPath)) != null) {
            AndroidSdkData cachedData = (AndroidSdkData)cachedRef.get();
            if (cachedData == null) {
                ourCache.remove(canonicalPath, cachedRef);
            } else {
                return cachedData;
            }
        }
        File canonicalLocation = new File(canonicalPath);
        if (!IdeSdks.getInstance().isValidAndroidSdkPath(canonicalLocation)) {
            return null;
        }
        AndroidSdkData sdkData = new AndroidSdkData(canonicalLocation);
        ourCache.put(canonicalPath, (SoftReference<AndroidSdkData>)new SoftReference((Object)sdkData));
        return sdkData;
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull String sdkPath) {
        if (sdkPath == null) {
            AndroidSdkData.$$$reportNull$$$0(5);
        }
        return AndroidSdkData.getSdkData(FilePaths.stringToFile((String)sdkPath));
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull Sdk sdk) {
        String sdkHomePath;
        if (sdk == null) {
            AndroidSdkData.$$$reportNull$$$0(6);
        }
        if ((sdkHomePath = sdk.getHomePath()) != null) {
            return AndroidSdkData.getSdkData(sdk.getHomePath());
        }
        return null;
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull Project project) {
        Sdk sdk;
        if (project == null) {
            AndroidSdkData.$$$reportNull$$$0(7);
        }
        if ((sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk()) != null) {
            return AndroidSdkData.getSdkData(sdk);
        }
        return null;
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull Module module2) {
        if (module2 == null) {
            AndroidSdkData.$$$reportNull$$$0(8);
        }
        return AndroidSdkData.getSdkData(module2.getProject());
    }

    private AndroidSdkData(@NotNull File localSdk) {
        if (localSdk == null) {
            AndroidSdkData.$$$reportNull$$$0(9);
        }
        this.myTargetDataByTarget = Maps.newHashMap();
        this.mySdkHandler = AndroidSdkHandler.getInstance((File)localSdk);
        File location = this.getLocation();
        String locationPath = location.getPath();
        Revision platformToolsRevision = AndroidBuildCommonUtils.parsePackageRevision((String)locationPath, (String)"platform-tools");
        this.myPlatformToolsRevision = platformToolsRevision == null ? -1 : platformToolsRevision.getMajor();
        this.myDeviceManager = DeviceManager.createInstance((AndroidSdkHandler)this.mySdkHandler, (ILogger)new MessageBuildingSdkLog());
    }

    @NotNull
    public File getLocation() {
        File location = this.mySdkHandler.getLocation();
        assert (location != null);
        File file2 = location;
        if (file2 == null) {
            AndroidSdkData.$$$reportNull$$$0(10);
        }
        return file2;
    }

    @Deprecated
    @NotNull
    public String getPath() {
        String string = this.getLocation().getPath();
        if (string == null) {
            AndroidSdkData.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Deprecated
    @Nullable
    public BuildToolInfo getLatestBuildTool() {
        return this.getLatestBuildTool(false);
    }

    @Nullable
    public BuildToolInfo getLatestBuildTool(boolean allowPreview) {
        return this.mySdkHandler.getLatestBuildTool((ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()), allowPreview);
    }

    @NotNull
    public IAndroidTarget[] getTargets() {
        Collection<IAndroidTarget> targets = this.getTargetCollection();
        IAndroidTarget[] iAndroidTargetArray = targets.toArray(new IAndroidTarget[0]);
        if (iAndroidTargetArray == null) {
            AndroidSdkData.$$$reportNull$$$0(12);
        }
        return iAndroidTargetArray;
    }

    @NotNull
    private Collection<IAndroidTarget> getTargetCollection() {
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        Collection collection2 = this.mySdkHandler.getAndroidTargetManager((ProgressIndicator)progress).getTargets((ProgressIndicator)progress);
        if (collection2 == null) {
            AndroidSdkData.$$$reportNull$$$0(13);
        }
        return collection2;
    }

    @NotNull
    public IAndroidTarget[] getTargets(boolean includeAddOns) {
        Collection<IAndroidTarget> targets = this.getTargetCollection();
        ArrayList<IAndroidTarget> result2 = new ArrayList<IAndroidTarget>();
        if (!includeAddOns) {
            for (IAndroidTarget target : targets) {
                if (!target.isPlatform()) continue;
                result2.add(target);
            }
        } else {
            result2.addAll(targets);
        }
        IAndroidTarget[] iAndroidTargetArray = result2.toArray(new IAndroidTarget[0]);
        if (iAndroidTargetArray == null) {
            AndroidSdkData.$$$reportNull$$$0(14);
        }
        return iAndroidTargetArray;
    }

    @Nullable
    public IAndroidTarget findTargetByApiLevel(@NotNull String apiLevel) {
        if (apiLevel == null) {
            AndroidSdkData.$$$reportNull$$$0(15);
        }
        for (IAndroidTarget target : this.getTargets()) {
            if (!AndroidSdkUtils.targetHasId(target, apiLevel)) continue;
            return target;
        }
        return null;
    }

    @Nullable
    public IAndroidTarget findTargetByHashString(@NotNull String hashString) {
        if (hashString == null) {
            AndroidSdkData.$$$reportNull$$$0(16);
        }
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        return this.mySdkHandler.getAndroidTargetManager((ProgressIndicator)progress).getTargetFromHashString(hashString, (ProgressIndicator)progress);
    }

    public int getPlatformToolsRevision() {
        return this.myPlatformToolsRevision;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AndroidSdkData sdkData = (AndroidSdkData)obj;
        return FileUtil.filesEqual((File)this.getLocation(), (File)sdkData.getLocation());
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.getLocation());
    }

    @NotNull
    public DeviceManager getDeviceManager() {
        DeviceManager deviceManager = this.myDeviceManager;
        if (deviceManager == null) {
            AndroidSdkData.$$$reportNull$$$0(17);
        }
        return deviceManager;
    }

    @NotNull
    public AndroidTargetData getTargetData(@NotNull IAndroidTarget target) {
        String key;
        SoftReference<AndroidTargetData> targetDataRef;
        AndroidTargetData targetData;
        if (target == null) {
            AndroidSdkData.$$$reportNull$$$0(18);
        }
        AndroidTargetData androidTargetData = targetData = (targetDataRef = this.myTargetDataByTarget.get(key = target.hashString())) != null ? (AndroidTargetData)targetDataRef.get() : null;
        if (targetData == null) {
            targetData = new AndroidTargetData(this, target);
            this.myTargetDataByTarget.put(key, (SoftReference<AndroidTargetData>)new SoftReference((Object)targetData));
        }
        AndroidTargetData androidTargetData2 = targetData;
        if (androidTargetData2 == null) {
            AndroidSdkData.$$$reportNull$$$0(19);
        }
        return androidTargetData2;
    }

    @NotNull
    public AndroidSdkHandler getSdkHandler() {
        AndroidSdkHandler androidSdkHandler = this.mySdkHandler;
        if (androidSdkHandler == null) {
            AndroidSdkData.$$$reportNull$$$0(20);
        }
        return androidSdkHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/sdk/AndroidSdkData";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkLocation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localSdk";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apiLevel";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashString";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/sdk/AndroidSdkData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkHolder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetCollection";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceManager";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetData";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSdkData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSdkHolder";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findTargetByApiLevel";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findTargetByHashString";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTargetData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModuleSdkDataHolder
    implements Disposable {
        private static final Key<ModuleSdkDataHolder> KEY = Key.create((String)ModuleSdkDataHolder.class.getName());
        private AndroidFacet myFacet;
        @NotNull
        private final AndroidSdkHandler mySdkHandler;
        @Nullable
        private final AndroidSdkData mySdkData;

        @NotNull
        static ModuleSdkDataHolder getInstance(@NotNull AndroidFacet facet2) {
            ModuleSdkDataHolder sdkDataHolder;
            if (facet2 == null) {
                ModuleSdkDataHolder.$$$reportNull$$$0(0);
            }
            if ((sdkDataHolder = (ModuleSdkDataHolder)facet2.getUserData(KEY)) == null) {
                sdkDataHolder = new ModuleSdkDataHolder(facet2);
                facet2.putUserData(KEY, (Object)sdkDataHolder);
            }
            ModuleSdkDataHolder moduleSdkDataHolder = sdkDataHolder;
            if (moduleSdkDataHolder == null) {
                ModuleSdkDataHolder.$$$reportNull$$$0(1);
            }
            return moduleSdkDataHolder;
        }

        ModuleSdkDataHolder(@NotNull AndroidFacet facet2) {
            if (facet2 == null) {
                ModuleSdkDataHolder.$$$reportNull$$$0(2);
            }
            this.myFacet = facet2;
            Disposer.register((Disposable)facet2, (Disposable)this);
            AndroidPlatform platform = AndroidPlatform.getInstance(facet2.getModule());
            if (platform != null) {
                this.mySdkData = platform.getSdkData();
                this.mySdkHandler = this.mySdkData.getSdkHandler();
            } else {
                this.mySdkData = null;
                this.mySdkHandler = AndroidSdkHandler.getInstance(null);
            }
        }

        @Nullable
        AndroidSdkData getSdkData() {
            return this.mySdkData;
        }

        @NotNull
        AndroidSdkHandler getSdkHandler() {
            AndroidSdkHandler androidSdkHandler = this.mySdkHandler;
            if (androidSdkHandler == null) {
                ModuleSdkDataHolder.$$$reportNull$$$0(3);
            }
            return androidSdkHandler;
        }

        public void dispose() {
            this.myFacet.putUserData(KEY, null);
            this.myFacet = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facet";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/sdk/AndroidSdkData$ModuleSdkDataHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/sdk/AndroidSdkData$ModuleSdkDataHolder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSdkHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstance";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

