/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.utils.HashCodes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.Item;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValueResourceInfoImpl
implements ValueResourceInfo {
    private final ResourceItem myResource;
    private final VirtualFile myFile;
    private final Project myProject;

    public ValueResourceInfoImpl(@NotNull ResourceItem resourceItem, @NotNull VirtualFile file2, @NotNull Project project) {
        if (resourceItem == null) {
            ValueResourceInfoImpl.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ValueResourceInfoImpl.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ValueResourceInfoImpl.$$$reportNull$$$0(2);
        }
        this.myResource = resourceItem;
        this.myFile = file2;
        this.myProject = project;
    }

    @Override
    @NotNull
    public ResourceItem getResource() {
        ResourceItem resourceItem = this.myResource;
        if (resourceItem == null) {
            ValueResourceInfoImpl.$$$reportNull$$$0(3);
        }
        return resourceItem;
    }

    @Override
    @NotNull
    public VirtualFile getContainingFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            ValueResourceInfoImpl.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public XmlAttributeValue computeXmlElement() {
        if (this.myResource.getType().equals((Object)ResourceType.ATTR)) {
            Attr attrElement = this.computeAttrElement();
            return attrElement != null ? attrElement.getName().getXmlAttributeValue() : null;
        }
        ResourceElement resDomElement = this.computeDomElement();
        return resDomElement != null ? resDomElement.getName().getXmlAttributeValue() : null;
    }

    @Nullable
    private Attr computeAttrElement() {
        PsiFile file2 = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        if (!(file2 instanceof XmlFile)) {
            return null;
        }
        XmlTag tag = IdeResourcesUtil.getItemTag(this.myProject, this.myResource);
        if (tag == null) {
            return null;
        }
        DomElement domElement = DomManager.getDomManager((Project)this.myProject).getDomElement(tag);
        if (!(domElement instanceof Attr)) {
            return null;
        }
        ResourceReference resourceReference = (ResourceReference)((Attr)domElement).getName().getValue();
        if (resourceReference == null) {
            return null;
        }
        String resName = resourceReference.getName();
        return this.getName().equals(resName) ? (Attr)domElement : null;
    }

    @Nullable
    public ResourceElement computeDomElement() {
        String resType;
        PsiFile file2 = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        if (!(file2 instanceof XmlFile)) {
            return null;
        }
        XmlTag tag = IdeResourcesUtil.getItemTag(this.myProject, this.myResource);
        if (tag == null) {
            return null;
        }
        DomElement domElement = DomManager.getDomManager((Project)this.myProject).getDomElement(tag);
        if (!(domElement instanceof ResourceElement)) {
            return null;
        }
        String string = resType = domElement instanceof Item ? ((Item)domElement).getType().getStringValue() : ResourceType.fromXmlTagName((String)tag.getName()).getName();
        if (!this.getType().getName().equals(resType)) {
            return null;
        }
        ResourceElement resDomElement = (ResourceElement)domElement;
        String resName = ((ResourceElement)domElement).getName().getStringValue();
        return this.getName().equals(resName) ? resDomElement : null;
    }

    @Override
    public int compareTo(@NotNull ValueResourceInfo other) {
        int delta;
        if (other == null) {
            ValueResourceInfoImpl.$$$reportNull$$$0(5);
        }
        if ((delta = IdeResourcesUtil.compareResourceFiles(this.myFile, other.getContainingFile())) != 0) {
            return delta;
        }
        delta = this.getType().compareTo((Enum)other.getType());
        if (delta != 0) {
            return delta;
        }
        return this.getName().compareTo(other.getName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ValueResourceInfo) {
            ValueResourceInfo other = (ValueResourceInfo)obj;
            return this.myFile.equals(other.getContainingFile()) && this.getType().equals((Object)other.getType()) && this.getName().equals(other.getName());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return HashCodes.mix((int)this.myFile.hashCode(), (int)this.getType().hashCode(), (int)this.getName().hashCode());
    }

    public String toString() {
        return "ANDROID_RESOURCE: " + this.getType() + ", " + this.getName() + ", " + this.myFile.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceItem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/resourceManagers/ValueResourceInfoImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/resourceManagers/ValueResourceInfoImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResource";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

