/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.wrappers.FileResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.resourceManagers.ValueResourceInfoImpl;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceManager {
    protected final Project myProject;

    protected ResourceManager(@NotNull Project project) {
        if (project == null) {
            ResourceManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public abstract boolean isResourceDir(@NotNull VirtualFile var1);

    @Nullable
    public abstract AttributeDefinitions getAttributeDefinitions();

    public boolean isResourcePublic(@NotNull String type, @NotNull String name) {
        if (type == null) {
            ResourceManager.$$$reportNull$$$0(1);
        }
        if (name == null) {
            ResourceManager.$$$reportNull$$$0(2);
        }
        return true;
    }

    @Nullable
    public ResourceType getValueResourceType(@NotNull XmlTag tag) {
        ResourceFolderType fileResType;
        if (tag == null) {
            ResourceManager.$$$reportNull$$$0(3);
        }
        if (ResourceFolderType.VALUES == (fileResType = this.getFileResourceFolderType(tag.getContainingFile()))) {
            return IdeResourcesUtil.getResourceTypeForResourceTag(tag);
        }
        return null;
    }

    @Nullable
    public ResourceFolderType getFileResourceFolderType(@NotNull PsiFile file2) {
        if (file2 == null) {
            ResourceManager.$$$reportNull$$$0(4);
        }
        return (ResourceFolderType)ApplicationManager.getApplication().runReadAction(() -> {
            PsiDirectory dir = file2.getContainingDirectory();
            if (dir == null) {
                return null;
            }
            PsiDirectory possibleResDir = dir.getParentDirectory();
            if (possibleResDir == null || !this.isResourceDir(possibleResDir.getVirtualFile())) {
                return null;
            }
            return ResourceFolderType.getFolderType((String)dir.getName());
        });
    }

    @Nullable
    public String getFileResourceType(@NotNull PsiFile file2) {
        ResourceFolderType folderType;
        if (file2 == null) {
            ResourceManager.$$$reportNull$$$0(5);
        }
        return (folderType = this.getFileResourceFolderType(file2)) == null ? null : folderType.getName();
    }

    @NotNull
    public List<XmlAttributeValue> findIdDeclarations(@NotNull ResourceNamespace namespace, @NotNull String id) {
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(6);
        }
        if (id == null) {
            ResourceManager.$$$reportNull$$$0(7);
        }
        if (!this.isResourcePublic(ResourceType.ID.getName(), id)) {
            List<XmlAttributeValue> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(8);
            }
            return list;
        }
        Set<VirtualFile> files2 = this.getFilesDeclaringId(namespace, id);
        List<XmlAttributeValue> list = this.findIdUsagesFromFiles(files2, attributeValue -> {
            if (IdeResourcesUtil.isIdDeclaration(attributeValue)) {
                String value2 = attributeValue.getValue();
                String idInAttr = IdeResourcesUtil.getResourceNameByReferenceText(value2);
                return id.equals(idInAttr);
            }
            return false;
        });
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<XmlAttributeValue> findConstraintReferencedIds(@NotNull ResourceNamespace namespace, @NotNull String id) {
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(10);
        }
        if (id == null) {
            ResourceManager.$$$reportNull$$$0(11);
        }
        if (!this.isResourcePublic(ResourceType.ID.getName(), id)) {
            List<XmlAttributeValue> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(12);
            }
            return list;
        }
        Set<VirtualFile> files2 = this.getFilesDeclaringId(namespace, id);
        List<XmlAttributeValue> list = this.findIdUsagesFromFiles(files2, attributeValue -> {
            if (IdeResourcesUtil.isConstraintReferencedIds(attributeValue)) {
                String ids2 = attributeValue.getValue();
                return ArrayUtil.indexOf((Object[])ids2.split(","), (Object)id) >= 0;
            }
            return false;
        });
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private Set<VirtualFile> getFilesDeclaringId(@NotNull ResourceNamespace namespace, @NotNull String id) {
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(14);
        }
        if (id == null) {
            ResourceManager.$$$reportNull$$$0(15);
        }
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        for (ResourceRepository resourceRepository : this.getLeafResourceRepositories()) {
            List items2 = resourceRepository.getResources(namespace, ResourceType.ID, id);
            for (ResourceItem item : items2) {
                VirtualFile file2 = IdeResourcesUtil.getSourceAsVirtualFile(item);
                if (file2 == null) continue;
                files2.add(file2);
            }
        }
        HashSet<VirtualFile> hashSet = files2;
        if (hashSet == null) {
            ResourceManager.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    private List<XmlAttributeValue> findIdUsagesFromFiles(@NotNull Set<VirtualFile> fileSet, final @NotNull Predicate<XmlAttributeValue> condition) {
        if (fileSet == null) {
            ResourceManager.$$$reportNull$$$0(17);
        }
        if (condition == null) {
            ResourceManager.$$$reportNull$$$0(18);
        }
        final ArrayList<XmlAttributeValue> usages = new ArrayList<XmlAttributeValue>();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile file2 : fileSet) {
            PsiFile psiFile2;
            if (!fileSet.contains(file2) || !((psiFile2 = psiManager.findFile(file2)) instanceof XmlFile)) continue;
            psiFile2.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlAttributeValue(XmlAttributeValue attributeValue) {
                    if (condition.test(attributeValue)) {
                        usages.add(attributeValue);
                    }
                }
            });
        }
        return usages;
    }

    public List<ResourceElement> findValueResources(@NotNull ResourceNamespace namespace, @NotNull String resType, @NotNull String resName) {
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(19);
        }
        if (resType == null) {
            ResourceManager.$$$reportNull$$$0(20);
        }
        if (resName == null) {
            ResourceManager.$$$reportNull$$$0(21);
        }
        return this.findValueResources(namespace, resType, resName, true);
    }

    @NotNull
    public List<ResourceElement> findValueResources(@NotNull ResourceNamespace namespace, @NotNull String resourceType, @NotNull String resourceName, boolean distinguishDelimitersInName) {
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(22);
        }
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(23);
        }
        if (resourceName == null) {
            ResourceManager.$$$reportNull$$$0(24);
        }
        List<ValueResourceInfoImpl> resources = this.findValueResourceInfos(namespace, resourceType, resourceName, distinguishDelimitersInName, false);
        ArrayList<ResourceElement> result2 = new ArrayList<ResourceElement>();
        for (ValueResourceInfoImpl resource : resources) {
            ResourceElement domElement = resource.computeDomElement();
            if (domElement == null) continue;
            result2.add(domElement);
        }
        ArrayList<ResourceElement> arrayList = result2;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    public void collectLazyResourceElements(@NotNull ResourceNamespace namespace, @NotNull String resType, @NotNull String resName, boolean withAttrs, @NotNull PsiElement context, @NotNull Collection<PsiElement> elements) {
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(26);
        }
        if (resType == null) {
            ResourceManager.$$$reportNull$$$0(27);
        }
        if (resName == null) {
            ResourceManager.$$$reportNull$$$0(28);
        }
        if (context == null) {
            ResourceManager.$$$reportNull$$$0(29);
        }
        if (elements == null) {
            ResourceManager.$$$reportNull$$$0(30);
        }
        List<ValueResourceInfoImpl> valueResources = this.findValueResourceInfos(namespace, resType, resName, false, withAttrs);
        for (ValueResourceInfo valueResourceInfo : valueResources) {
            elements.add((PsiElement)new LazyValueResourceElementWrapper(valueResourceInfo, context));
        }
        ResourceType resourceType = ResourceType.fromClassName((String)resType);
        if (resourceType != null) {
            if (resourceType == ResourceType.ID) {
                elements.addAll(this.findIdDeclarations(namespace, resName));
            } else if (FolderTypeRelationship.getNonValuesRelatedFolder((ResourceType)resourceType) != null) {
                List<ResourceItem> list = this.getResources(namespace, resourceType, resName);
                for (ResourceItem resource : list) {
                    PsiFile psiFile2;
                    VirtualFile file2;
                    if (!resource.isFileBased() || (file2 = IdeResourcesUtil.getSourceAsVirtualFile(resource)) == null || (psiFile2 = PsiManager.getInstance((Project)this.myProject).findFile(file2)) == null) continue;
                    elements.add(new FileResourceElementWrapper(psiFile2));
                }
            }
        }
    }

    @NotNull
    public List<ValueResourceInfoImpl> findValueResourceInfos(@NotNull ResourceNamespace namespace, @NotNull String resourceType, @NotNull String resourceName, boolean distinguishDelimitersInName, boolean searchAttrs) {
        ResourceType type;
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(31);
        }
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(32);
        }
        if (resourceName == null) {
            ResourceManager.$$$reportNull$$$0(33);
        }
        ResourceType resourceType2 = type = resourceType.startsWith("+") ? ResourceType.ID : ResourceType.fromClassName((String)resourceType);
        if (type == null) {
            List<ValueResourceInfoImpl> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(34);
            }
            return list;
        }
        List<ValueResourceInfoImpl> list = this.findValueResourceInfos(namespace, type, resourceName, distinguishDelimitersInName, searchAttrs);
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    public List<ValueResourceInfoImpl> findValueResourceInfos(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull String resourceName, boolean distinguishDelimitersInName, boolean searchAttrs) {
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(36);
        }
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(37);
        }
        if (resourceName == null) {
            ResourceManager.$$$reportNull$$$0(38);
        }
        if (!(IdeResourcesUtil.VALUE_RESOURCE_TYPES.contains(resourceType) || resourceType == ResourceType.ATTR && searchAttrs)) {
            List<ValueResourceInfoImpl> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(39);
            }
            return list;
        }
        ArrayList<ValueResourceInfoImpl> result2 = new ArrayList<ValueResourceInfoImpl>();
        for (ResourceRepository resourceRepository : this.getLeafResourceRepositories()) {
            List items2;
            if (distinguishDelimitersInName) {
                List items22 = resourceRepository.getResources(namespace, resourceType, resourceName);
            } else {
                items2 = resourceRepository.getResources(namespace, resourceType, item -> AndroidUtils.equal(resourceName, item.getName(), false));
            }
            for (ResourceItem item2 : items2) {
                VirtualFile file2 = IdeResourcesUtil.getSourceAsVirtualFile(item2);
                if (file2 == null || !ResourceManager.isValueResourceFile(file2)) continue;
                result2.add(new ValueResourceInfoImpl(item2, file2, this.myProject));
            }
        }
        ArrayList<ValueResourceInfoImpl> arrayList = result2;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    private static boolean isValueResourceFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ResourceManager.$$$reportNull$$$0(41);
        }
        return ResourceFolderType.getFolderType((String)file2.getParent().getName()) == ResourceFolderType.VALUES;
    }

    @NotNull
    protected abstract Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories();

    @NotNull
    protected abstract List<ResourceItem> getResources(@NotNull ResourceNamespace var1, @NotNull ResourceType var2, @NotNull String var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 25: 
            case 34: 
            case 35: 
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 25: 
            case 34: 
            case 35: 
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: 
            case 5: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 19: 
            case 22: 
            case 26: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 25: 
            case 34: 
            case 35: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/resourceManagers/ResourceManager";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resType";
                break;
            }
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resName";
                break;
            }
            case 23: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 24: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/resourceManagers/ResourceManager";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findIdDeclarations";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findConstraintReferencedIds";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesDeclaringId";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findValueResources";
                break;
            }
            case 34: 
            case 35: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "findValueResourceInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isResourcePublic";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValueResourceType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileResourceFolderType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileResourceType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findIdDeclarations";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 25: 
            case 34: 
            case 35: 
            case 39: 
            case 40: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findConstraintReferencedIds";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFilesDeclaringId";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findIdUsagesFromFiles";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findValueResources";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "collectLazyResourceElements";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findValueResourceInfos";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isValueResourceFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 25: 
            case 34: 
            case 35: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

