/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeDefinitionsImpl;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.DeclareStyleable;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalResourceManager
extends ResourceManager {
    private final AndroidFacet myFacet;
    private final Object myAttrDefsLock;
    private AttributeDefinitions myAttrDefs;

    @Nullable
    public static LocalResourceManager getInstance(@NotNull Module module2) {
        AndroidFacet facet2;
        if (module2 == null) {
            LocalResourceManager.$$$reportNull$$$0(0);
        }
        return (facet2 = AndroidFacet.getInstance((Module)module2)) != null ? ModuleResourceManagers.getInstance(facet2).getLocalResourceManager() : null;
    }

    @Nullable
    public static LocalResourceManager getInstance(@NotNull PsiElement element2) {
        AndroidFacet facet2;
        if (element2 == null) {
            LocalResourceManager.$$$reportNull$$$0(1);
        }
        return (facet2 = AndroidFacet.getInstance((PsiElement)element2)) != null ? ModuleResourceManagers.getInstance(facet2).getLocalResourceManager() : null;
    }

    public LocalResourceManager(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            LocalResourceManager.$$$reportNull$$$0(2);
        }
        super(facet2.getModule().getProject());
        this.myAttrDefsLock = new Object();
        this.myFacet = facet2;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @Override
    public boolean isResourceDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            LocalResourceManager.$$$reportNull$$$0(3);
        }
        for (VirtualFile resDir : ResourceFolderManager.getInstance(this.myFacet).getFolders()) {
            if (!dir.equals(resDir)) continue;
            return true;
        }
        for (VirtualFile resDir : AndroidRootUtil.getResourceOverlayDirs(this.myFacet)) {
            if (!dir.equals(resDir)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public AttributeDefinitions getAttributeDefinitions() {
        Object object = this.myAttrDefsLock;
        // MONITORENTER : object
        if (this.myAttrDefs == null) {
            FrameworkResourceManager frameworkResourceManager = ModuleResourceManagers.getInstance(this.myFacet).getFrameworkResourceManager();
            AttributeDefinitions frameworkAttributes = frameworkResourceManager == null ? null : ((ResourceManager)frameworkResourceManager).getAttributeDefinitions();
            this.myAttrDefs = AttributeDefinitionsImpl.create(frameworkAttributes, this.getResourceRepository());
        }
        AttributeDefinitions attributeDefinitions = this.myAttrDefs;
        // MONITOREXIT : object
        if (attributeDefinitions != null) return attributeDefinitions;
        LocalResourceManager.$$$reportNull$$$0(4);
        return attributeDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAttributeDefinitions() {
        Object object = this.myAttrDefsLock;
        synchronized (object) {
            this.myAttrDefs = null;
        }
    }

    @NotNull
    public List<Attr> findAttrs(@NotNull ResourceNamespace namespace, @NotNull String name) {
        if (namespace == null) {
            LocalResourceManager.$$$reportNull$$$0(5);
        }
        if (name == null) {
            LocalResourceManager.$$$reportNull$$$0(6);
        }
        ArrayList<Attr> list = new ArrayList<Attr>();
        List<Resources> rootElements = this.loadPsiForFilesContainingResource(namespace, ResourceType.ATTR, name);
        for (Resources root2 : rootElements) {
            for (Attr attr : root2.getAttrs()) {
                ResourceReference resourceReference = (ResourceReference)attr.getName().getValue();
                if (resourceReference == null || !name.equals(resourceReference.getName())) continue;
                list.add(attr);
            }
            for (DeclareStyleable styleable : root2.getDeclareStyleables()) {
                for (Attr attr : styleable.getAttrs()) {
                    ResourceReference resourceReference = (ResourceReference)attr.getName().getValue();
                    if (resourceReference == null || !name.equals(resourceReference.getName())) continue;
                    list.add(attr);
                }
            }
        }
        ArrayList<Attr> arrayList = list;
        if (arrayList == null) {
            LocalResourceManager.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public List<DeclareStyleable> findStyleables(@NotNull ResourceNamespace namespace, @NotNull String name) {
        if (namespace == null) {
            LocalResourceManager.$$$reportNull$$$0(8);
        }
        if (name == null) {
            LocalResourceManager.$$$reportNull$$$0(9);
        }
        ArrayList<DeclareStyleable> list = new ArrayList<DeclareStyleable>();
        List<Resources> rootElements = this.loadPsiForFilesContainingResource(namespace, ResourceType.STYLEABLE, name);
        for (Resources root2 : rootElements) {
            for (DeclareStyleable styleable : root2.getDeclareStyleables()) {
                if (!name.equals(styleable.getName().getValue())) continue;
                list.add(styleable);
            }
        }
        return list;
    }

    public List<Attr> findStyleableAttributesByFieldName(@NotNull ResourceNamespace namespace, @NotNull String fieldName) {
        int prev;
        if (namespace == null) {
            LocalResourceManager.$$$reportNull$$$0(10);
        }
        if (fieldName == null) {
            LocalResourceManager.$$$reportNull$$$0(11);
        }
        int index2 = fieldName.lastIndexOf(95);
        while (index2 >= 0 && (prev = fieldName.lastIndexOf(95, index2 - 1)) != -1 && !Character.isUpperCase(fieldName.charAt(prev + 1))) {
            index2 = prev;
        }
        if (index2 < 0) {
            return Collections.emptyList();
        }
        String styleableName = fieldName.substring(0, index2);
        String attrName = fieldName.substring(index2 + 1);
        ArrayList<Attr> list = new ArrayList<Attr>();
        List<Resources> rootElements = this.loadPsiForFilesContainingResource(namespace, ResourceType.STYLEABLE, styleableName);
        for (Resources root2 : rootElements) {
            for (DeclareStyleable styleable : root2.getDeclareStyleables()) {
                if (!styleableName.equals(styleable.getName().getValue())) continue;
                for (Attr attr : styleable.getAttrs()) {
                    ResourceReference resourceReference = (ResourceReference)attr.getName().getValue();
                    if (resourceReference == null || !ResourcesUtil.resourceNameToFieldName((String)resourceReference.getQualifiedName()).equals(attrName) && !resourceReference.getName().equals(attrName)) continue;
                    list.add(attr);
                }
            }
        }
        return list;
    }

    @NotNull
    private List<Resources> loadPsiForFilesContainingResource(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull String name) {
        if (namespace == null) {
            LocalResourceManager.$$$reportNull$$$0(12);
        }
        if (resourceType == null) {
            LocalResourceManager.$$$reportNull$$$0(13);
        }
        if (name == null) {
            LocalResourceManager.$$$reportNull$$$0(14);
        }
        List<Resources> list = this.getResourceRepository().getResources(namespace, resourceType, name).stream().map(item -> IdeResourcesUtil.getSourceAsVirtualFile(item)).filter(file2 -> Objects.nonNull(file2)).distinct().map(file2 -> AndroidUtils.loadDomElement(this.myProject, file2, Resources.class)).filter(res -> Objects.nonNull(res)).collect(Collectors.toList());
        if (list == null) {
            LocalResourceManager.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public List<PsiElement> findResourcesByField(@NotNull PsiField field2) {
        String type;
        if (field2 == null) {
            LocalResourceManager.$$$reportNull$$$0(16);
        }
        if ((type = IdeResourcesUtil.getResourceClassName(field2)) == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                LocalResourceManager.$$$reportNull$$$0(17);
            }
            return list;
        }
        String fieldName = field2.getName();
        if (fieldName == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                LocalResourceManager.$$$reportNull$$$0(18);
            }
            return list;
        }
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance((PsiElement)field2);
        if (repositoryManager == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                LocalResourceManager.$$$reportNull$$$0(19);
            }
            return list;
        }
        ResourceNamespace namespace = repositoryManager.getNamespace();
        List<PsiElement> list = this.findResourcesByFieldName(namespace, type, fieldName);
        if (list == null) {
            LocalResourceManager.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    public List<PsiElement> findResourcesByFieldName(@NotNull ResourceNamespace namespace, @NotNull String resClassName, @NotNull String fieldName) {
        ResourceFolderType folderType;
        if (namespace == null) {
            LocalResourceManager.$$$reportNull$$$0(21);
        }
        if (resClassName == null) {
            LocalResourceManager.$$$reportNull$$$0(22);
        }
        if (fieldName == null) {
            LocalResourceManager.$$$reportNull$$$0(23);
        }
        ArrayList<PsiElement> targets = new ArrayList<PsiElement>();
        if (resClassName.equals(ResourceType.ID.getName())) {
            targets.addAll(this.findIdDeclarations(namespace, fieldName));
        }
        if ((folderType = ResourceFolderType.getTypeByName((String)resClassName)) != null) {
            targets.addAll(this.findResourceFiles(namespace, folderType, fieldName, false, true));
        }
        for (ResourceElement element2 : this.findValueResources(namespace, resClassName, fieldName, false)) {
            targets.add((PsiElement)element2.getName().getXmlAttributeValue());
        }
        if (resClassName.equals(ResourceType.ATTR.getName())) {
            for (Attr attr : this.findAttrs(namespace, fieldName)) {
                targets.add((PsiElement)attr.getName().getXmlAttributeValue());
            }
        } else if (resClassName.equals(ResourceType.STYLEABLE.getName())) {
            for (DeclareStyleable styleable : this.findStyleables(namespace, fieldName)) {
                targets.add((PsiElement)styleable.getName().getXmlAttributeValue());
            }
            for (Attr attr : this.findStyleableAttributesByFieldName(namespace, fieldName)) {
                targets.add((PsiElement)attr.getName().getXmlAttributeValue());
            }
        }
        ArrayList<PsiElement> arrayList = targets;
        if (arrayList == null) {
            LocalResourceManager.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @NotNull
    public Collection<PsiFile> findResourceFiles(@NotNull ResourceNamespace namespace, @NotNull ResourceFolderType resourceFolderType) {
        if (namespace == null) {
            LocalResourceManager.$$$reportNull$$$0(25);
        }
        if (resourceFolderType == null) {
            LocalResourceManager.$$$reportNull$$$0(26);
        }
        Collection<PsiFile> collection2 = this.findResourceFiles(namespace, resourceFolderType, null, true, true);
        if (collection2 == null) {
            LocalResourceManager.$$$reportNull$$$0(27);
        }
        return collection2;
    }

    @NotNull
    public Collection<PsiFile> findResourceFiles(@NotNull ResourceNamespace namespace, @NotNull ResourceFolderType resourceFolderType, @Nullable String nameToLookFor, boolean distinguishDelimitersInName, boolean withDependencies) {
        if (namespace == null) {
            LocalResourceManager.$$$reportNull$$$0(28);
        }
        if (resourceFolderType == null) {
            LocalResourceManager.$$$reportNull$$$0(29);
        }
        LinkedHashSet<PsiFile> result2 = new LinkedHashSet<PsiFile>();
        LocalResourceRepository repository = withDependencies ? ResourceRepositoryManager.getAppResources(this.myFacet) : ResourceRepositoryManager.getModuleResources(this.myFacet);
        Collection repositories = repository.getLeafResourceRepositories();
        if (resourceFolderType == ResourceFolderType.VALUES) {
            for (ResourceType resourceType : FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)resourceFolderType)) {
                this.findResourceFiles(repositories, namespace, resourceType, resourceFolderType, nameToLookFor, distinguishDelimitersInName, result2);
            }
        } else {
            ResourceType resourceType = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)resourceFolderType);
            this.findResourceFiles(repositories, namespace, resourceType, resourceFolderType, nameToLookFor, distinguishDelimitersInName, result2);
        }
        LinkedHashSet<PsiFile> linkedHashSet = result2;
        if (linkedHashSet == null) {
            LocalResourceManager.$$$reportNull$$$0(30);
        }
        return linkedHashSet;
    }

    private void findResourceFiles(@NotNull Collection<SingleNamespaceResourceRepository> repositories, @NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull ResourceFolderType resourceFolderType, @Nullable String nameToLookFor, boolean distinguishDelimitersInName, @NotNull Set<PsiFile> result2) {
        if (repositories == null) {
            LocalResourceManager.$$$reportNull$$$0(31);
        }
        if (namespace == null) {
            LocalResourceManager.$$$reportNull$$$0(32);
        }
        if (resourceType == null) {
            LocalResourceManager.$$$reportNull$$$0(33);
        }
        if (resourceFolderType == null) {
            LocalResourceManager.$$$reportNull$$$0(34);
        }
        if (result2 == null) {
            LocalResourceManager.$$$reportNull$$$0(35);
        }
        for (ResourceRepository resourceRepository : repositories) {
            List items2;
            if (nameToLookFor == null) {
                Collection items22 = resourceRepository.getResources(namespace, resourceType).values();
            } else {
                items2 = distinguishDelimitersInName ? resourceRepository.getResources(namespace, resourceType, nameToLookFor) : resourceRepository.getResources(namespace, resourceType, item -> AndroidUtils.equal(nameToLookFor, item.getName(), false));
            }
            for (ResourceItem item2 : items2) {
                PsiFile file2;
                VirtualFile resFile = IdeResourcesUtil.getSourceAsVirtualFile(item2);
                if (resFile == null || ResourceFolderType.getFolderType((String)resFile.getParent().getName()) != resourceFolderType || (file2 = AndroidPsiUtils.getPsiFileSafely((Project)this.myProject, (VirtualFile)resFile)) == null) continue;
                result2.add(file2);
            }
        }
    }

    @Override
    @NotNull
    protected Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories() {
        Collection collection2 = this.getResourceRepository().getLeafResourceRepositories();
        if (collection2 == null) {
            LocalResourceManager.$$$reportNull$$$0(36);
        }
        return collection2;
    }

    @Override
    @NotNull
    protected List<ResourceItem> getResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull String resName) {
        if (namespace == null) {
            LocalResourceManager.$$$reportNull$$$0(37);
        }
        if (resourceType == null) {
            LocalResourceManager.$$$reportNull$$$0(38);
        }
        if (resName == null) {
            LocalResourceManager.$$$reportNull$$$0(39);
        }
        List list = this.getResourceRepository().getResources(namespace, resourceType, resName);
        if (list == null) {
            LocalResourceManager.$$$reportNull$$$0(40);
        }
        return list;
    }

    @NotNull
    private ResourceRepository getResourceRepository() {
        LocalResourceRepository localResourceRepository = ResourceRepositoryManager.getAppResources(this.myFacet);
        if (localResourceRepository == null) {
            LocalResourceManager.$$$reportNull$$$0(41);
        }
        return localResourceRepository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 27: 
            case 30: 
            case 36: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 27: 
            case 30: 
            case 36: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 4: 
            case 7: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 27: 
            case 30: 
            case 36: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/resourceManagers/LocalResourceManager";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 21: 
            case 25: 
            case 28: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 6: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 13: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resClassName";
                break;
            }
            case 26: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceFolderType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/resourceManagers/LocalResourceManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDefinitions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findAttrs";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPsiForFilesContainingResource";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourcesByField";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourcesByFieldName";
                break;
            }
            case 27: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourceFiles";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeafResourceRepositories";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getResources";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isResourceDir";
                break;
            }
            case 4: 
            case 7: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 27: 
            case 30: 
            case 36: 
            case 40: 
            case 41: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAttrs";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findStyleables";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findStyleableAttributesByFieldName";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadPsiForFilesContainingResource";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findResourcesByField";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findResourcesByFieldName";
                break;
            }
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findResourceFiles";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getResources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 27: 
            case 30: 
            case 36: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

