/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring.renaming;

import com.android.annotations.concurrency.WorkerThread;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.psi.AndroidResourceToPsiResolver;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.android.tools.idea.res.psi.ResourceRepositoryToPsiResolver;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.augment.ResourceLightField;
import org.jetbrains.android.augment.StyleableAttrFieldUrl;
import org.jetbrains.android.augment.StyleableAttrLightField;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.renaming.ResourceReferenceRenameProcessor$WhenMappings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\fH\u0016J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0017J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J,\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u0019H\u0016J \u0010\u001a\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\nH\u0002J7\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010!\u00a8\u0006$"}, d2={"Lorg/jetbrains/android/refactoring/renaming/ResourceReferenceRenameProcessor;", "Lcom/intellij/refactoring/rename/RenamePsiElementProcessor;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "findExistingNameConflicts", "", "newName", "", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "findReferences", "", "Lcom/intellij/psi/PsiReference;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "searchInCommentsAndStrings", "getPostRenameCallback", "Ljava/lang/Runnable;", "elementListener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "prepareRenaming", "allRenames", "", "renameAndroidLightField", "usage", "Lcom/intellij/usageView/UsageInfo;", "renameElement", "usages", "", "listener", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "Companion", "ResourceFileReference", "intellij.android.core"})
public final class ResourceReferenceRenameProcessor
extends RenamePsiElementProcessor {
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canProcessElement(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Object object = StudioFlags.RESOLVE_USING_REPOS.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"StudioFlags.RESOLVE_USING_REPOS.get()");
        if ((Boolean)object == false) return false;
        ResourceReferencePsiElement resourceReferencePsiElement = ResourceReferencePsiElement.Companion.create(element2);
        if (resourceReferencePsiElement == null) return false;
        ResourceReferencePsiElement resourceReferencePsiElement2 = resourceReferencePsiElement.toWritableResourceReferencePsiElement();
        if (resourceReferencePsiElement2 == null) return false;
        return true;
    }

    public void findExistingNameConflicts(@NotNull PsiElement element2, @NotNull String newName2, @NotNull MultiMap<PsiElement, String> conflicts) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
        if (!(element2 instanceof ResourceReferencePsiElement)) {
            super.findExistingNameConflicts(element2, newName2, conflicts);
            return;
        }
        PsiElement psiElement = (PsiElement)element2.getCopyableUserData(ResourceReferencePsiElement.RESOURCE_CONTEXT_ELEMENT);
        if (psiElement == null) {
            super.findExistingNameConflicts(element2, newName2, conflicts);
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.getCopyableUserD\u2026ment, newName, conflicts)");
        PsiElement contextElement = psiElement;
        ResourceRepositoryManager resourceRepositoryManager = ResourceRepositoryManager.getInstance(contextElement);
        if (resourceRepositoryManager == null || (resourceRepositoryManager = resourceRepositoryManager.getAllResources()) == null) {
            super.findExistingNameConflicts(element2, newName2, conflicts);
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)resourceRepositoryManager, (String)"ResourceRepositoryManage\u2026ment, newName, conflicts)");
        ResourceRepositoryManager repository = resourceRepositoryManager;
        ResourceReference oldResourceReference = ((ResourceReferencePsiElement)element2).getResourceReference();
        if (repository.hasResources(oldResourceReference.getNamespace(), oldResourceReference.getResourceType(), newName2)) {
            PsiElement[] gotoDeclarationTargets;
            ResourceReference newReference = new ResourceReference(oldResourceReference.getNamespace(), oldResourceReference.getResourceType(), newName2);
            for (PsiElement target : gotoDeclarationTargets = ResourceRepositoryToPsiResolver.INSTANCE.getGotoDeclarationTargets(newReference, contextElement)) {
                conflicts.put((Object)target, (Collection)CollectionsKt.mutableListOf((Object[])new String[]{"Resource " + newReference.getResourceUrl() + " already exists"}));
            }
        }
        super.findExistingNameConflicts(element2, newName2, conflicts);
    }

    public void prepareRenaming(@NotNull PsiElement element2, @NotNull String newName2, @NotNull Map<PsiElement, String> allRenames) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        if (!(element2 instanceof ResourceReferencePsiElement)) {
            ResourceReferencePsiElement resourceReferencePsiElement = ResourceReferencePsiElement.Companion.create(element2);
            if (resourceReferencePsiElement == null || (resourceReferencePsiElement = resourceReferencePsiElement.toWritableResourceReferencePsiElement()) == null) {
                return;
            }
            ResourceReferencePsiElement resourceReferenceElement = resourceReferencePsiElement;
            resourceReferenceElement.putCopyableUserData(ResourceReferencePsiElement.RESOURCE_CONTEXT_ELEMENT, element2);
            allRenames.remove(element2);
            allRenames.put((PsiElement)resourceReferenceElement, newName2);
        }
    }

    public void renameElement(@NotNull PsiElement element2, @NotNull String newName2, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        for (UsageInfo usage : usages) {
            Language language;
            if (usage.getReference() instanceof BindablePsiReference) continue;
            PsiElement psiElement = usage.getElement();
            Object object = language = psiElement != null ? psiElement.getLanguage() : null;
            if (language != null && (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE) || Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) && element2 instanceof ResourceReferencePsiElement) {
                this.renameAndroidLightField(element2, usage, newName2);
                continue;
            }
            RenameUtil.rename((UsageInfo)usage, (String)newName2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void renameAndroidLightField(PsiElement element2, UsageInfo usage, String newName2) {
        PsiElement resolvedValue;
        PsiReference psiReference = usage.getReference();
        Object object = resolvedValue = psiReference != null ? psiReference.resolve() : null;
        if (resolvedValue instanceof ResourceLightField) {
            RenameUtil.rename((UsageInfo)usage, (String)newName2);
            return;
        }
        if (!(resolvedValue instanceof StyleableAttrLightField)) {
            RenameUtil.rename((UsageInfo)usage, (String)newName2);
            return;
        }
        StyleableAttrFieldUrl fieldUrl = ((StyleableAttrLightField)resolvedValue).getStyleableAttrFieldUrl();
        PsiElement psiElement = element2;
        if (!(psiElement instanceof ResourceReferencePsiElement)) {
            psiElement = null;
        }
        ResourceReferencePsiElement resourceReferencePsiElement2 = (ResourceReferencePsiElement)psiElement;
        resourceReferencePsiElement2 = resourceReferencePsiElement2;
        if (resourceReferencePsiElement == null) return;
        ResourceReference resourceReference = resourceReferencePsiElement2.getResourceReference();
        resourceReferencePsiElement2 = resourceReference;
        if (resourceReference == null) return;
        ResourceReferencePsiElement resourceReference2 = resourceReferencePsiElement2;
        ResourceType resourceType = resourceReference2.getResourceType();
        if (resourceType != null) {
            switch (ResourceReferenceRenameProcessor$WhenMappings.$EnumSwitchMapping$0[resourceType.ordinal()]) {
                case 1: {
                    String newAttrName = new StyleableAttrFieldUrl(fieldUrl.getStyleable(), new ResourceReference(fieldUrl.getAttr().getNamespace(), ResourceType.ATTR, newName2)).toFieldName();
                    RenameUtil.rename((UsageInfo)usage, (String)newAttrName);
                    return;
                }
                case 2: {
                    String newStyleableName = new StyleableAttrFieldUrl(new ResourceReference(fieldUrl.getStyleable().getNamespace(), ResourceType.STYLEABLE, newName2), fieldUrl.getAttr()).toFieldName();
                    RenameUtil.rename((UsageInfo)usage, (String)newStyleableName);
                    return;
                }
            }
        }
        if (!LOG.isDebugEnabled()) return;
        StringBuilder stringBuilder = new StringBuilder().append("Trying to rename styleable attr field from incorrect resource type: ");
        ResourceType resourceType2 = resourceReference2.getResourceType();
        Intrinsics.checkNotNullExpressionValue((Object)resourceType2, (String)"resourceReference.resourceType");
        LOG.debug(stringBuilder.append(resourceType2.getDisplayName()).toString());
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element2, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        Object object;
        Collection<Object> collection2;
        PsiField[] $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        PsiElement psiElement = element2;
        if (!(psiElement instanceof ResourceReferencePsiElement)) {
            psiElement = null;
        }
        ResourceReferencePsiElement resourceReferencePsiElement = (ResourceReferencePsiElement)psiElement;
        if (resourceReferencePsiElement == null) {
            Collection collection3 = super.findReferences(element2, searchScope, searchInCommentsAndStrings);
            Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"super.findReferences(ele\u2026archInCommentsAndStrings)");
            return collection3;
        }
        ResourceReferencePsiElement resourceElement = resourceReferencePsiElement;
        PsiElement psiElement2 = (PsiElement)resourceElement.getCopyableUserData(ResourceReferencePsiElement.RESOURCE_CONTEXT_ELEMENT);
        if (psiElement2 == null) {
            Collection collection4 = super.findReferences(element2, searchScope, searchInCommentsAndStrings);
            Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"super.findReferences(ele\u2026archInCommentsAndStrings)");
            return collection4;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"resourceElement.getCopya\u2026archInCommentsAndStrings)");
        PsiElement contextElement = psiElement2;
        SearchScope resourceScope = ResourceRepositoryToPsiResolver.getResourceSearchScope(resourceElement.getResourceReference(), contextElement);
        Collection collection5 = super.findReferences(element2, searchScope.intersectWith(resourceScope), searchInCommentsAndStrings);
        Intrinsics.checkNotNullExpressionValue((Object)collection5, (String)"super.findReferences(ele\u2026archInCommentsAndStrings)");
        Collection found = collection5;
        PsiFile[] fileResources = AndroidResourceToPsiResolver.getInstance().getGotoDeclarationFileBasedTargets(resourceElement.getResourceReference(), contextElement);
        Intrinsics.checkNotNullExpressionValue((Object)fileResources, (String)"fileResources");
        PsiFile[] psiFileArray = fileResources;
        Collection collection6 = found;
        boolean $i$f$map = false;
        void var11_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo2 = false;
        void var14_21 = $this$mapTo$iv$iv;
        int n = ((void)var14_21).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var18_29 = item$iv$iv = var14_21[j];
            collection2 = destination$iv$iv;
            boolean bl = false;
            void v6 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"it");
            object = new ResourceFileReference((PsiFile)v6);
            collection2.add(object);
        }
        collection2 = (List)destination$iv$iv;
        collection6.addAll((Collection)collection2);
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((PsiElement)contextElement);
        if (androidFacet == null) {
            return found;
        }
        AndroidFacet androidFacet2 = androidFacet;
        ResourceType resourceType = resourceElement.getResourceReference().getResourceType();
        if (resourceType != null) {
            switch (ResourceReferenceRenameProcessor$WhenMappings.$EnumSwitchMapping$1[resourceType.ordinal()]) {
                case 1: {
                    void $this$mapTo$iv$iv2;
                    PsiField[] $this$map$iv2;
                    PsiField[] fields;
                    String string = resourceElement.getResourceReference().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resourceElement.resourceReference.name");
                    $this$mapTo$iv$iv = fields = IdeResourcesUtil.findStyleableAttrFieldsForAttr(androidFacet2, string);
                    collection6 = found;
                    boolean $i$f$map2 = false;
                    PsiField[] $i$f$mapTo2 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
                    boolean $i$f$mapTo3 = false;
                    void var16_24 = $this$mapTo$iv$iv2;
                    int n2 = ((void)var16_24).length;
                    for (int j = 0; j < n2; ++j) {
                        void it;
                        void item$iv$iv;
                        void var20_37 = item$iv$iv = var16_24[j];
                        collection2 = destination$iv$iv2;
                        boolean bl = false;
                        object = super.findReferences((PsiElement)it, searchScope, searchInCommentsAndStrings);
                        collection2.add(object);
                    }
                    collection2 = (List)destination$iv$iv2;
                    collection6.addAll(CollectionsKt.flatten((Iterable)collection2));
                    break;
                }
                case 2: {
                    PsiField[] fields;
                    String string = resourceElement.getResourceReference().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resourceElement.resourceReference.name");
                    PsiField[] $this$map$iv2 = fields = IdeResourcesUtil.findStyleableAttrFieldsForStyleable(androidFacet2, string);
                    collection6 = found;
                    boolean $i$f$map3 = false;
                    PsiField[] $this$mapTo$iv$iv2 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
                    boolean $i$f$mapTo3 = false;
                    PsiField[] psiFieldArray = $this$mapTo$iv$iv2;
                    int n3 = psiFieldArray.length;
                    for (int j = 0; j < n3; ++j) {
                        PsiField item$iv$iv;
                        PsiField it = item$iv$iv = psiFieldArray[j];
                        collection2 = destination$iv$iv2;
                        boolean bl = false;
                        object = super.findReferences((PsiElement)it, searchScope, searchInCommentsAndStrings);
                        collection2.add(object);
                    }
                    collection2 = (List)destination$iv$iv2;
                    collection6.addAll(CollectionsKt.flatten((Iterable)collection2));
                    break;
                }
            }
        }
        return found;
    }

    @Nullable
    public Runnable getPostRenameCallback(@NotNull PsiElement element2, @NotNull String newName2, @NotNull RefactoringElementListener elementListener) {
        ResourceReferencePsiElement resourceReferencePsiElement;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)elementListener, (String)"elementListener");
        PsiElement psiElement = element2;
        if (!(psiElement instanceof ResourceReferencePsiElement)) {
            psiElement = null;
        }
        if ((resourceReferencePsiElement = (ResourceReferencePsiElement)psiElement) == null || (resourceReferencePsiElement = resourceReferencePsiElement.getPsiManager()) == null) {
            return null;
        }
        ResourceReferencePsiElement psiManager = resourceReferencePsiElement;
        return new Runnable((PsiManager)psiManager){
            final /* synthetic */ PsiManager $psiManager;

            public final void run() {
                IdeResourcesUtil.scheduleNewResolutionAndHighlighting(this.$psiManager);
            }
            {
                this.$psiManager = psiManager;
            }
        };
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(ResourceReferenceRenameProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(Resou\u2026ameProcessor::class.java)");
        LOG = logger2;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0012\u0010\n\u001a\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/android/refactoring/renaming/ResourceReferenceRenameProcessor$ResourceFileReference;", "Lcom/intellij/psi/PsiReference;", "myFile", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "getMyFile", "()Lcom/intellij/psi/PsiFile;", "bindToElement", "Lcom/intellij/psi/PsiElement;", "element", "getCanonicalText", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getElement", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "handleElementRename", "newElementName", "isReferenceTo", "", "isSoft", "resolve", "intellij.android.core"})
    public static final class ResourceFileReference
    implements PsiReference {
        @NotNull
        private final PsiFile myFile;

        @NotNull
        public PsiElement handleElementRename(@NotNull String newElementName) {
            Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
            if (this.myFile.isValid()) {
                String string = FileUtilRt.getNameWithoutExtension((String)this.myFile.getName());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtilRt.getNameWithoutExtension(myFile.name)");
                String nameWithoutExtension = string;
                String string2 = FileUtilRt.getExtension((String)this.myFile.getName());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUtilRt.getExtension(myFile.name)");
                String extension = string2;
                if (StringsKt.endsWith$default((String)nameWithoutExtension, (String)".9", (boolean)false, (int)2, null) && FileUtilRt.extensionEquals((String)this.myFile.getName(), (String)"png")) {
                    this.myFile.setName(newElementName + ".9." + extension);
                } else {
                    this.myFile.setName(newElementName + '.' + extension);
                }
            }
            return (PsiElement)this.myFile;
        }

        @NotNull
        public PsiFile getElement() {
            return this.myFile;
        }

        @NotNull
        public TextRange getRangeInElement() {
            TextRange textRange = TextRange.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"TextRange.EMPTY_RANGE");
            return textRange;
        }

        @NotNull
        public PsiFile resolve() {
            return this.myFile;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myFile.name");
            return string;
        }

        @NotNull
        public PsiElement bindToElement(@NotNull PsiElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            return (PsiElement)this.myFile;
        }

        public boolean isReferenceTo(@NotNull PsiElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            return false;
        }

        public boolean isSoft() {
            return true;
        }

        @NotNull
        public final PsiFile getMyFile() {
            return this.myFile;
        }

        public ResourceFileReference(@NotNull PsiFile myFile) {
            Intrinsics.checkNotNullParameter((Object)myFile, (String)"myFile");
            this.myFile = myFile;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/android/refactoring/renaming/ResourceReferenceRenameProcessor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

