/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring.namespaces;

import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.impl.migration.PsiMigrationManager;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.namespaces.CodeUsageInfo;
import org.jetbrains.android.refactoring.namespaces.MigrateToNonTransitiveRClassesKt;
import org.jetbrains.android.refactoring.namespaces.NamespacesRefactoringsUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B%\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001b\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u001d\u0010\u0014\u001a\u00020\u00152\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\rH\u0014\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/android/refactoring/namespaces/MigrateToNonTransitiveRClassesProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "facetsToMigrate", "", "Lorg/jetbrains/android/facet/AndroidFacet;", "updateTopLevelGradleProperties", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Z)V", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "getCommandName", "", "performRefactoring", "", "([Lcom/intellij/usageView/UsageInfo;)V", "Companion", "intellij.android.core"})
public final class MigrateToNonTransitiveRClassesProcessor
extends BaseRefactoringProcessor {
    private final Collection<AndroidFacet> facetsToMigrate;
    private final boolean updateTopLevelGradleProperties;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected String getCommandName() {
        return "Migrate to non-transitive R classes";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected UsageInfo[] findUsages() {
        void $this$flatMapTo$iv$iv;
        ProgressIndicator progressIndicator;
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator progressIndicator2 = progressIndicator = progressManager.getProgressIndicator();
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator2, (String)"progressIndicator");
        progressIndicator2.setIndeterminate(true);
        progressIndicator.setText("Finding R class usages...");
        Iterable $this$flatMap$iv = this.facetsToMigrate;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            AndroidFacet p1 = (AndroidFacet)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = NamespacesRefactoringsUtilKt.findUsagesOfRClassesFromModule(p1);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List usages = (List)destination$iv$iv;
        progressIndicator.setText("Inferring package names...");
        NamespacesRefactoringsUtilKt.inferPackageNames(usages, progressIndicator);
        progressIndicator.setText((String)null);
        Collection $this$toTypedArray$iv = usages;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        UsageInfo[] usageInfoArray = thisCollection$iv.toArray(new UsageInfo[0]);
        if (usageInfoArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return usageInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        block11: {
            ProgressIndicator progressIndicator;
            Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
            ProgressManager progressManager = ProgressManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
            ProgressIndicator progressIndicator2 = progressIndicator = progressManager.getProgressIndicator();
            Intrinsics.checkNotNullExpressionValue((Object)progressIndicator2, (String)"progressIndicator");
            progressIndicator2.setIndeterminate(false);
            progressIndicator.setFraction(0.0);
            progressIndicator.setText("Rewriting resource references...");
            double totalUsages = usages.length;
            PsiMigration psiMigration = PsiMigrationManager.getInstance((Project)this.myProject).startMigration();
            Intrinsics.checkNotNullExpressionValue((Object)psiMigration, (String)"PsiMigrationManager.getI\u2026Project).startMigration()");
            PsiMigration psiMigration2 = psiMigration;
            try {
                UsageInfo[] $this$forEachIndexed$iv = usages;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (UsageInfo item$iv : $this$forEachIndexed$iv) {
                    void usageInfo;
                    int n = index$iv++;
                    UsageInfo usageInfo2 = item$iv;
                    int index2 = n;
                    boolean bl = false;
                    if (!(usageInfo instanceof CodeUsageInfo)) {
                        String string = "unexpected " + usageInfo;
                        boolean bl2 = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    ((CodeUsageInfo)usageInfo).updateClassReference(psiMigration2);
                    progressIndicator.setFraction((double)(index2 + 1) / totalUsages);
                }
            }
            finally {
                psiMigration2.finish();
            }
            if (!this.updateTopLevelGradleProperties) break block11;
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            PropertiesFile propertiesFile = AndroidRefactoringUtil.getProjectProperties(project, true);
            if (propertiesFile != null) {
                Unit unit;
                Unit unit2;
                PropertiesFile propertiesFile2 = propertiesFile;
                boolean bl = false;
                boolean bl3 = false;
                PropertiesFile $this$apply = propertiesFile2;
                boolean bl4 = false;
                IProperty iProperty = $this$apply.findPropertyByKey("android.nonTransitiveRClass");
                if (iProperty != null) {
                    iProperty.setValue("true");
                    unit2 = Unit.INSTANCE;
                } else {
                    IProperty iProperty2 = $this$apply.addProperty("android.nonTransitiveRClass", "true");
                    unit2 = iProperty2;
                    Intrinsics.checkNotNullExpressionValue((Object)iProperty2, (String)"addProperty(NON_TRANSITI\u2026CLASSES_PROPERTY, \"true\")");
                }
                IProperty iProperty3 = $this$apply.findPropertyByKey("android.experimental.nonTransitiveAppRClass");
                if (iProperty3 != null) {
                    iProperty3.setValue("true");
                    unit = Unit.INSTANCE;
                } else {
                    IProperty iProperty4 = $this$apply.addProperty("android.experimental.nonTransitiveAppRClass", "true");
                    unit = iProperty4;
                    Intrinsics.checkNotNullExpressionValue((Object)iProperty4, (String)"addProperty(NON_TRANSITI\u2026CLASSES_PROPERTY, \"true\")");
                }
                Project project2 = this.myProject;
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
                AndroidRefactoringUtil.syncBeforeFinishingRefactoring(project2, GradleSyncStats.Trigger.TRIGGER_REFACTOR_MIGRATE_TO_RESOURCE_NAMESPACES);
            }
        }
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return (UsageViewDescriptor)new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"PsiElement.EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }

            @NotNull
            public String getProcessedElementsHeader() {
                return "Resource references to migrate";
            }
        };
    }

    private MigrateToNonTransitiveRClassesProcessor(Project project, Collection<? extends AndroidFacet> facetsToMigrate, boolean updateTopLevelGradleProperties) {
        super(project);
        this.facetsToMigrate = facetsToMigrate;
        this.updateTopLevelGradleProperties = updateTopLevelGradleProperties;
    }

    public /* synthetic */ MigrateToNonTransitiveRClassesProcessor(Project project, Collection facetsToMigrate, boolean updateTopLevelGradleProperties, DefaultConstructorMarker $constructor_marker) {
        this(project, facetsToMigrate, updateTopLevelGradleProperties);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/android/refactoring/namespaces/MigrateToNonTransitiveRClassesProcessor$Companion;", "", "()V", "forEntireProject", "Lorg/jetbrains/android/refactoring/namespaces/MigrateToNonTransitiveRClassesProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "forSingleModule", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "intellij.android.core"})
    public static final class Companion {
        @NotNull
        public final MigrateToNonTransitiveRClassesProcessor forSingleModule(@NotNull AndroidFacet facet2) {
            Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
            Module module2 = facet2.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
            Project project = module2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"facet.module.project");
            return new MigrateToNonTransitiveRClassesProcessor(project, SetsKt.setOf((Object)facet2), false, null);
        }

        @NotNull
        public final MigrateToNonTransitiveRClassesProcessor forEntireProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new MigrateToNonTransitiveRClassesProcessor(project, MigrateToNonTransitiveRClassesKt.access$findFacetsToMigrate(project), true, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

