/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring.namespaces;

import com.android.tools.idea.flags.StudioFlags;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.namespaces.MigrateToNonTransitiveRClassesHandler;
import org.jetbrains.android.refactoring.namespaces.MigrateToNonTransitiveRClassesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J\b\u0010\u000b\u001a\u00020\bH\u0014J(\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0014J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u001b\u0010\u0015\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017H\u0014\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\bH\u0014\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/android/refactoring/namespaces/MigrateToNonTransitiveRClassesAction;", "Lcom/intellij/refactoring/actions/BaseRefactoringAction;", "()V", "getHandler", "Lorg/jetbrains/android/refactoring/namespaces/MigrateToNonTransitiveRClassesHandler;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isAvailableForLanguage", "", "language", "Lcom/intellij/lang/Language;", "isAvailableInEditorOnly", "isAvailableOnElementInEditorAndFile", "element", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "context", "isEnabledOnDataContext", "isEnabledOnElements", "elements", "", "([Lcom/intellij/psi/PsiElement;)Z", "isEnabledOnProject", "project", "Lcom/intellij/openapi/project/Project;", "isHidden", "intellij.android.core"})
public final class MigrateToNonTransitiveRClassesAction
extends BaseRefactoringAction {
    @NotNull
    protected MigrateToNonTransitiveRClassesHandler getHandler(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return new MigrateToNonTransitiveRClassesHandler();
    }

    protected boolean isHidden() {
        return (Boolean)StudioFlags.MIGRATE_TO_NON_TRANSITIVE_R_CLASSES_REFACTORING_ENABLED.get() == false;
    }

    protected boolean isAvailableInEditorOnly() {
        return false;
    }

    protected boolean isAvailableForLanguage(@Nullable Language language) {
        return true;
    }

    protected boolean isEnabledOnDataContext(@NotNull DataContext dataContext) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = AndroidRefactoringUtil.getProject(dataContext);
        if (project != null) {
            Project project2 = project;
            MigrateToNonTransitiveRClassesAction migrateToNonTransitiveRClassesAction = this;
            boolean bl2 = false;
            boolean bl3 = false;
            Project p1 = project2;
            boolean bl4 = false;
            bl = migrateToNonTransitiveRClassesAction.isEnabledOnProject(p1);
        } else {
            bl = false;
        }
        return bl;
    }

    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Project project = ((PsiElement)ArraysKt.first((Object[])elements)).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"elements.first().project");
        return this.isEnabledOnProject(project);
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element2, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = element2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        return this.isEnabledOnProject(project);
    }

    private final boolean isEnabledOnProject(Project project) {
        Collection collection2 = MigrateToNonTransitiveRClassesKt.access$findFacetsToMigrate(project);
        boolean bl = false;
        return !collection2.isEmpty();
    }
}

