/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.ui.GuiTestingService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarFile;
import org.jetbrains.android.refactoring.AppCompatStyleMigration;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppCompatPublicDotTxtLookup {
    private static final String BASE_URL = "https://maven.google.com/com/android/support/appcompat-v7/%1$s/appcompat-v7-%2$s.aar";
    private static final String ANDROIDX_BASE_URL = "https://maven.google.com/androidx/appcompat/appcompat/%1$s/appcompat-%2$s.aar";
    private static final Splitter PUBLIC_TXT_SPLITTER = Splitter.on((char)' ').trimResults();
    private static final String RELATIVE_URI_PATH = "com/android/support/appcompat-v7/%1$s/public.txt";
    private static final String ANDROIDX_RELATIVE_URI_PATH = "androidx/appcompat/appcompat/%1$s/public.txt";
    private static final String RELATIVE_FILE_PATH = "com/android/support/appcompat-v7/%1$s/public.txt".replace('/', File.separatorChar);
    private static final String ANDROIDX_RELATIVE_FILE_PATH = "androidx/appcompat/appcompat/%1$s/public.txt".replace('/', File.separatorChar);

    static AppCompatPublicDotTxtLookup getInstance() {
        return LookupCreator.INSTANCE;
    }

    @VisibleForTesting
    AppCompatPublicDotTxtLookup() {
    }

    AppCompatStyleMigration createAppCompatStyleMigration(@NotNull GoogleMavenArtifactId artifactId, @NotNull String appCompatVersion) {
        AppCompatStyleMigration appCompatStyleMigration;
        block13: {
            if (artifactId == null) {
                AppCompatPublicDotTxtLookup.$$$reportNull$$$0(0);
            }
            if (appCompatVersion == null) {
                AppCompatPublicDotTxtLookup.$$$reportNull$$$0(1);
            }
            HashSet attrSet = Sets.newHashSetWithExpectedSize((int)250);
            HashSet styleSet = Sets.newHashSetWithExpectedSize((int)200);
            BufferedReader reader = this.findAppCompatPublicTxt(artifactId, appCompatVersion);
            try {
                String line2;
                while ((line2 = reader.readLine()) != null) {
                    List splitList = PUBLIC_TXT_SPLITTER.splitToList((CharSequence)line2);
                    if (splitList.size() != 2) continue;
                    String key = (String)splitList.get(0);
                    String value2 = (String)splitList.get(1);
                    if ("attr".equals(key)) {
                        attrSet.add(value2);
                        continue;
                    }
                    if (!"style".equals(key)) continue;
                    if (value2.contains("_")) {
                        value2 = value2.replace('_', '.');
                    }
                    styleSet.add(value2);
                }
                appCompatStyleMigration = new AppCompatStyleMigration(attrSet, styleSet);
                if (reader == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.getInstance(AppCompatPublicDotTxtLookup.class).warn((Throwable)e);
                    return new AppCompatStyleMigration(Collections.emptySet(), Collections.emptySet());
                }
            }
            reader.close();
        }
        return appCompatStyleMigration;
    }

    private File getCacheDir() {
        if (ApplicationManager.getApplication().isUnitTestMode() || GuiTestingService.getInstance().isGuiTestingMode()) {
            return null;
        }
        return new File(FileUtil.toCanonicalPath((String)PathManager.getSystemPath()), "maven.google");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static JarFile findRemoteAppCompatAar(@NotNull GoogleMavenArtifactId artifactId, @NotNull String appCompatVersion) throws IOException {
        JarFile jarFile;
        if (artifactId == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(2);
        }
        if (appCompatVersion == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(3);
        }
        URLConnection ucon = null;
        BufferedInputStream is = null;
        try {
            String url = String.format(artifactId.isAndroidxLibrary() ? ANDROIDX_BASE_URL : BASE_URL, appCompatVersion, appCompatVersion);
            ucon = HttpConfigurable.getInstance().openConnection(url);
            is = new BufferedInputStream(ucon.getInputStream());
            Path tmpPath = Files.createTempFile("aar_appcompat_cache", null, new FileAttribute[0]);
            tmpPath.toFile().deleteOnExit();
            Files.copy(is, tmpPath, StandardCopyOption.REPLACE_EXISTING);
            jarFile = new JarFile(tmpPath.toFile());
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(is);
            if (ucon instanceof HttpURLConnection) {
                ((HttpURLConnection)ucon).disconnect();
            }
            throw throwable;
        }
        Closeables.closeQuietly((InputStream)is);
        if (ucon instanceof HttpURLConnection) {
            ((HttpURLConnection)ucon).disconnect();
        }
        JarFile jarFile2 = jarFile;
        if (jarFile2 == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(4);
        }
        return jarFile2;
    }

    @Nullable
    private static JarFile findLocalAppCompatAar(@NotNull GoogleMavenArtifactId artifactId, @NotNull String appCompatVersion) throws IOException {
        AndroidSdkData sdkData;
        if (artifactId == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(5);
        }
        if (appCompatVersion == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(6);
        }
        if ((sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk()) == null) {
            return null;
        }
        GradleCoordinate coordinate = artifactId.getCoordinate(appCompatVersion);
        File appCompatAarFile = RepositoryUrlManager.get().getArchiveForCoordinate(coordinate, sdkData.getLocation(), FileOpUtils.create());
        if (appCompatAarFile == null || !appCompatAarFile.exists()) {
            return null;
        }
        return new JarFile(appCompatAarFile);
    }

    private static byte[] findEntryRemote(@NotNull GoogleMavenArtifactId artifactId, @NotNull String appCompatVersion) throws IOException {
        JarFile jarFile;
        if (artifactId == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(7);
        }
        if (appCompatVersion == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(8);
        }
        if ((jarFile = AppCompatPublicDotTxtLookup.findLocalAppCompatAar(artifactId, appCompatVersion)) == null) {
            jarFile = AppCompatPublicDotTxtLookup.findRemoteAppCompatAar(artifactId, appCompatVersion);
        }
        try {
            byte[] byArray;
            block12: {
                InputStream is = jarFile.getInputStream(jarFile.getEntry("public.txt"));
                try {
                    byArray = ByteStreams.toByteArray((InputStream)is);
                    if (is == null) break block12;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return byArray;
        }
        finally {
            jarFile.close();
        }
    }

    @NotNull
    private synchronized BufferedReader findAppCompatPublicTxt(@NotNull GoogleMavenArtifactId artifactId, @NotNull String appCompatVersion) throws IOException {
        if (artifactId == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(9);
        }
        if (appCompatVersion == null) {
            AppCompatPublicDotTxtLookup.$$$reportNull$$$0(10);
        }
        if (this.getCacheDir() != null) {
            File file2 = new File(this.getCacheDir(), String.format(artifactId.isAndroidxLibrary() ? ANDROIDX_RELATIVE_FILE_PATH : RELATIVE_FILE_PATH, appCompatVersion));
            if (file2.exists()) {
                return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), StandardCharsets.UTF_8));
            }
            try {
                byte[] bytes = AppCompatPublicDotTxtLookup.findEntryRemote(artifactId, appCompatVersion);
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                if (file2.getParentFile().mkdirs()) {
                    in.mark(Integer.MAX_VALUE);
                    Files.copy(in, file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    in.reset();
                }
                return new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                Logger.getInstance(AppCompatPublicDotTxtLookup.class).warn((Throwable)e);
                return AppCompatPublicDotTxtLookup.getPublicTxtAsResource();
            }
        }
        return AppCompatPublicDotTxtLookup.getPublicTxtAsResource();
    }

    @NotNull
    private static BufferedReader getPublicTxtAsResource() {
        InputStream is = AppCompatPublicDotTxtLookup.class.getResourceAsStream("/migrateToAppCompat/public.txt");
        if (is == null) {
            throw new AssertionError((Object)"Missing resource migrateToAppCompat/public.txt");
        }
        return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appCompatVersion";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/refactoring/AppCompatPublicDotTxtLookup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/refactoring/AppCompatPublicDotTxtLookup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findRemoteAppCompatAar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAppCompatStyleMigration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteAppCompatAar";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findLocalAppCompatAar";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findEntryRemote";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findAppCompatPublicTxt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LookupCreator {
        static final AppCompatPublicDotTxtLookup INSTANCE = new AppCompatPublicDotTxtLookup();

        private LookupCreator() {
        }
    }
}

