/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.idea.actions.ExportProjectZip;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.PairFunction;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.dom.resources.StyleItem;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.StyleRefData;
import org.jetbrains.android.util.ErrorReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000~\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a.\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0000\u001a*\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00012\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0007\u001a\u001e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0001\u001a\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a$\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00012\f\u0010%\u001a\b\u0012\u0004\u0012\u00020#0&\u001a\u0016\u0010'\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010(\u001a\u00020)\u001a\u0016\u0010*\u001a\u0004\u0018\u00010+*\u00020\f2\b\b\u0002\u0010,\u001a\u00020-\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006."}, d2={"ACTION_WARNING_TEXT", "", "RESULT_CANCEL", "", "RESULT_MIGRATE", "RESULT_MIGRATE_WITH_BACKUP", "module", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/openapi/actionSystem/DataContext;", "getModule", "(Lcom/intellij/openapi/actionSystem/DataContext;)Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "(Lcom/intellij/openapi/actionSystem/DataContext;)Lcom/intellij/openapi/project/Project;", "computeAttributeMap", "", "Lorg/jetbrains/android/refactoring/AndroidAttributeInfo;", "style", "Lorg/jetbrains/android/dom/resources/Style;", "errorReporter", "Lorg/jetbrains/android/util/ErrorReporter;", "errorReportTitle", "findOrCreateClass", "Lcom/intellij/psi/PsiClass;", "migration", "Lcom/intellij/psi/PsiMigration;", "qName", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findOrCreatePackage", "Lcom/intellij/psi/PsiPackage;", "getParentStyle", "Lorg/jetbrains/android/refactoring/StyleRefData;", "offerToCreateBackupAndRun", "", "title", "runRefactoring", "Lkotlin/Function0;", "syncBeforeFinishingRefactoring", "trigger", "Lcom/google/wireless/android/sdk/stats/GradleSyncStats$Trigger;", "getProjectProperties", "Lcom/intellij/lang/properties/psi/PropertiesFile;", "createIfNotExists", "", "intellij.android.core"})
@JvmName(name="AndroidRefactoringUtil")
public final class AndroidRefactoringUtil {
    private static final int RESULT_MIGRATE_WITH_BACKUP = 0;
    private static final int RESULT_MIGRATE = 1;
    private static final int RESULT_CANCEL = 2;
    private static final String ACTION_WARNING_TEXT = "\nBefore proceeding, we recommend that you make a backup of your project.\n\nDepending on your project dependencies, you might need to manually fix\nsome errors after the refactoring in order to successfully compile your project.\n\nDo you want to proceed with the migration?\n";

    @Nullable
    public static final Project getProject(@NotNull DataContext $this$project) {
        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"$this$project");
        return (Project)LangDataKeys.PROJECT.getData($this$project);
    }

    @Nullable
    public static final Module getModule(@NotNull DataContext $this$module) {
        Intrinsics.checkNotNullParameter((Object)$this$module, (String)"$this$module");
        return (Module)LangDataKeys.MODULE.getData($this$module);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final StyleRefData getParentStyle(@NotNull Style style) {
        StyleRefData styleRefData;
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        GenericAttributeValue<ResourceValue> genericAttributeValue = style.getParentStyle();
        Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"style.parentStyle");
        ResourceValue parentStyleRefValue = (ResourceValue)genericAttributeValue.getValue();
        if (parentStyleRefValue != null) {
            String string = parentStyleRefValue.getResourceName();
            if (string == null) return null;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            styleRefData = new StyleRefData(it, parentStyleRefValue.getPackage());
            return styleRefData;
        } else {
            GenericAttributeValue<String> genericAttributeValue2 = style.getName();
            Intrinsics.checkNotNullExpressionValue(genericAttributeValue2, (String)"style.name");
            String string = genericAttributeValue2.getStringValue();
            String string3 = string;
            if (string == null) return null;
            String string4 = string3;
            boolean bl = false;
            boolean bl4 = false;
            String it = string4;
            boolean bl5 = false;
            String string5 = it;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it");
            if (StringsKt.indexOf$default((CharSequence)string5, (char)'.', (int)0, (boolean)false, (int)6, null) <= 0) return null;
            boolean bl6 = true;
            if (!bl6) return null;
            String string6 = string4;
            string3 = string6;
            if (string6 == null) return null;
            string4 = string3;
            bl = false;
            bl4 = false;
            it = string4;
            boolean bl7 = false;
            String string7 = it;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"it");
            styleRefData = new StyleRefData(StringsKt.substringBeforeLast$default((String)string7, (char)'.', null, (int)2, null), null);
        }
        return styleRefData;
    }

    @Nullable
    public static final Map<AndroidAttributeInfo, String> computeAttributeMap(@NotNull Style style, @NotNull ErrorReporter errorReporter, @NotNull String errorReportTitle) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)errorReportTitle, (String)"errorReportTitle");
        boolean bl = false;
        Map attributeValues = new LinkedHashMap();
        Iterator<StyleItem> iterator = style.getItems().iterator();
        while (iterator.hasNext()) {
            StyleItem item;
            StyleItem styleItem = item = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)styleItem, (String)"item");
            GenericAttributeValue<ResourceReference> genericAttributeValue = styleItem.getName();
            Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"item.name");
            String attributeName = genericAttributeValue.getStringValue();
            String attributeValue = item.getStringValue();
            if (attributeName == null) continue;
            CharSequence charSequence = attributeName;
            boolean bl2 = false;
            if (charSequence.length() == 0 || attributeValue == null) continue;
            String localName = StringsKt.substringAfterLast$default((String)attributeName, (char)':', null, (int)2, null);
            String nsPrefix = StringsKt.substringBefore((String)attributeName, (char)':', (String)"");
            CharSequence charSequence2 = nsPrefix;
            boolean bl3 = false;
            if (charSequence2.length() > 0) {
                if (Intrinsics.areEqual((Object)"android", (Object)nsPrefix) ^ true) {
                    errorReporter.report(RefactoringBundle.getCannotRefactorMessage((String)("Unknown XML attribute prefix '" + nsPrefix + ":'")), errorReportTitle);
                    return null;
                }
            } else {
                errorReporter.report(RefactoringBundle.getCannotRefactorMessage((String)"The style contains attribute without 'android' prefix."), errorReportTitle);
                return null;
            }
            attributeValues.put(new AndroidAttributeInfo(localName, nsPrefix), attributeValue);
        }
        return attributeValues;
    }

    @JvmOverloads
    @NotNull
    public static final PsiClass findOrCreateClass(@NotNull Project project, @NotNull PsiMigration migration, @NotNull String qName, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)migration, (String)"migration");
        Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(qName, scope2);
        if (psiClass == null) {
            boolean $i$f$runWriteAction = false;
            Object object = ApplicationManager.getApplication().runWriteAction(new Computable(migration, qName){
                final /* synthetic */ PsiMigration $migration$inlined;
                final /* synthetic */ String $qName$inlined;
                {
                    this.$migration$inlined = psiMigration;
                    this.$qName$inlined = string;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)this.$migration$inlined.createClass(this.$qName$inlined);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runWriteAction { migration.createClass(qName) }");
            psiClass = (PsiClass)object;
        }
        return psiClass;
    }

    public static /* synthetic */ PsiClass findOrCreateClass$default(Project project, PsiMigration psiMigration, String string, GlobalSearchScope globalSearchScope, int n, Object object) {
        if ((n & 8) != 0) {
            GlobalSearchScope globalSearchScope2 = GlobalSearchScope.allScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"GlobalSearchScope.allScope(project)");
            globalSearchScope = globalSearchScope2;
        }
        return AndroidRefactoringUtil.findOrCreateClass(project, psiMigration, string, globalSearchScope);
    }

    @JvmOverloads
    @NotNull
    public static final PsiClass findOrCreateClass(@NotNull Project project, @NotNull PsiMigration migration, @NotNull String qName) {
        return AndroidRefactoringUtil.findOrCreateClass$default(project, migration, qName, null, 8, null);
    }

    @NotNull
    public static final PsiPackage findOrCreatePackage(@NotNull Project project, @NotNull PsiMigration migration, @NotNull String qName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)migration, (String)"migration");
        Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)project).findPackage(qName);
        if (psiPackage == null) {
            boolean $i$f$runWriteAction = false;
            Object object = ApplicationManager.getApplication().runWriteAction(new Computable(migration, qName){
                final /* synthetic */ PsiMigration $migration$inlined;
                final /* synthetic */ String $qName$inlined;
                {
                    this.$migration$inlined = psiMigration;
                    this.$qName$inlined = string;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)this.$migration$inlined.createPackage(this.$qName$inlined);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runWriteAction { migration.createPackage(qName) }");
            psiPackage = (PsiPackage)object;
        }
        return psiPackage;
    }

    public static final void offerToCreateBackupAndRun(@NotNull Project project, @NotNull String title, @NotNull Function0<Unit> runRefactoring) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(runRefactoring, (String)"runRefactoring");
        String string = ACTION_WARNING_TEXT;
        boolean bl = false;
        int okCancelResult2 = Messages.showCheckboxMessageDialog((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (String)title, (String[])new String[]{"Migrate", "Cancel"}, (String)"Backup project as Zip file", (boolean)true, (int)0, (int)0, (Icon)Messages.getWarningIcon(), (PairFunction)offerToCreateBackupAndRun.okCancelResult.1.INSTANCE);
        switch (okCancelResult2) {
            case 2: {
                return;
            }
            case 0: {
                ExportProjectZip exportZip = new ExportProjectZip();
                Function0<Unit> function0 = runRefactoring;
                ActionUtil.invokeAction((AnAction)exportZip, (DataContext)SimpleDataContext.getProjectContext((Project)project), (String)title, null, (Runnable)new Runnable(function0){
                    private final /* synthetic */ Function0 function;
                    {
                        this.function = function0;
                    }

                    public final /* synthetic */ void run() {
                        Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                    }
                });
                break;
            }
            default: {
                runRefactoring.invoke();
            }
        }
    }

    public static final void syncBeforeFinishingRefactoring(@NotNull Project project, @NotNull GradleSyncStats.Trigger trigger) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        boolean bl = application.isDispatchThread();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        GradleSyncInvoker.getInstance().requestProjectSync(project, new GradleSyncInvoker.Request(trigger));
    }

    @Nullable
    public static final PropertiesFile getProjectProperties(@NotNull Project $this$getProjectProperties, boolean createIfNotExists) {
        VirtualFile gradlePropertiesFile;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getProjectProperties, (String)"$this$getProjectProperties");
        if ($this$getProjectProperties.isDisposed()) {
            return null;
        }
        VirtualFile projectBaseDirectory = ProjectUtil.guessProjectDir((Project)$this$getProjectProperties);
        if (createIfNotExists) {
            VirtualFile virtualFile = projectBaseDirectory;
            object = virtualFile != null ? virtualFile.findOrCreateChildData((Object)$this$getProjectProperties, "gradle.properties") : null;
        } else {
            VirtualFile virtualFile = projectBaseDirectory;
            object = virtualFile != null ? virtualFile.findChild("gradle.properties") : null;
        }
        VirtualFile virtualFile = gradlePropertiesFile = object;
        if (virtualFile == null) {
            return null;
        }
        PsiFile psiPropertiesFile = PsiManager.getInstance((Project)$this$getProjectProperties).findFile(virtualFile);
        return psiPropertiesFile instanceof PropertiesFile ? (PropertiesFile)psiPropertiesFile : null;
    }

    public static /* synthetic */ PropertiesFile getProjectProperties$default(Project project, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return AndroidRefactoringUtil.getProjectProperties(project, bl);
    }
}

