/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProviderEx;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.refactoring.UsageTypeProvidersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J)\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\f"}, d2={"Lorg/jetbrains/android/refactoring/AndroidNewXmlUsageProvider;", "Lcom/intellij/usages/impl/rules/UsageTypeProviderEx;", "()V", "getUsageType", "Lcom/intellij/usages/impl/rules/UsageType;", "element", "Lcom/intellij/psi/PsiElement;", "targets", "", "Lcom/intellij/usages/UsageTarget;", "(Lcom/intellij/psi/PsiElement;[Lcom/intellij/usages/UsageTarget;)Lcom/intellij/usages/impl/rules/UsageType;", "Companion", "intellij.android.core"})
public final class AndroidNewXmlUsageProvider
implements UsageTypeProviderEx {
    private static final UsageType ANDROID_RESOURCES_XML_DECLARATION_TYPE;
    private static final UsageType ANDROID_RESOURCES_XML_USAGE_TYPE;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public UsageType getUsageType(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullExpressionValue((Object)UsageTarget.EMPTY_ARRAY, (String)"UsageTarget.EMPTY_ARRAY");
        return this.getUsageType(element2, UsageTarget.EMPTY_ARRAY);
    }

    @Nullable
    public UsageType getUsageType(@Nullable PsiElement element2, @NotNull UsageTarget[] targets) {
        UsageType usageType;
        DomFileDescription domFileDescription;
        Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
        if (!((Boolean)StudioFlags.RESOLVE_USING_REPOS.get()).booleanValue()) {
            return null;
        }
        PsiElement psiElement = element2;
        Object object = psiElement != null ? psiElement.getContainingFile() : null;
        if (!(object instanceof XmlFile)) {
            object = null;
        }
        XmlFile xmlFile = (XmlFile)object;
        if (xmlFile == null) {
            return null;
        }
        XmlFile xmlFile2 = xmlFile;
        DomManager domManager = DomManager.getDomManager((Project)xmlFile2.getProject());
        if (domManager == null) {
            return null;
        }
        DomManager domManager2 = domManager;
        Object object2 = ArraysKt.firstOrNull((Object[])targets);
        if (!(object2 instanceof PsiElementUsageTarget)) {
            object2 = null;
        }
        PsiElementUsageTarget psiElementUsageTarget = (PsiElementUsageTarget)object2;
        Object object3 = psiElementUsageTarget != null ? psiElementUsageTarget.getElement() : null;
        if (!(object3 instanceof ResourceReferencePsiElement)) {
            object3 = null;
        }
        ResourceReferencePsiElement resourceReferencePsiElement = (ResourceReferencePsiElement)((Object)object3);
        DomFileElement domFileElement = domManager2.getFileElement(xmlFile2, AndroidDomElement.class);
        Object object4 = domFileDescription = domFileElement != null ? domFileElement.getFileDescription() : null;
        if (domFileDescription == null) {
            usageType = null;
        } else if (domFileDescription instanceof ManifestDomFileDescription) {
            usageType = UsageTypeProvidersKt.access$getANDROID_MANIFEST_USAGE_TYPE$p();
        } else {
            return resourceReferencePsiElement != null && IdeResourcesUtil.isResourceDeclaration(element2, resourceReferencePsiElement) ? ANDROID_RESOURCES_XML_DECLARATION_TYPE : ANDROID_RESOURCES_XML_USAGE_TYPE;
        }
        return usageType;
    }

    static {
        Companion = new Companion(null);
        ANDROID_RESOURCES_XML_DECLARATION_TYPE = new UsageType("Resource declaration in Android resources XML");
        ANDROID_RESOURCES_XML_USAGE_TYPE = new UsageType("Resource reference Android resources XML");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/android/refactoring/AndroidNewXmlUsageProvider$Companion;", "", "()V", "ANDROID_RESOURCES_XML_DECLARATION_TYPE", "Lcom/intellij/usages/impl/rules/UsageType;", "ANDROID_RESOURCES_XML_USAGE_TYPE", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

