/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.resources.ResourceType;
import com.google.common.base.CharMatcher;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.intentions.AndroidAddStringResourceAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidAddStringResourceQuickFix
extends AndroidAddStringResourceAction {
    private static final CharMatcher DISALLOWED_CHARS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).negate();
    private final PsiElement myStartElement;

    public AndroidAddStringResourceQuickFix(@NotNull PsiElement startElement) {
        if (startElement == null) {
            AndroidAddStringResourceQuickFix.$$$reportNull$$$0(0);
        }
        this.myStartElement = startElement;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file2) {
        if (project == null) {
            AndroidAddStringResourceQuickFix.$$$reportNull$$$0(1);
        }
        if (!this.myStartElement.isValid()) {
            return false;
        }
        XmlAttributeValue value2 = AndroidAddStringResourceQuickFix.getAttributeValue(this.myStartElement);
        return value2 != null && AndroidAddStringResourceQuickFix.getStringLiteralValue(project, (PsiElement)value2, file2, ResourceType.STRING) != null;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        String value2;
        if (project == null) {
            AndroidAddStringResourceQuickFix.$$$reportNull$$$0(2);
        }
        String defaultName = null;
        PsiElement parent = this.myStartElement.getParent();
        if (parent instanceof XmlAttribute && (value2 = ((XmlAttribute)parent).getValue()) != null) {
            defaultName = AndroidAddStringResourceQuickFix.buildResourceName(value2);
        }
        this.invokeIntention(project, editor2, file2, defaultName);
    }

    @NotNull
    static String buildResourceName(@NotNull String value2) {
        String result2;
        if (value2 == null) {
            AndroidAddStringResourceQuickFix.$$$reportNull$$$0(3);
        }
        if (!(result2 = StringUtil.toLowerCase((String)DISALLOWED_CHARS.trimAndCollapseFrom((CharSequence)value2, '_'))).isEmpty() && CharMatcher.javaDigit().matches(result2.charAt(0))) {
            String string = "_" + result2;
            if (string == null) {
                AndroidAddStringResourceQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = result2;
        if (string == null) {
            AndroidAddStringResourceQuickFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void invokeIntention(Project project, Editor editor2, PsiFile file2, @Nullable String resName) {
        XmlAttributeValue attributeValue = AndroidAddStringResourceQuickFix.getAttributeValue(this.myStartElement);
        if (attributeValue != null) {
            AndroidAddStringResourceQuickFix.doInvoke(project, editor2, file2, resName, (PsiElement)attributeValue, ResourceType.STRING);
        }
    }

    @Nullable
    private static XmlAttributeValue getAttributeValue(@NotNull PsiElement element2) {
        XmlAttribute attribute;
        if (element2 == null) {
            AndroidAddStringResourceQuickFix.$$$reportNull$$$0(6);
        }
        return (attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlAttribute.class)) != null ? attribute.getValueElement() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/lint/AndroidAddStringResourceQuickFix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/lint/AndroidAddStringResourceQuickFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildResourceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildResourceName";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

