/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlNamespaceHelper;
import java.util.Collections;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AddMissingPrefixQuickFix
implements LintIdeQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.inspections.lint.AddMissingPrefixQuickFix");

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlAttribute attribute;
        if (startElement == null) {
            AddMissingPrefixQuickFix.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            AddMissingPrefixQuickFix.$$$reportNull$$$0(1);
        }
        if (context == null) {
            AddMissingPrefixQuickFix.$$$reportNull$$$0(2);
        }
        if ((attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class, (boolean)false)) == null) {
            return;
        }
        XmlTag tag = attribute.getParent();
        if (tag == null) {
            LOG.debug("tag is null");
            return;
        }
        String androidNsPrefix = tag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
        if (androidNsPrefix == null) {
            PsiFile file2 = tag.getContainingFile();
            XmlNamespaceHelper extension = XmlNamespaceHelper.getHelper((PsiFile)file2);
            if (extension == null) {
                LOG.debug("Cannot get XmlNamespaceHelper for file + " + file2);
                return;
            }
            if (!(file2 instanceof XmlFile)) {
                LOG.debug(file2 + " is not XmlFile");
                return;
            }
            XmlFile xmlFile = (XmlFile)file2;
            String defaultPrefix = "android";
            extension.insertNamespaceDeclaration(xmlFile, null, Collections.singleton("http://schemas.android.com/apk/res/android"), "android", null);
            androidNsPrefix = "android";
        }
        String finalAndroidNsPrefix = androidNsPrefix;
        ApplicationManager.getApplication().runWriteAction(() -> attribute.setName(finalAndroidNsPrefix + ":" + attribute.getLocalName()));
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            AddMissingPrefixQuickFix.$$$reportNull$$$0(3);
        }
        if (endElement == null) {
            AddMissingPrefixQuickFix.$$$reportNull$$$0(4);
        }
        if (contextType == null) {
            AddMissingPrefixQuickFix.$$$reportNull$$$0(5);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class, (boolean)false) != null;
    }

    @NotNull
    public String getName() {
        String string = AndroidBundle.message("android.lint.fix.add.android.prefix", new Object[0]);
        if (string == null) {
            AddMissingPrefixQuickFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/lint/AddMissingPrefixQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/lint/AddMissingPrefixQuickFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

