/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.utils.SdkUtils;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.AndroidGotoRelatedLineMarkerProvider;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.dom.menu.MenuDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.intentions.AndroidCreateOnClickHandlerAction;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;

public class AndroidMissingOnClickHandlerInspection
extends LocalInspectionTool {
    @NotNull
    private static Collection<PsiClass> findRelatedActivities(@NotNull XmlFile file2, @NotNull AndroidFacet facet2, @NotNull DomFileDescription<?> description2) {
        if (file2 == null) {
            AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(0);
        }
        if (facet2 == null) {
            AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(1);
        }
        if (description2 == null) {
            AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(2);
        }
        if (AndroidResourceDomFileDescription.isFileInResourceFolderType(file2, ResourceFolderType.LAYOUT)) {
            List<GotoRelatedItem> items2 = AndroidGotoRelatedLineMarkerProvider.getItemsForXmlFile(file2, facet2);
            if (items2 == null || items2.isEmpty()) {
                List<PsiClass> list = Collections.emptyList();
                if (list == null) {
                    AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(3);
                }
                return list;
            }
            PsiClass activityClass = AndroidMissingOnClickHandlerInspection.findActivityClass(facet2.getModule());
            if (activityClass == null) {
                List<PsiClass> list = Collections.emptyList();
                if (list == null) {
                    AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(4);
                }
                return list;
            }
            ArrayList<PsiClass> result2 = new ArrayList<PsiClass>();
            for (GotoRelatedItem item : items2) {
                PsiClass aClass;
                PsiElement element2 = item.getElement();
                if (element2 instanceof PsiClass) {
                    aClass = (PsiClass)element2;
                    if (!aClass.isInheritor(activityClass, true)) continue;
                    result2.add(aClass);
                    continue;
                }
                if (!(element2 instanceof KtClass) || (aClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClass)element2))) == null || !aClass.isInheritor(activityClass, true)) continue;
                result2.add(aClass);
            }
            ArrayList<PsiClass> arrayList = result2;
            if (arrayList == null) {
                AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        return AndroidMissingOnClickHandlerInspection.findRelatedActivitiesForMenu(file2, facet2);
    }

    @NotNull
    private static Set<PsiClass> findRelatedActivitiesForMenu(@NotNull XmlFile file2, @NotNull AndroidFacet facet2) {
        String resourceName;
        String resType;
        PsiField[] fields;
        if (file2 == null) {
            AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(6);
        }
        if (facet2 == null) {
            AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(7);
        }
        if ((fields = IdeResourcesUtil.findResourceFields(facet2, resType = ResourceType.MENU.getName(), resourceName = SdkUtils.fileNameToResourceName((String)file2.getName()), true)).length == 0) {
            Set<PsiClass> set = Collections.emptySet();
            if (set == null) {
                AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(8);
            }
            return set;
        }
        Module module2 = facet2.getModule();
        GlobalSearchScope scope2 = module2.getModuleScope(false);
        final PsiClass activityClass = AndroidMissingOnClickHandlerInspection.findActivityClass(module2);
        if (activityClass == null) {
            Set<PsiClass> set = Collections.emptySet();
            if (set == null) {
                AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(9);
            }
            return set;
        }
        final HashSet<PsiClass> result2 = new HashSet<PsiClass>();
        ReferencesSearch.search((PsiElement)fields[0], (SearchScope)scope2).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference reference2) {
                PsiElement element2 = reference2.getElement();
                if (element2 == null) {
                    return true;
                }
                PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiClass.class);
                if (aClass != null && !result2.contains(aClass) && aClass.isInheritor(activityClass, true)) {
                    result2.add(aClass);
                }
                return true;
            }
        });
        HashSet<PsiClass> hashSet = result2;
        if (hashSet == null) {
            AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @Nullable
    public static PsiClass findActivityClass(@NotNull Module module2) {
        if (module2 == null) {
            AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(11);
        }
        return JavaPsiFacade.getInstance((Project)module2.getProject()).findClass("android.app.Activity", module2.getModuleWithDependenciesAndLibrariesScope(false));
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file2 == null) {
            AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(13);
        }
        if (!(file2 instanceof XmlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file2);
        if (facet2 == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        DomFileDescription description2 = DomManager.getDomManager((Project)file2.getProject()).getDomFileDescription((XmlFile)file2);
        if (!AndroidResourceDomFileDescription.isFileInResourceFolderType((XmlFile)file2, ResourceFolderType.LAYOUT) && !(description2 instanceof MenuDomFileDescription)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Collection<PsiClass> activities = AndroidMissingOnClickHandlerInspection.findRelatedActivities((XmlFile)file2, facet2, description2);
        MyVisitor visitor2 = new MyVisitor(manager, isOnTheFly, activities);
        file2.accept((PsiElementVisitor)visitor2);
        return visitor2.myResult.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/AndroidMissingOnClickHandlerInspection";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/AndroidMissingOnClickHandlerInspection";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelatedActivities";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelatedActivitiesForMenu";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findRelatedActivities";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findRelatedActivitiesForMenu";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findActivityClass";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyQuickFix
    extends AbstractIntentionAction
    implements LocalQuickFix {
        private final String myMethodName;
        private final OnClickConverter myConverter;
        private final PsiClass myClass;

        private MyQuickFix(@NotNull String methodName, @NotNull OnClickConverter converter, @NotNull PsiClass aClass) {
            if (methodName == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            if (converter == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            if (aClass == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            this.myMethodName = methodName;
            this.myConverter = converter;
            this.myClass = aClass;
        }

        @NotNull
        public String getFamilyName() {
            String string = "Create '" + this.myMethodName + "(" + this.myConverter.getShortParameterName() + ")' in '" + this.myClass.getName() + "'";
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getName();
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        public void invoke(@NotNull Project project, Editor editor2, PsiFile file2) throws IncorrectOperationException {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(5);
            }
            String paramType = this.myConverter.getDefaultMethodParameterType(this.myClass);
            AndroidCreateOnClickHandlerAction.addHandlerMethodAndNavigate(project, this.myClass, this.myMethodName, paramType);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(6);
            }
            if (descriptor2 == null) {
                MyQuickFix.$$$reportNull$$$0(7);
            }
            this.doApplyFix(project);
        }

        public void doApplyFix(@NotNull Project project) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(8);
            }
            String paramType = this.myConverter.getDefaultMethodParameterType(this.myClass);
            AndroidCreateOnClickHandlerAction.addHandlerMethod(project, this.myClass, this.myMethodName, paramType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "converter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/inspections/AndroidMissingOnClickHandlerInspection$MyQuickFix";
                    break;
                }
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/inspections/AndroidMissingOnClickHandlerInspection$MyQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "doApplyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyVisitor
    extends XmlRecursiveElementVisitor {
        private final InspectionManager myInspectionManager;
        private final boolean myOnTheFly;
        private final Collection<PsiClass> myRelatedActivities;
        final List<ProblemDescriptor> myResult;

        private MyVisitor(@NotNull InspectionManager inspectionManager, boolean onTheFly, @NotNull Collection<PsiClass> relatedActivities) {
            if (inspectionManager == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (relatedActivities == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            this.myResult = new ArrayList<ProblemDescriptor>();
            this.myInspectionManager = inspectionManager;
            this.myOnTheFly = onTheFly;
            this.myRelatedActivities = relatedActivities;
        }

        public void visitXmlAttributeValue(XmlAttributeValue value2) {
            for (PsiReference reference2 : value2.getReferences()) {
                OnClickConverter.MyReference ref;
                String methodName;
                if (!(reference2 instanceof OnClickConverter.MyReference) || (methodName = (ref = (OnClickConverter.MyReference)reference2).getValue()).isEmpty()) continue;
                ResolveResult[] results = ref.multiResolve(false);
                HashSet<PsiClass> resolvedClasses = new HashSet<PsiClass>();
                HashSet<PsiClass> resolvedClassesWithMistake = new HashSet<PsiClass>();
                for (ResolveResult result2 : results) {
                    PsiClass aClass;
                    PsiElement element2;
                    if (!(result2 instanceof OnClickConverter.MyResolveResult) || (element2 = result2.getElement()) == null || (aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiClass.class)) == null) continue;
                    resolvedClasses.add(aClass);
                    if (((OnClickConverter.MyResolveResult)result2).hasCorrectSignature()) continue;
                    resolvedClassesWithMistake.add(aClass);
                }
                PsiClass activity = null;
                for (PsiClass relatedActivity : this.myRelatedActivities) {
                    if (!MyVisitor.containsOrExtends(resolvedClasses, relatedActivity)) {
                        activity = relatedActivity;
                        break;
                    }
                    if (activity != null || !MyVisitor.containsOrExtends(resolvedClassesWithMistake, relatedActivity)) continue;
                    activity = relatedActivity;
                }
                if (activity != null) {
                    this.reportMissingOnClickProblem(ref, activity, methodName, resolvedClassesWithMistake.contains(activity));
                    continue;
                }
                if (results.length == 0) {
                    this.myResult.add(this.myInspectionManager.createProblemDescriptor((PsiElement)value2, reference2.getRangeInElement(), ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference2), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, new LocalQuickFix[0]));
                    continue;
                }
                if (resolvedClassesWithMistake.isEmpty()) continue;
                this.reportMissingOnClickProblem(ref, (PsiClass)resolvedClassesWithMistake.iterator().next(), methodName, true);
            }
        }

        private static boolean containsOrExtends(@NotNull Set<PsiClass> resolvedClasses, @NotNull PsiClass relatedActivity) {
            if (resolvedClasses == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if (relatedActivity == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if (resolvedClasses.contains(relatedActivity)) {
                return true;
            }
            for (PsiClass resolvedClass : resolvedClasses) {
                if (!relatedActivity.isInheritor(resolvedClass, false)) continue;
                return true;
            }
            return false;
        }

        private void reportMissingOnClickProblem(OnClickConverter.MyReference reference2, PsiClass activity, String methodName, boolean incorrectSignature) {
            LocalQuickFix[] localQuickFixArray;
            String message2;
            String activityName = activity.getName();
            if (activityName == null) {
                activityName = "";
            }
            String string = message2 = incorrectSignature ? AndroidBundle.message("android.inspections.on.click.missing.incorrect.signature", methodName, activityName) : AndroidBundle.message("android.inspections.on.click.missing.problem", methodName, activityName);
            if (StringUtil.isJavaIdentifier((String)methodName)) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = new MyQuickFix(methodName, reference2.getConverter(), activity);
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            this.myResult.add(this.myInspectionManager.createProblemDescriptor(reference2.getElement(), reference2.getRangeInElement(), message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, fixes));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspectionManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relatedActivities";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedClasses";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relatedActivity";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/inspections/AndroidMissingOnClickHandlerInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "containsOrExtends";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

