/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.tools.idea.model.AndroidModuleInfo;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageFeatureProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidLanguageFeatureProvider
implements LanguageFeatureProvider {
    @NotNull
    public ThreeState isFeatureSupported(@NotNull JavaFeature feature, @NotNull PsiFile file2) {
        if (feature == null) {
            AndroidLanguageFeatureProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            AndroidLanguageFeatureProvider.$$$reportNull$$$0(1);
        }
        if (JavaFeature.MULTI_CATCH == feature) {
            ThreeState threeState = ThreeState.fromBoolean((boolean)AndroidLanguageFeatureProvider.isApiLevelAtLeast(file2, 19, true));
            if (threeState == null) {
                AndroidLanguageFeatureProvider.$$$reportNull$$$0(2);
            }
            return threeState;
        }
        if (JavaFeature.STREAMS == feature || JavaFeature.ADVANCED_COLLECTIONS_API == feature) {
            ThreeState threeState = ThreeState.fromBoolean((boolean)AndroidLanguageFeatureProvider.isApiLevelAtLeast(file2, 24, true));
            if (threeState == null) {
                AndroidLanguageFeatureProvider.$$$reportNull$$$0(3);
            }
            return threeState;
        }
        if (JavaFeature.THREAD_LOCAL_WITH_INITIAL == feature) {
            ThreeState threeState = ThreeState.fromBoolean((boolean)AndroidLanguageFeatureProvider.isApiLevelAtLeast(file2, 26, true));
            if (threeState == null) {
                AndroidLanguageFeatureProvider.$$$reportNull$$$0(4);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            AndroidLanguageFeatureProvider.$$$reportNull$$$0(5);
        }
        return threeState;
    }

    public static boolean isApiLevelAtLeast(PsiFile file2, int minApiLevel, boolean defaultValue2) {
        AndroidFacet facet2;
        if (file2 != null && (facet2 = AndroidFacet.getInstance((PsiElement)file2)) != null && !facet2.isDisposed()) {
            AndroidModuleInfo info2 = AndroidModuleInfo.getInstance(facet2);
            return info2.getMinSdkVersion().getApiLevel() >= minApiLevel;
        }
        return defaultValue2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/AndroidLanguageFeatureProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/AndroidLanguageFeatureProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "isFeatureSupported";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFeatureSupported";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

