/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.DeprecationUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.android.inspections.AndroidDeprecationFilter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDeprecationInspection
extends BaseJavaBatchLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "Deprecation";
    @NonNls
    public static final String ID = "deprecation";
    public static final String DISPLAY_NAME = DeprecationUtil.getDeprecationDisplayName();
    public static final String IGNORE_METHODS_OF_DEPRECATED_NAME = "IGNORE_METHODS_OF_DEPRECATED";
    public boolean IGNORE_INSIDE_DEPRECATED;
    public boolean IGNORE_ABSTRACT_DEPRECATED_OVERRIDES = true;
    public boolean IGNORE_IMPORT_STATEMENTS = true;
    public boolean IGNORE_METHODS_OF_DEPRECATED = true;
    private static final DeprecationFilter[] DEPRECATION_FILTERS = new DeprecationFilter[]{new AndroidDeprecationFilter()};

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AndroidDeprecationInspection.$$$reportNull$$$0(0);
        }
        return new DeprecationElementVisitor(holder, this.IGNORE_INSIDE_DEPRECATED, this.IGNORE_ABSTRACT_DEPRECATED_OVERRIDES, this.IGNORE_IMPORT_STATEMENTS, this.IGNORE_METHODS_OF_DEPRECATED);
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            AndroidDeprecationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        return "";
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @NotNull
    @NonNls
    public String getID() {
        return ID;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox("Ignore inside deprecated members", "IGNORE_INSIDE_DEPRECATED");
        panel2.addCheckbox("Ignore inside non-static imports", "IGNORE_IMPORT_STATEMENTS");
        panel2.addCheckbox("<html>Ignore overrides of deprecated abstract methods from non-deprecated supers</html>", "IGNORE_ABSTRACT_DEPRECATED_OVERRIDES");
        panel2.addCheckbox("Ignore members of deprecated classes", IGNORE_METHODS_OF_DEPRECATED_NAME);
        return panel2;
    }

    private static boolean hasDefaultDeprecatedConstructor(PsiClass superClass) {
        if (superClass != null) {
            PsiMethod[] constructors;
            for (PsiMethod constructor : constructors = superClass.getConstructors()) {
                if (constructor.getParameterList().getParametersCount() != 0 || !constructor.isDeprecated()) continue;
                return true;
            }
        }
        return false;
    }

    static void checkMethodOverridesDeprecated(MethodSignatureBackedByPsiMethod methodSignature, List<MethodSignatureBackedByPsiMethod> superMethodSignatures, boolean ignoreAbstractDeprecatedOverrides, ProblemsHolder holder) {
        PsiMethod method2 = methodSignature.getMethod();
        PsiIdentifier methodName = method2.getNameIdentifier();
        if (methodName == null) {
            return;
        }
        for (MethodSignatureBackedByPsiMethod superMethodSignature : superMethodSignatures) {
            PsiMethod superMethod = superMethodSignature.getMethod();
            PsiClass aClass = superMethod.getContainingClass();
            if (aClass == null || ignoreAbstractDeprecatedOverrides && !aClass.isDeprecated() && superMethod.hasModifierProperty("abstract") || !superMethod.isDeprecated()) continue;
            String description2 = JavaErrorBundle.message((String)"overrides.deprecated.method", (Object[])new Object[]{HighlightMessageUtil.getSymbolName((PsiElement)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY)});
            ArrayList fixes = new ArrayList(4);
            String symbolName = HighlightMessageUtil.getSymbolName((PsiElement)methodName, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            for (DeprecationFilter filter2 : AndroidDeprecationInspection.getFilters()) {
                if (filter2.isExcluded((PsiElement)superMethod, (PsiElement)methodName, symbolName)) {
                    return;
                }
                description2 = filter2.getDeprecationMessage((PsiElement)superMethod, (PsiElement)methodName, symbolName, description2);
                LocalQuickFix[] additionalFixes = filter2.getQuickFixes((PsiElement)superMethod, (PsiElement)methodName, symbolName);
                Collections.addAll(fixes, additionalFixes);
            }
            holder.registerProblem((PsiElement)methodName, description2, ProblemHighlightType.LIKE_DEPRECATED, null, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    public static void checkDeprecated(PsiElement refElement, PsiElement elementToHighlight, @Nullable TextRange rangeInElement, ProblemsHolder holder) {
        AndroidDeprecationInspection.checkDeprecated(refElement, elementToHighlight, rangeInElement, false, false, true, holder);
    }

    public static void checkDeprecated(PsiElement refElement, PsiElement elementToHighlight, @Nullable TextRange rangeInElement, boolean ignoreInsideDeprecated, boolean ignoreImportStatements, boolean ignoreMethodsOfDeprecated, ProblemsHolder holder) {
        if (!(refElement instanceof PsiDocCommentOwner)) {
            return;
        }
        if (!((PsiDocCommentOwner)refElement).isDeprecated()) {
            if (!ignoreMethodsOfDeprecated) {
                AndroidDeprecationInspection.checkDeprecated((PsiElement)((PsiDocCommentOwner)refElement).getContainingClass(), elementToHighlight, rangeInElement, ignoreInsideDeprecated, ignoreImportStatements, false, holder);
            }
            return;
        }
        if (ignoreInsideDeprecated) {
            PsiElement parent = elementToHighlight;
            while ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, PsiDocCommentOwner.class, (boolean)true)) != null) {
                if (!((PsiDocCommentOwner)parent).isDeprecated()) continue;
                return;
            }
        }
        if (ignoreImportStatements && PsiTreeUtil.getParentOfType((PsiElement)elementToHighlight, PsiImportStatementBase.class) != null) {
            return;
        }
        String symbolName = HighlightMessageUtil.getSymbolName((PsiElement)refElement, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        String description2 = JavaErrorBundle.message((String)"deprecated.symbol", (Object[])new Object[]{symbolName});
        ArrayList fixes = new ArrayList(4);
        for (DeprecationFilter filter2 : AndroidDeprecationInspection.getFilters()) {
            if (filter2.isExcluded(refElement, elementToHighlight, symbolName)) {
                return;
            }
            description2 = filter2.getDeprecationMessage(refElement, elementToHighlight, symbolName, description2);
            LocalQuickFix[] additionalFixes = filter2.getQuickFixes(refElement, elementToHighlight, symbolName);
            Collections.addAll(fixes, additionalFixes);
        }
        holder.registerProblem(elementToHighlight, description2, ProblemHighlightType.LIKE_DEPRECATED, rangeInElement, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    @NotNull
    public static DeprecationFilter[] getFilters() {
        if (DEPRECATION_FILTERS == null) {
            AndroidDeprecationInspection.$$$reportNull$$$0(2);
        }
        return DEPRECATION_FILTERS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/AndroidDeprecationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/AndroidDeprecationInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class DeprecationFilter {
        public static final ExtensionPointName<DeprecationFilter> EP_NAME = new ExtensionPointName("com.intellij.deprecationFilter");

        public boolean isExcluded(@NotNull PsiElement deprecatedElement, @NotNull PsiElement referenceElement, @Nullable String symbolName) {
            if (deprecatedElement == null) {
                DeprecationFilter.$$$reportNull$$$0(0);
            }
            if (referenceElement == null) {
                DeprecationFilter.$$$reportNull$$$0(1);
            }
            return false;
        }

        @NotNull
        public String getDeprecationMessage(@NotNull PsiElement deprecatedElement, @NotNull PsiElement referenceElement, @Nullable String symbolName, @NotNull String defaultMessage) {
            if (deprecatedElement == null) {
                DeprecationFilter.$$$reportNull$$$0(2);
            }
            if (referenceElement == null) {
                DeprecationFilter.$$$reportNull$$$0(3);
            }
            if (defaultMessage == null) {
                DeprecationFilter.$$$reportNull$$$0(4);
            }
            String string = defaultMessage;
            if (string == null) {
                DeprecationFilter.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public LocalQuickFix[] getQuickFixes(@NotNull PsiElement deprecatedElement, @NotNull PsiElement referenceElement, @Nullable String symbolName) {
            if (deprecatedElement == null) {
                DeprecationFilter.$$$reportNull$$$0(6);
            }
            if (referenceElement == null) {
                DeprecationFilter.$$$reportNull$$$0(7);
            }
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                DeprecationFilter.$$$reportNull$$$0(8);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deprecatedElement";
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultMessage";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/inspections/AndroidDeprecationInspection$DeprecationFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/inspections/AndroidDeprecationInspection$DeprecationFilter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeprecationMessage";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuickFixes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isExcluded";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDeprecationMessage";
                    break;
                }
                case 5: 
                case 8: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getQuickFixes";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DeprecationElementVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myIgnoreInsideDeprecated;
        private final boolean myIgnoreAbstractDeprecatedOverrides;
        private final boolean myIgnoreImportStatements;
        private final boolean myIgnoreMethodsOfDeprecated;

        public DeprecationElementVisitor(ProblemsHolder holder, boolean ignoreInsideDeprecated, boolean ignoreAbstractDeprecatedOverrides, boolean ignoreImportStatements, boolean ignoreMethodsOfDeprecated) {
            this.myHolder = holder;
            this.myIgnoreInsideDeprecated = ignoreInsideDeprecated;
            this.myIgnoreAbstractDeprecatedOverrides = ignoreAbstractDeprecatedOverrides;
            this.myIgnoreImportStatements = ignoreImportStatements;
            this.myIgnoreMethodsOfDeprecated = ignoreMethodsOfDeprecated;
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference2) {
            JavaResolveResult result2 = reference2.advancedResolve(true);
            PsiElement resolved = result2.getElement();
            AndroidDeprecationInspection.checkDeprecated(resolved, reference2.getReferenceNameElement(), null, this.myIgnoreInsideDeprecated, this.myIgnoreImportStatements, this.myIgnoreMethodsOfDeprecated, this.myHolder);
        }

        public void visitImportStaticStatement(PsiImportStaticStatement statement) {
            PsiJavaCodeReferenceElement importReference = statement.getImportReference();
            if (importReference != null) {
                AndroidDeprecationInspection.checkDeprecated(importReference.resolve(), importReference.getReferenceNameElement(), null, this.myIgnoreInsideDeprecated, false, true, this.myHolder);
            }
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression2);
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            PsiType type = expression2.getType();
            PsiExpressionList list = expression2.getArgumentList();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type).resolveGenerics();
            PsiClass aClass = typeResult.getElement();
            if (aClass == null) {
                return;
            }
            if (aClass instanceof PsiAnonymousClass && (aClass = (typeResult = ((PsiClassType)(type = ((PsiAnonymousClass)aClass).getBaseClassType())).resolveGenerics()).getElement()) == null) {
                return;
            }
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)expression2.getProject()).getResolveHelper();
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length > 0 && list != null) {
                PsiMethod constructor;
                JavaResolveResult[] results = resolveHelper.multiResolveConstructor((PsiClassType)type, list, (PsiElement)list);
                MethodCandidateInfo result2 = null;
                if (results.length == 1) {
                    result2 = (MethodCandidateInfo)results[0];
                }
                PsiMethod psiMethod = constructor = result2 == null ? null : result2.getElement();
                if (constructor != null && expression2.getClassOrAnonymousClassReference() != null) {
                    if (expression2.getClassReference() == null && constructor.getParameterList().getParametersCount() == 0) {
                        return;
                    }
                    AndroidDeprecationInspection.checkDeprecated((PsiElement)constructor, (PsiElement)expression2.getClassOrAnonymousClassReference(), null, this.myIgnoreInsideDeprecated, this.myIgnoreImportStatements, true, this.myHolder);
                }
            }
        }

        public void visitMethod(PsiMethod method2) {
            MethodSignatureBackedByPsiMethod methodSignature = MethodSignatureBackedByPsiMethod.create((PsiMethod)method2, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            if (!method2.isConstructor()) {
                List superMethodSignatures = method2.findSuperMethodSignaturesIncludingStatic(true);
                AndroidDeprecationInspection.checkMethodOverridesDeprecated(methodSignature, superMethodSignatures, this.myIgnoreAbstractDeprecatedOverrides, this.myHolder);
            } else {
                this.checkImplicitCallToSuper(method2);
            }
        }

        private void checkImplicitCallToSuper(PsiMethod method2) {
            PsiClass containingClass = method2.getContainingClass();
            assert (containingClass != null);
            PsiClass superClass = containingClass.getSuperClass();
            if (AndroidDeprecationInspection.hasDefaultDeprecatedConstructor(superClass)) {
                PsiStatement[] statements;
                PsiExpressionList argumentList;
                if (superClass instanceof PsiAnonymousClass && (argumentList = ((PsiAnonymousClass)superClass).getArgumentList()) != null && argumentList.getExpressions().length > 0) {
                    return;
                }
                PsiCodeBlock body = method2.getBody();
                if (!(body == null || (statements = body.getStatements()).length != 0 && JavaHighlightUtil.isSuperOrThisCall((PsiStatement)statements[0], (boolean)true, (boolean)true))) {
                    this.registerDefaultConstructorProblem(superClass, (PsiElement)method2.getNameIdentifier(), false);
                }
            }
        }

        private void registerDefaultConstructorProblem(PsiClass superClass, PsiElement nameIdentifier, boolean asDeprecated) {
            this.myHolder.registerProblem(nameIdentifier, "Default constructor in " + superClass.getQualifiedName() + " is deprecated", asDeprecated ? ProblemHighlightType.LIKE_DEPRECATED : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }

        public void visitClass(PsiClass aClass) {
            PsiClass superClass;
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            PsiMethod[] currentConstructors = aClass.getConstructors();
            if (currentConstructors.length == 0 && AndroidDeprecationInspection.hasDefaultDeprecatedConstructor(superClass = aClass.getSuperClass())) {
                PsiExpressionList argumentList;
                boolean isAnonymous = aClass instanceof PsiAnonymousClass;
                if (isAnonymous && (argumentList = ((PsiAnonymousClass)aClass).getArgumentList()) != null && argumentList.getExpressions().length > 0) {
                    return;
                }
                this.registerDefaultConstructorProblem(superClass, (PsiElement)(isAnonymous ? ((PsiAnonymousClass)aClass).getBaseClassReference() : aClass.getNameIdentifier()), isAnonymous);
            }
        }
    }
}

