/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.importDependencies;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import org.jetbrains.android.importDependencies.ImportDependenciesTask;
import org.jetbrains.android.importDependencies.ModuleProvider;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AddModuleDependencyTask
extends ImportDependenciesTask {
    private final ModuleProvider myModuleProvider;
    private final ModuleProvider myDepModuleProvider;

    public AddModuleDependencyTask(@NotNull ModuleProvider moduleProvider, @NotNull ModuleProvider depModuleProvider) {
        if (moduleProvider == null) {
            AddModuleDependencyTask.$$$reportNull$$$0(0);
        }
        if (depModuleProvider == null) {
            AddModuleDependencyTask.$$$reportNull$$$0(1);
        }
        this.myModuleProvider = moduleProvider;
        this.myDepModuleProvider = depModuleProvider;
    }

    @Override
    @Nullable
    public Exception perform() {
        Module module2 = this.myModuleProvider.getModule();
        Module depModule = this.myDepModuleProvider.getModule();
        if (module2 == null || depModule == null) {
            return null;
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
        if (!rootManager.isDependsOn(depModule)) {
            ModuleRootModificationUtil.addDependency((Module)module2, (Module)depModule);
        }
        return null;
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = AndroidBundle.message("android.import.dependencies.add.module.dependency.task.title", this.myModuleProvider.getModuleName(), this.myDepModuleProvider.getModuleName());
        if (string == null) {
            AddModuleDependencyTask.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddModuleDependencyTask that = (AddModuleDependencyTask)o;
        if (!this.myDepModuleProvider.equals(that.myDepModuleProvider)) {
            return false;
        }
        return this.myModuleProvider.equals(that.myModuleProvider);
    }

    public int hashCode() {
        int result2 = this.myModuleProvider.hashCode();
        result2 = 31 * result2 + this.myDepModuleProvider.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depModuleProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/importDependencies/AddModuleDependencyTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/importDependencies/AddModuleDependencyTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

