/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.res.AndroidProjectRootListener;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.google.common.base.Splitter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetProperties;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ,2\u00020\u0001:\u0003,-.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u000bH\u0016JS\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\r2\u0018\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060#2\u001e\u0010$\u001a\u001a\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\u001a0%H\u0082\bJ\u0010\u0010'\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020)2\u0006\u0010*\u001a\u00020+H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\t\u00a8\u0006/"}, d2={"Lorg/jetbrains/android/facet/ResourceFolderManager;", "Lcom/intellij/openapi/util/ModificationTracker;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "folders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFolders", "()Ljava/util/List;", "generation", "", "mainAndTestFolders", "Lorg/jetbrains/android/facet/ResourceFolderManager$Folders;", "getMainAndTestFolders", "()Lorg/jetbrains/android/facet/ResourceFolderManager$Folders;", "getModule", "()Lcom/intellij/openapi/module/Module;", "primaryFolder", "getPrimaryFolder$annotations", "()V", "getPrimaryFolder", "()Lcom/intellij/openapi/vfs/VirtualFile;", "testFolders", "getTestFolders", "checkForChanges", "", "computeFolders", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "getModificationCount", "notifyIfChanged", "before", "after", "filesToCheck", "Lkotlin/Function1;", "callback", "Lkotlin/Function2;", "Lorg/jetbrains/android/facet/ResourceFolderManager$ResourceFolderListener;", "readFromFacetState", "toVirtualFiles", "", "manager", "Lcom/intellij/openapi/vfs/VirtualFileManager;", "Companion", "Folders", "ResourceFolderListener", "intellij.android.core"})
public final class ResourceFolderManager
implements ModificationTracker {
    private volatile long generation;
    @NotNull
    private final Module module;
    private static final Key<Folders> FOLDERS_KEY;
    private static final Folders emptyFolders;
    @JvmField
    @NotNull
    public static final Topic<ResourceFolderListener> TOPIC;
    @NotNull
    public static final Companion Companion;

    public long getModificationCount() {
        return this.generation;
    }

    @NotNull
    public final List<VirtualFile> getFolders() {
        return this.getMainAndTestFolders().getMain();
    }

    @NotNull
    public final List<VirtualFile> getTestFolders() {
        return this.getMainAndTestFolders().getTest();
    }

    private final Folders getMainAndTestFolders() {
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((Module)this.module);
        if (androidFacet == null) {
            return emptyFolders;
        }
        AndroidFacet facet2 = androidFacet;
        Folders folders = (Folders)facet2.getUserData(FOLDERS_KEY);
        if (folders == null) {
            Object object = facet2.putUserDataIfAbsent(FOLDERS_KEY, (Object)this.computeFolders(facet2));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"facet.putUserDataIfAbsen\u2026Y, computeFolders(facet))");
            folders = (Folders)object;
        }
        return folders;
    }

    @Deprecated(message="Instead of calling this, ask the user which resource folder should be used.")
    public static /* synthetic */ void getPrimaryFolder$annotations() {
    }

    @Nullable
    public final VirtualFile getPrimaryFolder() {
        return (VirtualFile)CollectionsKt.firstOrNull(this.getFolders());
    }

    /*
     * WARNING - void declaration
     */
    public final void checkForChanges() {
        Object resourceFolderListener;
        void receiver;
        List<VirtualFile> list;
        Object object;
        long l;
        if (this.module.isDisposed()) {
            return;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)this.module);
        if (androidFacet == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"AndroidFacet.getInstance(module) ?: return");
        AndroidFacet facet2 = androidFacet;
        Folders folders = (Folders)facet2.getUserData(FOLDERS_KEY);
        if (folders == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)folders, (String)"facet.getUserData(FOLDERS_KEY) ?: return");
        Folders before = folders;
        facet2.putUserData(FOLDERS_KEY, null);
        Folders after = this.getMainAndTestFolders();
        ResourceFolderManager this_$iv = this;
        boolean $i$f$notifyIfChanged = false;
        Folders receiver2 = before;
        boolean bl = false;
        List<VirtualFile> filesBefore$iv = receiver2.getMain();
        receiver2 = after;
        bl = false;
        List<VirtualFile> filesAfter$iv = receiver2.getMain();
        if (Intrinsics.areEqual(filesBefore$iv, filesAfter$iv) ^ true) {
            void folders2;
            ResourceFolderManager resourceFolderManager = this_$iv;
            l = resourceFolderManager.generation;
            resourceFolderManager.generation = l + 1L;
            Project project = this_$iv.getModule().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            Object object2 = project.getMessageBus().syncPublisher(TOPIC);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"module.project.messageBus.syncPublisher(TOPIC)");
            Folders folders3 = after;
            object = object2;
            list2 = false;
            List<VirtualFile> list2 = list = receiver.getMain();
            resourceFolderListener = (ResourceFolderListener)object;
            boolean bl2 = false;
            resourceFolderListener.mainResourceFoldersChanged(facet2, (List<? extends VirtualFile>)folders2);
        }
        this_$iv = this;
        $i$f$notifyIfChanged = false;
        receiver2 = before;
        bl = false;
        filesBefore$iv = receiver2.getTest();
        receiver2 = after;
        bl = false;
        filesAfter$iv = receiver2.getTest();
        if (Intrinsics.areEqual(filesBefore$iv, filesAfter$iv) ^ true) {
            void folders4;
            ResourceFolderManager resourceFolderManager = this_$iv;
            l = resourceFolderManager.generation;
            resourceFolderManager.generation = l + 1L;
            Project project = this_$iv.getModule().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            Object object3 = project.getMessageBus().syncPublisher(TOPIC);
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"module.project.messageBus.syncPublisher(TOPIC)");
            resourceFolderListener = after;
            object = object3;
            list3 = false;
            List<VirtualFile> list3 = list = receiver.getTest();
            resourceFolderListener = (ResourceFolderListener)object;
            boolean bl3 = false;
            resourceFolderListener.testResourceFoldersChanged(facet2, (List<? extends VirtualFile>)folders4);
        }
    }

    private final void notifyIfChanged(Folders before, Folders after, Function1<? super Folders, ? extends List<? extends VirtualFile>> filesToCheck, Function2<? super ResourceFolderListener, ? super List<? extends VirtualFile>, Unit> callback2) {
        List filesAfter;
        int $i$f$notifyIfChanged = 0;
        List filesBefore = (List)filesToCheck.invoke((Object)before);
        if (Intrinsics.areEqual((Object)filesBefore, (Object)(filesAfter = (List)filesToCheck.invoke((Object)after))) ^ true) {
            ResourceFolderManager resourceFolderManager = this;
            long l = resourceFolderManager.generation;
            resourceFolderManager.generation = l + 1L;
            Project project = this.getModule().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            Object object = project.getMessageBus().syncPublisher(TOPIC);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"module.project.messageBus.syncPublisher(TOPIC)");
            callback2.invoke(object, filesToCheck.invoke((Object)after));
        }
    }

    private final Folders computeFolders(AndroidFacet facet2) {
        return !AndroidModel.isRequired(facet2) ? new Folders(CollectionsKt.toList(SourceProviderManager.Companion.getInstance(facet2).getMainIdeaSourceProvider().getResDirectories()), CollectionsKt.emptyList()) : this.readFromFacetState(facet2);
    }

    private final Folders readFromFacetState(AndroidFacet facet2) {
        Folders folders;
        AndroidFacetConfiguration androidFacetConfiguration = (AndroidFacetConfiguration)facet2.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)androidFacetConfiguration, (String)"facet.configuration");
        AndroidFacetProperties androidFacetProperties = androidFacetConfiguration.getState();
        Intrinsics.checkNotNullExpressionValue((Object)androidFacetProperties, (String)"facet.configuration.state");
        AndroidFacetProperties state = androidFacetProperties;
        String mainFolders = state.RES_FOLDERS_RELATIVE_PATH;
        if (mainFolders != null) {
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"VirtualFileManager.getInstance()");
            VirtualFileManager manager = virtualFileManager;
            List<VirtualFile> list = this.toVirtualFiles(mainFolders, manager);
            String string = state.TEST_RES_FOLDERS_RELATIVE_PATH;
            List list2 = string != null ? this.toVirtualFiles(string, manager) : null;
            boolean bl = false;
            List list3 = list2;
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            folders = new Folders(list, list3);
        } else {
            VirtualFile virtualFile = AndroidRootUtil.getFileByRelativeModulePath(facet2.getModule(), "/src/main/res", true);
            if (virtualFile == null) {
                virtualFile = AndroidRootUtil.getFileByRelativeModulePath(facet2.getModule(), "/res", true);
            }
            if (virtualFile == null) {
                return emptyFolders;
            }
            folders = new Folders(CollectionsKt.listOf((Object)virtualFile), CollectionsKt.emptyList());
        }
        return folders;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> toVirtualFiles(String $this$toVirtualFiles, VirtualFileManager manager) {
        void $this$mapNotNullTo$iv$iv;
        Iterable iterable = Splitter.on((String)";").omitEmptyStrings().trimResults().split((CharSequence)$this$toVirtualFiles);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"Splitter.on(AndroidFacet\u2026ults()\n      .split(this)");
        Iterable $this$mapNotNull$iv = iterable;
        boolean $i$f$mapNotNull = false;
        Iterable iterable2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile virtualFile;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String p1 = (String)element$iv$iv;
            boolean bl2 = false;
            if (manager.findFileByUrl(p1) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            VirtualFile it$iv$iv = virtualFile;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    public ResourceFolderManager(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        this.module = module2;
        AndroidProjectRootListener.ensureSubscribed(this.module.getProject());
    }

    static {
        Companion = new Companion(null);
        String string = Reflection.getOrCreateKotlinClass(ResourceFolderManager.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        Key key = Key.create((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<Folders>(Reso\u2026r::class.qualifiedName!!)");
        FOLDERS_KEY = key;
        emptyFolders = new Folders(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        TOPIC = new Topic(ResourceFolderListener.class, Topic.BroadcastDirection.NONE);
    }

    @JvmStatic
    @NotNull
    public static final ResourceFolderManager getInstance(@NotNull AndroidFacet facet2) {
        return Companion.getInstance(facet2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&J\u001e\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&\u00a8\u0006\n"}, d2={"Lorg/jetbrains/android/facet/ResourceFolderManager$ResourceFolderListener;", "", "mainResourceFoldersChanged", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "folders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "testResourceFoldersChanged", "intellij.android.core"})
    public static interface ResourceFolderListener {
        public void mainResourceFoldersChanged(@NotNull AndroidFacet var1, @NotNull List<? extends VirtualFile> var2);

        public void testResourceFoldersChanged(@NotNull AndroidFacet var1, @NotNull List<? extends VirtualFile> var2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/android/facet/ResourceFolderManager$Folders;", "", "main", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "test", "(Ljava/util/List;Ljava/util/List;)V", "getMain", "()Ljava/util/List;", "getTest", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.android.core"})
    private static final class Folders {
        @NotNull
        private final List<VirtualFile> main;
        @NotNull
        private final List<VirtualFile> test;

        @NotNull
        public final List<VirtualFile> getMain() {
            return this.main;
        }

        @NotNull
        public final List<VirtualFile> getTest() {
            return this.test;
        }

        public Folders(@NotNull List<? extends VirtualFile> main, @NotNull List<? extends VirtualFile> test) {
            Intrinsics.checkNotNullParameter(main, (String)"main");
            Intrinsics.checkNotNullParameter(test, (String)"test");
            this.main = main;
            this.test = test;
        }

        @NotNull
        public final List<VirtualFile> component1() {
            return this.main;
        }

        @NotNull
        public final List<VirtualFile> component2() {
            return this.test;
        }

        @NotNull
        public final Folders copy(@NotNull List<? extends VirtualFile> main, @NotNull List<? extends VirtualFile> test) {
            Intrinsics.checkNotNullParameter(main, (String)"main");
            Intrinsics.checkNotNullParameter(test, (String)"test");
            return new Folders(main, test);
        }

        public static /* synthetic */ Folders copy$default(Folders folders, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = folders.main;
            }
            if ((n & 2) != 0) {
                list2 = folders.test;
            }
            return folders.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "Folders(main=" + this.main + ", test=" + this.test + ")";
        }

        public int hashCode() {
            List<VirtualFile> list = this.main;
            List<VirtualFile> list2 = this.test;
            return (list != null ? ((Object)list).hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Folders)) break block3;
                    Folders folders = (Folders)object;
                    if (!Intrinsics.areEqual(this.main, folders.main) || !Intrinsics.areEqual(this.test, folders.test)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n0\t8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/android/facet/ResourceFolderManager$Companion;", "", "()V", "FOLDERS_KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/android/facet/ResourceFolderManager$Folders;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lorg/jetbrains/android/facet/ResourceFolderManager$ResourceFolderListener;", "emptyFolders", "getInstance", "Lorg/jetbrains/android/facet/ResourceFolderManager;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "intellij.android.core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ResourceFolderManager getInstance(@NotNull AndroidFacet facet2) {
            Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
            Object object = facet2.getModule().getService(ResourceFolderManager.class);
            Intrinsics.checkNotNull((Object)object);
            return (ResourceFolderManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

