/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.projectsystem.AndroidProjectRootUtil;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.util.PropertiesFiles;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.OrderedSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class AndroidRootUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.facet.AndroidRootUtil");
    @NonNls
    public static final String DEFAULT_PROPERTIES_FILE_NAME = "default.properties";

    private AndroidRootUtil() {
    }

    @Nullable
    public static VirtualFile getPrimaryManifestFile(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(0);
        }
        if (facet2.isDisposed()) {
            return null;
        }
        return SourceProviderManager.getInstance(facet2).getMainManifestFile();
    }

    @Nullable
    public static VirtualFile getCustomManifestFileForCompiler(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(1);
        }
        return AndroidRootUtil.getFileByRelativeModulePath(facet2.getModule(), facet2.getProperties().CUSTOM_COMPILER_MANIFEST, false);
    }

    @Nullable
    public static VirtualFile getManifestFileForCompiler(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(2);
        }
        return facet2.getProperties().USE_CUSTOM_COMPILER_MANIFEST ? AndroidRootUtil.getCustomManifestFileForCompiler(facet2) : AndroidRootUtil.getPrimaryManifestFile(facet2);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getResourceDir(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(3);
        }
        return ResourceFolderManager.getInstance(facet2).getPrimaryFolder();
    }

    @Nullable
    private static String suggestResourceDirPath(@NotNull AndroidFacet facet2) {
        Module module2;
        VirtualFile[] contentRoots;
        if (facet2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(4);
        }
        if ((contentRoots = ModuleRootManager.getInstance((Module)(module2 = facet2.getModule())).getContentRoots()).length == 0) {
            return null;
        }
        VirtualFile root2 = contentRoots[0];
        if (contentRoots.length > 1) {
            String moduleFileParentDirPath = FileUtil.toSystemIndependentName((String)new File(module2.getModuleFilePath()).getParent());
            VirtualFile moduleFileParentDir = LocalFileSystem.getInstance().findFileByPath(moduleFileParentDirPath);
            if (moduleFileParentDir != null) {
                for (VirtualFile contentRoot : contentRoots) {
                    if (!Objects.equals(contentRoot, moduleFileParentDir)) continue;
                    root2 = contentRoot;
                }
            }
        }
        return root2.getPath() + facet2.getProperties().RES_FOLDER_RELATIVE_PATH;
    }

    @Deprecated
    @Nullable
    public static String getResourceDirPath(@NotNull AndroidFacet facet2) {
        VirtualFile resourceDir;
        if (facet2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(5);
        }
        return (resourceDir = AndroidRootUtil.getResourceDir(facet2)) != null ? resourceDir.getPath() : AndroidRootUtil.suggestResourceDirPath(facet2);
    }

    @Nullable
    public static VirtualFile getFileByRelativeModulePath(Module module2, String relativePath, boolean lookInContentRoot) {
        return AndroidProjectRootUtil.getFileByRelativeModulePath(module2, relativePath, lookInContentRoot);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getAssetsDir(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(6);
        }
        return AndroidProjectRootUtil.getAssetsDir(facet2);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getLibsDir(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(7);
        }
        return AndroidRootUtil.getFileByRelativeModulePath(facet2.getModule(), facet2.getProperties().LIBS_FOLDER_RELATIVE_PATH, false);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getAidlGenDir(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(8);
        }
        return AndroidProjectRootUtil.getAidlGenDir(facet2);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getAaptGenDir(@NotNull AndroidFacet facet2) {
        String genPath;
        if (facet2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(9);
        }
        return (genPath = AndroidRootUtil.getAptGenSourceRootPath(facet2)) != null ? LocalFileSystem.getInstance().findFileByPath(genPath) : null;
    }

    @Deprecated
    @Nullable
    public static VirtualFile getRenderscriptGenDir(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(10);
        }
        return AndroidProjectRootUtil.getRenderscriptGenDir(facet2);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getBuildconfigGenDir(@NotNull AndroidFacet facet2) {
        String path2;
        if (facet2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(11);
        }
        return (path2 = AndroidRootUtil.getBuildconfigGenSourceRootPath(facet2)) != null ? LocalFileSystem.getInstance().findFileByPath(path2) : null;
    }

    private static void collectClassFilesAndJars(@NotNull VirtualFile root2, @NotNull Set<VirtualFile> result2, @NotNull Set<VirtualFile> visited) {
        if (root2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(12);
        }
        if (result2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(13);
        }
        if (visited == null) {
            AndroidRootUtil.$$$reportNull$$$0(14);
        }
        if (!visited.add(root2)) {
            return;
        }
        for (VirtualFile child : root2.getChildren()) {
            if (!child.exists()) continue;
            if (child.isDirectory()) {
                AndroidRootUtil.collectClassFilesAndJars(child, result2, visited);
                continue;
            }
            if (!"jar".equals(child.getExtension()) && !"class".equals(child.getExtension())) continue;
            if (child.getFileSystem() instanceof JarFileSystem) {
                VirtualFile localFile = JarFileSystem.getInstance().getVirtualFileForJar(child);
                if (localFile == null) continue;
                result2.add(localFile);
                continue;
            }
            result2.add(child);
        }
    }

    private static void fillExternalLibrariesAndModules(@NotNull Module module2, @NotNull Set<VirtualFile> outputDirs, @NotNull Set<Module> visited, @Nullable Set<VirtualFile> libraries, boolean exportedLibrariesOnly, boolean recursive) {
        if (module2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(15);
        }
        if (outputDirs == null) {
            AndroidRootUtil.$$$reportNull$$$0(16);
        }
        if (visited == null) {
            AndroidRootUtil.$$$reportNull$$$0(17);
        }
        if (!visited.add(module2)) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            ModuleRootManager manager = ModuleRootManager.getInstance((Module)module2);
            for (OrderEntry entry : manager.getOrderEntries()) {
                Module depModule;
                if (!(entry instanceof ExportableOrderEntry) || ((ExportableOrderEntry)entry).getScope() != DependencyScope.COMPILE) continue;
                if (libraries != null && entry instanceof LibraryOrderEntry) {
                    LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
                    Library library = libraryOrderEntry.getLibrary();
                    if (library == null || exportedLibrariesOnly && !libraryOrderEntry.isExported()) continue;
                    for (VirtualFile file2 : library.getFiles(OrderRootType.CLASSES)) {
                        if (!file2.exists()) continue;
                        if (file2.getFileType() instanceof ArchiveFileType) {
                            if (file2.getFileSystem() instanceof JarFileSystem) {
                                VirtualFile localFile = JarFileSystem.getInstance().getVirtualFileForJar(file2);
                                if (localFile == null) continue;
                                libraries.add(localFile);
                                continue;
                            }
                            libraries.add(file2);
                            continue;
                        }
                        if (!file2.isDirectory() || file2.getFileSystem() instanceof JarFileSystem) continue;
                        AndroidRootUtil.collectClassFilesAndJars(file2, libraries, new HashSet<VirtualFile>());
                    }
                    continue;
                }
                if (!(entry instanceof ModuleOrderEntry) || (depModule = ((ModuleOrderEntry)entry).getModule()) == null) continue;
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)depModule);
                boolean libraryProject = facet2 != null && ((AndroidFacetConfiguration)facet2.getConfiguration()).isLibraryProject();
                CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)depModule);
                if (extension != null) {
                    VirtualFile classDir = extension.getCompilerOutputPath();
                    if (libraryProject) {
                        VirtualFile packedClassesJar;
                        VirtualFile tmpArtifactsDir = AndroidRootUtil.getOutputDirectoryForDex(depModule);
                        if (tmpArtifactsDir != null && (packedClassesJar = tmpArtifactsDir.findChild("classes.jar")) != null) {
                            outputDirs.add(packedClassesJar);
                        }
                    } else if (facet2 == null && !outputDirs.contains(classDir) && classDir != null && classDir.exists()) {
                        outputDirs.add(classDir);
                    }
                }
                if (!recursive) continue;
                AndroidRootUtil.fillExternalLibrariesAndModules(depModule, outputDirs, visited, libraries, !libraryProject || exportedLibrariesOnly, true);
            }
        });
    }

    private static VirtualFile getOutputDirectoryForDex(@NotNull Module module2) {
        if (module2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(18);
        }
        return CompilerModuleExtension.getInstance((Module)module2).getCompilerOutputPath();
    }

    @NotNull
    public static List<VirtualFile> getExternalLibraries(Module module2) {
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        OrderedSet libs = new OrderedSet();
        AndroidRootUtil.fillExternalLibrariesAndModules(module2, files2, new HashSet<Module>(), (Set<VirtualFile>)libs, false, true);
        AndroidRootUtil.addAnnotationsJar(module2, (OrderedSet<VirtualFile>)libs);
        OrderedSet orderedSet = libs;
        if (orderedSet == null) {
            AndroidRootUtil.$$$reportNull$$$0(19);
        }
        return orderedSet;
    }

    private static void addAnnotationsJar(@NotNull Module module2, @NotNull OrderedSet<VirtualFile> libs) {
        Sdk sdk;
        if (module2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(20);
        }
        if (libs == null) {
            AndroidRootUtil.$$$reportNull$$$0(21);
        }
        if ((sdk = ModuleRootManager.getInstance((Module)module2).getSdk()) == null || !AndroidSdks.getInstance().isAndroidSdk(sdk)) {
            return;
        }
        String sdkHomePath = sdk.getHomePath();
        if (sdkHomePath == null) {
            return;
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(module2);
        if (platform != null && platform.needToAddAnnotationsJarToClasspath()) {
            String annotationsJarPath = FileUtil.toSystemIndependentName((String)sdkHomePath) + "/tools/support/annotations.jar";
            VirtualFile annotationsJar = LocalFileSystem.getInstance().findFileByPath(annotationsJarPath);
            if (annotationsJar != null) {
                libs.add((Object)annotationsJar);
            }
        }
    }

    @Deprecated
    @NotNull
    public static Set<VirtualFile> getDependentModules(@NotNull Module module2, @NotNull VirtualFile moduleOutputDir) {
        if (module2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(22);
        }
        if (moduleOutputDir == null) {
            AndroidRootUtil.$$$reportNull$$$0(23);
        }
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        AndroidRootUtil.fillExternalLibrariesAndModules(module2, files2, new HashSet<Module>(), null, false, true);
        files2.remove(moduleOutputDir);
        HashSet<VirtualFile> hashSet = files2;
        if (hashSet == null) {
            AndroidRootUtil.$$$reportNull$$$0(24);
        }
        return hashSet;
    }

    @NotNull
    public static VirtualFile[] getResourceOverlayDirs(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(25);
        }
        List<String> overlayFolders = facet2.getProperties().RES_OVERLAY_FOLDERS;
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (String overlayFolder : overlayFolders) {
            VirtualFile overlayDir = AndroidRootUtil.getFileByRelativeModulePath(facet2.getModule(), overlayFolder, true);
            if (overlayDir == null) continue;
            result2.add(overlayDir);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            AndroidRootUtil.$$$reportNull$$$0(26);
        }
        return virtualFileArray;
    }

    @Nullable
    public static @SystemIndependent String getModuleDirPath(@NotNull Module module2) {
        if (module2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(27);
        }
        return AndroidProjectRootUtil.getModuleDirPath(module2);
    }

    @Nullable
    public static File findModuleRootFolderPath(@NotNull Module module2) {
        String path2;
        if (module2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(28);
        }
        if ((path2 = AndroidRootUtil.getModuleDirPath(module2)) == null) {
            return null;
        }
        return new File(PathUtil.toSystemDependentName((String)path2));
    }

    @Deprecated
    @Nullable
    public static String getRenderscriptGenSourceRootPath(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(29);
        }
        return AndroidProjectRootUtil.getRenderscriptGenSourceRootPath(facet2);
    }

    @Deprecated
    @Nullable
    public static String getBuildconfigGenSourceRootPath(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(30);
        }
        return AndroidRootUtil.getAptGenSourceRootPath(facet2);
    }

    @Nullable
    public static VirtualFile getMainContentRoot(@NotNull AndroidFacet facet2) {
        Module module2;
        VirtualFile[] contentRoots;
        if (facet2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(31);
        }
        if ((contentRoots = ModuleRootManager.getInstance((Module)(module2 = facet2.getModule())).getContentRoots()).length == 0) {
            return null;
        }
        if (contentRoots.length == 1) {
            return contentRoots[0];
        }
        VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(facet2);
        if (manifestFile != null) {
            for (VirtualFile root2 : contentRoots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)root2, (VirtualFile)manifestFile, (boolean)true)) continue;
                return root2;
            }
        }
        return contentRoots[0];
    }

    @Deprecated
    @Nullable
    public static Pair<PropertiesFile, VirtualFile> findPropertyFile(@NotNull Module module2, @NotNull String propertyFileName) {
        if (module2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(32);
        }
        if (propertyFileName == null) {
            AndroidRootUtil.$$$reportNull$$$0(33);
        }
        for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
            PsiFile psiFile2;
            VirtualFile vFile = contentRoot.findChild(propertyFileName);
            if (vFile == null || !((psiFile2 = AndroidPsiUtils.getPsiFileSafely((Project)module2.getProject(), (VirtualFile)vFile)) instanceof PropertiesFile)) continue;
            return Pair.create((Object)((PropertiesFile)psiFile2), (Object)vFile);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static Pair<Properties, VirtualFile> readPropertyFile(@NotNull Module module2, @NotNull String propertyFileName) {
        if (module2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(34);
        }
        if (propertyFileName == null) {
            AndroidRootUtil.$$$reportNull$$$0(35);
        }
        for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
            Pair<Properties, VirtualFile> result2 = AndroidRootUtil.readPropertyFile(contentRoot, propertyFileName);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static Pair<Properties, VirtualFile> readProjectPropertyFile(@NotNull Module module2) {
        Pair<Properties, VirtualFile> pair;
        if (module2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(36);
        }
        return (pair = AndroidRootUtil.readPropertyFile(module2, "project.properties")) != null ? pair : AndroidRootUtil.readPropertyFile(module2, DEFAULT_PROPERTIES_FILE_NAME);
    }

    @Deprecated
    @Nullable
    private static Pair<Properties, VirtualFile> readPropertyFile(@NotNull VirtualFile contentRoot, @NotNull String propertyFileName) {
        VirtualFile vFile;
        if (contentRoot == null) {
            AndroidRootUtil.$$$reportNull$$$0(37);
        }
        if (propertyFileName == null) {
            AndroidRootUtil.$$$reportNull$$$0(38);
        }
        if ((vFile = contentRoot.findChild(propertyFileName)) != null) {
            try {
                File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)vFile);
                Properties properties2 = PropertiesFiles.getProperties(file2);
                return Pair.create((Object)properties2, (Object)vFile);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static Pair<Properties, VirtualFile> readProjectPropertyFile(@NotNull VirtualFile contentRoot) {
        Pair<Properties, VirtualFile> pair;
        if (contentRoot == null) {
            AndroidRootUtil.$$$reportNull$$$0(39);
        }
        return (pair = AndroidRootUtil.readPropertyFile(contentRoot, "project.properties")) != null ? pair : AndroidRootUtil.readPropertyFile(contentRoot, DEFAULT_PROPERTIES_FILE_NAME);
    }

    @Nullable
    public static Pair<String, VirtualFile> getPropertyValue(@NotNull Module module2, @NotNull String propertyFileName, @NotNull String propertyKey) {
        String value2;
        Pair<Properties, VirtualFile> pair;
        if (module2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(40);
        }
        if (propertyFileName == null) {
            AndroidRootUtil.$$$reportNull$$$0(41);
        }
        if (propertyKey == null) {
            AndroidRootUtil.$$$reportNull$$$0(42);
        }
        if ((pair = AndroidRootUtil.readPropertyFile(module2, propertyFileName)) != null && (value2 = ((Properties)pair.first).getProperty(propertyKey)) != null) {
            return Pair.create((Object)value2, (Object)((VirtualFile)pair.second));
        }
        return null;
    }

    @Nullable
    public static Pair<String, VirtualFile> getProjectPropertyValue(@NotNull Module module2, @NotNull String propertyName) {
        Pair<String, VirtualFile> result2;
        if (module2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(43);
        }
        if (propertyName == null) {
            AndroidRootUtil.$$$reportNull$$$0(44);
        }
        return (result2 = AndroidRootUtil.getPropertyValue(module2, "project.properties", propertyName)) != null ? result2 : AndroidRootUtil.getPropertyValue(module2, DEFAULT_PROPERTIES_FILE_NAME, propertyName);
    }

    @Deprecated
    @Nullable
    public static @SystemIndependent String getAptGenSourceRootPath(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(45);
        }
        return AndroidProjectRootUtil.getAptGenSourceRootPath(facet2);
    }

    @Deprecated
    @Nullable
    public static @SystemIndependent String getAidlGenSourceRootPath(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(46);
        }
        return AndroidProjectRootUtil.getAidlGenSourceRootPath(facet2);
    }

    @Nullable
    public static @SystemIndependent String getPathRelativeToModuleDir(@NotNull Module module2, @NotNull String path2) {
        String moduleDirPath;
        if (module2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(47);
        }
        if (path2 == null) {
            AndroidRootUtil.$$$reportNull$$$0(48);
        }
        if ((moduleDirPath = AndroidRootUtil.getModuleDirPath(module2)) == null) {
            return null;
        }
        if (moduleDirPath.equals(path2)) {
            return "";
        }
        return FileUtil.getRelativePath((String)moduleDirPath, (String)path2, (char)'/');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 24: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 28: 
            case 32: 
            case 34: 
            case 36: 
            case 40: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDirs";
                break;
            }
            case 19: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/facet/AndroidRootUtil";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libs";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOutputDir";
                break;
            }
            case 33: 
            case 35: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyFileName";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKey";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/facet/AndroidRootUtil";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalLibraries";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentModules";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceOverlayDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPrimaryManifestFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCustomManifestFileForCompiler";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getManifestFileForCompiler";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getResourceDir";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "suggestResourceDirPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResourceDirPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAssetsDir";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLibsDir";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAidlGenDir";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAaptGenDir";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRenderscriptGenDir";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBuildconfigGenDir";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectClassFilesAndJars";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fillExternalLibrariesAndModules";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getOutputDirectoryForDex";
                break;
            }
            case 19: 
            case 24: 
            case 26: {
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotationsJar";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDependentModules";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getResourceOverlayDirs";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDirPath";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findModuleRootFolderPath";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRenderscriptGenSourceRootPath";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getBuildconfigGenSourceRootPath";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getMainContentRoot";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyFile";
                break;
            }
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "readPropertyFile";
                break;
            }
            case 36: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "readProjectPropertyFile";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValue";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getProjectPropertyValue";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getAptGenSourceRootPath";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getAidlGenSourceRootPath";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeToModuleDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

