/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.download;

import com.android.tools.idea.IdeInfo;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.SwingUtilities;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidComponentDownloader {
    private static final Logger LOG = Logger.getInstance(AndroidComponentDownloader.class);
    private static final String VERSION = "27.2.0.0";
    public static final String BINTRAY_ANDROID_TOOLS_BASE = "https://cache-redirector.jetbrains.com/intellij-dependencies/org/jetbrains/intellij/deps/android/tools/base/";
    public static final String ZIP = "zip";
    public static final String ANDROID_GROUP_DISPLAY_ID = "Android";
    private ReentrantReadWriteLock downloadLock = new ReentrantReadWriteLock();

    public boolean makeSureComponentIsInPlace() {
        if (ApplicationManager.getApplication() == null) {
            return false;
        }
        if (IdeInfo.getInstance().isAndroidStudio()) {
            return true;
        }
        this.waitOtherThreadToCompleteIfNotInEDT();
        if (this.isAlreadyDownloaded()) {
            return true;
        }
        DownloadableFileService service = DownloadableFileService.getInstance();
        String fileName = this.getArtifactName() + "-" + this.getVersion() + "." + this.getExtension();
        DownloadableFileDescription description2 = service.createFileDescription(this.getBaseUrl() + this.getArtifactName() + "/" + this.getVersion() + "/" + fileName, fileName);
        FileDownloader downloader = service.createDownloader(Collections.singletonList(description2), "Download Android Plugin component: " + this.getArtifactName());
        if (SwingUtilities.isEventDispatchThread()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.downloadWithLock(downloader));
            return false;
        }
        return this.downloadWithLock(downloader);
    }

    private void waitOtherThreadToCompleteIfNotInEDT() {
        if (!SwingUtilities.isEventDispatchThread()) {
            this.downloadLock.readLock().lock();
            this.downloadLock.readLock().unlock();
        }
    }

    private boolean isAlreadyDownloaded() {
        File pluginDir = this.getPluginDir();
        if (this.downloadLock.readLock().tryLock()) {
            try {
                boolean bl = pluginDir.exists();
                return bl;
            }
            finally {
                this.downloadLock.readLock().unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadWithLock(FileDownloader downloader) {
        this.downloadLock.writeLock().lock();
        try {
            if (this.isAlreadyDownloaded()) {
                boolean bl = true;
                return bl;
            }
            File pluginDir = this.getPluginDir();
            boolean bl = this.downloadWithProgress((Computable<Boolean>)((Computable)() -> this.doDownload(pluginDir, downloader)));
            return bl;
        }
        finally {
            this.downloadLock.writeLock().unlock();
        }
    }

    private boolean downloadWithProgress(Computable<Boolean> downloadTask) {
        if (ProgressManager.getInstance().hasProgressIndicator()) {
            return (Boolean)downloadTask.compute();
        }
        BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(null, AndroidBundle.message("downloading.android.plugin.components", new Object[0]), PerformInBackgroundOption.ALWAYS_BACKGROUND, null, null, true);
        return (Boolean)ProgressManager.getInstance().runProcess(downloadTask, (ProgressIndicator)indicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doDownload(File pluginDir, FileDownloader downloader) {
        Path tempDir = null;
        try {
            tempDir = Files.createTempDirectory("android-component-download", new FileAttribute[0]);
            List list = downloader.download(tempDir.toFile());
            File file2 = (File)((Pair)list.get((int)0)).first;
            ZipUtil.extract((File)file2, (File)this.getTargetDir(pluginDir), null);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            String message2 = "Can't download Android Plugin component: " + this.getArtifactName();
            LOG.warn(message2, (Throwable)e);
            Notifications.Bus.notify((Notification)new Notification(ANDROID_GROUP_DISPLAY_ID, message2, "Check logs for details", NotificationType.ERROR));
            boolean bl = false;
            return bl;
        }
        finally {
            if (tempDir != null) {
                FileUtil.delete((File)tempDir.toFile());
            }
        }
    }

    protected File getTargetDir(File dir) {
        return dir;
    }

    @NotNull
    protected String getExtension() {
        return ZIP;
    }

    @NotNull
    protected String getVersion() {
        return VERSION;
    }

    @NotNull
    protected String getBaseUrl() {
        return BINTRAY_ANDROID_TOOLS_BASE;
    }

    @NotNull
    protected abstract String getArtifactName();

    public File getPluginDir() {
        return new File(PathManager.getSystemPath(), "android/" + this.getArtifactName() + "/" + this.getVersion());
    }

    public File getHostDir(String hostReleaseDir) {
        return new File(this.getPluginDir(), hostReleaseDir);
    }
}

