/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.wrappers;

import com.android.tools.idea.res.psi.ResourceNavigationItem;
import com.google.common.base.Stopwatch;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyValueResourceElementWrapper
extends RenameableFakePsiElement
implements PsiTarget,
Comparable<LazyValueResourceElementWrapper> {
    private static final Logger LOG = Logger.getInstance(LazyValueResourceElementWrapper.class);
    private final ValueResourceInfo myResourceInfo;
    private final PsiElement myParent;

    public LazyValueResourceElementWrapper(@NotNull ValueResourceInfo resourceInfo, @NotNull PsiElement parent) {
        if (resourceInfo == null) {
            LazyValueResourceElementWrapper.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            LazyValueResourceElementWrapper.$$$reportNull$$$0(1);
        }
        super(parent);
        this.myParent = parent;
        this.myResourceInfo = resourceInfo;
    }

    @NotNull
    public String getName() {
        String string = this.myResourceInfo.getName();
        if (string == null) {
            LazyValueResourceElementWrapper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        XmlAttributeValue element2;
        if (name == null) {
            LazyValueResourceElementWrapper.$$$reportNull$$$0(3);
        }
        if ((element2 = this.computeElement()) == null) {
            throw new IncorrectOperationException("Cannot find resource '" + this.myResourceInfo.getName() + "' in file " + this.myResourceInfo.getContainingFile().getPath());
        }
        return new ValueResourceElementWrapper(element2).setName(name);
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new ResourceNavigationItem.ResourceItemPresentation(this.myResourceInfo.getResource(), this.myResourceInfo.getContainingFile());
    }

    @Nullable
    public XmlAttributeValue computeElement() {
        if (LOG.isDebugEnabled()) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            XmlAttributeValue value2 = this.myResourceInfo.computeXmlElement();
            LOG.debug("Computing XML element for lazy resource: " + this.myResourceInfo + ", time: " + stopwatch);
            return value2;
        }
        return this.myResourceInfo.computeXmlElement();
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myParent.getLanguage();
        if (language == null) {
            LazyValueResourceElementWrapper.$$$reportNull$$$0(4);
        }
        return language;
    }

    public PsiFile getContainingFile() {
        return PsiManager.getInstance((Project)this.myParent.getProject()).findFile(this.myResourceInfo.getContainingFile());
    }

    @Nullable
    public TextRange getTextRange() {
        return this.getNavigationElement().getTextRange();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        XmlAttributeValue element2 = this.myResourceInfo.computeXmlElement();
        Object object = element2 != null ? element2 : this.myParent;
        if (object == null) {
            LazyValueResourceElementWrapper.$$$reportNull$$$0(5);
        }
        return object;
    }

    @NotNull
    public ValueResourceInfo getResourceInfo() {
        ValueResourceInfo valueResourceInfo = this.myResourceInfo;
        if (valueResourceInfo == null) {
            LazyValueResourceElementWrapper.$$$reportNull$$$0(6);
        }
        return valueResourceInfo;
    }

    @NotNull
    public String getTypeName() {
        return "Android Value Resource";
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Nullable
    public static PsiElement computeLazyElement(PsiElement element2) {
        if (element2 instanceof LazyValueResourceElementWrapper) {
            element2 = ((LazyValueResourceElementWrapper)element2).computeElement();
        }
        return element2;
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another instanceof LazyValueResourceElementWrapper) {
            return this.myResourceInfo.equals(((LazyValueResourceElementWrapper)another).getResourceInfo());
        }
        return super.isEquivalentTo(another);
    }

    @Override
    public int compareTo(@NotNull LazyValueResourceElementWrapper other) {
        if (other == null) {
            LazyValueResourceElementWrapper.$$$reportNull$$$0(7);
        }
        return this.myResourceInfo.compareTo(other.myResourceInfo);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/wrappers/LazyValueResourceElementWrapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/wrappers/LazyValueResourceElementWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

