/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.structure.resources;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.dom.resources.StyleItem;
import org.jetbrains.android.dom.structure.StructureUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceStructureViewBuilder
extends TreeBasedStructureViewBuilder {
    private final DomFileElement<Resources> myResources;

    public ResourceStructureViewBuilder(@NotNull DomFileElement<Resources> resources) {
        if (resources == null) {
            ResourceStructureViewBuilder.$$$reportNull$$$0(0);
        }
        this.myResources = resources;
    }

    @NotNull
    public StructureViewModel createStructureViewModel(@Nullable Editor editor2) {
        return new StructureViewModelBase((PsiFile)this.myResources.getFile(), (StructureViewTreeElement)new ResourcesRoot(this.myResources));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder", "<init>"));
    }

    private static class Resource
    extends PsiTreeElementBase<PsiElement> {
        private final String myName;
        private final ResourceType myResourceType;
        private final DomElement myElement;

        protected Resource(@NotNull DomElement element2, @NotNull String name, @NotNull ResourceType resourceType) {
            if (element2 == null) {
                Resource.$$$reportNull$$$0(0);
            }
            if (name == null) {
                Resource.$$$reportNull$$$0(1);
            }
            if (resourceType == null) {
                Resource.$$$reportNull$$$0(2);
            }
            super((PsiElement)element2.getXmlTag());
            this.myElement = element2;
            this.myName = name;
            this.myResourceType = resourceType;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            final ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>();
            DomElementVisitor visitor2 = new DomElementVisitor(){

                public void visitStyleItem(StyleItem element2) {
                    ResourceReference resourceReference = (ResourceReference)element2.getName().getValue();
                    if (resourceReference != null) {
                        result2.add(new Resource(element2, resourceReference.getName(), ResourceType.STYLE_ITEM));
                    }
                }

                public void visitAttr(Attr element2) {
                    ResourceReference resourceReference = (ResourceReference)element2.getName().getValue();
                    XmlElement xmlElement = element2.getXmlElement();
                    if (resourceReference != null && xmlElement != null) {
                        result2.add(new Resource(element2, resourceReference.getName(), resourceReference.getResourceType()));
                    }
                }

                public void visitDomElement(DomElement element2) {
                }
            };
            StructureUtils.acceptChildrenInOrder(this.myElement, visitor2);
            ArrayList<StructureViewTreeElement> arrayList = result2;
            if (arrayList == null) {
                Resource.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        @Nullable
        public String getPresentableText() {
            return this.myResourceType.getDisplayName() + " - " + this.myName;
        }

        public String toString() {
            return this.getPresentableText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder$Resource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder$Resource";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ResourcesRoot
    extends PsiTreeElementBase<PsiElement> {
        private final DomFileElement<Resources> myResources;

        ResourcesRoot(@NotNull DomFileElement<Resources> resources) {
            if (resources == null) {
                ResourcesRoot.$$$reportNull$$$0(0);
            }
            super((PsiElement)resources.getXmlElement());
            this.myResources = resources;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            if (!this.myResources.isValid()) {
                Set<StructureViewTreeElement> set = Collections.emptySet();
                if (set == null) {
                    ResourcesRoot.$$$reportNull$$$0(1);
                }
                return set;
            }
            final ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>();
            StructureUtils.acceptChildrenInOrder(this.myResources.getRootElement(), new DomElementVisitor(){

                public void visitDomElement(DomElement element2) {
                }

                public void visitResourceElement(ResourceElement element2) {
                    ResourceType type = IdeResourcesUtil.getResourceTypeForResourceTag(element2.getXmlTag());
                    String name = (String)element2.getName().getValue();
                    XmlElement xmlElement = element2.getXmlElement();
                    if (name != null && type != null && xmlElement != null) {
                        result2.add(new Resource(element2, name, type));
                    }
                }

                public void visitAttr(Attr element2) {
                    ResourceReference resourceReference = (ResourceReference)element2.getName().getValue();
                    XmlElement xmlElement = element2.getXmlElement();
                    if (resourceReference != null && xmlElement != null) {
                        result2.add(new Resource(element2, resourceReference.getName(), resourceReference.getResourceType()));
                    }
                }
            });
            ArrayList<StructureViewTreeElement> arrayList = result2;
            if (arrayList == null) {
                ResourcesRoot.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @NotNull
        public String getPresentableText() {
            String string = String.format("Resources file '%s'", this.myResources.getFile().getName());
            if (string == null) {
                ResourcesRoot.$$$reportNull$$$0(3);
            }
            return string;
        }

        public String toString() {
            StringBuilder builder2 = new StringBuilder(this.getPresentableText());
            builder2.append('\n');
            for (StructureViewTreeElement child : this.getChildrenBase()) {
                builder2.append("  ").append(child.toString()).append('\n');
                if (!(child instanceof Resource)) continue;
                for (StructureViewTreeElement grandChild : ((Resource)child).getChildrenBase()) {
                    builder2.append("    ").append(grandChild.toString()).append('\n');
                }
            }
            return builder2.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resources";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder$ResourcesRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder$ResourcesRoot";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenBase";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

