/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.structure.layout;

import com.google.common.base.Joiner;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.layout.Fragment;
import org.jetbrains.android.dom.layout.Include;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.structure.StructureUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutStructureViewBuilder
extends TreeBasedStructureViewBuilder {
    private final DomFileElement<LayoutViewElement> myElement;

    public LayoutStructureViewBuilder(@NotNull DomFileElement<LayoutViewElement> element2) {
        if (element2 == null) {
            LayoutStructureViewBuilder.$$$reportNull$$$0(0);
        }
        this.myElement = element2;
    }

    @NotNull
    public StructureViewModel createStructureViewModel(@Nullable Editor editor2) {
        return new StructureViewModelBase((PsiFile)this.myElement.getFile(), (StructureViewTreeElement)new LayoutNode((LayoutViewElement)this.myElement.getRootElement()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/structure/layout/LayoutStructureViewBuilder", "<init>"));
    }

    private static class LayoutNode
    extends PsiTreeElementBase<XmlTag> {
        private final LayoutViewElement myElement;

        public LayoutNode(@NotNull LayoutViewElement element2) {
            if (element2 == null) {
                LayoutNode.$$$reportNull$$$0(0);
            }
            super((PsiElement)element2.getXmlTag());
            this.myElement = element2;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            final ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>();
            DomElementVisitor visitor2 = new DomElementVisitor(){

                public void visitLayoutViewElement(LayoutViewElement element2) {
                    result2.add(new LayoutNode(element2));
                }

                public void visitFragment(Fragment element2) {
                    result2.add(new FragmentNode(element2));
                }

                public void visitInclude(Include element2) {
                    result2.add(new IncludeNode(element2));
                }

                public void visitDomElement(DomElement element2) {
                }
            };
            StructureUtils.acceptChildrenInOrder(this.myElement, visitor2);
            ArrayList<StructureViewTreeElement> arrayList = result2;
            if (arrayList == null) {
                LayoutNode.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        public Icon getIcon(boolean open) {
            XmlTag tag = this.myElement.getXmlTag();
            if (tag == null) {
                return null;
            }
            return AndroidDomElementDescriptorProvider.getIconForViewTag(tag.getName());
        }

        public String getLocationString() {
            XmlTag xmlTag = this.myElement.getXmlTag();
            XmlAttribute idAttribute = xmlTag == null ? null : xmlTag.getAttribute("id", "http://schemas.android.com/apk/res/android");
            return idAttribute == null ? null : idAttribute.getValue();
        }

        public boolean isSearchInLocationString() {
            return true;
        }

        @NotNull
        public String getPresentableText() {
            XmlTag xmlTag = this.myElement.getXmlTag();
            if (xmlTag == null) {
                return "";
            }
            String className2 = xmlTag.getName();
            String string = className2.substring(className2.lastIndexOf(46) + 1);
            if (string == null) {
                LayoutNode.$$$reportNull$$$0(2);
            }
            return string;
        }

        public String toString() {
            StringBuilder builder2 = new StringBuilder();
            this.dumpIndented(builder2, 0);
            return builder2.toString();
        }

        private void dumpIndented(@NotNull StringBuilder builder2, int indentLevel) {
            if (builder2 == null) {
                LayoutNode.$$$reportNull$$$0(3);
            }
            for (int i2 = 0; i2 < indentLevel; ++i2) {
                builder2.append("  ");
            }
            builder2.append(this.getPresentableText());
            String locationString = this.getLocationString();
            if (locationString != null) {
                builder2.append(" (").append(locationString).append(")");
            }
            builder2.append('\n');
            for (StructureViewTreeElement element2 : this.getChildrenBase()) {
                if (element2 instanceof LayoutNode) {
                    ((LayoutNode)element2).dumpIndented(builder2, indentLevel + 1);
                    continue;
                }
                for (int i3 = 0; i3 < indentLevel + 1; ++i3) {
                    builder2.append("  ");
                }
                builder2.append(element2.toString()).append("\n");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/dom/structure/layout/LayoutStructureViewBuilder$LayoutNode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/dom/structure/layout/LayoutStructureViewBuilder$LayoutNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenBase";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "dumpIndented";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IncludeNode
    extends PsiTreeElementBase<XmlTag> {
        private final Include myElement;

        private IncludeNode(@NotNull Include element2) {
            if (element2 == null) {
                IncludeNode.$$$reportNull$$$0(0);
            }
            super((PsiElement)element2.getXmlTag());
            this.myElement = element2;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                IncludeNode.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Nullable
        public String getPresentableText() {
            Object result2 = "Include";
            String text2 = this.myElement.getLayout().getRawText();
            if (text2 != null) {
                result2 = (String)result2 + " " + text2;
            }
            return result2;
        }

        public Icon getIcon(boolean open) {
            return StudioIcons.LayoutEditor.Palette.INCLUDE;
        }

        public String toString() {
            return this.getPresentableText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/dom/structure/layout/LayoutStructureViewBuilder$IncludeNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/dom/structure/layout/LayoutStructureViewBuilder$IncludeNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FragmentNode
    extends PsiTreeElementBase<XmlTag> {
        private final Fragment myElement;

        public FragmentNode(@NotNull Fragment element2) {
            if (element2 == null) {
                FragmentNode.$$$reportNull$$$0(0);
            }
            super((PsiElement)element2.getXmlTag());
            this.myElement = element2;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                FragmentNode.$$$reportNull$$$0(1);
            }
            return list;
        }

        public Icon getIcon(boolean open) {
            return StudioIcons.LayoutEditor.Palette.FRAGMENT;
        }

        @Nullable
        public String getPresentableText() {
            return Joiner.on((String)" ").skipNulls().join((Object)"Fragment", (Object)this.myElement.getFragmentName().getRawText(), new Object[0]);
        }

        public String toString() {
            return this.getPresentableText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/dom/structure/layout/LayoutStructureViewBuilder$FragmentNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/dom/structure/layout/LayoutStructureViewBuilder$FragmentNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

