/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.navigation;

import com.android.SdkConstants;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.ScopeType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.navigation.ActivityDestinationElement;
import org.jetbrains.android.dom.navigation.ConcreteDestinationElement;
import org.jetbrains.android.dom.navigation.DeeplinkElement;
import org.jetbrains.android.dom.navigation.FragmentDestinationElement;
import org.jetbrains.android.dom.navigation.NavActionElement;
import org.jetbrains.android.dom.navigation.NavArgumentElement;
import org.jetbrains.android.dom.navigation.NavClassHelperKt;
import org.jetbrains.android.dom.navigation.NavGraphElement;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationSchema
implements Disposable {
    public static final String TAG_ACTION = "action";
    public static final String TAG_ARGUMENT = "argument";
    public static final String ATTR_DESTINATION = "destination";
    public static final String INCLUDE_GRAPH_LABEL = "Include Graph";
    public static final String ACTION_LABEL = "Action";
    private static final String NAVIGATOR_CLASS_NAME = "androidx.navigation.Navigator";
    private static final String ANNOTATION_NAV_TAG_NAME = "androidx.navigation.Navigator.Name";
    private static final String ANNOTATION_NAV_CLASS_TYPE = "androidx.navigation.NavDestination.ClassType";
    public static final String ATTR_POP_UP_TO = "popUpTo";
    public static final String ATTR_POP_UP_TO_INCLUSIVE = "popUpToInclusive";
    public static final String ATTR_SINGLE_TOP = "launchSingleTop";
    public static final String ATTR_ENTER_ANIM = "enterAnim";
    public static final String ATTR_EXIT_ANIM = "exitAnim";
    public static final String ATTR_POP_ENTER_ANIM = "popEnterAnim";
    public static final String ATTR_POP_EXIT_ANIM = "popExitAnim";
    public static final String ATTR_ACTION = "action";
    public static final String ATTR_DATA = "data";
    public static final String ATTR_DATA_PATTERN = "dataPattern";
    public static final String ATTR_DEFAULT_VALUE = "defaultValue";
    public static final String NAV_GRAPH_DESTINATION = "androidx.navigation.NavGraph";
    @NotNull
    private ImmutableMap<DestinationType, String> myTypeToRootTag;
    public static final String ROOT_ACTIVITY_NAVIGATOR = "androidx.navigation.ActivityNavigator";
    public static final String ROOT_FRAGMENT_NAVIGATOR = "androidx.navigation.fragment.FragmentNavigator";
    public static final String ROOT_NAV_GRAPH_NAVIGATOR = "androidx.navigation.NavGraphNavigator";
    private final TypeRef NULL_TYPE;
    private final Map<String, TypeRef> myTypeCache;
    @NotNull
    private ImmutableList<NavigatorKeyInfo> myNavigatorCacheKeys;
    private final Module myModule;
    @NotNull
    private ImmutableMultimap<DestinationType, TypeRef> myTypeToDestinationClass;
    @NotNull
    private ImmutableMultimap<String, TypeRef> myTagToDestinationClass;
    @NotNull
    private ImmutableMultimap<String, TypeRef> myTagToStyleables;
    private static final Map<Module, NavigationSchema> ourSchemas = new HashMap<Module, NavigationSchema>();
    private static final Multimap<Module, Runnable> ourListeners = ArrayListMultimap.create();
    private static final Object ourListenerLock = new Object();
    private CompletableFuture<NavigationSchema> myRebuildTask;
    private final Object myTaskLock;
    private int myCustomNavigatorCount;
    private int myCustomTagCount;
    private int myCustomDestinationCount;

    @Nullable
    private PsiClass getClass(@Nullable String className2) {
        GlobalSearchScope scope2;
        PsiClass c;
        if (className2 == null) {
            return null;
        }
        TypeRef ref = this.myTypeCache.get(className2);
        if (ref != null && (c = ref.dereference()) != null) {
            return c;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)this.myModule.getProject());
        PsiClass result2 = javaPsiFacade.findClass(className2, scope2 = ProjectSystemUtil.getModuleSystem(this.myModule).getResolveScope(ScopeType.MAIN));
        if (result2 != null) {
            this.myTypeCache.put(className2, new TypeRef(result2));
        } else {
            this.myTypeCache.remove(className2);
        }
        return result2;
    }

    public int hashCode() {
        return Objects.hash(this.myModule, this.myTagToDestinationClass, this.myTagToDestinationClass, this.myTagToStyleables);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NavigationSchema)) {
            return false;
        }
        NavigationSchema otherSchema = (NavigationSchema)obj;
        return Objects.equals(this.myModule, otherSchema.myModule) && Objects.equals(this.myTypeToDestinationClass, otherSchema.myTypeToDestinationClass) && Objects.equals(this.myTagToDestinationClass, otherSchema.myTagToDestinationClass) && Objects.equals(this.myTagToStyleables, otherSchema.myTagToStyleables);
    }

    @NotNull
    public static synchronized NavigationSchema get(@NotNull Module module2) {
        NavigationSchema result2;
        if (module2 == null) {
            NavigationSchema.$$$reportNull$$$0(0);
        }
        NavigationSchema navigationSchema = (result2 = ourSchemas.get(module2)) == null ? new NavigationSchema(module2) : result2;
        if (navigationSchema == null) {
            NavigationSchema.$$$reportNull$$$0(1);
        }
        return navigationSchema;
    }

    public static synchronized void createIfNecessary(@NotNull Module module2) throws ClassNotFoundException {
        NavigationSchema result2;
        if (module2 == null) {
            NavigationSchema.$$$reportNull$$$0(2);
        }
        if ((result2 = ourSchemas.get(module2)) == null) {
            result2 = new NavigationSchema(module2);
            result2.init();
            ourSchemas.put(module2, result2);
            try {
                Disposer.register((Disposable)module2, (Disposable)result2);
            }
            catch (IncorrectOperationException ignore) {
                result2.dispose();
            }
        }
    }

    @VisibleForTesting
    public NavigationSchema(@NotNull Module module2) {
        if (module2 == null) {
            NavigationSchema.$$$reportNull$$$0(3);
        }
        this.myTypeToRootTag = ImmutableMap.of();
        this.NULL_TYPE = new TypeRef();
        this.myTypeCache = new HashMap<String, TypeRef>();
        this.myNavigatorCacheKeys = ImmutableList.of();
        this.myTypeToDestinationClass = ImmutableMultimap.of();
        this.myTagToDestinationClass = ImmutableMultimap.of();
        this.myTagToStyleables = ImmutableMultimap.of();
        this.myTaskLock = new Object();
        this.myModule = module2;
    }

    public void dispose() {
        ApplicationManager.getApplication().invokeLater(() -> ourSchemas.remove(this.myModule, this));
    }

    private void init() throws ClassNotFoundException {
        GlobalSearchScope scope2;
        Project project = this.myModule.getProject();
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass navigatorRoot = javaPsiFacade.findClass(NAVIGATOR_CLASS_NAME, scope2 = ProjectSystemUtil.getModuleSystem(this.myModule).getResolveScope(ScopeType.MAIN));
        if (navigatorRoot == null) {
            Logger.getInstance(this.getClass()).warn("Navigator class not found.");
            throw new ClassNotFoundException(NAVIGATOR_CLASS_NAME);
        }
        PsiClass activity = javaPsiFacade.findClass("android.app.Activity", scope2);
        if (activity == null) {
            Logger.getInstance(this.getClass()).warn("Activity class not found.");
            throw new ClassNotFoundException("android.app.Activity");
        }
        HashMap<PsiClass, String> navigatorToTag = new HashMap<PsiClass, String>();
        HashMap<PsiClass, PsiClass> navigatorToDestinationClass = new HashMap<PsiClass, PsiClass>();
        navigatorToDestinationClass.put(this.getClass(ROOT_NAV_GRAPH_NAVIGATOR), this.getClass(NAV_GRAPH_DESTINATION));
        HashSet<PsiClass> nonCustomDestinations = new HashSet<PsiClass>();
        HashSet<String> nonCustomTags = new HashSet<String>();
        for (PsiClass navClass : ClassInheritorsSearch.search((PsiClass)navigatorRoot, (SearchScope)scope2, (boolean)true)) {
            if (navClass.equals(navigatorRoot)) continue;
            String qName = navClass.getQualifiedName();
            if (qName != null) {
                if (qName.startsWith("androidx.")) {
                    if (!navClass.hasModifier(JvmModifier.PUBLIC)) {
                        continue;
                    }
                } else {
                    ++this.myCustomNavigatorCount;
                }
            }
            NavigationSchema.collectDestinationsForNavigator(navigatorRoot, navClass, navigatorToDestinationClass);
            NavigationSchema.collectTagsForNavigator(navClass, navigatorToTag);
            if (qName == null || !qName.startsWith("androidx.")) continue;
            nonCustomDestinations.add((PsiClass)navigatorToDestinationClass.get(navClass));
            nonCustomTags.add((String)navigatorToTag.get(navClass));
        }
        this.myTagToStyleables = this.buildTagToStyleables(navigatorToTag);
        this.myTagToDestinationClass = this.buildTagToDestinationMap(navigatorToTag, navigatorToDestinationClass);
        this.myTypeToDestinationClass = this.buildDestinationTypeToDestinationMap();
        this.myCustomDestinationCount = new HashSet(this.myTagToDestinationClass.values()).size() - nonCustomDestinations.size();
        this.myCustomTagCount = this.myTagToDestinationClass.keySet().size() - nonCustomTags.size();
        this.myTypeToRootTag = this.buildTypeToDefaultTag(navigatorToTag);
        this.myNavigatorCacheKeys = this.buildCacheKeys(navigatorToTag, navigatorToDestinationClass);
    }

    private ImmutableList<NavigatorKeyInfo> buildCacheKeys(Map<PsiClass, String> tagMap, Map<PsiClass, PsiClass> destinationTypeMap) {
        ImmutableList.Builder result2 = new ImmutableList.Builder();
        for (PsiClass navigator : Sets.union(tagMap.keySet(), destinationTypeMap.keySet())) {
            NavigatorKeyInfo key = new NavigatorKeyInfo(navigator, tagMap.get(navigator), destinationTypeMap.get(navigator));
            result2.add((Object)key);
        }
        return result2.build();
    }

    private ImmutableMultimap<String, TypeRef> buildTagToStyleables(Map<PsiClass, String> navigatorToTag) {
        ImmutableMultimap.Builder builder2 = ImmutableMultimap.builder();
        navigatorToTag.forEach((navigator, tag) -> builder2.put(tag, (Object)new TypeRef((PsiClass)navigator)));
        return builder2.build();
    }

    @NotNull
    private ImmutableMultimap<DestinationType, TypeRef> buildDestinationTypeToDestinationMap() {
        HashMap<String, DestinationType> destinationClassToType = new HashMap<String, DestinationType>();
        destinationClassToType.put("android.app.Activity", DestinationType.ACTIVITY);
        destinationClassToType.put(SdkConstants.CLASS_V4_FRAGMENT.oldName(), DestinationType.FRAGMENT);
        destinationClassToType.put(SdkConstants.CLASS_V4_FRAGMENT.newName(), DestinationType.FRAGMENT);
        destinationClassToType.put(NAV_GRAPH_DESTINATION, DestinationType.NAVIGATION);
        for (TypeRef destinationClassRef : this.myTagToDestinationClass.values()) {
            PsiClass destinationClass;
            if (destinationClassRef == this.NULL_TYPE || (destinationClass = destinationClassRef.dereference()) == null) continue;
            ArrayList<PsiClass> toUpdate = new ArrayList<PsiClass>();
            DestinationType result2 = DestinationType.OTHER;
            while (destinationClass != null) {
                toUpdate.add(destinationClass);
                DestinationType t = (DestinationType)((Object)destinationClassToType.get(destinationClass.getQualifiedName()));
                if (t != null) {
                    result2 = t;
                    break;
                }
                destinationClass = destinationClass.getSuperClass();
            }
            for (PsiClass d : toUpdate) {
                destinationClassToType.put(d.getQualifiedName(), result2);
            }
        }
        ImmutableMultimap.Builder typeToDestinationBuilder = ImmutableMultimap.builder();
        destinationClassToType.forEach((destination, type) -> typeToDestinationBuilder.put((Object)type, (Object)new TypeRef((String)destination)));
        typeToDestinationBuilder.put((Object)DestinationType.OTHER, (Object)this.NULL_TYPE);
        ImmutableMultimap immutableMultimap = typeToDestinationBuilder.build();
        if (immutableMultimap == null) {
            NavigationSchema.$$$reportNull$$$0(4);
        }
        return immutableMultimap;
    }

    @NotNull
    private ImmutableMultimap<String, TypeRef> buildTagToDestinationMap(@NotNull Map<PsiClass, String> navigatorToTag, @NotNull Map<PsiClass, PsiClass> navigatorToDestinationClass) {
        if (navigatorToTag == null) {
            NavigationSchema.$$$reportNull$$$0(5);
        }
        if (navigatorToDestinationClass == null) {
            NavigationSchema.$$$reportNull$$$0(6);
        }
        ImmutableMultimap.Builder tagToDestBuilder = new ImmutableMultimap.Builder();
        for (Map.Entry<PsiClass, PsiClass> navToDestEntry : navigatorToDestinationClass.entrySet()) {
            String tag = navigatorToTag.get(navToDestEntry.getKey());
            if (tag == null) continue;
            PsiClass destClass = navToDestEntry.getValue();
            tagToDestBuilder.put((Object)tag, (Object)(destClass == null ? this.NULL_TYPE : new TypeRef(destClass)));
        }
        ImmutableMultimap immutableMultimap = tagToDestBuilder.build();
        if (immutableMultimap == null) {
            NavigationSchema.$$$reportNull$$$0(7);
        }
        return immutableMultimap;
    }

    private static void collectTagsForNavigator(@NotNull PsiClass navClass, @NotNull Map<PsiClass, String> navigatorToTagCollector) {
        String result2;
        if (navClass == null) {
            NavigationSchema.$$$reportNull$$$0(8);
        }
        if (navigatorToTagCollector == null) {
            NavigationSchema.$$$reportNull$$$0(9);
        }
        PsiClass tempNavigator = navClass;
        ArrayList<PsiClass> childrenToUpdate = new ArrayList<PsiClass>();
        do {
            childrenToUpdate.add(tempNavigator);
            result2 = navigatorToTagCollector.get(tempNavigator);
        } while (result2 == null && (result2 = NavigationSchema.getTagAnnotationValue(tempNavigator)) == null && (tempNavigator = tempNavigator.getSuperClass()) != null && !NAVIGATOR_CLASS_NAME.equals(tempNavigator.getQualifiedName()));
        if (result2 != null) {
            for (PsiClass navigator : childrenToUpdate) {
                navigatorToTagCollector.put(navigator, result2);
            }
        }
    }

    private static void collectDestinationsForNavigator(@NotNull PsiClass navigatorRoot, @NotNull PsiClass navClass, @NotNull Map<PsiClass, PsiClass> navigatorToDestinationClassCollector) {
        PsiClass resultDestination;
        if (navigatorRoot == null) {
            NavigationSchema.$$$reportNull$$$0(10);
        }
        if (navClass == null) {
            NavigationSchema.$$$reportNull$$$0(11);
        }
        if (navigatorToDestinationClassCollector == null) {
            NavigationSchema.$$$reportNull$$$0(12);
        }
        if ((resultDestination = navigatorToDestinationClassCollector.get(navClass)) == null) {
            resultDestination = NavigationSchema.getDestinationClassAnnotationValue(navClass, navigatorRoot);
        }
        if (resultDestination == null) {
            for (PsiClass parentClass = navClass.getSuperClass(); parentClass != null && resultDestination == null; parentClass = parentClass.getSuperClass()) {
                resultDestination = navigatorToDestinationClassCollector.get(parentClass);
            }
        }
        navigatorToDestinationClassCollector.put(navClass, resultDestination);
    }

    @Nullable
    private static PsiClass getDestinationClassAnnotationValue(@NotNull PsiClass subNav, @NotNull PsiClass navigatorRoot) {
        if (subNav == null) {
            NavigationSchema.$$$reportNull$$$0(13);
        }
        if (navigatorRoot == null) {
            NavigationSchema.$$$reportNull$$$0(14);
        }
        PsiTypeParameter destinationTypeParam = navigatorRoot.getTypeParameters()[0];
        PsiType resolved = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)navigatorRoot, (PsiClassType)PsiTypesUtil.getClassType((PsiClass)subNav)).substitute(destinationTypeParam);
        if (resolved == null) {
            return null;
        }
        ArrayList<PsiType> resolvedWithSupers = new ArrayList<PsiType>(Arrays.asList(resolved.getSuperTypes()));
        resolvedWithSupers.add(0, resolved);
        for (PsiType t : resolvedWithSupers) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)PsiTypesUtil.getPsiClass((PsiType)t), (String[])new String[]{ANNOTATION_NAV_CLASS_TYPE});
            if (annotation == null) continue;
            PsiAnnotationMemberValue expression2 = annotation.findAttributeValue("value");
            if (!(expression2 instanceof PsiClassObjectAccessExpression)) {
                return null;
            }
            return PsiTypesUtil.getPsiClass((PsiType)((PsiClassObjectAccessExpression)expression2).getOperand().getType());
        }
        return null;
    }

    @Nullable
    private static String getTagAnnotationValue(@NotNull PsiClass subNav) {
        PsiAnnotation annotation;
        if (subNav == null) {
            NavigationSchema.$$$reportNull$$$0(15);
        }
        return (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)subNav, (String[])new String[]{ANNOTATION_NAV_TAG_NAME})) == null ? null : AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)"value");
    }

    @NotNull
    private ImmutableMap<DestinationType, String> buildTypeToDefaultTag(Map<PsiClass, String> navigatorToTag) {
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        this.addDefaultTag(DestinationType.FRAGMENT, ROOT_FRAGMENT_NAVIGATOR, navigatorToTag, (ImmutableMap.Builder<DestinationType, String>)builder2);
        this.addDefaultTag(DestinationType.ACTIVITY, ROOT_ACTIVITY_NAVIGATOR, navigatorToTag, (ImmutableMap.Builder<DestinationType, String>)builder2);
        this.addDefaultTag(DestinationType.NAVIGATION, ROOT_NAV_GRAPH_NAVIGATOR, navigatorToTag, (ImmutableMap.Builder<DestinationType, String>)builder2);
        ImmutableMap immutableMap = builder2.build();
        if (immutableMap == null) {
            NavigationSchema.$$$reportNull$$$0(16);
        }
        return immutableMap;
    }

    private void addDefaultTag(DestinationType destinationType, String className2, Map<PsiClass, String> navigatorToTag, ImmutableMap.Builder<DestinationType, String> builder2) {
        PsiClass psiClass = this.getClass(className2);
        if (psiClass == null) {
            return;
        }
        String tag = navigatorToTag.get(psiClass);
        if (tag != null) {
            builder2.put((Object)destinationType, (Object)tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompletableFuture<NavigationSchema> getRebuildTask() {
        Object object = this.myTaskLock;
        synchronized (object) {
            return this.myRebuildTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean quickValidate() {
        Object object = this.myTaskLock;
        synchronized (object) {
            if (this.myRebuildTask != null) {
                return false;
            }
            return this.myNavigatorCacheKeys.stream().allMatch(value2 -> value2.checkConsistent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public CompletableFuture<NavigationSchema> rebuildSchema() {
        CompletableFuture<NavigationSchema> task2;
        if (this.myModule.isDisposed()) {
            CompletableFuture<NavigationSchema> completableFuture = CompletableFuture.completedFuture(new NavigationSchema(this.myModule));
            if (completableFuture == null) {
                NavigationSchema.$$$reportNull$$$0(17);
            }
            return completableFuture;
        }
        Object object = this.myTaskLock;
        synchronized (object) {
            if (this.myRebuildTask != null) {
                CompletableFuture<NavigationSchema> completableFuture = this.myRebuildTask;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl10 : MonitorExitStatement: MONITOREXIT : var2_1
                if (completableFuture == null) {
                    NavigationSchema.$$$reportNull$$$0(18);
                }
                return completableFuture;
            }
            task2 = this.myRebuildTask = new CompletableFuture();
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ArrayList listeners;
            NavigationSchema newVersion = new NavigationSchema(this.myModule);
            DumbService.getInstance((Project)this.myModule.getProject()).runReadActionInSmartMode(() -> {
                try {
                    newVersion.init();
                }
                catch (Throwable t) {
                    Object object = this.myTaskLock;
                    synchronized (object) {
                        this.myRebuildTask.completeExceptionally(t);
                        this.myRebuildTask = null;
                    }
                }
            });
            if (this.myRebuildTask == null) {
                return;
            }
            if (this.equals(newVersion)) {
                Object object = this.myTaskLock;
                synchronized (object) {
                    this.myRebuildTask.complete(this);
                    this.myRebuildTask = null;
                }
                return;
            }
            ourSchemas.put(this.myModule, newVersion);
            boolean registered = false;
            try {
                Disposer.register((Disposable)this.myModule, (Disposable)newVersion);
                registered = true;
            }
            catch (IncorrectOperationException ignore) {
                newVersion.dispose();
            }
            Object ignore = this.myTaskLock;
            synchronized (ignore) {
                this.myRebuildTask.complete(registered ? newVersion : new NavigationSchema(this.myModule));
            }
            Object object = ourListenerLock;
            synchronized (object) {
                listeners = new ArrayList(ourListeners.get((Object)this.myModule));
            }
            listeners.forEach(Runnable::run);
            Disposer.dispose((Disposable)this);
        });
        CompletableFuture<NavigationSchema> completableFuture = task2;
        if (completableFuture == null) {
            NavigationSchema.$$$reportNull$$$0(19);
        }
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSchemaRebuildListener(@NotNull Module module2, @NotNull Runnable listener2) {
        if (module2 == null) {
            NavigationSchema.$$$reportNull$$$0(20);
        }
        if (listener2 == null) {
            NavigationSchema.$$$reportNull$$$0(21);
        }
        Object object = ourListenerLock;
        synchronized (object) {
            ourListeners.put((Object)module2, (Object)listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSchemaRebuildListener(@NotNull Module module2, Runnable listener2) {
        if (module2 == null) {
            NavigationSchema.$$$reportNull$$$0(22);
        }
        Object object = ourListenerLock;
        synchronized (object) {
            ourListeners.remove((Object)module2, (Object)listener2);
        }
    }

    @NotNull
    public Multimap<Class<? extends AndroidDomElement>, String> getDestinationSubtags(@NotNull String tagName) {
        if (tagName == null) {
            NavigationSchema.$$$reportNull$$$0(23);
        }
        if (tagName.equals("action")) {
            ImmutableSetMultimap immutableSetMultimap = ImmutableSetMultimap.of(NavArgumentElement.class, (Object)TAG_ARGUMENT);
            if (immutableSetMultimap == null) {
                NavigationSchema.$$$reportNull$$$0(24);
            }
            return immutableSetMultimap;
        }
        HashMultimap result2 = HashMultimap.create();
        for (DestinationType type : this.getDestinationTypesForTag(tagName)) {
            if (type == null || this.isIncludeTag(tagName).booleanValue()) continue;
            if (type == DestinationType.NAVIGATION) {
                this.myTypeToDestinationClass.forEach((arg_0, arg_1) -> this.lambda$getDestinationSubtags$6((Multimap)result2, arg_0, arg_1));
                result2.put(NavGraphElement.class, (Object)"include");
            }
            if (type != DestinationType.ACTIVITY) {
                result2.put(NavActionElement.class, (Object)"action");
            }
            result2.put(DeeplinkElement.class, (Object)"deepLink");
            result2.put(NavArgumentElement.class, (Object)TAG_ARGUMENT);
        }
        HashMultimap hashMultimap = result2;
        if (hashMultimap == null) {
            NavigationSchema.$$$reportNull$$$0(25);
        }
        return hashMultimap;
    }

    @NotNull
    public static List<String> getPossibleRootsMaybeWithoutSchema(@NotNull Module module2) {
        if (module2 == null) {
            NavigationSchema.$$$reportNull$$$0(26);
        }
        Application application = ApplicationManager.getApplication();
        AtomicReference result2 = new AtomicReference();
        application.invokeAndWait(() -> application.runReadAction(() -> {
            try {
                NavigationSchema.createIfNecessary(module2);
                result2.set(NavigationSchema.get(module2).getPossibleRoots());
            }
            catch (ClassNotFoundException e) {
                result2.set(ImmutableList.of((Object)"navigation"));
            }
        }));
        List list = (List)result2.get();
        if (list == null) {
            NavigationSchema.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NotNull
    public List<String> getPossibleRoots() {
        List<String> list = this.myTypeToDestinationClass.get((Object)DestinationType.NAVIGATION).stream().flatMap(c -> this.myTagToDestinationClass.inverse().get(c).stream()).collect(Collectors.toList());
        if (list == null) {
            NavigationSchema.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    public Collection<PsiClass> getStyleablesForTag(@NotNull String tag) {
        if (tag == null) {
            NavigationSchema.$$$reportNull$$$0(29);
        }
        List list = ContainerUtil.map((Collection)this.myTagToStyleables.get((Object)tag), TypeRef::dereference);
        if (list == null) {
            NavigationSchema.$$$reportNull$$$0(30);
        }
        return list;
    }

    @NotNull
    public Collection<String> getAllTags() {
        ImmutableSet immutableSet = this.myTagToDestinationClass.keySet();
        if (immutableSet == null) {
            NavigationSchema.$$$reportNull$$$0(31);
        }
        return immutableSet;
    }

    @NotNull
    public Collection<DestinationType> getDestinationTypesForTag(@NotNull String tag) {
        if (tag == null) {
            NavigationSchema.$$$reportNull$$$0(32);
        }
        if (tag.equals("include")) {
            ImmutableList immutableList = ImmutableList.of((Object)((Object)DestinationType.NAVIGATION));
            if (immutableList == null) {
                NavigationSchema.$$$reportNull$$$0(33);
            }
            return immutableList;
        }
        EnumSet<DestinationType> result2 = EnumSet.noneOf(DestinationType.class);
        for (TypeRef destinationClassRef : this.myTagToDestinationClass.get((Object)tag)) {
            if (destinationClassRef == this.NULL_TYPE) {
                result2.add(DestinationType.OTHER);
                continue;
            }
            result2.addAll((Collection<DestinationType>)this.myTypeToDestinationClass.inverse().get((Object)destinationClassRef));
        }
        EnumSet<DestinationType> enumSet = result2;
        if (enumSet == null) {
            NavigationSchema.$$$reportNull$$$0(34);
        }
        return enumSet;
    }

    @Nullable
    public DestinationType getDestinationTypeForDestinationClassName(@NotNull String className2) {
        ImmutableCollection types2;
        if (className2 == null) {
            NavigationSchema.$$$reportNull$$$0(35);
        }
        return (types2 = this.myTypeToDestinationClass.inverse().get((Object)new TypeRef(className2))).isEmpty() ? null : (DestinationType)((Object)types2.iterator().next());
    }

    @Contract(value="null -> null")
    @Nullable
    public Collection<String> getTagsForDestinationClass(@Nullable PsiClass layoutClass) {
        while (layoutClass != null) {
            ImmutableCollection result2 = this.myTagToDestinationClass.inverse().get((Object)new TypeRef(layoutClass));
            if (!result2.isEmpty()) {
                return result2;
            }
            layoutClass = layoutClass.getSuperClass();
        }
        return null;
    }

    @NotNull
    public Collection<PsiClass> getDestinationClassesForTag(@NotNull String tagName) {
        if (tagName == null) {
            NavigationSchema.$$$reportNull$$$0(36);
        }
        Collection collection2 = this.myTagToDestinationClass.get((Object)tagName).stream().map(TypeRef::dereference).filter(c -> c != null).collect(Collectors.toSet());
        if (collection2 == null) {
            NavigationSchema.$$$reportNull$$$0(37);
        }
        return collection2;
    }

    @NotNull
    public List<PsiClass> getProjectClassesForTag(@NotNull String tagName, @NotNull SearchScope scope2) {
        if (tagName == null) {
            NavigationSchema.$$$reportNull$$$0(38);
        }
        if (scope2 == null) {
            NavigationSchema.$$$reportNull$$$0(39);
        }
        Collection<PsiClass> destinationClasses = this.getDestinationClassesForTag(tagName);
        ArrayList<PsiClass> projectClasses = new ArrayList<PsiClass>();
        for (PsiClass destinationClass : destinationClasses) {
            if (NavClassHelperKt.isInProject(destinationClass)) {
                projectClasses.add(destinationClass);
            }
            Query query = ClassInheritorsSearch.search((PsiClass)destinationClass, (SearchScope)scope2, (boolean)true, (boolean)true, (boolean)false);
            for (PsiClass inherited : query) {
                if (NavClassHelperKt.extendsNavHostFragment(inherited, this.myModule)) continue;
                projectClasses.add(inherited);
            }
        }
        ArrayList<PsiClass> arrayList = projectClasses;
        if (arrayList == null) {
            NavigationSchema.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    @NotNull
    public List<PsiClass> getProjectClassesForTag(@NotNull String tagName) {
        if (tagName == null) {
            NavigationSchema.$$$reportNull$$$0(41);
        }
        List<PsiClass> list = this.getProjectClassesForTag(tagName, (SearchScope)GlobalSearchScope.moduleWithDependenciesScope((Module)this.myModule));
        if (list == null) {
            NavigationSchema.$$$reportNull$$$0(42);
        }
        return list;
    }

    @Nullable
    public String getDefaultTag(@NotNull DestinationType type) {
        if (type == null) {
            NavigationSchema.$$$reportNull$$$0(43);
        }
        return (String)this.myTypeToRootTag.get((Object)type);
    }

    @NotNull
    public String getTagLabel(@NotNull String tag) {
        if (tag == null) {
            NavigationSchema.$$$reportNull$$$0(44);
        }
        String string = this.getTagLabel(tag, false);
        if (string == null) {
            NavigationSchema.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    public String getTagLabel(@NotNull String tag, boolean isRoot) {
        if (tag == null) {
            NavigationSchema.$$$reportNull$$$0(46);
        }
        Object text2 = null;
        if (this.isIncludeTag(tag).booleanValue()) {
            text2 = INCLUDE_GRAPH_LABEL;
        } else if ("action".equals(tag)) {
            text2 = ACTION_LABEL;
        } else {
            Collection<DestinationType> types2 = this.getDestinationTypesForTag(tag);
            if (types2.size() > 1) {
                text2 = "Ambiguous Type";
            } else if (types2.contains((Object)DestinationType.NAVIGATION)) {
                text2 = isRoot ? "Root Graph" : "Nested Graph";
            } else if (types2.contains((Object)DestinationType.FRAGMENT)) {
                text2 = "Fragment";
            } else if (types2.contains((Object)DestinationType.ACTIVITY)) {
                text2 = "Activity";
            } else if (types2.contains((Object)DestinationType.OTHER)) {
                text2 = tag;
            }
            if (types2.stream().map(this::getDefaultTag).noneMatch(t -> t == null || t.equals(tag))) {
                text2 = (String)text2 + " (" + tag + ")";
            }
        }
        assert (text2 != null);
        String string = text2;
        if (string == null) {
            NavigationSchema.$$$reportNull$$$0(47);
        }
        return string;
    }

    public Boolean isFragmentTag(@NotNull String tag) {
        if (tag == null) {
            NavigationSchema.$$$reportNull$$$0(48);
        }
        return this.getDestinationTypesForTag(tag).contains((Object)DestinationType.FRAGMENT);
    }

    public Boolean isActivityTag(@NotNull String tag) {
        if (tag == null) {
            NavigationSchema.$$$reportNull$$$0(49);
        }
        return this.getDestinationTypesForTag(tag).contains((Object)DestinationType.ACTIVITY);
    }

    public Boolean isNavigationTag(@NotNull String tag) {
        if (tag == null) {
            NavigationSchema.$$$reportNull$$$0(50);
        }
        return this.getDestinationTypesForTag(tag).contains((Object)DestinationType.NAVIGATION);
    }

    public Boolean isOtherTag(@NotNull String tag) {
        if (tag == null) {
            NavigationSchema.$$$reportNull$$$0(51);
        }
        return this.getDestinationTypesForTag(tag).contains((Object)DestinationType.OTHER);
    }

    public Boolean isIncludeTag(@NotNull String tag) {
        if (tag == null) {
            NavigationSchema.$$$reportNull$$$0(52);
        }
        return tag.equals("include");
    }

    public int getCustomNavigatorCount() {
        return this.myCustomNavigatorCount;
    }

    public int getCustomTagCount() {
        return this.myCustomTagCount;
    }

    public int getCustomDestinationCount() {
        return this.myCustomDestinationCount;
    }

    private /* synthetic */ void lambda$getDestinationSubtags$6(Multimap result2, DestinationType childType, TypeRef childDestinationClass) {
        for (String tag : this.myTagToDestinationClass.inverse().get((Object)childDestinationClass)) {
            if (childType == DestinationType.NAVIGATION) {
                result2.put(NavGraphElement.class, (Object)tag);
                continue;
            }
            if (childType == DestinationType.FRAGMENT) {
                result2.put(FragmentDestinationElement.class, (Object)tag);
                continue;
            }
            if (childType == DestinationType.ACTIVITY) {
                result2.put(ActivityDestinationElement.class, (Object)tag);
                continue;
            }
            result2.put(ConcreteDestinationElement.class, (Object)tag);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 45: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 45: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/navigation/NavigationSchema";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatorToTag";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatorToDestinationClass";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatorToTagCollector";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatorRoot";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatorToDestinationClassCollector";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subNav";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 23: 
            case 36: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 29: 
            case 32: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/navigation/NavigationSchema";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDestinationTypeToDestinationMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTagToDestinationMap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeToDefaultTag";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "rebuildSchema";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getDestinationSubtags";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleRootsMaybeWithoutSchema";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleRoots";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyleablesForTag";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTags";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDestinationTypesForTag";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getDestinationClassesForTag";
                break;
            }
            case 40: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectClassesForTag";
                break;
            }
            case 45: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 45: 
            case 47: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createIfNecessary";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildTagToDestinationMap";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectTagsForNavigator";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectDestinationsForNavigator";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationClassAnnotationValue";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTagAnnotationValue";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addSchemaRebuildListener";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeSchemaRebuildListener";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationSubtags";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleRootsMaybeWithoutSchema";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getStyleablesForTag";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationTypesForTag";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationTypeForDestinationClassName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationClassesForTag";
                break;
            }
            case 38: 
            case 39: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getProjectClassesForTag";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTag";
                break;
            }
            case 44: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getTagLabel";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isFragmentTag";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isActivityTag";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isNavigationTag";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isOtherTag";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isIncludeTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 45: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class NavigatorKeyInfo {
        long myModificationCount;
        @NotNull
        TypeRef myNavigatorTypeRef;
        @Nullable
        String myTagName;
        @Nullable
        TypeRef myDestinationClassRef;

        private NavigatorKeyInfo(@Nullable PsiClass navigator, @Nullable String tag, PsiClass destinationClass) {
            if (navigator == null) {
                NavigatorKeyInfo.$$$reportNull$$$0(0);
            }
            this.myModificationCount = this.getModificationCount(navigator);
            this.myNavigatorTypeRef = new TypeRef(navigator);
            this.myTagName = tag;
            this.myDestinationClassRef = destinationClass == null ? NavigationSchema.this.NULL_TYPE : new TypeRef(destinationClass);
        }

        boolean checkConsistent(@NotNull NavigationSchema schema) {
            PsiClass otherClass;
            if (schema == null) {
                NavigatorKeyInfo.$$$reportNull$$$0(1);
            }
            if ((otherClass = this.myNavigatorTypeRef.dereference()) == null) {
                return false;
            }
            if (this.getModificationCount(otherClass) == this.myModificationCount) {
                return true;
            }
            String tag = NavigationSchema.getTagAnnotationValue(otherClass);
            if (!Objects.equals(this.myTagName, tag)) {
                return false;
            }
            PsiClass rootNavigator = schema.getClass(NavigationSchema.NAVIGATOR_CLASS_NAME);
            if (rootNavigator == null) {
                return false;
            }
            PsiClass otherDestination = null;
            for (PsiClass otherOrParent = otherClass; otherDestination == null && otherOrParent != null && otherOrParent.isInheritor(rootNavigator, true); otherOrParent = otherOrParent.getSuperClass()) {
                otherDestination = NavigationSchema.getDestinationClassAnnotationValue(otherOrParent, rootNavigator);
            }
            PsiClass destinationClass = this.myDestinationClassRef == null ? null : this.myDestinationClassRef.dereference();
            String destinationName = destinationClass == null ? null : destinationClass.getQualifiedName();
            String otherName = otherDestination == null ? null : otherDestination.getQualifiedName();
            return Objects.equals(destinationName, otherName);
        }

        private long getModificationCount(@NotNull PsiClass psiClass) {
            PsiDocumentManager manager;
            if (psiClass == null) {
                NavigatorKeyInfo.$$$reportNull$$$0(2);
            }
            if ((manager = PsiDocumentManager.getInstance((Project)psiClass.getProject())) == null) {
                return 0L;
            }
            PsiFile file2 = psiClass.getContainingFile();
            if (file2 == null) {
                return 0L;
            }
            Document document = manager.getDocument(file2);
            return document == null ? 0L : document.getModificationStamp();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schema";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/dom/navigation/NavigationSchema$NavigatorKeyInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkConsistent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getModificationCount";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class TypeRef {
        private String myClassName;
        private SmartPsiElementPointer<PsiClass> myPointer;

        TypeRef(PsiClass c) {
            if (c == null) {
                TypeRef.$$$reportNull$$$0(0);
            }
            this.myClassName = c.getQualifiedName();
            this.myPointer = SmartPointerManager.getInstance((Project)c.getProject()).createSmartPsiElementPointer((PsiElement)c);
        }

        TypeRef(String className2) {
            if (className2 == null) {
                TypeRef.$$$reportNull$$$0(1);
            }
            this.myClassName = className2;
        }

        TypeRef() {
        }

        @Nullable
        PsiClass dereference() {
            PsiClass result2;
            PsiClass psiClass = result2 = this.myPointer == null ? null : (PsiClass)this.myPointer.getElement();
            if (result2 == null) {
                NavigationSchema.this.myTypeCache.remove(this.myClassName);
                result2 = NavigationSchema.this.getClass(this.myClassName);
                if (result2 != null) {
                    this.myPointer = SmartPointerManager.getInstance((Project)result2.getProject()).createSmartPsiElementPointer((PsiElement)result2);
                }
            }
            return result2;
        }

        public int hashCode() {
            return this.myClassName == null ? 0 : this.myClassName.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof TypeRef && Objects.equals(((TypeRef)obj).myClassName, this.myClassName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "c";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "className";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/dom/navigation/NavigationSchema$TypeRef";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum DestinationType {
        NAVIGATION,
        FRAGMENT,
        ACTIVITY,
        OTHER;

    }
}

