/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.manifest;

import com.android.annotations.concurrency.AnyThread;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.model.AndroidManifestIndex;
import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.XmlName;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.dom.manifest.AndroidManifestXmlFile;
import org.jetbrains.android.dom.manifest.CompatibleScreensScreen;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0007\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0007\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a1\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00170\u0002\"\u0004\b\u0000\u0010\u0017*\u00020\n2\u0017\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\u00170\u0019\u00a2\u0006\u0002\b\u001b\u001a\f\u0010\u001c\u001a\u0004\u0018\u00010\u001a*\u00020\n\"=\u0010\u0000\u001a1\u0012(\u0012&\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003 \u0005*\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"=\u0010\u0007\u001a1\u0012(\u0012&\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003 \u0005*\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"CUSTOM_PERMISSIONS", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "CUSTOM_PERMISSION_GROUPS", "getCustomPermissionGroups", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "getCustomPermissions", "getPackageName", "module", "Lcom/intellij/openapi/module/Module;", "getTestPackageName", "isRequiredAttribute", "", "attrName", "Lcom/intellij/util/xml/XmlName;", "element", "Lcom/intellij/util/xml/DomElement;", "cachedValueFromPrimaryManifest", "T", "valueSelector", "Lkotlin/Function1;", "Lorg/jetbrains/android/dom/manifest/AndroidManifestXmlFile;", "Lkotlin/ExtensionFunctionType;", "getPrimaryManifestXml", "intellij.android.core"})
@JvmName(name="AndroidManifestUtils")
public final class AndroidManifestUtils {
    private static final Key<CachedValue<Collection<String>>> CUSTOM_PERMISSIONS;
    private static final Key<CachedValue<Collection<String>>> CUSTOM_PERMISSION_GROUPS;

    @AnyThread
    @Nullable
    public static final String getPackageName(@NotNull AndroidFacet facet2) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Module module2 = facet2.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
        return ProjectSystemUtil.getModuleSystem(module2).getPackageName();
    }

    @AnyThread
    @Nullable
    public static final String getPackageName(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return ProjectSystemUtil.getModuleSystem(module2).getPackageName();
    }

    @Nullable
    public static final String getTestPackageName(@NotNull AndroidFacet facet2) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(facet2);
        if (androidModuleModel == null || (androidModuleModel = androidModuleModel.getSelectedVariant()) == null || (androidModuleModel = androidModuleModel.getMergedFlavor()) == null) {
            return null;
        }
        AndroidModuleModel flavor = androidModuleModel;
        String string = flavor.getTestApplicationId();
        if (string == null) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            AndroidFacetConfiguration androidFacetConfiguration = (AndroidFacetConfiguration)facet2.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)androidFacetConfiguration, (String)"facet.configuration");
            String applicationId2 = androidFacetConfiguration.isLibraryProject() ? AndroidManifestUtils.getPackageName(facet2) : flavor.getApplicationId();
            CharSequence charSequence = applicationId2;
            boolean bl4 = false;
            boolean bl5 = false;
            string = charSequence == null || charSequence.length() == 0 ? null : applicationId2 + ".test";
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isRequiredAttribute(@NotNull XmlName attrName, @NotNull DomElement element2) {
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (!(element2 instanceof CompatibleScreensScreen)) return false;
        if (!Intrinsics.areEqual((Object)attrName.getNamespaceKey(), (Object)"http://schemas.android.com/apk/res/android")) return false;
        String string = attrName.getLocalName();
        switch (string.hashCode()) {
            case -417399155: {
                if (!string.equals("screenSize")) return false;
                return true;
            }
            case -1360635172: {
                if (!string.equals("screenDensity")) return false;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static final Collection<String> getCustomPermissions(@NotNull AndroidFacet facet2) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Boolean bl = AndroidManifestIndex.Companion.indexEnabled();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"AndroidManifestIndex.indexEnabled()");
        if (bl.booleanValue()) {
            try {
                Module module2 = facet2.getModule();
                Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
                return (Collection)DumbService.getInstance((Project)module2.getProject()).runReadActionInSmartMode(new Computable(facet2){
                    final /* synthetic */ AndroidFacet $facet;

                    public final Collection<String> compute() {
                        return AndroidManifestIndexQueryUtils.queryCustomPermissionsFromManifestIndex(this.$facet);
                    }
                    {
                        this.$facet = androidFacet;
                    }
                });
            }
            catch (IndexNotReadyException e) {
                AndroidManifestIndexQueryUtils.logManifestIndexQueryError((Exception)((Object)e));
            }
        }
        CachedValue cachedValue2 = AndroidManifestUtils.cachedValueFromPrimaryManifest(facet2, getCustomPermissions.cachedValue.1.INSTANCE);
        Object object = facet2.putUserDataIfAbsent(CUSTOM_PERMISSIONS, cachedValue2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"facet.putUserDataIfAbsen\u2026PERMISSIONS, cachedValue)");
        return (Collection)((CachedValue)object).getValue();
    }

    @Nullable
    public static final Collection<String> getCustomPermissionGroups(@NotNull AndroidFacet facet2) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Boolean bl = AndroidManifestIndex.Companion.indexEnabled();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"AndroidManifestIndex.indexEnabled()");
        if (bl.booleanValue()) {
            try {
                Module module2 = facet2.getModule();
                Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
                return (Collection)DumbService.getInstance((Project)module2.getProject()).runReadActionInSmartMode(new Computable(facet2){
                    final /* synthetic */ AndroidFacet $facet;

                    public final Collection<String> compute() {
                        return AndroidManifestIndexQueryUtils.queryCustomPermissionGroupsFromManifestIndex(this.$facet);
                    }
                    {
                        this.$facet = androidFacet;
                    }
                });
            }
            catch (IndexNotReadyException e) {
                AndroidManifestIndexQueryUtils.logManifestIndexQueryError((Exception)((Object)e));
            }
        }
        CachedValue cachedValue2 = AndroidManifestUtils.cachedValueFromPrimaryManifest(facet2, getCustomPermissionGroups.cachedValue.1.INSTANCE);
        Object object = facet2.putUserDataIfAbsent(CUSTOM_PERMISSION_GROUPS, cachedValue2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"facet.putUserDataIfAbsen\u2026SION_GROUPS, cachedValue)");
        return (Collection)((CachedValue)object).getValue();
    }

    @NotNull
    public static final <T> CachedValue<T> cachedValueFromPrimaryManifest(@NotNull AndroidFacet $this$cachedValueFromPrimaryManifest, @NotNull Function1<? super AndroidManifestXmlFile, ? extends T> valueSelector) {
        Intrinsics.checkNotNullParameter((Object)$this$cachedValueFromPrimaryManifest, (String)"$this$cachedValueFromPrimaryManifest");
        Intrinsics.checkNotNullParameter(valueSelector, (String)"valueSelector");
        Module module2 = $this$cachedValueFromPrimaryManifest.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
        CachedValue cachedValue2 = CachedValuesManager.getManager((Project)module2.getProject()).createCachedValue(new CachedValueProvider($this$cachedValueFromPrimaryManifest, valueSelector){
            final /* synthetic */ AndroidFacet $this_cachedValueFromPrimaryManifest;
            final /* synthetic */ Function1 $valueSelector;

            @Nullable
            public final CachedValueProvider.Result<T> compute() {
                CachedValueProvider.Result result2;
                boolean $i$f$runReadAction = false;
                AndroidManifestXmlFile primaryManifest = (AndroidManifestXmlFile)ApplicationManager.getApplication().runReadAction(new Computable(this){
                    final /* synthetic */ cachedValueFromPrimaryManifest.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)AndroidManifestUtils.getPrimaryManifestXml(this.this$0.$this_cachedValueFromPrimaryManifest);
                    }
                });
                if (primaryManifest == null) {
                    CachedValueProvider.Result result3 = CachedValueProvider.Result.create(null, (Object[])new Object[]{ModificationTracker.EVER_CHANGED});
                    result2 = result3;
                    Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"CachedValueProvider.Resu\u2026tionTracker.EVER_CHANGED)");
                } else {
                    boolean $i$f$runReadAction2 = false;
                    Object result4 = ApplicationManager.getApplication().runReadAction(new Computable(this, primaryManifest){
                        final /* synthetic */ cachedValueFromPrimaryManifest.1 this$0;
                        final /* synthetic */ AndroidManifestXmlFile $primaryManifest$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$primaryManifest$inlined = androidManifestXmlFile;
                        }

                        public final T compute() {
                            boolean bl = false;
                            return (T)this.this$0.$valueSelector.invoke((Object)this.$primaryManifest$inlined);
                        }
                    });
                    CachedValueProvider.Result result5 = CachedValueProvider.Result.create((Object)result4, (Object[])new Object[]{primaryManifest});
                    result2 = result5;
                    Intrinsics.checkNotNullExpressionValue((Object)result5, (String)"CachedValueProvider.Resu\u2026(result, primaryManifest)");
                }
                return result2;
            }
            {
                this.$this_cachedValueFromPrimaryManifest = androidFacet;
                this.$valueSelector = function1;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)cachedValue2, (String)"CachedValuesManager.getM\u2026rimaryManifest)\n    }\n  }");
        return cachedValue2;
    }

    @Nullable
    public static final AndroidManifestXmlFile getPrimaryManifestXml(@NotNull AndroidFacet $this$getPrimaryManifestXml) {
        AndroidManifestXmlFile androidManifestXmlFile;
        PsiFile psiFile2;
        PsiFile psiFile3;
        PsiFile psiFile4;
        VirtualFile it;
        boolean bl;
        boolean bl2;
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)$this$getPrimaryManifestXml, (String)"$this$getPrimaryManifestXml");
        if ($this$getPrimaryManifestXml.isDisposed()) {
            return null;
        }
        VirtualFile virtualFile2 = SourceProviderManager.Companion.getInstance($this$getPrimaryManifestXml).getMainManifestFile();
        if (virtualFile2 != null) {
            virtualFile = virtualFile2;
            bl2 = false;
            bl = false;
            it = virtualFile;
            boolean bl3 = false;
            Module module2 = $this$getPrimaryManifestXml.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
            psiFile4 = AndroidPsiUtils.getPsiFileSafely((Project)module2.getProject(), (VirtualFile)it);
        } else {
            psiFile4 = null;
        }
        if (!((psiFile3 = (psiFile2 = psiFile4)) instanceof XmlFile)) {
            psiFile3 = null;
        }
        XmlFile xmlFile = (XmlFile)psiFile3;
        if (xmlFile != null) {
            virtualFile = xmlFile;
            bl2 = false;
            bl = false;
            it = virtualFile;
            boolean bl4 = false;
            XmlTag xmlTag = it.getRootTag();
            androidManifestXmlFile = Intrinsics.areEqual((Object)(xmlTag != null ? xmlTag.getName() : null), (Object)"manifest") ? new AndroidManifestXmlFile((XmlFile)it) : null;
        } else {
            androidManifestXmlFile = null;
        }
        return androidManifestXmlFile;
    }

    static {
        Key key = Key.create((String)"merged.manifest.custom.permissions");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<CachedValue<C\u2026fest.custom.permissions\")");
        CUSTOM_PERMISSIONS = key;
        Key key2 = Key.create((String)"merged.manifest.custom.permission.groups");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"Key.create<CachedValue<C\u2026ustom.permission.groups\")");
        CUSTOM_PERMISSION_GROUPS = key2;
    }
}

