/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.resources.ResourceType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.resources.ResourceNameConverter;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParentStyleConverter
extends ResourceReferenceConverter {
    public ParentStyleConverter() {
        super(ResourceType.STYLE, false, false);
        this.setAllowAttributeReferences(false);
    }

    @Override
    @NotNull
    public PsiReference[] createReferences(GenericDomValue<ResourceValue> value2, PsiElement element2, ConvertContext context) {
        Object[] refs;
        XmlAttributeValue attributeValue;
        if (element2 instanceof XmlAttributeValue && (attributeValue = (XmlAttributeValue)element2).isValid() && attributeValue.getValue().isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ParentStyleConverter.$$$reportNull$$$0(0);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Object[] refsFromSuper = super.createReferences(value2, element2, context);
        ResourceValue resValue = (ResourceValue)value2.getValue();
        if (resValue == null || resValue.getPackage() != null) {
            if (refsFromSuper == null) {
                ParentStyleConverter.$$$reportNull$$$0(1);
            }
            return refsFromSuper;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((ConvertContext)context);
        if (facet2 != null && (refs = ParentStyleConverter.getReferencesInStyleName(value2, facet2)).length > 0) {
            PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.mergeArrays((Object[])refsFromSuper, (Object[])refs);
            if (psiReferenceArray == null) {
                ParentStyleConverter.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        if (refsFromSuper == null) {
            ParentStyleConverter.$$$reportNull$$$0(3);
        }
        return refsFromSuper;
    }

    @NotNull
    private static PsiReference[] getReferencesInStyleName(@NotNull GenericDomValue<?> value2, @NotNull AndroidFacet facet2) {
        String[] ids2;
        String s;
        if (value2 == null) {
            ParentStyleConverter.$$$reportNull$$$0(4);
        }
        if (facet2 == null) {
            ParentStyleConverter.$$$reportNull$$$0(5);
        }
        if ((s = value2.getStringValue()) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ParentStyleConverter.$$$reportNull$$$0(6);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        int start2 = 0;
        int idx = s.indexOf(47);
        if (idx >= 0) {
            start2 = idx + 1;
            s = s.substring(start2);
        }
        if ((ids2 = s.split("\\.")).length < 2) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ParentStyleConverter.$$$reportNull$$$0(7);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<ResourceNameConverter.MyParentStyleReference> result2 = new ArrayList<ResourceNameConverter.MyParentStyleReference>(ids2.length - 1);
        int offset2 = s.length();
        for (int i2 = ids2.length - 1; i2 >= 0; --i2) {
            String styleName = s.substring(0, offset2);
            if (i2 < ids2.length - 1) {
                ResourceValue val = ResourceValue.referenceTo('\u0000', null, ResourceType.STYLE.getName(), styleName);
                result2.add(new ResourceNameConverter.MyParentStyleReference(value2, new TextRange(1 + start2, 1 + start2 + offset2), val, facet2));
            }
            if (ResourceNameConverter.hasExplicitParent(facet2, styleName)) break;
            offset2 = offset2 - ids2[i2].length() - 1;
        }
        PsiReference[] psiReferenceArray = result2.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            ParentStyleConverter.$$$reportNull$$$0(8);
        }
        return psiReferenceArray;
    }

    @Override
    public String toString(@Nullable ResourceValue element2, ConvertContext context) {
        if (element2 != null && element2.getPrefix() == '@') {
            return element2.toString();
        }
        return super.toString(element2, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/converters/ParentStyleConverter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/converters/ParentStyleConverter";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesInStyleName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesInStyleName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

