/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.databinding.index.BindingXmlData;
import com.android.tools.idea.databinding.index.BindingXmlIndex;
import com.android.tools.idea.databinding.index.ImportData;
import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.tools.idea.lang.databinding.DataBindingLangUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.AndroidResolveScopeEnlarger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingConverter
extends ResolvingConverter<PsiElement>
implements CustomReferenceConverter<PsiElement> {
    @Nullable
    private static String getImport(@NotNull String importedShortName, @NotNull ConvertContext context) {
        BindingXmlIndex.Entry indexEntry;
        if (importedShortName == null) {
            DataBindingConverter.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DataBindingConverter.$$$reportNull$$$0(1);
        }
        if ((indexEntry = DataBindingConverter.getBindingIndexEntry(context)) == null) {
            return null;
        }
        return indexEntry.getData().resolveImport(importedShortName);
    }

    @NotNull
    public Collection<? extends PsiClass> getVariants(ConvertContext context) {
        List list = Collections.emptyList();
        if (list == null) {
            DataBindingConverter.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public PsiElement fromString(@Nullable @NonNls String type, ConvertContext context) {
        if (type == null) {
            return null;
        }
        Module module2 = context.getModule();
        if (module2 == null) {
            return null;
        }
        BindingXmlIndex.Entry indexEntry = DataBindingConverter.getBindingIndexEntry(context);
        String qualifiedName = indexEntry == null ? type : DataBindingUtil.resolveImport(type, indexEntry.getData());
        Project project = context.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope2 = DataBindingConverter.enlargeScope(module2.getModuleWithDependenciesAndLibrariesScope(false), project, (PsiFile)context.getFile());
        if (!qualifiedName.isEmpty() && qualifiedName.indexOf(46) < 0) {
            if (Character.isLowerCase(qualifiedName.charAt(0))) {
                PsiPrimitiveType primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType((String)qualifiedName);
                if (primitiveType != null) {
                    PsiClassType boxedType = primitiveType.getBoxedType(PsiManager.getInstance((Project)project), scope2);
                    if (boxedType != null) {
                        return boxedType.resolve();
                    }
                    return null;
                }
            } else {
                PsiClass aClass = psiFacade.findClass("java.lang." + qualifiedName, scope2);
                if (aClass != null) {
                    return aClass;
                }
            }
        }
        return psiFacade.findClass(qualifiedName, scope2);
    }

    @Nullable
    public String toString(@Nullable PsiElement element2, @NotNull ConvertContext context) {
        if (context == null) {
            DataBindingConverter.$$$reportNull$$$0(3);
        }
        if (element2 instanceof PsiClass) {
            BindingXmlIndex.Entry indexEntry;
            String type = ((PsiClass)element2).getQualifiedName();
            if (type != null && (indexEntry = DataBindingConverter.getBindingIndexEntry(context)) != null) {
                type = DataBindingConverter.unresolveImport(type, indexEntry.getData());
            }
            return type;
        }
        if (element2 instanceof PsiTypeElement) {
            return ((PsiTypeElement)element2).getType().getCanonicalText();
        }
        return null;
    }

    private static String unresolveImport(@NotNull String className2, @NotNull BindingXmlData layoutData) {
        List<String> segments;
        if (className2 == null) {
            DataBindingConverter.$$$reportNull$$$0(4);
        }
        if (layoutData == null) {
            DataBindingConverter.$$$reportNull$$$0(5);
        }
        if (!(segments = StringUtil.split((String)className2, (String)".")).isEmpty()) {
            String importedShortName = null;
            int maxMatchedSegments = 0;
            for (ImportData anImport : layoutData.getImports()) {
                String importedType = anImport.getType();
                int matchedSegments = DataBindingConverter.getNumberOfMatchedSegments(importedType, segments);
                if (matchedSegments <= maxMatchedSegments) continue;
                maxMatchedSegments = matchedSegments;
                importedShortName = anImport.getShortName();
            }
            if (maxMatchedSegments != 0) {
                segments = segments.subList(maxMatchedSegments - 1, segments.size());
                segments.set(0, importedShortName);
                return StringUtil.join(segments, (String)".");
            }
        }
        return className2;
    }

    private static int getNumberOfMatchedSegments(String str, List<String> qName) {
        int offset2 = 0;
        for (int i2 = 0; i2 < qName.size(); ++i2) {
            String segment = qName.get(i2);
            int endOffset = offset2 + segment.length();
            if (!str.startsWith(segment, offset2) || endOffset != str.length() && str.charAt(endOffset) != '.') {
                return i2;
            }
            offset2 = endOffset + 1;
        }
        return qName.size();
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<PsiElement> value2, PsiElement element2, ConvertContext context) {
        assert (element2 instanceof XmlAttributeValue);
        XmlAttributeValue attrValue = (XmlAttributeValue)element2;
        String strValue = attrValue.getValue();
        ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
        int startOffset = attrValue.getValueTextRange().getStartOffset() - attrValue.getTextRange().getStartOffset();
        DataBindingConverter.createReferences(element2, strValue, false, startOffset, context, result2);
        PsiReference[] psiReferenceArray = result2.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            DataBindingConverter.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    protected static void createReferences(PsiElement element2, String className2, boolean resolveType, int startOffset, ConvertContext context, List<PsiReference> result2) {
        String packageName;
        String importedType;
        Module module2 = context.getModule();
        if (module2 == null) {
            return;
        }
        int offset2 = startOffset;
        List nameParts = StringUtil.split((String)className2, (String)".");
        if (nameParts.isEmpty()) {
            return;
        }
        PsiReferenceBase rootReference = null;
        String rootName = (String)nameParts.get(0);
        String string = importedType = resolveType ? DataBindingConverter.getImport(rootName, context) : null;
        if (importedType != null) {
            TextRange range = new TextRange(offset2, offset2 += rootName.length());
            rootReference = new AliasedReference(element2, range, importedType, module2);
        } else if (nameParts.size() == 1 && !rootName.isEmpty()) {
            if (Character.isLowerCase(rootName.charAt(0))) {
                PsiPrimitiveType primitive = PsiJavaParserFacadeImpl.getPrimitiveType((String)rootName);
                if (primitive != null) {
                    rootReference = new PsiReferenceBase.Immediate(element2, true, element2);
                }
            } else {
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass("java.lang." + rootName, GlobalSearchScope.moduleWithLibrariesScope((Module)module2));
                if (psiClass != null) {
                    TextRange range = new TextRange(offset2, offset2 += rootName.length());
                    rootReference = new ClassReference(element2, range, (PsiElement)psiClass);
                }
            }
        }
        if (rootReference != null) {
            result2.add((PsiReference)rootReference);
            nameParts.set(0, rootReference.getCanonicalText());
            ++offset2;
        }
        int i2 = result2.size();
        while (i2 < nameParts.size() && !(packageName = (String)nameParts.get(i2)).isEmpty()) {
            TextRange range = new TextRange(offset2, offset2 += packageName.length());
            String qualifiedNameSoFar = String.join((CharSequence)".", nameParts.subList(0, i2 + 1));
            result2.add((PsiReference)new AliasedReference(element2, range, qualifiedNameSoFar, module2));
            ++i2;
            ++offset2;
        }
    }

    @Nullable
    protected static BindingXmlIndex.Entry getBindingIndexEntry(@NotNull ConvertContext context) {
        if (context == null) {
            DataBindingConverter.$$$reportNull$$$0(7);
        }
        return DataBindingLangUtil.getBindingIndexEntry((PsiElement)context.getFile());
    }

    private static GlobalSearchScope enlargeScope(GlobalSearchScope scope2, Project project, PsiFile psiFile2) {
        SearchScope lightClassesScope = new AndroidResolveScopeEnlarger().getAdditionalResolveScope(psiFile2.getVirtualFile(), project);
        if (lightClassesScope != null) {
            scope2 = scope2.union(lightClassesScope);
        }
        return scope2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedShortName";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/converters/DataBindingConverter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/converters/DataBindingConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getImport";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unresolveImport";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBindingIndexEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ClassReference
    extends PsiReferenceBase<PsiElement> {
        @NotNull
        private final PsiElement myResolveTo;

        ClassReference(@NotNull PsiElement element2, @NotNull TextRange range, @NotNull PsiElement resolveTo) {
            if (element2 == null) {
                ClassReference.$$$reportNull$$$0(0);
            }
            if (range == null) {
                ClassReference.$$$reportNull$$$0(1);
            }
            if (resolveTo == null) {
                ClassReference.$$$reportNull$$$0(2);
            }
            super(element2, range, true);
            this.myResolveTo = resolveTo;
        }

        @Nullable
        public PsiElement resolve() {
            ResolveCache cache = ResolveCache.getInstance((Project)this.myElement.getProject());
            return (PsiElement)cache.resolveWithCaching((PsiReference)this, (psiReference, incompleteCode) -> this.resolveInner(), false, false);
        }

        private PsiElement resolveInner() {
            return this.myResolveTo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolveTo";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/dom/converters/DataBindingConverter$ClassReference";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AliasedReference
    extends PsiReferenceBase<PsiElement> {
        private final String myReferenceTo;
        private final Module myModule;

        AliasedReference(PsiElement referenceFrom, TextRange range, String referenceTo, Module module2) {
            super(referenceFrom, range, true);
            this.myReferenceTo = referenceTo;
            this.myModule = module2;
        }

        @Nullable
        public PsiElement resolve() {
            ResolveCache cache = ResolveCache.getInstance((Project)this.myElement.getProject());
            return (PsiElement)cache.resolveWithCaching((PsiReference)this, (psiReference, incompleteCode) -> this.resolveInner(), false, false);
        }

        private PsiElement resolveInner() {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myElement.getProject());
            PsiPackage aPackage = facade.findPackage(this.myReferenceTo);
            if (aPackage != null) {
                return aPackage;
            }
            Module module2 = this.myModule;
            GlobalSearchScope scope2 = module2 != null ? module2.getModuleWithDependenciesAndLibrariesScope(false) : this.myElement.getResolveScope();
            PsiClass aClass = facade.findClass(this.myReferenceTo, scope2 = DataBindingConverter.enlargeScope(scope2, this.myElement.getProject(), this.myElement.getContainingFile()));
            if (aClass != null) {
                return aClass;
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                AliasedReference.$$$reportNull$$$0(0);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myReferenceTo;
            if (string == null) {
                AliasedReference.$$$reportNull$$$0(1);
            }
            return string;
        }

        public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
            if (element2 == null) {
                AliasedReference.$$$reportNull$$$0(2);
            }
            if (element2 instanceof PsiClass) {
                PsiClass psiClass = (PsiClass)element2;
                String newName2 = psiClass.getQualifiedName();
                return ElementManipulators.handleContentChange((PsiElement)this.myElement, (String)newName2);
            }
            return super.bindToElement(element2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/dom/converters/DataBindingConverter$AliasedReference";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/dom/converters/DataBindingConverter$AliasedReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

