/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.utils.SdkUtils;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.DomCompletionContributor;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import java.util.ArrayList;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResourceReference
extends AndroidResourceReferenceBase {
    private final GenericDomValue<ResourceValue> myValue;
    private boolean myIncludeDynamicFeatures;

    public AndroidResourceReference(@NotNull GenericDomValue<ResourceValue> value2, @NotNull AndroidFacet facet2, @NotNull ResourceValue resourceValue2, boolean includeDynamicFeatures) {
        if (value2 == null) {
            AndroidResourceReference.$$$reportNull$$$0(0);
        }
        if (facet2 == null) {
            AndroidResourceReference.$$$reportNull$$$0(1);
        }
        if (resourceValue2 == null) {
            AndroidResourceReference.$$$reportNull$$$0(2);
        }
        super(value2, null, resourceValue2, facet2);
        this.myValue = value2;
        this.myIncludeDynamicFeatures = includeDynamicFeatures;
    }

    @Override
    public boolean includeDynamicFeatures() {
        return this.myIncludeDynamicFeatures;
    }

    @NotNull
    public Object[] getVariants() {
        Converter converter = this.getConverter();
        if ((converter instanceof EnumConverter || converter == AndroidDomUtil.BOOLEAN_CONVERTER) && DomCompletionContributor.isSchemaEnumerated((PsiElement)this.getElement())) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                AndroidResourceReference.$$$reportNull$$$0(3);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        if (converter instanceof ResolvingConverter) {
            ResolvingConverter resolvingConverter = (ResolvingConverter)converter;
            ArrayList<Object> result2 = new ArrayList<Object>();
            ConvertContext convertContext = ConvertContextFactory.createConvertContext(this.myValue);
            for (Object variant2 : resolvingConverter.getVariants(convertContext)) {
                String name = converter.toString(variant2, convertContext);
                if (name == null) continue;
                result2.add(ElementPresentationManager.getInstance().createVariant(variant2, name, resolvingConverter.getPsiElement(variant2)));
            }
            Object[] objectArray = result2.toArray();
            if (objectArray == null) {
                AndroidResourceReference.$$$reportNull$$$0(4);
            }
            return objectArray;
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            AndroidResourceReference.$$$reportNull$$$0(5);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            AndroidResourceReference.$$$reportNull$$$0(6);
        }
        if (newElementName.startsWith("@+id/")) {
            newElementName = IdeResourcesUtil.getResourceNameByReferenceText(newElementName);
        }
        ResourceValue value2 = (ResourceValue)this.myValue.getValue();
        assert (value2 != null);
        ResourceType resType = value2.getType();
        if (resType != null && newElementName != null) {
            String newText;
            Converter converter;
            ResourceFolderType folderType = FolderTypeRelationship.getNonValuesRelatedFolder((ResourceType)resType);
            String newResName = folderType != null && newElementName.contains(".") ? SdkUtils.fileNameToResourceName((String)newElementName) : newElementName;
            ResourceValue newValue = ResourceValue.parse(newResName, true, true, false);
            if (newValue == null || newValue.getPrefix() == '\u0000') {
                newValue = ResourceValue.referenceTo(value2.getPrefix(), value2.getPackage(), value2.getResourceType(), newResName);
            }
            if ((converter = this.getConverter()) != null && (newText = converter.toString((Object)newValue, this.createConvertContext())) != null) {
                return super.handleElementRename(newText);
            }
        }
        return this.myValue.getXmlTag();
    }

    @Nullable
    private Converter getConverter() {
        return WrappingConverter.getDeepestConverter((Converter)this.myValue.getConverter(), this.myValue);
    }

    @NotNull
    private ConvertContext createConvertContext() {
        ConvertContext convertContext = ConvertContextFactory.createConvertContext((DomInvocationHandler)DomManagerImpl.getDomInvocationHandler(this.myValue));
        if (convertContext == null) {
            AndroidResourceReference.$$$reportNull$$$0(7);
        }
        return convertContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceValue";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/converters/AndroidResourceReference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/converters/AndroidResourceReference";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createConvertContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

