/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.model.AndroidModel;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.android.AndroidApplicationPackageRenameProcessor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPackageConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        return s;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> value2, PsiElement element2, ConvertContext context) {
        String s = value2.getStringValue();
        PsiReference[] psiReferenceArray = s != null ? new MyPackageReferenceSet(s, element2).getPsiReferences() : PsiReference.EMPTY_ARRAY;
        if (psiReferenceArray == null) {
            AndroidPackageConverter.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/AndroidPackageConverter", "createReferences"));
    }

    private static class MyPsiPackageReference
    extends PsiPackageReference {
        private final MyPackageReferenceSet myReferenceSet;
        private final TextRange myTextRange;

        public MyPsiPackageReference(MyPackageReferenceSet referenceSet, TextRange textRange, int index2) {
            super((PackageReferenceSet)referenceSet, textRange, index2);
            this.myReferenceSet = referenceSet;
            this.myTextRange = textRange;
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{this.myElement});
            if (resolveResultArray == null) {
                MyPsiPackageReference.$$$reportNull$$$0(0);
            }
            return resolveResultArray;
        }

        public boolean isReferenceTo(@NotNull PsiElement element2) {
            ResolveResult[] results;
            if (element2 == null) {
                MyPsiPackageReference.$$$reportNull$$$0(1);
            }
            for (ResolveResult result2 : results = this.doMultiResolve()) {
                if (!this.getElement().getManager().areElementsEquivalent(result2.getElement(), element2)) continue;
                return true;
            }
            return false;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                MyPsiPackageReference.$$$reportNull$$$0(2);
            }
            return this.myElement;
        }

        public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
            if (element2 == null) {
                MyPsiPackageReference.$$$reportNull$$$0(3);
            }
            if (!(element2 instanceof PsiPackage) || !(this.myElement instanceof XmlAttributeValue)) {
                throw new IncorrectOperationException("Cannot bind to " + element2);
            }
            String newPackageName = ((PsiPackage)element2).getQualifiedName();
            String basePackage = ((XmlAttributeValue)this.myElement).getValue();
            String oldPackageName = this.myElement.getText().substring(this.myReferenceSet.myStartInElement, this.myTextRange.getEndOffset());
            PsiFile file2 = this.myElement.getContainingFile();
            if (!basePackage.isEmpty() && file2 instanceof XmlFile) {
                AndroidApplicationPackageRenameProcessor.processAllAttributesToUpdate((XmlFile)file2, basePackage, oldPackageName, newPackageName, new Processor<Pair<GenericAttributeValue, String>>(){

                    public boolean process(Pair<GenericAttributeValue, String> pair) {
                        ((GenericAttributeValue)pair.getFirst()).setStringValue((String)pair.getSecond());
                        return true;
                    }
                });
            }
            return this.myElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/dom/converters/AndroidPackageConverter$MyPsiPackageReference";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolve";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/dom/converters/AndroidPackageConverter$MyPsiPackageReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyPackageReferenceSet
    extends PackageReferenceSet {
        final int myStartInElement;

        public MyPackageReferenceSet(String s, PsiElement element2) {
            this(s, element2, ElementManipulators.getOffsetInElement((PsiElement)element2));
        }

        public MyPackageReferenceSet(String str, PsiElement element2, int startInElement) {
            super(str, element2, startInElement);
            this.myStartInElement = startInElement;
        }

        @NotNull
        protected PsiPackageReference createReference(TextRange range, int index2) {
            AndroidModel androidModel;
            AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)this.getElement());
            if (facet2 != null && ((androidModel = AndroidModel.get(facet2)) != null && androidModel.overridesManifestPackage() || ((AndroidFacetConfiguration)facet2.getConfiguration()).isLibraryProject())) {
                return new PsiPackageReference((PackageReferenceSet)this, range, index2);
            }
            return new MyPsiPackageReference(this, range, index2);
        }
    }
}

