/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.attrs;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.resources.base.CommentTrackingXmlPullParser;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.dom.attrs.StyleableDefinitionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class AttributeDefinitionsImpl
implements AttributeDefinitions {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.dom.attrs.AttributeDefinitionsImpl");
    private static final Splitter PIPE_SPLITTER = Splitter.on((char)'|').trimResults();
    @NotNull
    private final Map<ResourceReference, AttributeDefinition> myAttrs = new HashMap<ResourceReference, AttributeDefinition>();
    @NotNull
    private final Map<ResourceReference, StyleableDefinitionImpl> myStyleables = new HashMap<ResourceReference, StyleableDefinitionImpl>();
    @Nullable
    private final AttributeDefinitions myFrameworkAttributeDefinitions;

    private AttributeDefinitionsImpl(@Nullable AttributeDefinitions frameworkAttributeDefinitions) {
        this.myFrameworkAttributeDefinitions = frameworkAttributeDefinitions;
    }

    @NotNull
    public static AttributeDefinitions parseFrameworkFiles(File ... files2) {
        if (files2 == null) {
            AttributeDefinitionsImpl.$$$reportNull$$$0(0);
        }
        AttributeDefinitionsImpl attributeDefinitions = new AttributeDefinitionsImpl(null);
        for (File file2 : files2) {
            attributeDefinitions.addAttrsFromFile(file2);
        }
        AttributeDefinitionsImpl attributeDefinitionsImpl = attributeDefinitions;
        if (attributeDefinitionsImpl == null) {
            AttributeDefinitionsImpl.$$$reportNull$$$0(1);
        }
        return attributeDefinitionsImpl;
    }

    @NotNull
    public static AttributeDefinitions create(@Nullable AttributeDefinitions frameworkAttributeDefinitions, @NotNull ResourceRepository resources) {
        if (resources == null) {
            AttributeDefinitionsImpl.$$$reportNull$$$0(2);
        }
        AttributeDefinitionsImpl attributeDefinitions = new AttributeDefinitionsImpl(frameworkAttributeDefinitions);
        attributeDefinitions.initializeFromResourceRepository(resources);
        AttributeDefinitionsImpl attributeDefinitionsImpl = attributeDefinitions;
        if (attributeDefinitionsImpl == null) {
            AttributeDefinitionsImpl.$$$reportNull$$$0(3);
        }
        return attributeDefinitionsImpl;
    }

    private void initializeFromResourceRepository(@NotNull ResourceRepository resources) {
        ResourceValue resourceValue2;
        Collection items2;
        if (resources == null) {
            AttributeDefinitionsImpl.$$$reportNull$$$0(4);
        }
        for (ResourceNamespace namespace : resources.getNamespaces()) {
            items2 = resources.getResources(namespace, ResourceType.ATTR).values();
            for (ResourceItem item : items2) {
                resourceValue2 = item.getResourceValue();
                if (!(resourceValue2 instanceof AttrResourceValue)) continue;
                this.createOrUpdateAttributeDefinition((AttrResourceValue)resourceValue2, null);
            }
        }
        for (ResourceNamespace namespace : resources.getNamespaces()) {
            items2 = resources.getResources(namespace, ResourceType.STYLEABLE).values();
            for (ResourceItem item : items2) {
                resourceValue2 = item.getResourceValue();
                if (!(resourceValue2 instanceof StyleableResourceValue)) continue;
                StyleableResourceValue styleableValue = (StyleableResourceValue)resourceValue2;
                ResourceReference reference2 = styleableValue.asReference();
                StyleableDefinitionImpl styleable = this.myStyleables.computeIfAbsent(reference2, ref -> new StyleableDefinitionImpl(namespace, styleableValue.getName()));
                for (AttrResourceValue attrValue : styleableValue.getAllAttributes()) {
                    this.createOrUpdateAttributeDefinition(attrValue, styleable);
                }
            }
        }
    }

    private void createOrUpdateAttributeDefinition(@NotNull AttrResourceValue attrValue, @Nullable StyleableDefinitionImpl parentStyleable) {
        String groupName;
        String description2;
        ResourceReference attrRef;
        AttributeDefinition attr;
        if (attrValue == null) {
            AttributeDefinitionsImpl.$$$reportNull$$$0(5);
        }
        if ((attr = this.myAttrs.get(attrRef = attrValue.asReference())) == null) {
            if (this.myFrameworkAttributeDefinitions != null && attrValue.getNamespace().equals((Object)ResourceNamespace.ANDROID) && (attr = this.myFrameworkAttributeDefinitions.getAttrDefinition(attrRef)) != null) {
                attr = new AttributeDefinition(attr);
            }
            if (attr == null) {
                attr = new AttributeDefinition(attrValue.getNamespace(), attrValue.getName(), attrValue.getLibraryName(), null);
            }
            this.myAttrs.put(attrRef, attr);
        }
        attr.addFormats(attrValue.getFormats());
        Map valueMappings = attrValue.getAttributeValues();
        if (!valueMappings.isEmpty()) {
            attr.setValueMappings(valueMappings);
            HashMap valueDescriptions = Maps.newHashMapWithExpectedSize((int)valueMappings.size());
            for (String value2 : valueMappings.keySet()) {
                String description3 = attrValue.getValueDescription(value2);
                if (description3 == null) continue;
                valueDescriptions.put(value2, description3);
            }
            if (!valueDescriptions.isEmpty()) {
                attr.setValueDescriptions(valueDescriptions);
            }
        }
        if ((description2 = attrValue.getDescription()) != null) {
            attr.setDescription(description2, parentStyleable == null ? null : parentStyleable.getResourceReference());
        }
        if ((groupName = attrValue.getGroupName()) != null) {
            attr.setGroupName(groupName);
        }
        if (parentStyleable != null) {
            parentStyleable.addAttribute(attr);
        }
    }

    private void addAttrsFromFile(@NotNull File file2) {
        if (file2 == null) {
            AttributeDefinitionsImpl.$$$reportNull$$$0(6);
        }
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file2));){
            int event;
            CommentTrackingXmlPullParser parser = new CommentTrackingXmlPullParser();
            parser.setInput(stream, null);
            StyleableDefinitionImpl styleable = null;
            do {
                event = parser.nextToken();
                int depth = parser.getDepth();
                block4 : switch (event) {
                    case 2: {
                        String tagName = parser.getName();
                        if (depth == 1) {
                            if (tagName.equals("resources")) break;
                            return;
                        }
                        if (depth <= 1) break;
                        switch (tagName) {
                            case "attr": {
                                this.processAttrTag((XmlPullParser)parser, file2, parser.getLastComment(), parser.getAttrGroupComment(), styleable);
                                break block4;
                            }
                            case "declare-styleable": {
                                if (styleable != null) {
                                    LOG.info("Found nested declare-styleable tag at " + file2.getAbsolutePath() + " line " + parser.getLineNumber());
                                    break block4;
                                }
                                String styleableName = parser.getAttributeValue(null, "name");
                                if (styleableName == null) {
                                    LOG.info("Found declare-styleable tag with no name at " + file2.getAbsolutePath() + " line " + parser.getLineNumber());
                                    break block4;
                                }
                                styleable = new StyleableDefinitionImpl(ResourceNamespace.ANDROID, styleableName);
                                this.myStyleables.put(styleable.getResourceReference(), styleable);
                                break block4;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (!parser.getName().equals("declare-styleable")) break;
                        styleable = null;
                    }
                }
            } while (event != 1);
        }
        catch (IOException | XmlPullParserException e) {
            LOG.warn("Failed to parse " + file2.getAbsolutePath(), e);
        }
    }

    private void processAttrTag(@NotNull XmlPullParser parser, @NotNull File file2, @Nullable String precedingComment, @Nullable String attrGroup, @Nullable StyleableDefinitionImpl parentStyleable) throws IOException, XmlPullParserException {
        int event;
        String attrName;
        if (parser == null) {
            AttributeDefinitionsImpl.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            AttributeDefinitionsImpl.$$$reportNull$$$0(8);
        }
        if ((attrName = parser.getAttributeValue(null, "name")) == null) {
            LOG.info("Found attr tag with no name at " + file2.getAbsolutePath() + " line " + parser.getLineNumber());
            return;
        }
        if (attrName.startsWith("android:")) {
            attrName = attrName.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN);
        }
        if (attrName.indexOf(58) >= 0) {
            LOG.info("Found attr tag with an invalid name at " + file2.getAbsolutePath() + " line " + parser.getLineNumber());
            return;
        }
        AttributeDefinition attrDef = this.myAttrs.get(ResourceReference.attr((ResourceNamespace)ResourceNamespace.ANDROID, (String)attrName));
        if (attrDef == null) {
            attrDef = new AttributeDefinition(ResourceNamespace.ANDROID, attrName, null, null);
            attrDef.setGroupName(attrGroup);
            this.myAttrs.put(attrDef.getResourceReference(), attrDef);
        }
        if (parentStyleable != null) {
            parentStyleable.addAttribute(attrDef);
        }
        EnumSet<AttributeFormat> formats = EnumSet.noneOf(AttributeFormat.class);
        String format2 = parser.getAttributeValue(null, "format");
        if (format2 != null) {
            formats.addAll(AttributeDefinitionsImpl.parseAttrFormat(format2));
        }
        HashMap<String, Integer> valueMappings = null;
        HashMap<String, String> valueDescriptions = null;
        String lastComment = null;
        int attrTagDepth = parser.getDepth();
        do {
            event = parser.nextToken();
            switch (event) {
                case 2: {
                    Integer intValue;
                    String tagName = parser.getName();
                    if (tagName.equals("enum") && !formats.contains(AttributeFormat.FLAGS)) {
                        formats.add(AttributeFormat.ENUM);
                    } else if (tagName.equals("flag") && !formats.contains(AttributeFormat.ENUM)) {
                        formats.add(AttributeFormat.FLAGS);
                    }
                    String valueName = parser.getAttributeValue(null, "name");
                    if (valueName == null) {
                        LOG.info("Unknown value for tag: " + tagName);
                        break;
                    }
                    String strIntValue = parser.getAttributeValue(null, "value");
                    Integer n = intValue = strIntValue == null ? null : AttributeDefinitionsImpl.decodeIntegerValue(strIntValue);
                    if (valueMappings == null) {
                        valueMappings = new HashMap<String, Integer>();
                    }
                    valueMappings.putIfAbsent(valueName, intValue);
                    if (lastComment != null) {
                        if (valueDescriptions == null) {
                            valueDescriptions = new HashMap<String, String>();
                        }
                        valueDescriptions.putIfAbsent(valueName, lastComment);
                    }
                    lastComment = null;
                    break;
                }
                case 9: {
                    String commentText = parser.getText().trim();
                    if (AttributeDefinitionsImpl.isEmptyOrAsciiArt(commentText)) break;
                    lastComment = commentText;
                    break;
                }
            }
        } while (event != 3 || parser.getDepth() > attrTagDepth);
        attrDef.addFormats(formats);
        if (precedingComment != null) {
            attrDef.setDescription(precedingComment, parentStyleable == null ? null : parentStyleable.getResourceReference());
        }
        if (valueMappings != null) {
            attrDef.setValueMappings(valueMappings);
        }
        if (valueDescriptions != null) {
            attrDef.setValueDescriptions(valueDescriptions);
        }
    }

    @Nullable
    private static Integer decodeIntegerValue(@NotNull String value2) {
        if (value2 == null) {
            AttributeDefinitionsImpl.$$$reportNull$$$0(9);
        }
        try {
            return Long.decode(value2).intValue();
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static boolean isEmptyOrAsciiArt(@NotNull String commentText) {
        if (commentText == null) {
            AttributeDefinitionsImpl.$$$reportNull$$$0(10);
        }
        return commentText.isEmpty() || commentText.charAt(0) == '*' || commentText.charAt(0) == '=';
    }

    @NotNull
    private static Set<AttributeFormat> parseAttrFormat(@NotNull String formatString) {
        if (formatString == null) {
            AttributeDefinitionsImpl.$$$reportNull$$$0(11);
        }
        List formats = PIPE_SPLITTER.splitToList((CharSequence)formatString);
        EnumSet<AttributeFormat> result2 = EnumSet.noneOf(AttributeFormat.class);
        for (String format2 : formats) {
            AttributeFormat attributeFormat = AttributeFormat.fromXmlName((String)format2);
            if (attributeFormat == null) continue;
            result2.add(attributeFormat);
        }
        EnumSet<AttributeFormat> enumSet = result2;
        if (enumSet == null) {
            AttributeDefinitionsImpl.$$$reportNull$$$0(12);
        }
        return enumSet;
    }

    @Override
    @Nullable
    public StyleableDefinition getStyleableDefinition(@NotNull ResourceReference styleable) {
        if (styleable == null) {
            AttributeDefinitionsImpl.$$$reportNull$$$0(13);
        }
        if (this.myFrameworkAttributeDefinitions != null && styleable.getNamespace().equals((Object)ResourceNamespace.ANDROID)) {
            return this.myFrameworkAttributeDefinitions.getStyleableDefinition(styleable);
        }
        return this.myStyleables.get(styleable);
    }

    @Override
    @Deprecated
    @Nullable
    public StyleableDefinition getStyleableByName(@NotNull String name) {
        StyleableDefinition styleable;
        if (name == null) {
            AttributeDefinitionsImpl.$$$reportNull$$$0(14);
        }
        if ((styleable = this.getStyleableDefinition(ResourceReference.styleable((ResourceNamespace)ResourceNamespace.TODO(), (String)name))) == null) {
            styleable = this.getStyleableDefinition(ResourceReference.styleable((ResourceNamespace)ResourceNamespace.ANDROID, (String)name));
        }
        return styleable;
    }

    @Override
    @NotNull
    public Set<ResourceReference> getAttrs() {
        Set<ResourceReference> set = this.myAttrs.keySet();
        if (set == null) {
            AttributeDefinitionsImpl.$$$reportNull$$$0(15);
        }
        return set;
    }

    @Override
    @Nullable
    public AttributeDefinition getAttrDefinition(@NotNull ResourceReference attr) {
        AttributeDefinition attributeDefinition;
        if (attr == null) {
            AttributeDefinitionsImpl.$$$reportNull$$$0(16);
        }
        if ((attributeDefinition = this.myAttrs.get(attr)) == null && this.myFrameworkAttributeDefinitions != null && attr.getNamespace().equals((Object)ResourceNamespace.ANDROID)) {
            return this.myFrameworkAttributeDefinitions.getAttrDefinition(attr);
        }
        return attributeDefinition;
    }

    @Override
    @Deprecated
    @Nullable
    public AttributeDefinition getAttrDefByName(@NotNull String name) {
        if (name == null) {
            AttributeDefinitionsImpl.$$$reportNull$$$0(17);
        }
        ResourceReference attr = name.startsWith("android:") ? ResourceReference.attr((ResourceNamespace)ResourceNamespace.ANDROID, (String)name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN)) : (this.myFrameworkAttributeDefinitions == null ? ResourceReference.attr((ResourceNamespace)ResourceNamespace.ANDROID, (String)name) : ResourceReference.attr((ResourceNamespace)ResourceNamespace.TODO(), (String)name));
        return this.getAttrDefinition(attr);
    }

    @Override
    @Nullable
    public String getAttrGroup(@NotNull ResourceReference attr) {
        AttributeDefinition attributeDefinition;
        if (attr == null) {
            AttributeDefinitionsImpl.$$$reportNull$$$0(18);
        }
        return (attributeDefinition = this.getAttrDefinition(attr)) == null ? null : attributeDefinition.getGroupName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: 
            case 3: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/attrs/AttributeDefinitionsImpl";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrValue";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentText";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatString";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleable";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/attrs/AttributeDefinitionsImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFrameworkFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAttrFormat";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttrs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseFrameworkFiles";
                break;
            }
            case 1: 
            case 3: 
            case 12: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initializeFromResourceRepository";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createOrUpdateAttributeDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAttrsFromFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processAttrTag";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "decodeIntegerValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyOrAsciiArt";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseAttrFormat";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStyleableDefinition";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getStyleableByName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAttrDefinition";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAttrDefByName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAttrGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

