/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.attrs;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AttributeDefinition
implements Cloneable {
    @NotNull
    private final ResourceReference myAttr;
    @Nullable
    private final String myLibraryName;
    @Nullable
    private String myGlobalDescription;
    @Nullable
    private String myGroupName;
    @NotNull
    private Map<String, Integer> myValueMappings;
    @NotNull
    private Map<String, String> myValueDescriptions;
    @NotNull
    private Set<AttributeFormat> myFormats;
    @Nullable
    private Map<ResourceReference, String> myDescriptionsInStyleableContexts;

    public AttributeDefinition(@NotNull ResourceNamespace namespace, @NotNull String name) {
        if (namespace == null) {
            AttributeDefinition.$$$reportNull$$$0(0);
        }
        if (name == null) {
            AttributeDefinition.$$$reportNull$$$0(1);
        }
        this(namespace, name, null, null);
    }

    public AttributeDefinition(@NotNull ResourceNamespace namespace, @NotNull String name, @Nullable String libraryName, @Nullable Collection<AttributeFormat> formats) {
        if (namespace == null) {
            AttributeDefinition.$$$reportNull$$$0(2);
        }
        if (name == null) {
            AttributeDefinition.$$$reportNull$$$0(3);
        }
        this.myValueMappings = Collections.emptyMap();
        this.myValueDescriptions = Collections.emptyMap();
        assert (name.indexOf(58) < 0);
        this.myAttr = ResourceReference.attr((ResourceNamespace)namespace, (String)name);
        this.myLibraryName = libraryName;
        this.myFormats = formats == null || formats.isEmpty() ? EnumSet.noneOf(AttributeFormat.class) : EnumSet.copyOf(formats);
    }

    public AttributeDefinition(@NotNull AttributeDefinition other) {
        if (other == null) {
            AttributeDefinition.$$$reportNull$$$0(4);
        }
        this.myValueMappings = Collections.emptyMap();
        this.myValueDescriptions = Collections.emptyMap();
        this.myAttr = other.myAttr;
        this.myLibraryName = other.myLibraryName;
        this.myGlobalDescription = other.myGlobalDescription;
        this.myGroupName = other.myGroupName;
        this.myValueMappings = other.myValueMappings;
        this.myValueDescriptions = other.myValueDescriptions;
        this.myFormats = EnumSet.copyOf(other.myFormats);
        this.myDescriptionsInStyleableContexts = other.myDescriptionsInStyleableContexts == null ? null : new HashMap<ResourceReference, String>(other.myDescriptionsInStyleableContexts);
    }

    @Nullable
    public Integer getValueMapping(@NotNull String flagName) {
        if (flagName == null) {
            AttributeDefinition.$$$reportNull$$$0(5);
        }
        return this.myValueMappings.get(flagName);
    }

    @NotNull
    public ResourceReference getResourceReference() {
        ResourceReference resourceReference = this.myAttr;
        if (resourceReference == null) {
            AttributeDefinition.$$$reportNull$$$0(6);
        }
        return resourceReference;
    }

    @NotNull
    public String getName() {
        String string = this.myAttr.getName();
        if (string == null) {
            AttributeDefinition.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public String getLibraryName() {
        return this.myLibraryName;
    }

    @NotNull
    public Set<AttributeFormat> getFormats() {
        Set<AttributeFormat> set = Collections.unmodifiableSet(this.myFormats);
        if (set == null) {
            AttributeDefinition.$$$reportNull$$$0(8);
        }
        return set;
    }

    @Nullable
    public String getGroupName() {
        return this.myGroupName;
    }

    @NotNull
    public String[] getValues() {
        String[] stringArray = this.myValueMappings.isEmpty() ? ArrayUtil.EMPTY_STRING_ARRAY : ArrayUtil.toStringArray(this.myValueMappings.keySet());
        if (stringArray == null) {
            AttributeDefinition.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    @Nullable
    public String getDescription(@Nullable ResourceReference parentStyleable) {
        String description2 = parentStyleable == null || this.myDescriptionsInStyleableContexts == null ? null : this.myDescriptionsInStyleableContexts.get(parentStyleable);
        return description2 == null ? this.myGlobalDescription : description2;
    }

    @Deprecated
    @Nullable
    public String getDescriptionByParentStyleableName(@Nullable String parentStyleable) {
        if (parentStyleable == null || this.myDescriptionsInStyleableContexts == null) {
            return this.myGlobalDescription;
        }
        String description2 = this.myDescriptionsInStyleableContexts.get(ResourceReference.styleable((ResourceNamespace)ResourceNamespace.TODO(), (String)parentStyleable));
        if (description2 == null) {
            description2 = this.myDescriptionsInStyleableContexts.get(ResourceReference.styleable((ResourceNamespace)ResourceNamespace.ANDROID, (String)parentStyleable));
        }
        return description2 == null ? this.myGlobalDescription : description2;
    }

    @Nullable
    public String getValueDescription(@NotNull String value2) {
        if (value2 == null) {
            AttributeDefinition.$$$reportNull$$$0(10);
        }
        return this.myValueDescriptions.get(value2);
    }

    public boolean isAttributeDeprecated() {
        return this.myGlobalDescription != null && StringUtil.containsIgnoreCase((String)this.myGlobalDescription, (String)"deprecated");
    }

    public boolean isValueDeprecated(@NotNull String value2) {
        String description2;
        if (value2 == null) {
            AttributeDefinition.$$$reportNull$$$0(11);
        }
        return (description2 = this.getValueDescription(value2)) != null && StringUtil.containsIgnoreCase((String)description2, (String)"deprecated");
    }

    void addFormats(@NotNull Collection<AttributeFormat> formats) {
        if (formats == null) {
            AttributeDefinition.$$$reportNull$$$0(12);
        }
        this.myFormats.addAll(formats);
    }

    public void setValueMappings(@NotNull Map<String, Integer> valueMappings) {
        if (valueMappings == null) {
            AttributeDefinition.$$$reportNull$$$0(13);
        }
        if (!this.myValueMappings.isEmpty() && !this.myValueMappings.equals(valueMappings)) {
            AttributeDefinition.getLog().warn("An attempt to redefine value mappings of " + this.myAttr.getQualifiedName());
        }
        this.myValueMappings = Collections.unmodifiableMap(valueMappings);
    }

    void setValueDescriptions(@NotNull Map<String, String> valueDescriptions) {
        if (valueDescriptions == null) {
            AttributeDefinition.$$$reportNull$$$0(14);
        }
        if (!this.myValueDescriptions.isEmpty() && !this.myValueDescriptions.equals(valueDescriptions)) {
            AttributeDefinition.getLog().warn("An attempt to redefine value descriptions of " + this.myAttr.getQualifiedName());
        }
        this.myValueDescriptions = Collections.unmodifiableMap(valueDescriptions);
    }

    void setGroupName(@Nullable String groupName) {
        this.myGroupName = groupName;
    }

    void setDescription(@NotNull String description2, @Nullable ResourceReference parentStyleable) {
        if (description2 == null) {
            AttributeDefinition.$$$reportNull$$$0(15);
        }
        if (parentStyleable == null || this.myGlobalDescription == null) {
            this.myGlobalDescription = description2;
        }
        if (parentStyleable != null) {
            if (this.myDescriptionsInStyleableContexts == null) {
                this.myDescriptionsInStyleableContexts = new HashMap<ResourceReference, String>(3);
            }
            this.myDescriptionsInStyleableContexts.put(parentStyleable, description2);
        }
    }

    public String toString() {
        return this.myAttr.getQualifiedName() + " [" + this.myFormats + "]";
    }

    private static Logger getLog() {
        return Logger.getInstance(AttributeDefinition.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flagName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/attrs/AttributeDefinition";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formats";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueMappings";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueDescriptions";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/attrs/AttributeDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceReference";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormats";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValueMapping";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getValueDescription";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isValueDeprecated";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addFormats";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setValueMappings";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setValueDescriptions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

