/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.utils.Pair;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.XmlUtil;
import java.util.HashSet;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.annotations.NotNull;

public class XmlTagInnerClassInsertHandler
implements InsertHandler<LookupElement> {
    public static final XmlTagInnerClassInsertHandler INSTANCE = new XmlTagInnerClassInsertHandler();

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        XmlAttributeDescriptor[] attributes;
        if (context == null) {
            XmlTagInnerClassInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            XmlTagInnerClassInsertHandler.$$$reportNull$$$0(1);
        }
        Project project = context.getProject();
        Editor editor2 = context.getEditor();
        Document document = editor2.getDocument();
        PsiElement invalidElement = context.getFile().findElementAt(context.getStartOffset());
        if (invalidElement == null) {
            return;
        }
        XmlTag invalidTag = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)invalidElement, XmlTag.class, (boolean)true);
        if (invalidTag == null) {
            return;
        }
        XmlElementDescriptor descriptor2 = invalidTag.getDescriptor();
        XmlAttributeDescriptor[] xmlAttributeDescriptorArray = attributes = descriptor2 != null ? descriptor2.getAttributesDescriptors(invalidTag) : null;
        if (!(item.getObject() instanceof PsiClass)) {
            return;
        }
        PsiClass psiClass = (PsiClass)item.getObject();
        String className2 = PackageClassConverter.getQualifiedName(psiClass);
        String replacement = "view class=\"" + className2 + "\"";
        int sOffset = invalidElement.getTextRange().getStartOffset();
        int eOffset = invalidElement.getTextRange().getEndOffset();
        document.deleteString(sOffset, eOffset);
        document.insertString(sOffset, (CharSequence)replacement);
        sOffset += replacement.length();
        if (context.getCompletionChar() != '\r') {
            context.setAddCompletionChar(false);
        }
        int caretOffset = -1;
        if (XmlUtil.getTokenOfType((PsiElement)invalidTag, (IElementType)XmlTokenType.XML_TAG_END) == null && XmlUtil.getTokenOfType((PsiElement)invalidTag, (IElementType)XmlTokenType.XML_EMPTY_ELEMENT_END) == null) {
            int startIndent = XmlTagInnerClassInsertHandler.findStartIndent(document, context.getStartOffset() - 2);
            if (attributes != null) {
                Pair<Integer, Integer> result2 = XmlTagInnerClassInsertHandler.addRequiredAttributes(attributes, invalidTag, document, sOffset, startIndent + 4);
                sOffset = (Integer)result2.getFirst();
                caretOffset = (Integer)result2.getSecond();
            }
            String indent = StringUtil.repeatSymbol((char)' ', (int)startIndent);
            Object endTag = XmlTagInnerClassInsertHandler.isLayout(psiClass) ? ">\n\n" + indent + "</view>" : "/>";
            document.insertString(sOffset, (CharSequence)endTag);
            sOffset += ((String)endTag).length();
        } else if (context.getCompletionChar() == '\t') {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiElement otherTag = PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(context.getStartOffset()), XmlTag.class);
            XmlToken endTagStart = XmlUtil.getTokenOfType((PsiElement)otherTag, (IElementType)XmlTokenType.XML_END_TAG_START);
            if (endTagStart != null) {
                PsiElement sibling = endTagStart.getNextSibling();
                assert (sibling != null);
                ASTNode node2 = sibling.getNode();
                assert (node2 != null);
                if (node2.getElementType() == XmlTokenType.XML_NAME) {
                    sOffset = sibling.getTextRange().getStartOffset();
                    eOffset = sibling.getTextRange().getEndOffset();
                    document.deleteString(sOffset, eOffset);
                    document.insertString(sOffset, (CharSequence)((XmlTag)otherTag).getName());
                }
            }
        }
        if (caretOffset < 0) {
            caretOffset = sOffset;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        editor2.getCaretModel().moveToOffset(caretOffset);
        editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor2.getSelectionModel().removeSelection();
    }

    @NotNull
    private static Pair<Integer, Integer> addRequiredAttributes(@NotNull XmlAttributeDescriptor[] attributes, @NotNull XmlTag tag, @NotNull Document document, int offset2, int indentSize) {
        if (tag == null) {
            XmlTagInnerClassInsertHandler.$$$reportNull$$$0(2);
        }
        if (document == null) {
            XmlTagInnerClassInsertHandler.$$$reportNull$$$0(3);
        }
        if (attributes == null) {
            XmlTagInnerClassInsertHandler.$$$reportNull$$$0(4);
        }
        int cursorOffset = -1;
        String indent = StringUtil.repeatSymbol((char)' ', (int)indentSize);
        for (XmlAttributeDescriptor attribute : attributes) {
            String attributeName = attribute.getName((PsiElement)tag);
            if (!attribute.isRequired()) continue;
            String attrText = "\n" + indent + attributeName + "=\"\"";
            document.insertString(offset2, (CharSequence)attrText);
            offset2 += attrText.length();
            if (cursorOffset >= 0) continue;
            cursorOffset = offset2 - 1;
        }
        Pair pair = Pair.of((Object)offset2, (Object)cursorOffset);
        if (pair == null) {
            XmlTagInnerClassInsertHandler.$$$reportNull$$$0(5);
        }
        return pair;
    }

    private static boolean isLayout(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            XmlTagInnerClassInsertHandler.$$$reportNull$$$0(6);
        }
        HashSet<PsiClass> visited = new HashSet<PsiClass>();
        while (psiClass != null && visited.add(psiClass)) {
            if ("android.view.ViewGroup".equals(psiClass.getQualifiedName())) {
                return true;
            }
            psiClass = psiClass.getSuperClass();
        }
        return false;
    }

    private static int findStartIndent(@NotNull Document document, int offset2) {
        if (document == null) {
            XmlTagInnerClassInsertHandler.$$$reportNull$$$0(7);
        }
        int indent = 0;
        CharSequence text2 = document.getCharsSequence();
        while (offset2 > 0 && text2.charAt(offset2) == ' ') {
            --offset2;
            ++indent;
        }
        return indent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/XmlTagInnerClassInsertHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/XmlTagInnerClassInsertHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addRequiredAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addRequiredAttributes";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isLayout";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findStartIndent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

