/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.google.common.collect.Multimap;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.XmlName;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.function.Predicate;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.navigation.NavElement;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.dom.xml.PreferenceElementBase;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class SubtagsProcessingUtil {
    private SubtagsProcessingUtil() {
    }

    public static void registerXmlResourcesSubtags(@NotNull AndroidFacet facet2, @NotNull XmlTag tag, @NotNull SubtagProcessor subtagProcessor, boolean processExistingSubTags) {
        String tagName;
        if (facet2 == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(0);
        }
        if (tag == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(1);
        }
        if (subtagProcessor == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(2);
        }
        switch (tagName = tag.getName()) {
            case "searchable": {
                subtagProcessor.processSubtag("actionkey", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "Keyboard": {
                subtagProcessor.processSubtag("Row", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "Row": {
                subtagProcessor.processSubtag("Key", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "device-admin": {
                subtagProcessor.processSubtag("uses-policies", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "uses-policies": {
                subtagProcessor.processSubtag("limit-password", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("watch-login", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("reset-password", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("force-lock", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("wipe-data", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("set-global-proxy", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("expire-password", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("encrypted-storage", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("disable-camera", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("disable-keyguard-features", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "preference-headers": {
                subtagProcessor.processSubtag("header", (Type)((Object)PreferenceElementBase.class));
            }
        }
    }

    private static void registerSubtags(@NotNull XmlTag tag, @NotNull Collection<String> allowedTags, @NotNull Collection<String> tagsToComplete, @NotNull Type type, @NotNull SubtagProcessor subtagProcessor, boolean processExistingSubTags) {
        if (tag == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(3);
        }
        if (allowedTags == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(4);
        }
        if (tagsToComplete == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(5);
        }
        if (type == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(6);
        }
        if (subtagProcessor == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(7);
        }
        for (String tagName : tagsToComplete) {
            subtagProcessor.processSubtag(tagName, type);
        }
        if (processExistingSubTags) {
            SubtagsProcessingUtil.processExistingSubTags(tag, allowedTags::contains, type, subtagProcessor);
        }
    }

    public static void processSubTags(@NotNull AndroidFacet facet2, @NotNull AndroidDomElement element2, boolean processExistingSubTags, @NotNull SubtagProcessor subtagProcessor) {
        if (facet2 == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(8);
        }
        if (element2 == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(9);
        }
        if (subtagProcessor == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(10);
        }
        if (element2 instanceof XmlResourceElement) {
            XmlTag tag = element2.getXmlTag();
            if (tag != null) {
                SubtagsProcessingUtil.registerXmlResourcesSubtags(facet2, tag, subtagProcessor, true);
            }
        } else if (element2 instanceof NavElement) {
            try {
                NavigationSchema.createIfNecessary(facet2.getModule());
            }
            catch (ClassNotFoundException e) {
                return;
            }
            NavigationSchema schema = NavigationSchema.get(facet2.getModule());
            Multimap<Class<? extends AndroidDomElement>, String> subtags = schema.getDestinationSubtags(element2.getXmlTag().getName());
            for (Class c : subtags.keys()) {
                SubtagsProcessingUtil.registerSubtags(element2.getXmlTag(), subtags.get((Object)c), subtags.get((Object)c), c, subtagProcessor, processExistingSubTags);
            }
        }
    }

    private static void processExistingSubTags(@NotNull XmlTag tag, @NotNull Predicate<String> filter2, @NotNull Type type, @NotNull SubtagProcessor subtagProcessor) {
        XmlTag[] subtags;
        if (tag == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(11);
        }
        if (filter2 == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(12);
        }
        if (type == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(13);
        }
        if (subtagProcessor == null) {
            SubtagsProcessingUtil.$$$reportNull$$$0(14);
        }
        for (XmlTag subtag : subtags = tag.getSubTags()) {
            String localName = subtag.getLocalName();
            if (!filter2.test(localName) || localName.endsWith(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED)) continue;
            subtagProcessor.processSubtag(new XmlName(localName), type);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subtagProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedTags";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagsToComplete";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/dom/SubtagsProcessingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerXmlResourcesSubtags";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "registerSubtags";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "processSubTags";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "processExistingSubTags";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface SubtagProcessor {
        public void processSubtag(@NotNull XmlName var1, @NotNull Type var2);

        default public void processSubtag(@NotNull String xmlName, @NotNull Type type) {
            if (xmlName == null) {
                SubtagProcessor.$$$reportNull$$$0(0);
            }
            if (type == null) {
                SubtagProcessor.$$$reportNull$$$0(1);
            }
            this.processSubtag(new XmlName(xmlName), type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "xmlName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/dom/SubtagsProcessingUtil$SubtagProcessor";
            objectArray[2] = "processSubtag";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

