/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.layout.AndroidLayoutNSDescriptor;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.dom.xml.XmlResourceNSDescriptor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.TagFromClassDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlExtension
extends DefaultXmlExtension {
    private static final SchemaPrefix EMPTY_SCHEMA = new SchemaPrefix(null, new TextRange(0, 0), "android");

    @Nullable
    public XmlNSDescriptor getNSDescriptor(XmlTag element2, String namespace, boolean strict) {
        boolean isRoot;
        XmlFile file2 = (XmlFile)element2.getContainingFile();
        boolean bl = isRoot = file2.getRootTag() == element2;
        if (isRoot && AndroidResourceDomFileDescription.isFileInResourceFolderType(file2, ResourceFolderType.LAYOUT)) {
            return AndroidLayoutNSDescriptor.INSTANCE;
        }
        if (isRoot && AndroidResourceDomFileDescription.isFileInResourceFolderType(file2, ResourceFolderType.XML)) {
            return XmlResourceNSDescriptor.INSTANCE;
        }
        return super.getNSDescriptor(element2, namespace, strict);
    }

    @Nullable
    public TagNameReference createTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        return new TagNameReference(nameElement, startTagFlag){

            public boolean isSoft() {
                return true;
            }

            public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element2 instanceof PsiQualifiedNamedElement) {
                    return null;
                }
                return super.bindToElement(element2);
            }

            @Nullable
            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                XmlTag element2;
                if (newElementName == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((element2 = this.getTagElement()) != null && element2.getDescriptor() instanceof TagFromClassDescriptor) {
                    return null;
                }
                return super.handleElementRename(newElementName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElementName";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/android/dom/AndroidXmlExtension$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "bindToElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleElementRename";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public boolean isAvailable(final PsiFile file2) {
        if (file2 instanceof XmlFile) {
            return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    String tagName;
                    if (AndroidFacet.getInstance((PsiElement)file2) != null) {
                        if (IdeResourcesUtil.isInResourceSubdirectory(file2, null)) {
                            return true;
                        }
                        if (file2.getName().equals("AndroidManifest.xml") && ManifestDomFileDescription.isManifestFile((XmlFile)file2)) {
                            return true;
                        }
                    }
                    if ("lint.xml".equals(file2.getName())) {
                        return true;
                    }
                    XmlFile xmlFile = (XmlFile)file2;
                    XmlTag tag = xmlFile.getRootTag();
                    if (tag != null && ("lint".equals(tagName = tag.getName()) || "issues".equals(tagName))) {
                        return true;
                    }
                    return false;
                }
            });
        }
        return false;
    }

    public SchemaPrefix getPrefixDeclaration(XmlTag context, String namespacePrefix) {
        SchemaPrefix prefix = super.getPrefixDeclaration(context, namespacePrefix);
        if (prefix != null) {
            return prefix;
        }
        if (namespacePrefix.isEmpty()) {
            return EMPTY_SCHEMA;
        }
        return null;
    }

    public boolean isRequiredAttributeImplicitlyPresent(@NotNull XmlTag tag, @NotNull String attrName) {
        if (tag == null) {
            AndroidXmlExtension.$$$reportNull$$$0(0);
        }
        if (attrName == null) {
            AndroidXmlExtension.$$$reportNull$$$0(1);
        }
        return AndroidXmlExtension.isAaptAttributeDefined(tag, attrName);
    }

    public static boolean isAaptAttributeDefined(@NotNull XmlTag tag, @NotNull String attrName) {
        XmlTag[] subTags;
        if (tag == null) {
            AndroidXmlExtension.$$$reportNull$$$0(2);
        }
        if (attrName == null) {
            AndroidXmlExtension.$$$reportNull$$$0(3);
        }
        for (XmlTag child : subTags = tag.getSubTags()) {
            XmlAttribute attr;
            if (!"attr".equals(child.getLocalName()) || !"http://schemas.android.com/aapt".equals(child.getNamespace()) || (attr = child.getAttribute("name")) == null || !attrName.equals(attr.getValue())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/dom/AndroidXmlExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isRequiredAttributeImplicitlyPresent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAaptAttributeDefined";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

