/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.tools.idea.javadoc.AndroidJavaDocRenderer;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.android.utils.Pair;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.reference.SoftReference;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AttributeProcessingUtil;
import org.jetbrains.android.dom.ProvidedDocumentationPsiElement;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.converters.AttributeValueDocumentationProvider;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlDocumentationProvider
implements DocumentationProvider {
    private static final Key<SoftReference<Map<XmlName, CachedValue<String>>>> ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE_KEY = Key.create((String)"ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE");

    public String getQuickNavigateInfo(PsiElement element2, PsiElement originalElement) {
        if (element2 instanceof ResourceReferencePsiElement) {
            return ((ResourceReferencePsiElement)element2).getResourceReference().getResourceUrl().toString();
        }
        if (element2 instanceof LazyValueResourceElementWrapper) {
            ValueResourceInfo info2 = ((LazyValueResourceElementWrapper)element2).getResourceInfo();
            return "value resource '" + info2.getName() + "' [" + info2.getContainingFile().getName() + "]";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateDoc(PsiElement element2, @Nullable PsiElement originalElement) {
        PomTarget target;
        if (element2 instanceof ProvidedDocumentationPsiElement) {
            return ((ProvidedDocumentationPsiElement)element2).getDocumentation();
        }
        if (element2 instanceof ResourceReferencePsiElement) {
            ResourceUrl originalUrl = originalElement != null ? ResourceUrl.parse((String)originalElement.getText()) : null;
            ResourceReference resourceReference = ((ResourceReferencePsiElement)element2).getResourceReference();
            if (resourceReference.getResourceType().equals((Object)ResourceType.ATTR) && originalUrl != null) {
                return AndroidXmlDocumentationProvider.generateDoc(originalElement, originalUrl);
            }
            ResourceUrl resourceUrl = resourceReference.getResourceUrl();
            return AndroidXmlDocumentationProvider.generateDoc(originalElement, resourceUrl);
        }
        if (element2 instanceof LazyValueResourceElementWrapper) {
            ResourceUrl url;
            ResourceUrl originalUrl;
            LazyValueResourceElementWrapper wrapper = (LazyValueResourceElementWrapper)element2;
            ValueResourceInfo resourceInfo = wrapper.getResourceInfo();
            ResourceType type = resourceInfo.getType();
            String name = resourceInfo.getName();
            ResourceUrl resourceUrl = originalUrl = originalElement != null ? ResourceUrl.parse((String)originalElement.getText()) : null;
            if (originalUrl != null && name.equals(originalUrl.name)) {
                url = originalUrl;
            } else {
                boolean isFramework = false;
                isFramework = originalUrl != null ? originalUrl.isFramework() : resourceInfo.getResource().getNamespace().equals((Object)ResourceNamespace.ANDROID);
                url = ResourceUrl.create((ResourceType)type, (String)name, (boolean)isFramework);
            }
            return AndroidXmlDocumentationProvider.generateDoc(originalElement, url);
        }
        if (element2 instanceof ResourceReferenceCompletionElement) {
            return AndroidXmlDocumentationProvider.getResourceDocumentation(element2.getParent(), ((ResourceReferenceCompletionElement)element2).myResource);
        }
        if (element2 instanceof XmlAttributeValue) {
            return AndroidXmlDocumentationProvider.getResourceDocumentation(element2, ((XmlAttributeValue)element2).getValue());
        }
        if (element2 instanceof MyDocElement) {
            return ((MyDocElement)element2).getDocumentation();
        }
        if (originalElement instanceof XmlToken) {
            String text2;
            String documentation;
            PsiElement prev;
            XmlToken token = (XmlToken)originalElement;
            if (token.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                PsiElement next = token.getNextSibling();
                if (next instanceof XmlToken) {
                    token = (XmlToken)next;
                }
            } else if (token.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && (prev = token.getPrevSibling()) instanceof XmlToken) {
                token = (XmlToken)prev;
            }
            if (token.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                String documentation2 = AndroidXmlDocumentationProvider.getResourceDocumentation(originalElement, token.getText());
                if (documentation2 != null) {
                    return documentation2;
                }
            } else if (token.getTokenType() == XmlTokenType.XML_DATA_CHARACTERS && (documentation = AndroidXmlDocumentationProvider.getResourceDocumentation(originalElement, text2 = token.getText().trim())) != null) {
                return documentation;
            }
        }
        if (element2 instanceof PomTargetPsiElement && originalElement != null && (target = ((PomTargetPsiElement)element2).getTarget()) instanceof DomAttributeChildDescription) {
            Key<SoftReference<Map<XmlName, CachedValue<String>>>> key = ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE_KEY;
            synchronized (key) {
                return AndroidXmlDocumentationProvider.generateDocForXmlAttribute((DomAttributeChildDescription)target, originalElement);
            }
        }
        return null;
    }

    @Nullable
    private static String getResourceDocumentation(PsiElement element2, String value2) {
        ResourceUrl url = ResourceUrl.parse((String)value2);
        if (url != null) {
            return AndroidXmlDocumentationProvider.generateDoc(element2, url);
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlAttribute.class, (boolean)false);
        XmlTag tag = null;
        boolean isXmlValue = false;
        if (element2 instanceof XmlToken && XmlTokenType.XML_DATA_CHARACTERS.equals(((XmlToken)element2).getTokenType())) {
            tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class);
            attribute = tag == null ? null : tag.getAttribute("name");
            isXmlValue = true;
        }
        if (attribute == null) {
            return null;
        }
        if ("name".equals(attribute.getName())) {
            XmlTag parentTag = (tag = tag != null ? tag : attribute.getParent()).getParentTag();
            if (parentTag == null) {
                return null;
            }
            if ("resources".equals(parentTag.getName())) {
                ResourceType type = IdeResourcesUtil.getResourceTypeForResourceTag(tag);
                if (type != null) {
                    return AndroidXmlDocumentationProvider.generateDoc(element2, type, value2, false);
                }
            } else if ("style".equals(parentTag.getName())) {
                AttributeDefinition attributeDefinition;
                String targetValue = value2;
                if (isXmlValue && attribute.getValue() != null) {
                    targetValue = attribute.getValue();
                }
                if ((attributeDefinition = AndroidXmlDocumentationProvider.getAttributeDefinitionForElement(element2, targetValue = StringUtil.trimStart((String)targetValue, (String)"android:"))) == null) {
                    return null;
                }
                return StringUtil.trim((String)(isXmlValue ? attributeDefinition.getValueDescription(value2) : attributeDefinition.getDescription(null)));
            }
        }
        if ("http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) {
            AttributeDefinition attributeDefinition = AndroidXmlDocumentationProvider.getAttributeDefinitionForElement(element2, attribute.getLocalName());
            if (attributeDefinition == null) {
                return null;
            }
            return StringUtil.trim((String)attributeDefinition.getValueDescription(value2));
        }
        return null;
    }

    @Nullable
    private static AttributeDefinition getAttributeDefinitionForElement(@NotNull PsiElement element2, @NotNull String name) {
        AndroidFacet facet2;
        if (element2 == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (name == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(1);
        }
        if ((facet2 = AndroidFacet.getInstance((PsiElement)element2)) == null) {
            return null;
        }
        AttributeDefinitions definitions = AndroidXmlDocumentationProvider.getAttributeDefinitions(ModuleResourceManagers.getInstance(facet2).getFrameworkResourceManager());
        if (definitions == null) {
            return null;
        }
        AttributeDefinition attributeDefinition = definitions.getAttrDefByName(name);
        if (attributeDefinition == null) {
            definitions = AndroidXmlDocumentationProvider.getAttributeDefinitions(ModuleResourceManagers.getInstance(facet2).getLocalResourceManager());
            if (definitions == null) {
                return null;
            }
            attributeDefinition = definitions.getAttrDefByName(name);
        }
        return attributeDefinition;
    }

    @Nullable
    private static AttributeDefinitions getAttributeDefinitions(@Nullable ResourceManager manager) {
        return manager == null ? null : manager.getAttributeDefinitions();
    }

    @Nullable
    private static String generateDocForXmlAttribute(@NotNull DomAttributeChildDescription description2, @NotNull PsiElement originalElement) {
        CachedValue cachedDoc;
        if (description2 == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (originalElement == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(3);
        }
        XmlName xmlName = description2.getXmlName();
        HashMap<XmlName, CachedValue> cachedDocsMap = (HashMap<XmlName, CachedValue>)SoftReference.dereference((Reference)((Reference)originalElement.getUserData(ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE_KEY)));
        if (cachedDocsMap != null && (cachedDoc = (CachedValue)cachedDocsMap.get(xmlName)) != null) {
            return (String)cachedDoc.getValue();
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)originalElement);
        if (facet2 == null) {
            return null;
        }
        String localName = xmlName.getLocalName();
        String namespace = xmlName.getNamespaceKey();
        if (namespace == null) {
            return null;
        }
        if ("android".equals(namespace)) {
            namespace = "http://schemas.android.com/apk/res/android";
        }
        if (namespace.startsWith("http://schemas.android.com/apk/res/") || namespace.equals("http://schemas.android.com/apk/res-auto")) {
            String finalNamespace = namespace;
            CachedValue cachedValue2 = CachedValuesManager.getManager((Project)originalElement.getProject()).createCachedValue(() -> {
                Pair<AttributeDefinition, String> pair = AndroidXmlDocumentationProvider.findAttributeDefinition(originalElement, facet2, finalNamespace, localName);
                String doc = pair != null ? AndroidXmlDocumentationProvider.generateDocForXmlAttribute((AttributeDefinition)pair.getFirst(), (String)pair.getSecond()) : null;
                return CachedValueProvider.Result.create((Object)doc, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }, false);
            if (cachedDocsMap == null) {
                cachedDocsMap = new HashMap<XmlName, CachedValue>();
                originalElement.putUserData(ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE_KEY, (Object)new SoftReference(cachedDocsMap));
            }
            cachedDocsMap.put(xmlName, cachedValue2);
            return (String)cachedValue2.getValue();
        }
        return null;
    }

    @Nullable
    private static Pair<AttributeDefinition, String> findAttributeDefinition(@NotNull PsiElement originalElement, @NotNull AndroidFacet facet2, @NotNull String namespace, @NotNull String localName) {
        if (originalElement == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (facet2 == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (namespace == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(6);
        }
        if (localName == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(7);
        }
        if (!originalElement.isValid()) {
            return null;
        }
        XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class);
        if (parentTag == null) {
            return null;
        }
        DomElement parentDomElement = DomManager.getDomManager((Project)parentTag.getProject()).getDomElement(parentTag);
        if (!(parentDomElement instanceof AndroidDomElement)) {
            return null;
        }
        Ref result2 = Ref.create();
        try {
            AttributeProcessingUtil.processAttributes((AndroidDomElement)parentDomElement, facet2, false, (xn, attrDef, parentStyleableName) -> {
                if (xn.getLocalName().equals(localName) && namespace.equals(xn.getNamespaceKey())) {
                    result2.set((Object)Pair.of((Object)attrDef, (Object)parentStyleableName));
                    throw new MyStopException();
                }
                return null;
            });
        }
        catch (MyStopException myStopException) {
            // empty catch block
        }
        Pair pair = (Pair)result2.get();
        if (pair != null) {
            return pair;
        }
        AttributeDefinition attrDef2 = AndroidXmlDocumentationProvider.findAttributeDefinitionGlobally(facet2, namespace, localName);
        return attrDef2 != null ? Pair.of((Object)attrDef2, (Object)null) : null;
    }

    @Nullable
    private static AttributeDefinition findAttributeDefinitionGlobally(@NotNull AndroidFacet facet2, @NotNull String namespace, @NotNull String localName) {
        AttributeDefinitions attributes;
        ResourceManager resourceManager;
        if (facet2 == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(8);
        }
        if (namespace == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(9);
        }
        if (localName == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(10);
        }
        if ((resourceManager = "http://schemas.android.com/apk/res/android".equals(namespace) || "http://schemas.android.com/tools".equals(namespace) ? ModuleResourceManagers.getInstance(facet2).getFrameworkResourceManager() : (namespace.equals("http://schemas.android.com/apk/res-auto") || namespace.startsWith("http://schemas.android.com/apk/res/") ? ModuleResourceManagers.getInstance(facet2).getLocalResourceManager() : ModuleResourceManagers.getInstance(facet2).getFrameworkResourceManager())) != null && (attributes = ((ResourceManager)resourceManager).getAttributeDefinitions()) != null) {
            return attributes.getAttrDefByName(localName);
        }
        return null;
    }

    private static String generateDocForXmlAttribute(@NotNull AttributeDefinition definition, @Nullable String parentStyleable) {
        String docValue;
        String[] values2;
        if (definition == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(11);
        }
        StringBuilder builder2 = new StringBuilder("<html><body>");
        Set<AttributeFormat> formats = definition.getFormats();
        if (!formats.isEmpty()) {
            builder2.append("Formats: ");
            ArrayList<String> formatLabels = new ArrayList<String>(formats.size());
            for (AttributeFormat format2 : formats) {
                formatLabels.add(StringUtil.toLowerCase((String)format2.name()));
            }
            Collections.sort(formatLabels);
            int n = formatLabels.size();
            for (int i2 = 0; i2 < n; ++i2) {
                builder2.append((String)formatLabels.get(i2));
                if (i2 >= n - 1) continue;
                builder2.append(", ");
            }
        }
        if ((values2 = definition.getValues()).length > 0) {
            if (builder2.length() > 0) {
                builder2.append("<br>");
            }
            builder2.append("Values: ");
            Object[] sortedValues = new String[values2.length];
            System.arraycopy(values2, 0, sortedValues, 0, values2.length);
            Arrays.sort(sortedValues);
            for (int i3 = 0; i3 < sortedValues.length; ++i3) {
                builder2.append((String)sortedValues[i3]);
                if (i3 >= sortedValues.length - 1) continue;
                builder2.append(", ");
            }
        }
        if ((docValue = definition.getDescriptionByParentStyleableName(parentStyleable)) != null && !docValue.isEmpty()) {
            if (builder2.length() > 0) {
                builder2.append("<br><br>");
            }
            builder2.append(docValue);
        }
        builder2.append("</body></html>");
        return builder2.toString();
    }

    @Nullable
    private static String generateDoc(PsiElement originalElement, ResourceType type, String name, boolean framework) {
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement);
        if (module2 == null) {
            return null;
        }
        return AndroidJavaDocRenderer.render(module2, type, name, framework);
    }

    @Nullable
    private static String generateDoc(PsiElement originalElement, ResourceUrl url) {
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement);
        if (module2 == null) {
            return null;
        }
        return AndroidJavaDocRenderer.render(module2, url);
    }

    public PsiElement getDocumentationElementForLookupItem(@NotNull PsiManager psiManager, @NotNull Object object, @NotNull PsiElement element2) {
        if (psiManager == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(12);
        }
        if (object == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(13);
        }
        if (element2 == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(14);
        }
        if (element2 instanceof XmlToken) {
            element2 = element2.getParent();
        }
        if (!(element2 instanceof XmlAttributeValue) && !(element2 instanceof XmlToken) || !(object instanceof String)) {
            return null;
        }
        String value2 = (String)object;
        PsiElement parent = element2.getParent();
        if (!(parent instanceof XmlAttribute)) {
            return null;
        }
        GenericAttributeValue domValue = DomManager.getDomManager((Project)parent.getProject()).getDomElement((XmlAttribute)parent);
        if (domValue == null) {
            return null;
        }
        Converter converter = domValue.getConverter();
        if ((value2.startsWith("@") || value2.startsWith("?")) && !DataBindingUtil.isBindingExpression(value2)) {
            return new ResourceReferenceCompletionElement(element2, value2);
        }
        if (converter instanceof AttributeValueDocumentationProvider) {
            return new MyDocElement((XmlAttribute)parent, value2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/dom/AndroidXmlDocumentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAttributeDefinitionForElement";
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "generateDocForXmlAttribute";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findAttributeDefinition";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "findAttributeDefinitionGlobally";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getDocumentationElementForLookupItem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyStopException
    extends RuntimeException {
        private MyStopException() {
        }
    }

    public static class ResourceReferenceCompletionElement
    extends FakePsiElement {
        final PsiElement myParent;
        final String myResource;

        private ResourceReferenceCompletionElement(@NotNull PsiElement parent, @NotNull String resource) {
            if (parent == null) {
                ResourceReferenceCompletionElement.$$$reportNull$$$0(0);
            }
            if (resource == null) {
                ResourceReferenceCompletionElement.$$$reportNull$$$0(1);
            }
            this.myParent = parent;
            this.myResource = resource;
        }

        public PsiElement getParent() {
            return this.myParent;
        }

        public String getResource() {
            return this.myResource;
        }

        public PsiFile getContainingFile() {
            return null;
        }

        @NotNull
        public Language getLanguage() {
            XMLLanguage xMLLanguage = XMLLanguage.INSTANCE;
            if (xMLLanguage == null) {
                ResourceReferenceCompletionElement.$$$reportNull$$$0(2);
            }
            return xMLLanguage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/dom/AndroidXmlDocumentationProvider$ResourceReferenceCompletionElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/dom/AndroidXmlDocumentationProvider$ResourceReferenceCompletionElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyDocElement
    extends FakePsiElement {
        XmlAttribute myParent;
        String myValue;

        private MyDocElement(@NotNull XmlAttribute parent, String value2) {
            if (parent == null) {
                MyDocElement.$$$reportNull$$$0(0);
            }
            this.myParent = parent;
            this.myValue = value2;
        }

        public String getDocumentation() {
            GenericAttributeValue domValue = DomManager.getDomManager((Project)this.myParent.getProject()).getDomElement(this.myParent);
            if (domValue == null) {
                return null;
            }
            Converter converter = domValue.getConverter();
            return ((AttributeValueDocumentationProvider)converter).getDocumentation(this.myValue);
        }

        public PsiElement getParent() {
            return this.myParent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/android/dom/AndroidXmlDocumentationProvider$MyDocElement", "<init>"));
        }
    }
}

