/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import java.util.EnumSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.FileDescriptionUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u0018*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0018B'\b\u0012\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB+\b\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u0082\u0001\u0004\u0019\u001a\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/android/dom/AndroidResourceDomFileDescription;", "T", "Lcom/intellij/util/xml/DomElement;", "Lcom/intellij/util/xml/DomFileDescription;", "rootElementClass", "Ljava/lang/Class;", "rootTagName", "", "resourceFolderType", "Lcom/android/resources/ResourceFolderType;", "(Ljava/lang/Class;Ljava/lang/String;Lcom/android/resources/ResourceFolderType;)V", "resourceFolderTypes", "Ljava/util/EnumSet;", "(Ljava/lang/Class;Ljava/lang/String;Ljava/util/EnumSet;)V", "getResourceFolderTypes", "()Ljava/util/EnumSet;", "initializeFileDescription", "", "isMyFile", "", "file", "Lcom/intellij/psi/xml/XmlFile;", "module", "Lcom/intellij/openapi/module/Module;", "Companion", "Lorg/jetbrains/android/dom/SingleRootResourceDomFileDescription;", "Lorg/jetbrains/android/dom/MultipleKnownRootsResourceDomFileDescription;", "Lorg/jetbrains/android/dom/ResourceFolderTypeDomFileDescription;", "Lorg/jetbrains/android/dom/CustomLogicResourceDomFileDescription;", "intellij.android.core"})
public abstract class AndroidResourceDomFileDescription<T extends DomElement>
extends DomFileDescription<T> {
    @NotNull
    private final EnumSet<ResourceFolderType> resourceFolderTypes;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final EnumSet<ResourceFolderType> getResourceFolderTypes() {
        return this.resourceFolderTypes;
    }

    public boolean isMyFile(@NotNull XmlFile file2, @Nullable Module module2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Iterator iterator = this.resourceFolderTypes.iterator();
        while (iterator.hasNext()) {
            ResourceFolderType folderType;
            ResourceFolderType resourceFolderType = folderType = (ResourceFolderType)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)resourceFolderType, (String)"folderType");
            if (!Companion.isFileInResourceFolderType(file2, resourceFolderType)) continue;
            return true;
        }
        return false;
    }

    protected void initializeFileDescription() {
        this.registerNamespacePolicy("android", new String[]{"http://schemas.android.com/apk/res/android"});
        this.registerNamespacePolicy("app", new String[]{"http://schemas.android.com/apk/res-auto"});
        this.registerNamespacePolicy("tools", new String[]{"http://schemas.android.com/tools"});
    }

    private AndroidResourceDomFileDescription(Class<T> rootElementClass, String rootTagName, EnumSet<ResourceFolderType> resourceFolderTypes) {
        super(rootElementClass, rootTagName, new String[0]);
        EnumSet<ResourceFolderType> enumSet = EnumSet.copyOf(resourceFolderTypes);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"EnumSet.copyOf(resourceFolderTypes)");
        this.resourceFolderTypes = enumSet;
    }

    private AndroidResourceDomFileDescription(Class<T> rootElementClass, @NonNls String rootTagName, ResourceFolderType resourceFolderType) {
        EnumSet<Enum> enumSet = EnumSet.of((Enum)resourceFolderType);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"EnumSet.of<ResourceFolderType>(resourceFolderType)");
        this(rootElementClass, rootTagName, enumSet);
    }

    public /* synthetic */ AndroidResourceDomFileDescription(Class rootElementClass, String rootTagName, EnumSet resourceFolderTypes, DefaultConstructorMarker $constructor_marker) {
        this(rootElementClass, rootTagName, resourceFolderTypes);
    }

    public /* synthetic */ AndroidResourceDomFileDescription(Class rootElementClass, String rootTagName, ResourceFolderType resourceFolderType, DefaultConstructorMarker $constructor_marker) {
        this(rootElementClass, rootTagName, resourceFolderType);
    }

    @JvmStatic
    public static final boolean isFileInResourceFolderType(@NotNull XmlFile file2, @NotNull ResourceFolderType folderType) {
        return Companion.isFileInResourceFolderType(file2, folderType);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/dom/AndroidResourceDomFileDescription$Companion;", "", "()V", "isFileInResourceFolderType", "", "file", "Lcom/intellij/psi/xml/XmlFile;", "folderType", "Lcom/android/resources/ResourceFolderType;", "intellij.android.core"})
    public static final class Companion {
        @JvmStatic
        public final boolean isFileInResourceFolderType(@NotNull XmlFile file2, @NotNull ResourceFolderType folderType) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
            return FileDescriptionUtils.isResourceOfTypeWithRootTag(file2, folderType, SetsKt.emptySet());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

