/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.avdmanager.AvdListDialog;
import com.android.tools.idea.avdmanager.HardwareAccelerationCheck;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunAndroidAvdManagerAction
extends DumbAwareAction {
    public static final String ID = "Android.RunAndroidAvdManager";
    @Nullable
    private AvdListDialog myDialog;

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            RunAndroidAvdManagerAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = event.getPresentation();
        if ("toolbar".equals(event.getPlace())) {
            presentation.setIcon(null);
        }
        if ("MainToolbar".equals(event.getPlace()) && !IdeInfo.getInstance().isAndroidStudio()) {
            @Nullable Project project = event.getProject();
            boolean hasAndroidFacets = project != null && ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID);
            presentation.setVisible(hasAndroidFacets);
        }
        if (HardwareAccelerationCheck.isChromeOSAndIsNotHWAccelerated()) {
            presentation.setVisible(false);
            return;
        }
        presentation.setEnabled(AndroidSdkUtils.isAndroidSdkAvailable());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RunAndroidAvdManagerAction.$$$reportNull$$$0(1);
        }
        this.openAvdManager(e.getProject());
    }

    public void openAvdManager(@Nullable Project project) {
        if (HardwareAccelerationCheck.isChromeOSAndIsNotHWAccelerated()) {
            return;
        }
        if (this.myDialog == null) {
            this.myDialog = new AvdListDialog(project);
            this.myDialog.init();
            this.myDialog.show();
            Disposer.register((Disposable)this.myDialog, () -> {
                this.myDialog = null;
            });
        } else {
            this.myDialog.getFrame().toFront();
        }
    }

    @Nullable
    public AvdInfo getSelected() {
        return this.myDialog == null ? null : this.myDialog.getSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/actions/RunAndroidAvdManagerAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

