/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.jetbrains.android.actions.CreateResourceDirectoryAction;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class CreateXmlResourceSubdirPanel {
    private JPanel myDirectoriesPanel;
    private final CheckBoxList myDirectoriesList;
    private Map<String, JCheckBox> myCheckBoxes = Collections.emptyMap();
    private String[] myDirNames = ArrayUtil.EMPTY_STRING_ARRAY;
    private Project myProject;
    ResourceFolderType myFolderType;
    private Parent myParent;

    public CreateXmlResourceSubdirPanel(Project project, ResourceFolderType folderType, JPanel parentPanel, Parent parent) {
        this.myProject = project;
        this.myFolderType = folderType;
        this.myParent = parent;
        this.myDirectoriesPanel = parentPanel;
        this.myDirectoriesList = new CheckBoxList();
        this.setupDirectoriesPanel();
    }

    protected void setupDirectoriesPanel() {
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)this.myDirectoriesList);
        decorator.setEditAction(null);
        decorator.disableUpDownActions();
        decorator.setAddAction(button2 -> this.doAddNewDirectory());
        decorator.setRemoveAction(button2 -> this.doDeleteDirectory());
        AnActionButton selectAll = new AnActionButton(AndroidBundle.messagePointer("action.AnActionButton.text.select.all", new Object[0]), PlatformIcons.SELECT_ALL_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                CreateXmlResourceSubdirPanel.this.doSelectAllDirs();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/actions/CreateXmlResourceSubdirPanel$1", "actionPerformed"));
            }
        };
        decorator.addExtraAction(selectAll);
        AnActionButton unselectAll = new AnActionButton(AndroidBundle.messagePointer("action.AnActionButton.text.unselect.all", new Object[0]), PlatformIcons.UNSELECT_ALL_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                CreateXmlResourceSubdirPanel.this.doUnselectAllDirs();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/actions/CreateXmlResourceSubdirPanel$2", "actionPerformed"));
            }
        };
        decorator.addExtraAction(unselectAll);
        this.myDirectoriesPanel.add(decorator.createPanel());
        this.updateDirectories(true, this.myParent.getResourceDirectory());
    }

    private void doDeleteDirectory() {
        VirtualFile resourceDir = this.myParent.getResourceDirectory();
        if (resourceDir == null) {
            return;
        }
        int selectedIndex = this.myDirectoriesList.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        String selectedDirName = this.myDirNames[selectedIndex];
        VirtualFile selectedDir = resourceDir.findChild(selectedDirName);
        if (selectedDir == null) {
            return;
        }
        VirtualFileDeleteProvider provider2 = new VirtualFileDeleteProvider();
        provider2.deleteElement(dataId -> {
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                return new VirtualFile[]{selectedDir};
            }
            return null;
        });
        this.updateDirectories(false, resourceDir);
    }

    private void doSelectAllDirs() {
        for (JCheckBox checkBox : this.myCheckBoxes.values()) {
            checkBox.setSelected(true);
        }
        this.myDirectoriesList.repaint();
    }

    private void doUnselectAllDirs() {
        for (JCheckBox checkBox : this.myCheckBoxes.values()) {
            checkBox.setSelected(false);
        }
        this.myDirectoriesList.repaint();
    }

    private void doAddNewDirectory() {
        PsiElement[] createdElements;
        VirtualFile resourceDir = this.myParent.getResourceDirectory();
        if (resourceDir == null) {
            return;
        }
        PsiDirectory psiResDir = PsiManager.getInstance((Project)this.myProject).findDirectory(resourceDir);
        if (psiResDir != null && (createdElements = new CreateResourceDirectoryAction(this.myFolderType).invokeDialog(this.myProject, psiResDir)).length > 0) {
            this.updateDirectories(false, resourceDir);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateDirectories(boolean updateFileCombo, VirtualFile resourceDir) {
        void var11_14;
        List<Object> directories = Collections.emptyList();
        if (resourceDir != null) {
            directories = IdeResourcesUtil.getResourceSubdirs(this.myFolderType, Collections.singleton(resourceDir));
        }
        directories.sort((f1, f2) -> f1.getName().compareTo(f2.getName()));
        Map<String, JCheckBox> oldCheckBoxes = this.myCheckBoxes;
        int selectedIndex = this.myDirectoriesList.getSelectedIndex();
        String selectedDirName = selectedIndex >= 0 ? this.myDirNames[selectedIndex] : null;
        ArrayList<JCheckBox> checkBoxList = new ArrayList<JCheckBox>();
        this.myCheckBoxes = new HashMap<String, JCheckBox>();
        this.myDirNames = new String[directories.size()];
        int newSelectedIndex = -1;
        int i2 = 0;
        for (VirtualFile virtualFile : directories) {
            String dirName = virtualFile.getName();
            JCheckBox oldCheckBox = oldCheckBoxes.get(dirName);
            boolean selected = oldCheckBox != null && oldCheckBox.isSelected();
            JCheckBox checkBox = new JCheckBox(dirName, selected);
            checkBoxList.add(checkBox);
            this.myCheckBoxes.put(dirName, checkBox);
            this.myDirNames[i2] = dirName;
            if (dirName.equals(selectedDirName)) {
                newSelectedIndex = i2;
            }
            ++i2;
        }
        String defaultFolderName = this.myFolderType.getName();
        JCheckBox jCheckBox = this.myCheckBoxes.get(defaultFolderName);
        if (jCheckBox == null) {
            JCheckBox jCheckBox2 = new JCheckBox(defaultFolderName);
            checkBoxList.add(0, jCheckBox2);
            this.myCheckBoxes.put(defaultFolderName, jCheckBox2);
            String[] newDirNames = new String[this.myDirNames.length + 1];
            newDirNames[0] = defaultFolderName;
            System.arraycopy(this.myDirNames, 0, newDirNames, 1, this.myDirNames.length);
            this.myDirNames = newDirNames;
        }
        var11_14.setSelected(true);
        this.myDirectoriesList.setModel((ListModel)new CollectionListModel(checkBoxList));
        if (newSelectedIndex >= 0) {
            this.myDirectoriesList.setSelectedIndex(newSelectedIndex);
        }
        if (updateFileCombo) {
            this.myParent.updateFilesCombo(directories);
        }
    }

    public void resetToDefault() {
        for (JCheckBox checkBox : this.myCheckBoxes.values()) {
            checkBox.setSelected(false);
        }
        this.myCheckBoxes.get(this.myFolderType.getName()).setSelected(true);
        this.myDirectoriesList.repaint();
    }

    public void resetFromFile(@NotNull VirtualFile directory) {
        JCheckBox checkBox;
        if (directory == null) {
            CreateXmlResourceSubdirPanel.$$$reportNull$$$0(0);
        }
        if ((checkBox = this.myCheckBoxes.get(directory.getName())) == null) {
            return;
        }
        for (JCheckBox checkBox1 : this.myCheckBoxes.values()) {
            checkBox1.setSelected(false);
        }
        checkBox.setSelected(true);
    }

    public List<String> getDirNames() {
        ArrayList<String> selectedDirs = new ArrayList<String>();
        for (Map.Entry<String, JCheckBox> entry : this.myCheckBoxes.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            selectedDirs.add(entry.getKey());
        }
        return selectedDirs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/android/actions/CreateXmlResourceSubdirPanel", "resetFromFile"));
    }

    public static interface Parent {
        public VirtualFile getResourceDirectory();

        public void updateFilesCombo(List<VirtualFile> var1);
    }
}

