/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.CommonBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.xml.refactoring.XmlTagInplaceRenamer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.actions.CreateResourceActionBase;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateTypedResourceFileAction
extends CreateResourceActionBase {
    protected final ResourceFolderType myResourceFolderType;
    protected final String myResourcePresentableName;
    String myDefaultRootTag;
    private final boolean myValuesResourceFile;
    private boolean myChooseTagName;

    public CreateTypedResourceFileAction(@NotNull String resourcePresentableName, @NotNull ResourceFolderType resourceFolderType, boolean valuesResourceFile, boolean chooseTagName) {
        if (resourcePresentableName == null) {
            CreateTypedResourceFileAction.$$$reportNull$$$0(0);
        }
        if (resourceFolderType == null) {
            CreateTypedResourceFileAction.$$$reportNull$$$0(1);
        }
        super(AndroidBundle.messagePointer("new.typed.resource.action.title", resourcePresentableName), AndroidBundle.messagePointer("new.typed.resource.action.description", resourcePresentableName), XmlFileType.INSTANCE.getIcon());
        this.myResourceFolderType = resourceFolderType;
        this.myResourcePresentableName = resourcePresentableName;
        this.myDefaultRootTag = CreateTypedResourceFileAction.getDefaultRootTagByResourceType(resourceFolderType);
        this.myValuesResourceFile = valuesResourceFile;
        this.myChooseTagName = chooseTagName;
    }

    @NotNull
    public ResourceFolderType getResourceFolderType() {
        ResourceFolderType resourceFolderType = this.myResourceFolderType;
        if (resourceFolderType == null) {
            CreateTypedResourceFileAction.$$$reportNull$$$0(2);
        }
        return resourceFolderType;
    }

    protected InputValidator createValidator(Project project, PsiDirectory directory) {
        return new MyValidator(project, directory);
    }

    @Override
    @NotNull
    protected PsiElement[] invokeDialog(@NotNull Project project, @NotNull DataContext dataContext) {
        IdeView view;
        if (project == null) {
            CreateTypedResourceFileAction.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            CreateTypedResourceFileAction.$$$reportNull$$$0(4);
        }
        if ((view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext)) != null) {
            AbstractProjectViewPane pane = ProjectView.getInstance((Project)project).getCurrentProjectViewPane();
            if (pane instanceof AndroidProjectViewPane) {
                PsiElement[] psiElementArray = CreateResourceFileAction.getInstance().invokeDialog(project, dataContext);
                if (psiElementArray == null) {
                    CreateTypedResourceFileAction.$$$reportNull$$$0(5);
                }
                return psiElementArray;
            }
            PsiDirectory directory = view.getOrChooseDirectory();
            if (directory != null) {
                InputValidator validator = this.createValidator(project, directory);
                Messages.showInputDialog((Project)project, (String)AndroidBundle.message("new.file.dialog.text", new Object[0]), (String)AndroidBundle.message("new.typed.resource.dialog.title", this.myResourcePresentableName), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)validator);
            }
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            CreateTypedResourceFileAction.$$$reportNull$$$0(6);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    protected PsiElement[] create(String newName2, PsiDirectory directory) throws Exception {
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)directory);
        PsiElement[] psiElementArray = this.doCreateAndNavigate(newName2, directory, this.getDefaultRootTag(module2), this.myChooseTagName, true);
        if (psiElementArray == null) {
            CreateTypedResourceFileAction.$$$reportNull$$$0(7);
        }
        return psiElementArray;
    }

    PsiElement[] doCreateAndNavigate(String newName2, PsiDirectory directory, String rootTagName, boolean chooseTagName, boolean navigate) throws Exception {
        Project project;
        Editor editor2;
        XmlTag rootTag;
        XmlDocument document;
        XmlFile file2 = IdeResourcesUtil.createFileResource(newName2, directory, rootTagName, this.myResourceFolderType.getName(), this.myValuesResourceFile);
        if (navigate) {
            this.doNavigate(file2);
        }
        if (chooseTagName && (document = file2.getDocument()) != null && (rootTag = document.getRootTag()) != null && (editor2 = FileEditorManager.getInstance((Project)(project = file2.getProject())).getSelectedTextEditor()) != null) {
            CaretModel caretModel = editor2.getCaretModel();
            caretModel.moveToOffset(rootTag.getTextOffset() + 1);
            XmlTagInplaceRenamer.rename((Editor)editor2, (XmlTag)rootTag);
        }
        return new PsiElement[]{file2};
    }

    protected void doNavigate(XmlFile file2) {
        if (file2.isValid() && LayoutPullParsers.isSupported((PsiFile)file2)) {
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile != null && virtualFile.isValid()) {
                if (AndroidEditorSettings.getInstance().getGlobalState().isPreferXmlEditor()) {
                    new OpenFileDescriptor(file2.getProject(), virtualFile, 0).navigate(true);
                } else {
                    new OpenFileDescriptor(file2.getProject(), virtualFile).navigate(true);
                }
            }
        } else {
            PsiNavigateUtil.navigate((PsiElement)file2);
        }
    }

    @Override
    protected boolean isAvailable(DataContext context) {
        return super.isAvailable(context) && CreateTypedResourceFileAction.doIsAvailable(context, this.myResourceFolderType.getName());
    }

    public boolean isChooseTagName() {
        return this.myChooseTagName;
    }

    @NotNull
    public List<String> getAllowedTagNames(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            CreateTypedResourceFileAction.$$$reportNull$$$0(8);
        }
        List<String> list = Collections.singletonList(this.getDefaultRootTag(facet2.getModule()));
        if (list == null) {
            CreateTypedResourceFileAction.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public final List<String> getSortedAllowedTagNames(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            CreateTypedResourceFileAction.$$$reportNull$$$0(10);
        }
        ArrayList<String> result2 = new ArrayList<String>(this.getAllowedTagNames(facet2));
        Collections.sort(result2);
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            CreateTypedResourceFileAction.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public String getDefaultRootTag(@Nullable Module module2) {
        return this.myDefaultRootTag;
    }

    static boolean doIsAvailable(DataContext context, String resourceType) {
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        if (element2 == null || AndroidFacet.getInstance((PsiElement)element2) == null) {
            return false;
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            for (PsiElement e = element2; e != null; e = e.getParent()) {
                if (!(e instanceof PsiDirectory) || !IdeResourcesUtil.isResourceSubdirectory((PsiDirectory)e, resourceType)) continue;
                return true;
            }
            return false;
        });
    }

    @Override
    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    @Override
    protected String getCommandName() {
        return AndroidBundle.message("new.typed.resource.command.name", this.myResourceFolderType);
    }

    @Override
    @Nullable
    protected String getActionName(PsiDirectory directory, String newName2) {
        return CreateResourceFileAction.doGetActionName(directory, newName2);
    }

    public String toString() {
        return this.myResourcePresentableName;
    }

    @NotNull
    public static String getDefaultRootTagByResourceType(@NotNull ResourceFolderType resourceType) {
        if (resourceType == null) {
            CreateTypedResourceFileAction.$$$reportNull$$$0(12);
        }
        switch (resourceType) {
            case XML: {
                return "PreferenceScreen";
            }
            case DRAWABLE: {
                return "selector";
            }
            case COLOR: {
                return "selector";
            }
            case VALUES: {
                return "resources";
            }
            case MENU: {
                return "menu";
            }
            case ANIM: {
                return "set";
            }
            case ANIMATOR: {
                return "set";
            }
            case LAYOUT: {
                return "LinearLayout";
            }
            case TRANSITION: {
                return "transitionManager";
            }
            case FONT: {
                return "font-family";
            }
            case NAVIGATION: {
                return "navigation";
            }
        }
        throw new IllegalArgumentException("Incorrect resource folder type");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePresentableName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceFolderType";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/actions/CreateTypedResourceFileAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/actions/CreateTypedResourceFileAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceFolderType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeDialog";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllowedTagNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedAllowedTagNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invokeDialog";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllowedTagNames";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSortedAllowedTagNames";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRootTagByResourceType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyValidator
    extends CreateResourceActionBase.MyInputValidator
    implements InputValidatorEx {
        @NotNull
        private final IdeResourceNameValidator myNameValidator;

        public MyValidator(Project project, PsiDirectory directory) {
            super(project, directory);
            this.myNameValidator = IdeResourceNameValidator.forFilename(CreateTypedResourceFileAction.this.myResourceFolderType, ".xml");
        }

        public String getErrorText(String inputString) {
            return this.myNameValidator.getErrorText(inputString);
        }
    }
}

