/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import java.io.IOException;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.android.actions.widgets.SourceSetCellRenderer;
import org.jetbrains.android.actions.widgets.SourceSetItem;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResourceDialogUtils {
    private static final Logger LOG = Logger.getInstance(ExternalSystemUtil.class);

    @Nullable
    private static String getResourceUrl(@NotNull JComboBox combo) {
        SourceSetItem comboItem;
        if (combo == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(0);
        }
        if ((comboItem = (SourceSetItem)combo.getSelectedItem()) != null) {
            return comboItem.getResDirUrl();
        }
        return null;
    }

    @Nullable
    public static PsiDirectory getOrCreateResourceDirectory(@NotNull JComboBox combo, @NotNull Module module2) {
        VirtualFile res;
        PsiDirectory dir;
        if (combo == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(1);
        }
        if (module2 == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(2);
        }
        String resDirUrl = CreateResourceDialogUtils.getResourceUrl(combo);
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiManager manager = PsiManager.getInstance((Project)module2.getProject());
        VirtualFile virtualFile = null;
        if (resDirUrl != null && (virtualFile = VirtualFileManager.getInstance().findFileByUrl(resDirUrl)) == null) {
            try {
                virtualFile = VfsUtil.createDirectories((String)VfsUtilCore.urlToPath((String)resDirUrl));
            }
            catch (IOException ex) {
                LOG.warn((Throwable)ex);
            }
        }
        if (virtualFile != null && (dir = manager.findDirectory(virtualFile)) != null) {
            return dir;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 != null && (res = ResourceFolderManager.getInstance(facet2).getPrimaryFolder()) != null) {
            return PsiManager.getInstance((Project)module2.getProject()).findDirectory(res);
        }
        return null;
    }

    public static void updateSourceSetCombo(@NotNull JComponent label, @NotNull JComboBox combo, @Nullable AndroidFacet facet2, @Nullable PsiDirectory resDirectory) {
        if (label == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(3);
        }
        if (combo == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(4);
        }
        if (resDirectory != null) {
            label.setVisible(false);
            combo.setVisible(false);
            return;
        }
        if (facet2 != null && AndroidModel.isRequired(facet2) && AndroidModel.get(facet2) != null) {
            List<NamedIdeaSourceProvider> providers2 = SourceProviderManager.getInstance(facet2).getCurrentAndSomeFrequentlyUsedInactiveSourceProviders();
            DefaultComboBoxModel<SourceSetItem> model2 = new DefaultComboBoxModel<SourceSetItem>();
            for (NamedIdeaSourceProvider sourceProvider : providers2) {
                for (String resDirUrl : sourceProvider.getResDirectoryUrls()) {
                    model2.addElement(SourceSetItem.create(sourceProvider, facet2.getModule(), resDirUrl));
                }
            }
            combo.setModel(model2);
            combo.setRenderer(new SourceSetCellRenderer());
            label.setVisible(true);
            combo.setVisible(true);
        } else {
            label.setVisible(false);
            combo.setVisible(false);
        }
    }

    @Nullable
    private static VirtualFile getResFolderParent(@NotNull LocalResourceManager manager, @NotNull VirtualFile file2) {
        if (manager == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(6);
        }
        for (VirtualFile current = file2; current != null; current = current.getParent()) {
            if (!current.isDirectory() || !manager.isResourceDir(current)) continue;
            return current;
        }
        return null;
    }

    @Nullable
    public static PsiDirectory findResourceDirectory(@NotNull DataContext dataContext) {
        VirtualFile resFolder;
        LocalResourceManager manager;
        Module module2;
        AbstractProjectViewPane pane;
        Project project;
        if (dataContext == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(7);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) != null && (pane = ProjectView.getInstance((Project)project).getCurrentProjectViewPane()) instanceof AndroidProjectViewPane) {
            return null;
        }
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file2 != null && (module2 = (Module)LangDataKeys.MODULE.getData(dataContext)) != null && (manager = LocalResourceManager.getInstance(module2)) != null && (resFolder = CreateResourceDialogUtils.getResFolderParent(manager, file2)) != null) {
            return AndroidPsiUtils.getPsiDirectorySafely((Project)module2.getProject(), (VirtualFile)resFolder);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "combo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/actions/CreateResourceDialogUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getResourceUrl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCreateResourceDirectory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSourceSetCombo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getResFolderParent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findResourceDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

