/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.ScopeType;
import com.android.tools.idea.psi.TagToClassMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.AndroidClassesForXmlUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

class TagToClassMapperImpl
implements TagToClassMapper {
    private static final Logger LOG = Logger.getInstance(TagToClassMapper.class);
    private final Map<String, Map<String, SmartPsiElementPointer<PsiClass>>> myInitialClassMaps;
    private final Map<String, CachedValue<Map<String, PsiClass>>> myClassMaps;
    private final Module myModule;

    TagToClassMapperImpl(@NotNull Module module2) {
        if (module2 == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(0);
        }
        this.myInitialClassMaps = new HashMap<String, Map<String, SmartPsiElementPointer<PsiClass>>>();
        this.myClassMaps = Maps.newConcurrentMap();
        this.myModule = module2;
        MessageBusConnection connection = module2.getProject().getMessageBus().connect((Disposable)module2);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                TagToClassMapperImpl.this.clearInitialClassMaps();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/android/TagToClassMapperImpl$1", "rootsChanged"));
            }
        });
    }

    @Override
    @NotNull
    public TagToClassMapper.ClassMapFreshness getClassMapFreshness(String className2) {
        CachedValue<Map<String, PsiClass>> value2 = this.myClassMaps.get(className2);
        if (value2 == null) {
            TagToClassMapper.ClassMapFreshness classMapFreshness = TagToClassMapper.ClassMapFreshness.REBUILD_ENTIRE_CLASS_MAP;
            if (classMapFreshness == null) {
                TagToClassMapperImpl.$$$reportNull$$$0(1);
            }
            return classMapFreshness;
        }
        if (value2.hasUpToDateValue()) {
            TagToClassMapper.ClassMapFreshness classMapFreshness = TagToClassMapper.ClassMapFreshness.VALID_CLASS_MAP;
            if (classMapFreshness == null) {
                TagToClassMapperImpl.$$$reportNull$$$0(2);
            }
            return classMapFreshness;
        }
        Map<String, SmartPsiElementPointer<PsiClass>> classMap = this.myInitialClassMaps.get(className2);
        if (classMap != null && this.isClassMapUpToDate(classMap)) {
            TagToClassMapper.ClassMapFreshness classMapFreshness = TagToClassMapper.ClassMapFreshness.REBUILD_PARTIAL_CLASS_MAP;
            if (classMapFreshness == null) {
                TagToClassMapperImpl.$$$reportNull$$$0(3);
            }
            return classMapFreshness;
        }
        TagToClassMapper.ClassMapFreshness classMapFreshness = TagToClassMapper.ClassMapFreshness.REBUILD_ENTIRE_CLASS_MAP;
        if (classMapFreshness == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(4);
        }
        return classMapFreshness;
    }

    @Override
    @TestOnly
    public void resetAllClassMaps() {
        this.clearInitialClassMaps();
        this.myClassMaps.clear();
    }

    @Override
    @NotNull
    public Map<String, PsiClass> getClassMap(String classMapKey) {
        if (DumbService.isDumb((Project)this.myModule.getProject())) {
            Map<String, PsiClass> map2 = Collections.emptyMap();
            if (map2 == null) {
                TagToClassMapperImpl.$$$reportNull$$$0(5);
            }
            return map2;
        }
        CachedValue value2 = this.myClassMaps.get(classMapKey);
        if (value2 == null) {
            value2 = CachedValuesManager.getManager((Project)this.myModule.getProject()).createCachedValue(() -> {
                Map<String, PsiClass> map2 = this.computeClassMap(classMapKey);
                return CachedValueProvider.Result.create(map2, (Object[])new Object[]{AndroidPsiUtils.getPsiModificationTrackerIgnoringXml((Project)this.myModule.getProject())});
            }, false);
            this.myClassMaps.put(classMapKey, (CachedValue<Map<String, PsiClass>>)value2);
        }
        Map<String, PsiClass> map3 = Collections.unmodifiableMap((Map)value2.getValue());
        if (map3 == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(6);
        }
        return map3;
    }

    @NotNull
    private Map<String, PsiClass> computeClassMap(@NotNull String classMapKey) {
        PsiClass aClass;
        SmartPsiElementPointer<PsiClass> pointer;
        if (classMapKey == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(7);
        }
        Map<String, SmartPsiElementPointer<PsiClass>> classMap = this.getInitialClassMap(classMapKey, false);
        HashMap<String, PsiClass> result2 = new HashMap<String, PsiClass>();
        boolean shouldRebuildInitialMap = false;
        int apiLevel = this.getMinApiLevel();
        for (String key : classMap.keySet()) {
            pointer = classMap.get(key);
            aClass = (PsiClass)pointer.getElement();
            if (aClass == null) continue;
            if (!TagToClassMapperImpl.isUpToDate(aClass, key, apiLevel, classMapKey)) {
                shouldRebuildInitialMap = true;
                break;
            }
            result2.put(key, aClass);
        }
        if (shouldRebuildInitialMap) {
            result2.clear();
            classMap = this.getInitialClassMap(classMapKey, true);
            for (String key : classMap.keySet()) {
                pointer = classMap.get(key);
                aClass = (PsiClass)pointer.getElement();
                if (aClass == null) continue;
                result2.put(key, aClass);
            }
        }
        this.fillMap(classMapKey, this.projectClassesScope(), result2);
        HashMap<String, PsiClass> hashMap = result2;
        if (hashMap == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    private static boolean isUpToDate(@NotNull PsiClass aClass, @NotNull String tagName, int apiLevel, @Nullable String classMapKey) {
        if (aClass == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(9);
        }
        if (tagName == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(10);
        }
        return ArrayUtil.contains((String)tagName, (String[])AndroidClassesForXmlUtilKt.getTagNamesByClass(aClass, apiLevel, classMapKey));
    }

    private boolean isClassMapUpToDate(@NotNull Map<String, SmartPsiElementPointer<PsiClass>> classMap) {
        if (classMap == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(11);
        }
        int apiLevel = this.getMinApiLevel();
        for (String key : classMap.keySet()) {
            SmartPsiElementPointer<PsiClass> pointer = classMap.get(key);
            PsiClass aClass = (PsiClass)pointer.getElement();
            if (aClass == null || TagToClassMapperImpl.isUpToDate(aClass, key, apiLevel, key)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private Map<String, SmartPsiElementPointer<PsiClass>> getInitialClassMap(@NotNull String classMapKey, boolean forceRebuild) {
        Map<String, SmartPsiElementPointer<PsiClass>> viewClassMap;
        if (classMapKey == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(12);
        }
        if ((viewClassMap = this.myInitialClassMaps.get(classMapKey)) != null && !forceRebuild) {
            Map<String, SmartPsiElementPointer<PsiClass>> map2 = viewClassMap;
            if (map2 == null) {
                TagToClassMapperImpl.$$$reportNull$$$0(13);
            }
            return map2;
        }
        Map<String, SmartPsiElementPointer<PsiClass>> map3 = this.computeInitialClassMap(classMapKey);
        if (map3 == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(14);
        }
        return map3;
    }

    @VisibleForTesting
    @NotNull
    Map<String, SmartPsiElementPointer<PsiClass>> computeInitialClassMap(@NotNull String classMapKey) {
        if (classMapKey == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(15);
        }
        LOG.info("Building initial class map for " + classMapKey);
        Map<String, SmartPsiElementPointer<PsiClass>> viewClassMap = null;
        HashMap<String, PsiClass> map2 = new HashMap<String, PsiClass>();
        if (this.fillMap(classMapKey, this.dependenciesClassesScope(), map2)) {
            viewClassMap = new HashMap(map2.size());
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.myModule.getProject());
            for (Map.Entry entry : map2.entrySet()) {
                viewClassMap.put((String)entry.getKey(), (SmartPsiElementPointer<PsiClass>)manager.createSmartPsiElementPointer((PsiElement)((PsiClass)entry.getValue())));
            }
            this.myInitialClassMaps.put(classMapKey, viewClassMap);
        }
        Map<String, SmartPsiElementPointer<PsiClass>> map3 = viewClassMap != null ? viewClassMap : Collections.emptyMap();
        if (map3 == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(16);
        }
        return map3;
    }

    @NotNull
    private GlobalSearchScope moduleResolveScope() {
        GlobalSearchScope globalSearchScope = ProjectSystemUtil.getModuleSystem(this.myModule).getResolveScope(ScopeType.MAIN);
        if (globalSearchScope == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(17);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope allLibrariesScope() {
        GlobalSearchScope globalSearchScope = ProjectScope.getLibrariesScope((Project)this.myModule.getProject());
        if (globalSearchScope == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(18);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope projectClassesScope() {
        GlobalSearchScope globalSearchScope = this.moduleResolveScope().intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.allLibrariesScope()));
        if (globalSearchScope == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(19);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope dependenciesClassesScope() {
        GlobalSearchScope globalSearchScope = this.moduleResolveScope().intersectWith(this.allLibrariesScope());
        if (globalSearchScope == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(20);
        }
        return globalSearchScope;
    }

    private boolean fillMap(@NotNull String className2, @NotNull GlobalSearchScope scope2, @NotNull Map<String, PsiClass> map2) {
        String[] baseClassTagNames;
        JavaPsiFacade facade;
        PsiClass baseClass;
        if (className2 == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(21);
        }
        if (scope2 == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(22);
        }
        if (map2 == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(23);
        }
        if ((baseClass = (facade = JavaPsiFacade.getInstance((Project)this.myModule.getProject())).findClass(className2, this.moduleResolveScope())) == null) {
            return false;
        }
        int api = this.getMinApiLevel();
        for (String tagName : baseClassTagNames = AndroidClassesForXmlUtilKt.getTagNamesByClass(baseClass, api, className2)) {
            map2.put(tagName, baseClass);
        }
        try {
            ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)scope2, (boolean)true).forEach(c -> {
                String[] tagNames;
                for (String tagName : tagNames = AndroidClassesForXmlUtilKt.getTagNamesByClass(c, api, className2)) {
                    map2.put(tagName, (PsiClass)c);
                }
                return true;
            });
        }
        catch (IndexNotReadyException e) {
            Logger.getInstance(this.getClass()).info((Throwable)e);
            return false;
        }
        return !map2.isEmpty();
    }

    private int getMinApiLevel() {
        AndroidModuleInfo androidModuleInfo = AndroidModuleInfo.getInstance(this.myModule);
        return androidModuleInfo == null ? 1 : androidModuleInfo.getModuleMinApi();
    }

    public void clearInitialClassMaps() {
        this.myInitialClassMaps.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/TagToClassMapperImpl";
                break;
            }
            case 7: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMapKey";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMap";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/TagToClassMapperImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassMapFreshness";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassMap";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeClassMap";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialClassMap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInitialClassMap";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleResolveScope";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "allLibrariesScope";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "projectClassesScope";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "dependenciesClassesScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeClassMap";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isClassMapUpToDate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInitialClassMap";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeInitialClassMap";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fillMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

