/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.ColorIconRenderer;
import org.jetbrains.android.ComposeColorAnnotator$WhenMappings;
import org.jetbrains.android.ComposeColorAnnotatorKt;
import org.jetbrains.android.ComposeColorConstructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/android/ComposeColorAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "getColor", "Ljava/awt/Color;", "args", "", "Lorg/jetbrains/uast/UExpression;", "intellij.android.core"})
public final class ComposeColorAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            if (!((Boolean)StudioFlags.COMPOSE_EDITOR_SUPPORT.get()).booleanValue()) {
                return;
            }
            AndroidModuleSystem androidModuleSystem2 = ProjectSystemUtil.getModuleSystem(element2);
            if (androidModuleSystem2 == null || !androidModuleSystem2.getUsesCompose()) {
                return;
            }
            if (!(element2 instanceof KtCallElement)) break block8;
            UCallExpression uCallExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)element2, UCallExpression.class);
            if (uCallExpression == null) {
                return;
            }
            UCallExpression uElement = uCallExpression;
            PsiType psiType = uElement.getReturnType();
            if (psiType == null) {
                return;
            }
            PsiType returnType = psiType;
            if (Intrinsics.areEqual((Object)uElement.getKind(), (Object)UastCallKind.METHOD_CALL) ^ true || Intrinsics.areEqual((Object)returnType, (Object)PsiType.LONG) ^ true || Intrinsics.areEqual((Object)"Color", (Object)uElement.getMethodName()) ^ true) {
                return;
            }
            Object object = uElement.resolve();
            if (object == null || (object = object.getContainingClass()) == null || (object = object.getQualifiedName()) == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"uElement.resolve()?.cont\u2026?.qualifiedName ?: return");
            Object fqName = object;
            if (Intrinsics.areEqual((Object)fqName, (Object)"androidx.ui.graphics.ColorKt")) {
                Color color = this.getColor(uElement.getValueArguments());
                if (color == null) {
                    return;
                }
                Color color2 = color;
                holder.newSilentAnnotation(HighlightSeverity.INFORMATION).gutterIconRenderer((GutterIconRenderer)new ColorIconRenderer(uElement, color2)).create();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Color getColor(List<? extends UExpression> args) {
        try {
            ComposeColorConstructor composeColorConstructor = ComposeColorAnnotatorKt.access$getConstructorType(args);
            if (composeColorConstructor == null) return null;
            switch (ComposeColorAnnotator$WhenMappings.$EnumSwitchMapping$0[composeColorConstructor.ordinal()]) {
                case 1: {
                    Integer n = ComposeColorAnnotatorKt.access$getInt(args.get(0));
                    if (n == null) return null;
                    int rgbInt = n;
                    Color color = new Color(rgbInt);
                    return color;
                }
                case 2: {
                    Integer n = ComposeColorAnnotatorKt.access$getLong(args.get(0));
                    if (n == null) return null;
                    int rgbInt = n;
                    Color color = new Color(rgbInt);
                    return color;
                }
                case 3: {
                    Integer n = ComposeColorAnnotatorKt.access$getInt(args.get(0));
                    if (n == null) return null;
                    int r = n;
                    Integer n2 = ComposeColorAnnotatorKt.access$getInt(args.get(1));
                    if (n2 == null) return null;
                    int g = n2;
                    Integer n3 = ComposeColorAnnotatorKt.access$getInt(args.get(2));
                    if (n3 == null) return null;
                    int b = n3;
                    Color color = new Color(r, g, b);
                    return color;
                }
                case 4: {
                    Integer n = ComposeColorAnnotatorKt.access$getInt(args.get(0));
                    if (n == null) return null;
                    int r = n;
                    Integer n4 = ComposeColorAnnotatorKt.access$getInt(args.get(1));
                    if (n4 == null) return null;
                    int g = n4;
                    Integer n5 = ComposeColorAnnotatorKt.access$getInt(args.get(2));
                    if (n5 == null) return null;
                    int b = n5;
                    Integer n6 = ComposeColorAnnotatorKt.access$getInt(args.get(3));
                    if (n6 == null) return null;
                    int a = n6;
                    Color color = new Color(r, g, b, a);
                    return color;
                }
                case 5: {
                    Float f = ComposeColorAnnotatorKt.access$getFloat(args.get(0));
                    if (f == null) return null;
                    float r = f.floatValue();
                    Float f2 = ComposeColorAnnotatorKt.access$getFloat(args.get(1));
                    if (f2 == null) return null;
                    float g = f2.floatValue();
                    Float f3 = ComposeColorAnnotatorKt.access$getFloat(args.get(2));
                    if (f3 == null) return null;
                    float b = f3.floatValue();
                    Color color = new Color(r, g, b);
                    return color;
                }
                case 6: 
                case 7: {
                    Float f = ComposeColorAnnotatorKt.access$getFloat(args.get(0));
                    if (f == null) return null;
                    float r = f.floatValue();
                    Float f4 = ComposeColorAnnotatorKt.access$getFloat(args.get(1));
                    if (f4 == null) return null;
                    float g = f4.floatValue();
                    Float f5 = ComposeColorAnnotatorKt.access$getFloat(args.get(2));
                    if (f5 == null) return null;
                    float b = f5.floatValue();
                    Float f6 = ComposeColorAnnotatorKt.access$getFloat(args.get(3));
                    if (f6 == null) return null;
                    float a = f6.floatValue();
                    Color color = new Color(r, g, b, a);
                    return color;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception ignore) {
            return null;
        }
    }
}

