/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.impl.ui;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.stdui.KeyBindingKt;
import com.android.tools.adtui.stdui.KeyStrokes;
import com.android.tools.property.panel.api.PropertyItem;
import com.android.tools.property.panel.impl.model.TableEditingRequest;
import com.android.tools.property.panel.impl.model.TableLineModelImpl;
import com.android.tools.property.panel.impl.model.TableRowEditListener;
import com.android.tools.property.panel.impl.model.TextFieldPropertyEditorModel;
import com.android.tools.property.panel.impl.support.HelpSupportBinding;
import com.android.tools.property.panel.impl.ui.PropertyTextField;
import com.android.tools.property.panel.impl.ui.TableEditor$WhenMappings;
import com.android.tools.property.ptable2.PTable;
import com.android.tools.property.ptable2.PTableCellEditorProvider;
import com.android.tools.property.ptable2.PTableCellRendererProvider;
import com.android.tools.property.ptable2.PTableColumn;
import com.android.tools.property.ptable2.PTableGroupItem;
import com.android.tools.property.ptable2.PTableItem;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0017H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u001aH\u0002J\b\u0010%\u001a\u00020!H\u0002J\u001a\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u001a2\b\u0010(\u001a\u0004\u0018\u00010\u001aH\u0002J\u0018\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020+2\u0006\u0010$\u001a\u00020\u001aH\u0002J\u0012\u0010,\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010\u001aH\u0002J\b\u0010-\u001a\u00020!H\u0002J\b\u0010.\u001a\u00020!H\u0002R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/android/tools/property/panel/impl/ui/TableEditor;", "", "lineModel", "Lcom/android/tools/property/panel/impl/model/TableLineModelImpl;", "rendererProvider", "Lcom/android/tools/property/ptable2/PTableCellRendererProvider;", "editorProvider", "Lcom/android/tools/property/ptable2/PTableCellEditorProvider;", "actions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/android/tools/property/panel/impl/model/TableLineModelImpl;Lcom/android/tools/property/ptable2/PTableCellRendererProvider;Lcom/android/tools/property/ptable2/PTableCellEditorProvider;Ljava/util/List;)V", "getActions", "()Ljava/util/List;", "component", "Ljavax/swing/JTable;", "getComponent", "()Ljavax/swing/JTable;", "getLineModel", "()Lcom/android/tools/property/panel/impl/model/TableLineModelImpl;", "table", "Lcom/android/tools/property/ptable2/PTable;", "computeRowHeight", "", "findRowOf", "itemToEdit", "Lcom/android/tools/property/ptable2/PTableItem;", "findRowOfBestMatch", "getToolTipText", "", "event", "Ljava/awt/event/MouseEvent;", "handleEditRequest", "", "request", "Lcom/android/tools/property/panel/impl/model/TableEditingRequest;", "item", "handleValueChanged", "isBetter", "", "best", "isMatch", "matcher", "Lcom/intellij/util/text/Matcher;", "selectItem", "updateActions", "updateUI", "intellij.android.layout-ui"})
public final class TableEditor {
    private final PTable table;
    @NotNull
    private final JTable component;
    @NotNull
    private final TableLineModelImpl lineModel;
    @NotNull
    private final List<AnAction> actions;

    @NotNull
    public final JTable getComponent() {
        return this.component;
    }

    private final void updateUI() {
        this.component.setRowHeight(this.computeRowHeight());
    }

    private final void updateActions() {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.component);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"DataManager.getInstance(\u2026getDataContext(component)");
        DataContext context = dataContext;
        Iterable $this$forEach$iv = this.actions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnAction it = (AnAction)element$iv;
            boolean bl = false;
            it.update(AnActionEvent.createFromAnAction((AnAction)it, null, (String)"", (DataContext)context));
        }
    }

    private final void handleValueChanged() {
        this.component.setVisible(this.lineModel.getVisible());
        this.table.setFilter(this.lineModel.getFilter());
        this.lineModel.setItemCount(this.table.getItemCount());
    }

    private final void handleEditRequest(TableEditingRequest request, PTableItem item) {
        this.handleValueChanged();
        switch (TableEditor$WhenMappings.$EnumSwitchMapping$0[request.ordinal()]) {
            case 1: {
                this.table.startEditing(this.findRowOf(item));
                break;
            }
            case 2: {
                this.table.startEditing(-1);
                break;
            }
            case 3: {
                this.table.startEditing(this.findRowOfBestMatch());
                break;
            }
            case 4: {
                this.selectItem(item);
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void selectItem(PTableItem item) {
        if (item != null) {
            int n = 0;
            int n2 = this.component.getRowCount();
            while (n < n2) {
                void row;
                if (Intrinsics.areEqual((Object)this.component.getValueAt((int)row, 0), (Object)item)) {
                    this.component.setRowSelectionInterval((int)row, (int)row);
                    return;
                }
                ++row;
            }
        }
        this.component.transferFocusBackward();
    }

    private final String getToolTipText(MouseEvent event) {
        JComponent control;
        int tableRow = this.component.rowAtPoint(event.getPoint());
        int tableColumn = this.component.columnAtPoint(event.getPoint());
        if (tableRow < 0 || tableColumn < 0) {
            return null;
        }
        Object item = this.component.getValueAt(tableRow, tableColumn);
        TableCellRenderer renderer2 = this.component.getCellRenderer(tableRow, tableColumn);
        Component component = renderer2.getTableCellRendererComponent(this.component, item, false, false, tableRow, tableColumn);
        if (component == null) {
            return null;
        }
        Component cell = component;
        Rectangle rect = this.component.getCellRect(tableRow, tableColumn, true);
        cell.setBounds(0, 0, rect.width, rect.height);
        Component component2 = SwingUtilities.getDeepestComponentAt(cell, event.getX() - rect.x, event.getY() - rect.y);
        if (!(component2 instanceof JComponent)) {
            component2 = null;
        }
        JComponent jComponent = control = (JComponent)component2;
        return jComponent != null ? jComponent.getToolTipText(event) : null;
    }

    private final int computeRowHeight() {
        Object v1;
        Object v0;
        block3: {
            Iterable iterable = this.lineModel.getTableModel().getItems();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                PTableItem it = (PTableItem)t;
                boolean bl3 = false;
                if (!(it instanceof PropertyItem)) continue;
                v0 = t;
                break block3;
            }
            v0 = v1 = null;
        }
        if (!(v0 instanceof PropertyItem)) {
            v1 = null;
        }
        PropertyItem propertyItem = v1;
        if (propertyItem == null) {
            return JBUI.scale((int)24);
        }
        PropertyItem property2 = propertyItem;
        PropertyTextField textField = new PropertyTextField(new TextFieldPropertyEditorModel(property2, true));
        return Integer.max(textField.getPreferredSize().height, JBUI.scale((int)20));
    }

    /*
     * WARNING - void declaration
     */
    private final int findRowOf(PTableItem itemToEdit) {
        int count = this.table.getItemCount();
        int n = 0;
        int n2 = count;
        while (n < n2) {
            void i2;
            PTableItem item = this.table.item((int)i2);
            if (Intrinsics.areEqual((Object)item, (Object)itemToEdit)) {
                return (int)i2;
            }
            ++i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private final int findRowOfBestMatch() {
        CharSequence charSequence = this.lineModel.getFilter();
        boolean bl = false;
        if (charSequence.length() == 0) {
            return -1;
        }
        MinusculeMatcher matcher = NameUtil.buildMatcher((String)('*' + this.lineModel.getFilter())).build();
        int count = this.table.getItemCount();
        PTableItem best = null;
        int bestRow = -1;
        int n = 0;
        int n2 = count;
        while (n < n2) {
            void row;
            PTableItem item = this.table.item((int)row);
            MinusculeMatcher minusculeMatcher = matcher;
            Intrinsics.checkNotNullExpressionValue((Object)minusculeMatcher, (String)"matcher");
            if (this.isMatch((Matcher)minusculeMatcher, item) && this.isBetter(item, best)) {
                best = item;
                bestRow = row;
            }
            ++row;
        }
        return bestRow;
    }

    private final boolean isMatch(Matcher matcher, PTableItem item) {
        PTableItem pTableItem = item;
        return pTableItem instanceof PTableGroupItem ? matcher.matches(item.getName()) : true;
    }

    private final boolean isBetter(PTableItem item, PTableItem best) {
        return !this.lineModel.getTableModel().isCellEditable(item, PTableColumn.VALUE) ? false : (best == null ? true : item.getName().length() < best.getName().length());
    }

    @NotNull
    public final TableLineModelImpl getLineModel() {
        return this.lineModel;
    }

    @NotNull
    public final List<AnAction> getActions() {
        return this.actions;
    }

    /*
     * WARNING - void declaration
     */
    public TableEditor(@NotNull TableLineModelImpl lineModel, @NotNull PTableCellRendererProvider rendererProvider, @NotNull PTableCellEditorProvider editorProvider, @NotNull List<? extends AnAction> actions2) {
        Intrinsics.checkNotNullParameter((Object)lineModel, (String)"lineModel");
        Intrinsics.checkNotNullParameter((Object)rendererProvider, (String)"rendererProvider");
        Intrinsics.checkNotNullParameter((Object)editorProvider, (String)"editorProvider");
        Intrinsics.checkNotNullParameter(actions2, (String)"actions");
        this.lineModel = lineModel;
        this.actions = actions2;
        this.table = PTable.Companion.create(this.lineModel.getTableModel(), this.lineModel, rendererProvider, editorProvider, (Function1<? super MouseEvent, String>)((Function1)new Function1<MouseEvent, String>(this){
            final /* synthetic */ TableEditor this$0;

            @Nullable
            public final String invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return TableEditor.access$getToolTipText(this.this$0, it);
            }
            {
                this.this$0 = tableEditor;
                super(1);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this){

            public final void invoke() {
                TableEditor.access$updateUI((TableEditor)this.receiver);
            }
        }));
        JComponent jComponent = this.table.getComponent();
        if (jComponent == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.JTable");
        }
        this.component = (JTable)jComponent;
        this.component.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        this.component.setRowHeight(this.computeRowHeight());
        this.lineModel.addValueChangedListener(new TableRowEditListener(){

            public void valueChanged() {
                this.handleValueChanged();
            }

            @Override
            public void editRequest(@NotNull TableEditingRequest type, @Nullable PTableItem item) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                this.handleEditRequest(type, item);
            }
        });
        this.component.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent it) {
                PTableItem pTableItem;
                int index2 = this.getComponent().getSelectedRow();
                if (index2 >= 0 && index2 < this.getComponent().getRowCount()) {
                    Object object = this.getComponent().getValueAt(index2, 1);
                    if (!(object instanceof PTableItem)) {
                        object = null;
                    }
                    pTableItem = (PTableItem)object;
                } else {
                    pTableItem = null;
                }
                PTableItem item = pTableItem;
                this.getLineModel().setSelectedItem(item);
                this.updateActions();
            }
        });
        HelpSupportBinding.registerHelpKeyActions$default(HelpSupportBinding.INSTANCE, this.component, (Function0)new Function0<PropertyItem>(){

            @Nullable
            public final PropertyItem invoke() {
                PTableItem pTableItem = this.getLineModel().getSelectedItem();
                if (!(pTableItem instanceof PropertyItem)) {
                    pTableItem = null;
                }
                return (PropertyItem)pTableItem;
            }
        }, 0, 4, null);
        KeyBindingKt.registerActionKey$default((JComponent)this.component, (Function0)4.INSTANCE, (KeyStroke)KeyStrokes.INSTANCE.getPAGE_UP(), (String)"pageUp", (Function0)5.INSTANCE, (int)0, (int)16, null);
        KeyBindingKt.registerActionKey$default((JComponent)this.component, (Function0)6.INSTANCE, (KeyStroke)KeyStrokes.INSTANCE.getPAGE_DOWN(), (String)"pageDown", (Function0)7.INSTANCE, (int)0, (int)16, null);
        Iterable $this$forEach$iv = this.actions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            AnAction action2 = (AnAction)element$iv;
            boolean bl = false;
            ShortcutSet shortcutSet2 = action2.getShortcutSet();
            Intrinsics.checkNotNullExpressionValue((Object)shortcutSet2, (String)"action.shortcutSet");
            Intrinsics.checkNotNullExpressionValue((Object)shortcutSet2.getShortcuts(), (String)"action.shortcutSet.shortcuts");
            boolean $i$f$filterIsInstance = false;
            Iterator iterator = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KeyboardShortcut)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KeyboardShortcut it = (KeyboardShortcut)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getSecondKeyStroke() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KeyboardShortcut it = (KeyboardShortcut)element$iv2;
                boolean bl3 = false;
                JComponent jComponent2 = this.component;
                Function0 function0 = (Function0)new Function0<AnAction>(action2, this){
                    final /* synthetic */ AnAction $action$inlined;
                    final /* synthetic */ TableEditor this$0;
                    {
                        this.$action$inlined = anAction;
                        this.this$0 = tableEditor;
                        super(0);
                    }

                    @Nullable
                    public final AnAction invoke() {
                        return this.$action$inlined;
                    }
                };
                KeyStroke keyStroke = it.getFirstKeyStroke();
                Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"it.firstKeyStroke");
                Presentation presentation = action2.getTemplatePresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"action.templatePresentation");
                String string = presentation.getDescription();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"action.templatePresentation.description");
                KeyBindingKt.registerAnActionKey$default((JComponent)jComponent2, (Function0)function0, (KeyStroke)keyStroke, (String)string, (int)0, (int)8, null);
            }
        }
    }

    public /* synthetic */ TableEditor(TableLineModelImpl tableLineModelImpl, PTableCellRendererProvider pTableCellRendererProvider, PTableCellEditorProvider pTableCellEditorProvider, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(tableLineModelImpl, pTableCellRendererProvider, pTableCellEditorProvider, list);
    }

    public static final /* synthetic */ String access$getToolTipText(TableEditor $this, MouseEvent event) {
        return $this.getToolTipText(event);
    }

    public static final /* synthetic */ void access$updateUI(TableEditor $this) {
        $this.updateUI();
    }
}

