/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.impl.ui;

import com.google.common.html.HtmlEscapers;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.AbstractExpandableItemsHandler;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\r@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/property/panel/impl/ui/ExpandableLabel;", "Ljavax/swing/JLabel;", "()V", "value", "", "actualText", "getActualText", "()Ljava/lang/String;", "setActualText", "(Ljava/lang/String;)V", "expandableLabelHandler", "Lcom/android/tools/property/panel/impl/ui/ExpandableLabel$ExpandableLabelHandler;", "htmlText", "", "showEllipsis", "setShowEllipsis", "(Z)V", "repaint", "", "r", "Ljava/awt/Rectangle;", "toHtml", "updateText", "ExpandableLabelHandler", "intellij.android.layout-ui"})
public final class ExpandableLabel
extends JLabel {
    private final ExpandableLabelHandler expandableLabelHandler = new ExpandableLabelHandler(this);
    private String htmlText = "";
    private boolean showEllipsis = true;
    @NotNull
    private String actualText = "";

    private final void setShowEllipsis(boolean value2) {
        this.showEllipsis = value2;
        this.updateText();
    }

    @NotNull
    public final String getActualText() {
        return this.actualText;
    }

    public final void setActualText(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.actualText = value2;
        CharSequence charSequence = value2;
        boolean bl = false;
        this.htmlText = charSequence.length() == 0 ? "" : this.toHtml(value2);
        this.updateText();
    }

    private final void updateText() {
        super.setText(this.showEllipsis ? this.actualText : this.htmlText);
    }

    @Override
    public void repaint(@NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        super.repaint(r);
        this.setShowEllipsis(!this.expandableLabelHandler.isShowing());
    }

    private final String toHtml(String value2) {
        return "<html><nobr>" + HtmlEscapers.htmlEscaper().escape(value2) + "</nobr></html>";
    }

    public static final /* synthetic */ boolean access$getShowEllipsis$p(ExpandableLabel $this) {
        return $this.showEllipsis;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J$\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\n\u0018\u00010\u0017j\u0004\u0018\u0001`\u00192\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/property/panel/impl/ui/ExpandableLabel$ExpandableLabelHandler;", "Lcom/intellij/ui/AbstractExpandableItemsHandler;", "Lcom/android/tools/property/panel/impl/ui/ExpandableLabel;", "component", "(Lcom/android/tools/property/panel/impl/ui/ExpandableLabel;)V", "renderer", "Ljavax/swing/JLabel;", "computeBackgroundColor", "Ljava/awt/Color;", "computeOverlayBounds", "Ljava/awt/Rectangle;", "key", "doFillBackground", "", "height", "", "width", "g", "Ljava/awt/Graphics2D;", "getCellKeyForPoint", "point", "Ljava/awt/Point;", "getCellRendererAndBounds", "Lcom/intellij/openapi/util/Pair;", "Ljava/awt/Component;", "Lcom/android/tools/property/panel/impl/ui/ComponentBounds;", "isPaintBorder", "", "intellij.android.layout-ui"})
    private static final class ExpandableLabelHandler
    extends AbstractExpandableItemsHandler<ExpandableLabel, ExpandableLabel> {
        private final JLabel renderer;

        @NotNull
        protected ExpandableLabel getCellKeyForPoint(@NotNull Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            JComponent jComponent = this.myComponent;
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"myComponent");
            return (ExpandableLabel)jComponent;
        }

        @Nullable
        protected Pair<Component, Rectangle> getCellRendererAndBounds(@NotNull ExpandableLabel key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (key.getPreferredSize().width <= key.getWidth()) {
                return null;
            }
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isActive()) {
                return null;
            }
            this.renderer.setText(key.getText());
            this.renderer.setIcon(key.getIcon());
            this.renderer.setFont(key.getFont());
            this.renderer.setForeground(key.getForeground());
            key.setShowEllipsis(false);
            return Pair.create((Object)this.renderer, (Object)this.computeOverlayBounds(key));
        }

        protected boolean isPaintBorder() {
            return false;
        }

        protected void doFillBackground(int height, int width, @NotNull Graphics2D g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Color color = this.computeBackgroundColor();
            if (color == null) {
                return;
            }
            g.setColor(color);
            g.fillRect(0, 0, width, height);
        }

        private final Color computeBackgroundColor() {
            JComponent jComponent = this.myComponent;
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"myComponent");
            Component component = jComponent;
            while (!component.isOpaque()) {
                Container container = component.getParent();
                if (container == null) {
                    return null;
                }
                component = container;
            }
            return component.getBackground();
        }

        private final Rectangle computeOverlayBounds(ExpandableLabel key) {
            Rectangle bounds2 = new Rectangle(0, 0, key.getPreferredSize().width, key.getHeight());
            bounds2.width += JBUI.scale((int)6);
            return bounds2;
        }

        public ExpandableLabelHandler(@NotNull ExpandableLabel component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            super((JComponent)component);
            this.renderer = new JLabel();
        }
    }
}

